/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RTQueryJoinCollection;
import com.kingdee.bos.metadata.entity.RTQueryJoinInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinCreator;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryFilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QueryPKInfo;
import com.kingdee.bos.metadata.query.QueryParameterCollection;
import com.kingdee.bos.metadata.query.QuerySorterItemCollection;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.JoinQueryUtil;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.Assert;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class JoinQueryInfo
extends QueryInfo
implements Serializable {
    private static final Logger logger = Logger.getLogger(JoinQueryInfo.class);

    public JoinQueryInfo() {
        this.put("joins", new JoinCollection());
    }

    protected JoinQueryInfo(boolean init) {
        super(init);
    }

    @Override
    public Object clone() {
        JoinQueryInfo clone = new JoinQueryInfo();
        clone.setPackage(this.getPackage());
        clone.setName(this.getName());
        clone.setAlias(this.getAlias());
        clone.setDescription(this.getDescription());
        clone.setIsDistinct(this.isIsDistinct());
        clone.setUserDefined(this.isUserDefined());
        clone.setBizUnitPK(this.getBizUnitPK());
        clone.setReportDataSource(this.getReportDataSource());
        clone.setConnectionProvider(this.getConnectionProvider());
        clone.getSubObjects().addObjectCollection((SubObjectCollection)this.getSubObjects().clone());
        clone.getUnits().addObjectCollection((PropertyUnitCollection)this.getUnits().clone());
        clone.getParameters().addObjectCollection((QueryParameterCollection)this.getParameters().clone());
        if (this.getDefaultFilter() != null) {
            clone.setDefaultFilter((QueryFilterInfo)this.getDefaultFilter().clone());
        }
        if (this.getDefaultSorters() != null) {
            clone.getDefaultSorters().addObjectCollection((QuerySorterItemCollection)this.getDefaultSorters().clone());
        }
        if (this.getQueryPK() != null) {
            clone.setQueryPK((QueryPKInfo)this.getQueryPK().clone());
        }
        clone.getJoins().addObjectCollection((JoinCollection)this.getJoins().clone());
        clone.resetQueryInfo();
        JoinCollection newJoinCol = clone.getJoins();
        JoinCollection oldJoinCol = this.getJoins();
        if (oldJoinCol != null && newJoinCol != null) {
            int m = newJoinCol.size();
            for (int i = 0; i < m; ++i) {
                JoinInfo newJoin = newJoinCol.get(i);
                JoinInfo oldJoin = oldJoinCol.get(i);
                SubObjectInfo left = oldJoin.getLeftObject();
                SubObjectInfo right = oldJoin.getRightObject();
                int n = this.getSubObjects().size();
                for (int j = 0; j < n; ++j) {
                    if (left == this.getSubObjects().get(j)) {
                        newJoin.setLeftObject(clone.getSubObjects().get(j));
                    }
                    if (right != this.getSubObjects().get(j)) continue;
                    newJoin.setRightObject(clone.getSubObjects().get(j));
                }
            }
        }
        return clone;
    }

    public JoinCollection getJoins() {
        return (JoinCollection)this.get("joins");
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.JOINQUERY;
    }

    public boolean isIsDistinct() {
        return this.getBoolean("isDistinct");
    }

    public void setIsDistinct(boolean item) {
        this.setBoolean("isDistinct", item);
    }

    @Override
    public ValidateList validate() {
        return super.validate();
    }

    public String getNewJoinName() {
        return Uuid.create().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubObjectInfo getMainObject() throws BOSException {
        int i;
        SubObjectCollection subObjs = null;
        JoinCollection joins = null;
        JoinQueryInfo joinQueryInfo = this;
        synchronized (joinQueryInfo) {
            subObjs = this.getSubObjects();
            if (subObjs.size() == 1) {
                return subObjs.get(0);
            }
            joins = this.getJoins();
        }
        HashMap rightMap = new HashMap(joins.size());
        ArrayList<SubObjectInfo> mainList = new ArrayList<SubObjectInfo>(subObjs.size());
        if (joins.size() < subObjs.size() - 1 && subObjs.size() != 1) {
            throw new InvalidMetaDataException(this.getFullName() + ": Some subobject do not has join to link to the other subobject");
        }
        for (i = 0; i < joins.size(); ++i) {
            JoinInfo join = joins.get(i);
            if (join == null || join.getRightObject() == null) continue;
            rightMap.put(join.getRightObject().getName().toLowerCase(), null);
        }
        for (i = 0; i < subObjs.size(); ++i) {
            SubObjectInfo sub = subObjs.get(i);
            if (rightMap.containsKey(sub.getName().toLowerCase())) continue;
            mainList.add(sub);
        }
        if (mainList.size() == 0) {
            throw new InvalidMetaDataException(this.getFullName() + ": Can't find the main object.");
        }
        if (mainList.size() > 1) {
            throw new InvalidMetaDataException(this.getFullName() + ": There are more than one main object during this query.");
        }
        return (SubObjectInfo)mainList.get(0);
    }

    private HashSet getCompositionEntitys(SubEntityInfo mainEntity) {
        HashSet<EntityObjectInfo> set = new HashSet<EntityObjectInfo>();
        PropertyCollection props = mainEntity.getEntityRef().getInheritedProperties();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            RelationshipInfo rel;
            PropertyInfo prop = props.get(i);
            if (prop == null || !(prop instanceof LinkPropertyInfo) || !(rel = ((LinkPropertyInfo)prop).getRelationship()).getType().equals((Object)RelationshipType.COMPOSITION) || !rel.getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) && !rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) continue;
            set.add(rel.getSupplierObject());
        }
        return set;
    }

    public ArrayList getMergeQueryFieldNames() throws BOSException {
        SubObjectInfo subObj = this.getMainObject();
        if (subObj != null && subObj instanceof SubEntityInfo) {
            SubEntityInfo subEntity = (SubEntityInfo)subObj;
            ArrayList<QueryFieldInfo> list = this.getSelector().getFields();
            ArrayList<String> names = new ArrayList<String>(list.size());
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                SubEntityInfo subSubEntity;
                PropertyRefInfo ref;
                QueryFieldInfo field = list.get(i);
                if (field == null || field.getPropertyRefs().size() != 1 || (ref = field.getPropertyRefs().get(0)) == null || (subSubEntity = ref.getSubEntity()) == null || !subSubEntity.equals(subEntity) && this.getCompositionEntitys(subEntity).contains(subSubEntity.getEntityRef())) continue;
                names.add(field.getName());
            }
            return names;
        }
        return null;
    }

    private JoinInfo getJoinContain(SubEntityInfo left, SubEntityInfo right) {
        JoinInfo join = null;
        for (int i = 0; i < this.getJoins().size(); ++i) {
            join = this.getJoins().get(i);
            if ((!join.getLeftObject().getName().equals(left.getName()) || !join.getRightObject().getName().equals(right.getName())) && (!join.getLeftObject().getName().equals(right.getName()) || !join.getRightObject().getName().equals(left.getName()))) continue;
            return join;
        }
        return new JoinInfo(this);
    }

    private void opDefaultJoin(SubEntityInfo item, boolean isAdd) {
        if (item == null) {
            return;
        }
        String itemKey = item.getEntityRef().getFullName();
        for (int i = 0; i < this.getSubObjects().size(); ++i) {
            SubObjectInfo subObj = this.getSubObjects().get(i);
            if (subObj == null || !(subObj instanceof SubEntityInfo) || subObj.getName().equals(item.getName())) continue;
            SubEntityInfo sub = (SubEntityInfo)subObj;
            PropertyCollection props = sub.getEntityRef().getInheritedNoDuplicatedProperties();
            for (int j = 0; j < props.size(); ++j) {
                RelationshipInfo rel;
                PropertyInfo prop = props.get(j);
                if (prop == null || !(prop instanceof LinkPropertyInfo) || (rel = ((LinkPropertyInfo)prop).getRelationship()) == null || rel.getClientObject() == null || rel.getSupplierObject() == null || rel.getClientPropertyDesignTime() == null || rel.getSupplierPropertyDesignTime() == null || !rel.getClientObject().getFullName().equals(itemKey) && !rel.getSupplierObject().getFullName().equals(itemKey)) continue;
                boolean isClient = rel.getClientObject().getFullName().equals(itemKey);
                JoinInfo join = this.getJoinContain(item, sub);
                SubEntityInfo left = null;
                SubEntityInfo right = null;
                if (isClient) {
                    left = item;
                    right = sub;
                } else {
                    left = sub;
                    right = item;
                }
                join.setLeftObject(sub);
                join.setRightObject(item);
                JoinItemInfo joinItem = new JoinItemInfo(join);
                PropertyUnitInfo unit = new PropertyUnitInfo(this);
                PropertyRefInfo ref = new PropertyRefInfo(unit, left, rel.getClientPropertyDesignTime());
                unit.getPropertyRefs().add(ref);
                unit.setName(this.getNewUnitName());
                joinItem.setLeftField(unit);
                this.getUnits().add(unit);
                unit = new PropertyUnitInfo(this);
                ref = new PropertyRefInfo(unit, right, rel.getSupplierPropertyDesignTime());
                unit.setName(this.getNewUnitName());
                unit.getPropertyRefs().add(ref);
                joinItem.setRightField(unit);
                this.getUnits().add(unit);
                joinItem.setCompareType(CompareType.EQUALS);
                join.getJoinItems().add(joinItem);
                if (isAdd) {
                    this.getJoins().add(join);
                    continue;
                }
                this.getJoins().remove(join);
            }
        }
    }

    public void addDefaultJoin(SubEntityInfo item) {
        this.opDefaultJoin(item, true);
    }

    public void removeDefaultJoin(SubEntityInfo item) {
        this.opDefaultJoin(item, false);
    }

    public JoinInfo getJoinWithEntities(SubEntityInfo left, SubEntityInfo right, JoinType type, LinkPropertyInfo lnkProp) throws BOSException {
        return this.getJoinWithEntities(left, right, type, lnkProp, null);
    }

    public JoinInfo getJoinWithEntities(SubEntityInfo left, SubEntityInfo right, JoinType type, LinkPropertyInfo lnkProp, RelationshipInfo rela) throws BOSException {
        return new JoinCreator(left, right, type, lnkProp, rela).create(new JoinCreator.Carrier(this));
    }

    public JoinInfo getJoinWithEntities(SubEntityInfo left, SubEntityInfo right, JoinType type) throws BOSException {
        return this.getJoinWithEntities(left, right, type, null);
    }

    public JoinInfo getJoinWithEntities(RelationshipInfo rel, SubEntityInfo left, SubEntityInfo right, JoinType type) throws BOSException {
        if (rel != null && rel.getClientPropertyDesignTime() != null && rel.getClientPropertyDesignTime() instanceof LinkPropertyInfo) {
            return this.getJoinWithEntities(left, right, type, (LinkPropertyInfo)rel.getClientPropertyDesignTime());
        }
        return this.getJoinWithEntities(left, right, type, null, rel);
    }

    public JoinInfo getJoinWithEntities(RelationshipInfo rel, SubEntityInfo left, SubEntityInfo right) throws BOSException {
        JoinType type = JoinType.INNERJOIN;
        boolean clientIsLeft = false;
        if (rel.getClientObject() != null) {
            for (EntityObjectInfo _entity = left.getEntityRef(); !clientIsLeft && _entity != null; _entity = _entity.getBaseEntity()) {
                clientIsLeft = _entity.getFullName().equalsIgnoreCase(rel.getClientObject().getFullName());
            }
        }
        Assert.that((boolean)clientIsLeft, (String)"getJoinWithEntities not support Reversed Relationship!");
        CardinalityType supCard = rel.getSupplierCardinality();
        if (CardinalityType.ZERO_TO_ONE.equals((Object)supCard) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)supCard)) {
            type = JoinType.LEFTJOIN;
        }
        return this.getJoinWithEntities(rel, left, right, type);
    }

    @Override
    protected void resetQueryInfo() {
        super.resetQueryInfo();
        Iterator ite = this.getJoins().iterator();
        while (ite.hasNext()) {
            JoinInfo sub = (JoinInfo)ite.next();
            sub.setQuery(this);
        }
    }

    @Override
    protected void updateQuery(EntityViewInfo view, Context ctx) throws BOSException {
        RTQueryJoinInfo info;
        int i;
        if (view == null) {
            return;
        }
        RTQueryJoinCollection coll = view.getRTQueryJoins();
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            JoinQueryUtil.addRTJoinInfo(this, ctx, info);
        }
        super.updateQuery(view, ctx);
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            JoinQueryUtil.addRTQueryKey(this, ctx, info, view);
        }
    }
}

