/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.DeleContext;
import com.kingdee.bos.dao.DeleContextUtil;
import com.kingdee.bos.metadata.AbstractMDValueDele;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollectionDele;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyRefToken;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectDele;
import com.kingdee.bos.metadata.query.token.IToken;
import com.kingdee.bos.metadata.query.token.TokenType;
import java.util.Map;

public class PropertyRefDele
extends AbstractMDValueDele
implements IToken {
    private boolean isTransformProperty = true;
    private transient PropertyUnitDele unit = null;
    private transient SubObjectDele subEn = null;

    private PropertyRefDele(PropertyRefInfo target, DeleContext ctx) {
        super(target, ctx);
        this.isTransformProperty = target.getIsTransformProperty();
        this.subEn = SubObjectDele.getInstance(target.getSubEntity(), ctx);
        this.put("subEntity", this.subEn);
        this.put("subQuery", SubObjectDele.getInstance(target.getSubQuery(), ctx));
        this.unit = PropertyUnitDele.getInstance(target.getUnit(), ctx);
        this.put("parentUnit", this.unit);
        this.put("refUnit", PropertyUnitDele.getInstance(target.getRefUnit(), ctx));
    }

    public static PropertyRefDele getInstance(PropertyRefInfo target, DeleContext ctx) {
        PropertyRefDele dele = (PropertyRefDele)DeleContextUtil.get(target.getBOSType(), ctx, target);
        if (dele == null) {
            dele = new PropertyRefDele(target, ctx);
        }
        return dele;
    }

    public static PropertyRefDele newInstance(PropertyUnitDele fld, SubObjectDele subEn, PropertyInfo prop) {
        PropertyRefDele dele = new PropertyRefDele(new PropertyRefInfo((PropertyUnitInfo)fld.getTarget(), (SubEntityInfo)subEn.getTarget(), prop), fld.getContext());
        dele.isTgtNew = true;
        return dele;
    }

    public PropertyUnitDele getUnit() {
        if (this.unit == null) {
            this.unit = (PropertyUnitDele)this.get("parentUnit");
        }
        return this.unit;
    }

    public SubObjectDele getSubEntity() {
        if (this.subEn == null) {
            this.subEn = (SubObjectDele)this.get("subEntity");
        }
        return this.subEn;
    }

    public SubObjectDele getSubQuery() {
        return (SubObjectDele)this.get("subQuery");
    }

    public PropertyInfo getRefProperty() {
        return ((PropertyRefInfo)this.target).getRefProperty();
    }

    public PropertyUnitDele getRefUnit() {
        return (PropertyUnitDele)this.get("refUnit");
    }

    void setIsTransformProperty(boolean flag) {
        this.isTransformProperty = flag;
    }

    boolean getIsTransformProperty() {
        return this.isTransformProperty;
    }

    @Override
    public TokenType getTokenType() {
        return ((PropertyRefInfo)this.target).getTokenType();
    }

    public SQLType getSQLType() {
        PropertyRefCollectionDele propRefs;
        PropertyUnitDele propUnit;
        SQLType type = null;
        if (this.getSubEntity() != null) {
            PropertyInfo prop = this.getRefProperty();
            if (prop == null) {
                type = null;
            } else {
                ColumnInfo col = prop.getMappingField();
                if (col == null && prop.getExtendedField() != null) {
                    col = prop.getExtendedField().getExtendedColumn();
                }
                type = col == null ? null : col.getTypeName();
            }
        } else if (this.getSubQuery() != null && (propUnit = this.getRefUnit()) != null && (propRefs = propUnit.getPropertyRefs()) != null && propRefs.size() >= 1) {
            return propRefs.get(0).getSQLType();
        }
        return type;
    }

    String getPostfix() {
        return "_" + this.ctx.bosCtx.getLocale();
    }

    @Override
    public String showValue() throws BOSException {
        return new PropertyRefToken(this).showValue();
    }

    public String showValue(boolean paraType, Map paraMap) throws BOSException {
        return this.showValue();
    }
}

