/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendedFieldInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinCollectionDele;
import com.kingdee.bos.metadata.query.JoinDele;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemDele;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefDele;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitCollectionDele;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectDele;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.token.IToken;
import com.kingdee.bos.metadata.query.token.TokenType;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import java.util.Map;

class PropertyRefToken
implements IToken {
    private static final long serialVersionUID = 6136529319530969022L;
    private static final char QUT = '\"';
    private static final char DOT = '.';
    private final PropertyRef ref;

    public PropertyRefToken(PropertyRefInfo ref) {
        this.ref = new PropertyRef(ref);
    }

    public PropertyRefToken(PropertyRefDele ref) {
        this.ref = new PropertyRef(ref);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.OBJECTVALUE;
    }

    @Override
    public String showValue() throws BOSException {
        String s = "";
        if (0 == this.ref.getSubObjectType()) {
            Ref r = this.ref.getRef();
            s = s + this.getTableAlias(r.name, r.entity, r.property);
            ColumnInfo col = QueryUtil.getColumnInfoByProp(r.property, r.entity);
            if (col == null) {
                throw new InvalidMetaDataException("Unit[" + this.ref.getUnitName() + "]'s propertyRef's refProperty: " + r.property.getName() + " 's mappingfield is null");
            }
            s = r.property instanceof OwnPropertyInfo && ((OwnPropertyInfo)r.property).isMultilingual() ? s + col.getName() + this.ref.getPostfix() : s + col.getName();
        } else if (1 == this.ref.getSubObjectType()) {
            s = s + '\"' + this.ref.getSubQueryName() + '\"' + '.';
            s = s + '\"' + this.ref.getRefUnitName() + '\"';
        }
        return s;
    }

    private String getTableAlias(String alias, EntityObjectInfo entity, PropertyInfo prop) {
        ExtendedFieldInfo exFld = prop.getExtendedField();
        EntityObjectInfo parent = entity.getBaseEntity();
        int count = 0;
        while (parent != null && parent.getTable() != null) {
            if (!entity.getProperties().contains(prop) && parent.getEntityProperties().contains(prop)) {
                alias = alias + "_parent" + count;
                break;
            }
            parent = parent.getBaseEntity();
            ++count;
        }
        if (exFld != null) {
            alias = alias + "_extend";
        }
        alias = QueryUtil.getEntityAlias(alias);
        alias = '\"' + alias + '\"' + '.';
        return alias;
    }

    @Override
    public String showValue(boolean bParaType, Map<Integer, Object> paraMap) throws BOSException {
        return this.showValue();
    }

    static class DeleMainRefGetter
    implements RefGetter {
        private final PropertyRefDele ref;

        public DeleMainRefGetter(PropertyRefDele ref) {
            this.ref = ref;
        }

        @Override
        public Ref get() throws BOSException {
            SubObjectDele se;
            PropertyRefDele refProperty;
            PropertyUnitDele unit;
            SubObjectDele subEntity = this.ref.getSubEntity();
            if (subEntity == null) {
                return null;
            }
            QueryDele query = this.getQuery();
            if (query == null) {
                return null;
            }
            SubObjectDele subObj = query.getMainObject();
            if (0 == subObj.getType() && !subEntity.equals(subObj) && (unit = this.getPropertyUnit(subEntity, this.ref.getRefProperty(), query)) != null && (refProperty = this.getPropertyFromJoins(unit, query)) != null && (se = refProperty.getSubEntity()) != null) {
                return new Ref(se.getName(), se.getEntityRef(), refProperty.getRefProperty());
            }
            return null;
        }

        private QueryDele getQuery() throws BOSException {
            if (this.ref.getUnit() != null && this.ref.getUnit().getQuery() != null) {
                return this.ref.getUnit().getQuery();
            }
            return null;
        }

        private JoinCollectionDele getJoins(QueryDele query) throws BOSException {
            if (query.getType() == 0) {
                return query.getJoins();
            }
            return null;
        }

        private PropertyUnitDele getPropertyUnit(SubObjectDele subEntity, PropertyInfo prop, QueryDele query) throws BOSException {
            PropertyUnitCollectionDele units = query.getUnits();
            int n = units.size();
            for (int i = 0; i < n; ++i) {
                PropertyRefDele ref;
                PropertyUnitDele unit = units.get(i);
                if (unit == null || unit.getTarget() instanceof QueryFieldInfo || unit.getPropertyRefs().size() != 1 || (ref = unit.getPropertyRefs().get(0)) == null || ref.getSubEntity() == null || ref.getRefProperty() == null || !this.equalsRefProperty(ref.getSubEntity(), ref.getRefProperty(), subEntity, prop)) continue;
                return unit;
            }
            return null;
        }

        private boolean equalsSubEntity(SubObjectDele subEntity, SubObjectDele subEntity1) {
            EntityObjectInfo entity1;
            if (subEntity == subEntity1) {
                return true;
            }
            if (!subEntity.getName().equals(subEntity1.getName())) {
                return false;
            }
            EntityObjectInfo entity = subEntity.getEntityRef();
            if (entity == (entity1 = subEntity1.getEntityRef())) {
                return true;
            }
            if (entity == null) {
                return entity1 == null;
            }
            if (entity1 == null) {
                return false;
            }
            return entity.getFullName().equals(entity1.getFullName());
        }

        private boolean equalsRefProperty(SubObjectDele subEntity, PropertyInfo prop, SubObjectDele subEntity1, PropertyInfo prop1) {
            if (!this.equalsSubEntity(subEntity, subEntity1)) {
                return false;
            }
            if (prop == prop1) {
                return true;
            }
            if (prop == null) {
                return prop1 == null;
            }
            if (prop1 == null) {
                return false;
            }
            return prop.getName().equals(prop1.getName());
        }

        private PropertyRefDele getPropertyFromJoins(PropertyUnitDele unit, QueryDele query) throws BOSException {
            JoinCollectionDele joins = this.getJoins(query);
            if (joins == null) {
                return null;
            }
            int n = joins.size();
            for (int i = 0; i < n; ++i) {
                JoinDele join = joins.get(i);
                if (join == null || join.getJoinItems().size() != 1) continue;
                JoinItemDele joinItem = join.getJoinItems().get(0);
                if (!join.getJoinType().equals((Object)JoinType.LEFTJOIN) || joinItem == null || !joinItem.getRightField().equals(unit) || joinItem.getLeftField().getPropertyRefs().size() != 1) continue;
                return joinItem.getLeftField().getPropertyRefs().get(0);
            }
            return null;
        }
    }

    static class InfoMainRefGetter
    implements RefGetter {
        private final PropertyRefInfo ref;

        public InfoMainRefGetter(PropertyRefInfo ref) {
            this.ref = ref;
        }

        @Override
        public Ref get() throws BOSException {
            SubEntityInfo se;
            PropertyRefInfo refProperty;
            PropertyUnitInfo unit;
            SubEntityInfo subEntity = this.ref.getSubEntity();
            if (subEntity == null) {
                return null;
            }
            QueryInfo query = this.getQuery();
            if (query == null) {
                return null;
            }
            SubObjectInfo subObj = query.getMainObject();
            if (subObj instanceof SubEntityInfo && !subEntity.equals(subObj) && (unit = this.getPropertyUnit(subEntity, this.ref.getRefProperty(), query)) != null && (refProperty = this.getPropertyFromJoins(unit, query)) != null && (se = refProperty.getSubEntity()) != null) {
                return new Ref(se.getName(), se.getEntityRef(), refProperty.getRefProperty());
            }
            return null;
        }

        private QueryInfo getQuery() throws BOSException {
            if (this.ref.getUnit() != null && this.ref.getUnit().getQuery() != null) {
                return this.ref.getUnit().getQuery();
            }
            return null;
        }

        private PropertyUnitCollection getUnits(QueryInfo query) throws BOSException {
            PropertyUnitCollection units = query.getUnits();
            PropertyUnitCollection props = new PropertyUnitCollection();
            int n = units.size();
            for (int i = 0; i < n; ++i) {
                if (units.get(i) instanceof QueryFieldInfo) continue;
                props.add(units.get(i));
            }
            return props;
        }

        private JoinCollection getJoins(QueryInfo query) throws BOSException {
            if (query instanceof JoinQueryInfo) {
                JoinQueryInfo joinQuery = (JoinQueryInfo)query;
                return joinQuery.getJoins();
            }
            return new JoinCollection();
        }

        private PropertyUnitInfo getPropertyUnit(SubEntityInfo subEntity, PropertyInfo prop, QueryInfo query) throws BOSException {
            PropertyUnitCollection units = this.getUnits(query);
            int n = units.size();
            for (int i = 0; i < n; ++i) {
                PropertyRefInfo ref;
                PropertyUnitInfo unit = units.get(i);
                if (unit == null || unit.getPropertyRefs().size() != 1 || (ref = unit.getPropertyRefs().get(0)) == null || ref.getSubEntity() == null || ref.getRefProperty() == null || !this.equalsRefProperty(ref.getSubEntity(), ref.getRefProperty(), subEntity, prop)) continue;
                return unit;
            }
            return null;
        }

        private boolean equalsSubEntity(SubEntityInfo subEntity, SubEntityInfo subEntity1) {
            EntityObjectInfo entity1;
            if (subEntity == subEntity1) {
                return true;
            }
            if (!subEntity.getName().equals(subEntity1.getName())) {
                return false;
            }
            EntityObjectInfo entity = subEntity.getEntityRef();
            if (entity == (entity1 = subEntity1.getEntityRef())) {
                return true;
            }
            if (entity == null) {
                return entity1 == null;
            }
            if (entity1 == null) {
                return false;
            }
            return entity.getFullName().equals(entity1.getFullName());
        }

        private boolean equalsRefProperty(SubEntityInfo subEntity, PropertyInfo prop, SubEntityInfo subEntity1, PropertyInfo prop1) {
            if (!this.equalsSubEntity(subEntity, subEntity1)) {
                return false;
            }
            if (prop == prop1) {
                return true;
            }
            if (prop == null) {
                return prop1 == null;
            }
            if (prop1 == null) {
                return false;
            }
            return prop.getName().equals(prop1.getName());
        }

        private PropertyRefInfo getPropertyFromJoins(PropertyUnitInfo unit, QueryInfo query) throws BOSException {
            JoinCollection joins = this.getJoins(query);
            int n = joins.size();
            for (int i = 0; i < n; ++i) {
                JoinInfo join = joins.get(i);
                if (join == null || join.getJoinItems().size() != 1) continue;
                JoinItemInfo joinItem = join.getJoinItems().get(0);
                if (!join.getJoinType().equals((Object)JoinType.LEFTJOIN) || joinItem == null || !joinItem.getRightField().equals(unit) || joinItem.getLeftField().getPropertyRefs().size() != 1) continue;
                return joinItem.getLeftField().getPropertyRefs().get(0);
            }
            return null;
        }
    }

    static class DeleRefGetter
    implements RefGetter {
        private final PropertyRefDele ref;

        public DeleRefGetter(PropertyRefDele ref) {
            this.ref = ref;
        }

        @Override
        public Ref get() throws BOSException {
            SubObjectDele subEntity = this.ref.getSubEntity();
            if (subEntity != null) {
                return new Ref(subEntity.getName(), subEntity.getEntityRef(), this.ref.getRefProperty());
            }
            return null;
        }
    }

    static class InfoRefGetter
    implements RefGetter {
        private final PropertyRefInfo ref;

        public InfoRefGetter(PropertyRefInfo ref) {
            this.ref = ref;
        }

        @Override
        public Ref get() throws BOSException {
            SubEntityInfo subEntity = this.ref.getSubEntity();
            if (subEntity != null) {
                return new Ref(subEntity.getName(), subEntity.getEntityRef(), this.ref.getRefProperty());
            }
            return null;
        }
    }

    static interface RefGetter {
        public Ref get() throws BOSException;
    }

    static class Ref {
        final String name;
        final EntityObjectInfo entity;
        final PropertyInfo property;

        public Ref(String name, EntityObjectInfo entity, PropertyInfo property) {
            this.name = name;
            this.property = property;
            this.entity = entity;
        }
    }

    static class PropertyRef {
        private final PropertyRefInfo ref;
        private final PropertyRefDele refDele;

        PropertyRef(PropertyRefInfo ref) {
            this.ref = ref;
            this.refDele = null;
        }

        PropertyRef(PropertyRefDele refDele) {
            this.ref = null;
            this.refDele = refDele;
        }

        String getUnitName() {
            if (this.ref != null) {
                return this.ref.getUnit() == null ? null : this.ref.getUnit().getName();
            }
            return this.refDele.getUnit() == null ? null : this.refDele.getUnit().getName();
        }

        Ref getRef() throws BOSException {
            Ref r = null;
            if (this.ref != null) {
                Ref mr;
                r = new InfoRefGetter(this.ref).get();
                if (this.ref.getIsTransformProperty() && (mr = new InfoMainRefGetter(this.ref).get()) != null) {
                    r = mr;
                }
            } else {
                Ref mr;
                r = new DeleRefGetter(this.refDele).get();
                if (this.refDele.getIsTransformProperty() && (mr = new DeleMainRefGetter(this.refDele).get()) != null) {
                    r = mr;
                }
            }
            if (r == null || r.entity == null) {
                throw new InvalidMetaDataException("The propertyRef: " + this.ref.toString() + " 's subEntity or refEntity is null.");
            }
            if (r.property == null) {
                throw new InvalidMetaDataException("The propertyRef: " + this.ref.toString() + " 's refProperty is null.");
            }
            return r;
        }

        String getRefUnitName() {
            if (this.ref != null) {
                return this.ref.getRefUnit().getName();
            }
            return this.refDele.getRefUnit().getName();
        }

        String getSubQueryName() {
            if (this.ref != null) {
                return this.ref.getSubQuery().getName();
            }
            return this.refDele.getSubQuery().getName();
        }

        String getPostfix() {
            if (this.ref != null) {
                return "_" + ContextUtils.getLocaleFromEnv();
            }
            return this.refDele.getPostfix();
        }

        int getSubObjectType() {
            int type = -1;
            if (this.ref != null) {
                if (this.ref.getSubEntity() != null) {
                    type = 0;
                } else if (this.ref.getSubQuery() != null) {
                    type = 1;
                }
            } else if (this.refDele.getSubEntity() != null) {
                type = 0;
            } else if (this.refDele.getSubQuery() != null) {
                type = 1;
            }
            return type;
        }
    }
}

