/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.DeleContext;
import com.kingdee.bos.dao.DeleContextUtil;
import com.kingdee.bos.metadata.AbstractMDValueDele;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.query.PropertyRefCollectionDele;
import com.kingdee.bos.metadata.query.PropertyRefDele;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.ConstFieldCollection;
import com.kingdee.bos.metadata.query.util.GroupType;
import com.kingdee.bos.metadata.query.util.QueryDeleUtil;
import com.kingdee.util.StringUtils;
import java.util.Locale;

public class PropertyUnitDele
extends AbstractMDValueDele {
    private transient String name = null;

    protected PropertyUnitDele(PropertyUnitInfo field, DeleContext ctx) {
        super(field, ctx);
        this.put("propertyRefs", new PropertyRefCollectionDele(field.getPropertyRefs(), ctx));
        this.setQuery(QueryDele.getInstance(field.getQuery(), ctx));
    }

    public static PropertyUnitDele getInstance(PropertyUnitInfo queryField, DeleContext ctx) {
        if (queryField == null) {
            return null;
        }
        PropertyUnitDele dele = (PropertyUnitDele)DeleContextUtil.get(queryField.getBOSType(), ctx, queryField);
        if (dele == null) {
            dele = new PropertyUnitDele(queryField, ctx);
        }
        return dele;
    }

    public static PropertyUnitDele newInstance(QueryDele query) {
        PropertyUnitDele dele = new PropertyUnitDele(new PropertyUnitInfo((QueryInfo)query.getTarget()), query.getContext());
        dele.isTgtNew = true;
        dele.setQuery(query);
        return dele;
    }

    public static PropertyUnitDele newInstance(QueryDele query, PropertyRefDele propRef) {
        PropertyUnitDele dele = new PropertyUnitDele(new PropertyUnitInfo((QueryInfo)query.getTarget(), (PropertyRefInfo)propRef.getTarget()), query.getContext());
        dele.isTgtNew = true;
        dele.setQuery(query);
        return dele;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getString("name");
        }
        return this.name;
    }

    public void setName(String item) {
        this.setString("name", item);
        this.name = item;
    }

    public String getDisplayName() {
        return this.getDisplayName(null);
    }

    public void setDisplayName(String item) {
        this.setDisplayName(item, null);
    }

    public String getDisplayName(Locale locale) {
        return (String)this.get("displayName", locale);
    }

    public void setDisplayName(String item, Locale locale) {
        this.put("displayName", item, locale);
    }

    public boolean isIsSelector() {
        return this.getBoolean("isSelector");
    }

    public void setIsSelector(boolean item) {
        this.setBoolean("isSelector", item);
    }

    public boolean isIsFilter() {
        return this.getBoolean("isFilter");
    }

    public void setIsFilter(boolean item) {
        this.setBoolean("isFilter", item);
    }

    public boolean isIsSorter() {
        return this.getBoolean("isSorter");
    }

    public void setIsSorter(boolean item) {
        this.setBoolean("isSorter", item);
    }

    public GroupType getGroupType() {
        String s = this.getString("groupType");
        if (StringUtils.isEmpty((String)s) || s.length() == 0) {
            return GroupType.NONE;
        }
        return GroupType.getEnum(this.getString("groupType"));
    }

    public PropertyRefCollectionDele getPropertyRefs() {
        return (PropertyRefCollectionDele)this.get("propertyRefs");
    }

    public void addPropertyRef(PropertyRefDele propRef) {
        if (this.isTgtNew) {
            ((PropertyUnitInfo)this.getTarget()).getPropertyRefs().add((PropertyRefInfo)propRef.getTarget());
        } else {
            this.getPropertyRefs().add(propRef);
        }
    }

    public ConstFieldCollection getConstFields() {
        String s = this.getConstString();
        if (s == null) {
            s = "";
        }
        return new ConstFieldCollection(s);
    }

    protected String getConstString() {
        return this.getString("constString");
    }

    public String getFormulaString() {
        String s = this.getString("formulaString");
        if (StringUtils.isEmpty((String)s)) {
            s = this.getPropertyRefs().size() == 1 && this.getConstFields().size() == 0 ? "#0" : "";
        }
        return s;
    }

    public void setFormulaString(String formula) {
        this.setString("formulaString", formula);
    }

    public String getShowValue() throws BOSException {
        return QueryDeleUtil.getUnitString(this);
    }

    public ConstDataType getReturnType() throws BOSException {
        return ((PropertyUnitInfo)this.target).getReturnType();
    }

    public SQLType getMappingFieldType() throws BOSException {
        SQLType type = null;
        type = "#0".equalsIgnoreCase(this.getFormulaString()) ? this.getPropertyRefs().get(0).getSQLType() : SQLType.NVARCHAR;
        if (type != null) {
            return type;
        }
        throw new BOSException("Can't get the ColumnInfo type! This field displayName:" + this.getDisplayName());
    }

    public QueryDele getQuery() {
        return (QueryDele)this.get("query");
    }

    public void setQuery(QueryDele item) {
        this.put("query", item);
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!(that instanceof PropertyUnitDele)) {
            return false;
        }
        if (this.getName() != null) {
            return this.getName().equals(((PropertyUnitDele)that).getName());
        }
        return false;
    }
}

