/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryEditException;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryFilterInfo;
import com.kingdee.bos.metadata.query.QueryFilterItemInfo;
import com.kingdee.bos.metadata.query.QueryPKInfo;
import com.kingdee.bos.metadata.query.QueryParameterCollection;
import com.kingdee.bos.metadata.query.QueryParameterInfo;
import com.kingdee.bos.metadata.query.QuerySorterItemCollection;
import com.kingdee.bos.metadata.query.QuerySorterItemInfo;
import com.kingdee.bos.metadata.query.QueryValidate;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.util.Query4EntityUtil;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.util.Assert;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class QueryInfo
extends AbstractMetaDataValue
implements Serializable,
Cloneable {
    public static final String CONNECTION_PROVIDER = "connectionProvider";
    private static final Logger log = Logger.getLogger(QueryInfo.class);

    public QueryInfo() {
        this.put("units", new PropertyUnitCollection());
        this.put("parameters", new QueryParameterCollection());
        this.put("subObjects", new SubObjectCollection());
        this.put("defaultSorters", new QuerySorterItemCollection());
    }

    protected QueryInfo(boolean init) {
        super(init);
        this.put("units", new PropertyUnitCollection());
        this.put("parameters", new QueryParameterCollection());
        this.put("subObjects", new SubObjectCollection());
        this.put("defaultSorters", new QuerySorterItemCollection());
    }

    @Override
    public Object clone() {
        try {
            QueryInfo cloned = (QueryInfo)ObjectUtils.createCopy((Object)this);
            cloned.resetQueryInfo();
            return cloned;
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }

    public String getNewSubObjectName() {
        return this.getNewSubObjectName("NewSubObject");
    }

    public String getNewSubObjectName(String name) {
        int i = 0;
        String newName = name;
        while (this.getSubObjects().contains(newName)) {
            ++i;
            if (newName.length() == name.length()) {
                newName = newName + i;
                continue;
            }
            newName = newName.substring(0, newName.length() - ("" + i).length()) + i;
        }
        return newName;
    }

    public String getNewUnitName() {
        return Uuid.create().toString();
    }

    public String getNewParameterName() {
        return Uuid.create().toString();
    }

    public PropertyUnitCollection getUnits() {
        return (PropertyUnitCollection)this.get("units");
    }

    public QueryPKInfo getQueryPK() {
        return (QueryPKInfo)this.get("queryPK");
    }

    public void setQueryPK(QueryPKInfo queryPK) {
        this.put("queryPK", queryPK);
    }

    public SelectorInfo getSelector() {
        SelectorInfo selector = new SelectorInfo();
        int size = this.getUnits().size();
        for (int i = 0; i < size; ++i) {
            QueryFieldInfo fld;
            PropertyUnitInfo unit = this.getUnits().get(i);
            if (!(unit instanceof QueryFieldInfo) || !(fld = (QueryFieldInfo)unit).isIsSelector()) continue;
            selector.add(fld);
        }
        return selector;
    }

    public QueryParameterCollection getParameters() {
        return (QueryParameterCollection)this.get("parameters");
    }

    public QueryFilterInfo getDefaultFilter() {
        QueryFilterInfo filter = (QueryFilterInfo)this.get("defaultFilter");
        if (filter != null) {
            filter.setQuery(this);
            filter.setName("defaultFilter");
        }
        return filter;
    }

    public void setDefaultFilter(QueryFilterInfo item) {
        this.put("defaultFilter", item);
    }

    public QuerySorterItemCollection getDefaultSorters() {
        return (QuerySorterItemCollection)this.get("defaultSorters");
    }

    public void setDefaultSorters(QuerySorterItemCollection item) {
        this.put("defaultSorters", item);
    }

    public SubObjectCollection getSubObjects() {
        return (SubObjectCollection)this.get("subObjects");
    }

    public void removeSubObject(String name) throws BOSException {
        this.removeSubObject(this.getSubObjects().get(name));
    }

    public void removeSubObject(SubObjectInfo subObj) throws BOSException {
        if (subObj == null) {
            return;
        }
        SubObjectCollection subObjs = this.getSubObjects();
        if (!(this instanceof JoinQueryInfo)) {
            subObjs.remove(subObj);
            return;
        }
        JoinCollection joins = subObj.getJoinsFromClient();
        if (joins.size() > 0) {
            throw new QueryEditException("The SubObject:\"" + subObj.getName() + "\" has other link, can't be removed.");
        }
        this.removeJoin(subObj);
        this.removePKField(subObj);
        this.removeUnit(subObj);
        subObjs.remove(subObj.getName());
    }

    private void removePKField(SubObjectInfo subObj) {
        if (subObj == null) {
            return;
        }
        QueryPKInfo queryPK = this.getQueryPK();
        if (queryPK != null) {
            QueryFieldCollection fieldCol = queryPK.getKeyPropertys();
            block0: for (int i = fieldCol.size() - 1; i >= 0; --i) {
                PropertyRefCollection refs = fieldCol.get(i).getPropertyRefs();
                for (int j = 0; j < refs.size(); ++j) {
                    PropertyRefInfo ref = refs.get(j);
                    if (ref.getSubEntity() == null || !ref.getSubEntity().getName().equals(subObj.getName())) continue;
                    fieldCol.removeObject(i);
                    continue block0;
                }
            }
        }
    }

    private void removeJoin(SubObjectInfo subObj) {
        int i;
        JoinCollection joins = subObj.getJoins();
        PropertyUnitCollection delCols = new PropertyUnitCollection();
        for (i = 0; i < joins.size(); ++i) {
            JoinInfo join = joins.get(i);
            for (int j = 0; j < join.getJoinItems().size(); ++j) {
                JoinItemInfo item = join.getJoinItems().get(j);
                if (!delCols.contains(item.getLeftField())) {
                    delCols.add(item.getLeftField());
                    continue;
                }
                if (delCols.contains(item.getRightField())) continue;
                delCols.add(item.getRightField());
            }
            ((JoinQueryInfo)this).getJoins().remove(join.getName());
        }
        for (i = 0; i < delCols.size(); ++i) {
            this.getUnits().remove(delCols.get(i).getName());
        }
    }

    private void removeUnit(SubObjectInfo subObj) {
        int i;
        PropertyUnitCollection delCols = new PropertyUnitCollection();
        block0: for (i = 0; i < this.getUnits().size(); ++i) {
            PropertyUnitInfo unit = this.getUnits().get(i);
            PropertyRefCollection refs = unit.getPropertyRefs();
            for (int j = 0; j < refs.size(); ++j) {
                PropertyRefInfo ref = refs.get(j);
                if (ref.getSubEntity() != null) {
                    if (!ref.getSubEntity().getName().equals(subObj.getName())) continue;
                    if (delCols.contains(unit.getName())) continue block0;
                    delCols.add(unit);
                    continue block0;
                }
                if (ref.getSubQuery() != null) {
                    if (!ref.getSubQuery().getName().equals(subObj.getName())) continue;
                    if (delCols.contains(unit.getName())) continue block0;
                    delCols.add(unit);
                    continue block0;
                }
                Assert.that((String)("The Propertref: " + ref.toString() + " no parent."), (boolean)false);
            }
        }
        for (i = 0; i < delCols.size(); ++i) {
            this.getUnits().remove(delCols.get(i).getName());
            if (this.getDefaultSorters() == null) continue;
            this.getDefaultSorters().remove(delCols.get(i).getName());
        }
    }

    @Override
    public ValidateList validate() {
        super.validate();
        return new QueryValidate(this, this.getValidate()).validate();
    }

    public boolean isExist(String objName) {
        int n = this.getSubObjects().size();
        for (int i = 0; i < n; ++i) {
            if (!StringUtils.equalsIgnoreCase((String)this.getSubObjects().get(i).getName(), (String)objName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (!(that instanceof QueryInfo)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.getFullName())) {
            return false;
        }
        return this.getFullName().equals(((QueryInfo)that).getFullName());
    }

    @Override
    public String toString() {
        return this.getFullName();
    }

    @Override
    public void setUserDefined(boolean isUserDefined) {
        this.put("userDefined", isUserDefined);
    }

    @Override
    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public void setReportDataSource(String reportDataSource) {
        this.put("reportDataSource", reportDataSource);
    }

    public String getReportDataSource() {
        return this.getString("reportDataSource");
    }

    public void setBizUnitPK(String bizUnitPK) {
        this.put("bizUnitPK", bizUnitPK);
    }

    public String getBizUnitPK() {
        return this.getString("bizUnitPK");
    }

    public String getConnectionProvider() {
        return this.getString(CONNECTION_PROVIDER);
    }

    public void setConnectionProvider(String provider) {
        this.setString(CONNECTION_PROVIDER, provider);
    }

    public abstract SubObjectInfo getMainObject() throws BOSException;

    public void updateQuery(EntityViewInfo view) throws BOSException {
        this.updateQuery(view, null);
    }

    protected void updateQuery(EntityViewInfo view, Context context) throws BOSException {
        if (view == null) {
            return;
        }
        try {
            FilterItemCollection fic;
            Iterator ite = view.getSelector().iterator();
            while (ite.hasNext()) {
                SelectorItemInfo info = (SelectorItemInfo)ite.next();
                if (!info.isFuncCol()) {
                    QueryFieldInfo fld = this.getUnits().getQueryFields().get(info.getPropertyName());
                    if (fld == null && (fld = Query4EntityUtil.processPropertyName(this, info.getPropertyName(), true, context)) != null) {
                        fld.setFormulaString(info.getFormulaString());
                        fld.setDisplayName(info.getDisplayName());
                    }
                    if (fld == null) continue;
                    fld.getExtendedProperties().putAll(info.getExtendedProperties());
                    continue;
                }
                Object[] fields = info.getFieldsArray();
                for (int i = 0; i < fields.length; ++i) {
                    String propName = (String)fields[i];
                    QueryFieldInfo fld = this.getUnits().getQueryFields().get(propName);
                    if (fld == null) {
                        fld = Query4EntityUtil.processPropertyName(this, propName, true, context);
                    }
                    if (fld == null) continue;
                    fld.getExtendedProperties().putAll(info.getExtendedProperties());
                }
            }
            if (view.getFilter() != null && (fic = view.getFilter().getFilterItems()) != null) {
                ite = fic.iterator();
                while (ite.hasNext()) {
                    FilterItemInfo info = (FilterItemInfo)ite.next();
                    if (!info.isFuncCol()) {
                        QueryFieldInfo fld = this.getUnits().getQueryFields().get(info.getPropertyName());
                        if (fld == null) {
                            fld = Query4EntityUtil.processPropertyName(this, info.getPropertyName(), false, context);
                        }
                        if (fld == null) continue;
                        fld.getExtendedProperties().putAll(info.getExtendedProperties());
                        continue;
                    }
                    Object[] fields = info.getFieldsArray();
                    for (int i = 0; i < fields.length; ++i) {
                        String propName = (String)fields[i];
                        QueryFieldInfo fld = this.getUnits().getQueryFields().get(propName);
                        if (fld == null) {
                            fld = Query4EntityUtil.processPropertyName(this, propName, false, context);
                        }
                        if (fld == null) continue;
                        fld.getExtendedProperties().putAll(info.getExtendedProperties());
                    }
                }
            }
        }
        catch (BOSException e) {
            BOSException e2 = new BOSException(e.getMessage() + ",  query : " + this + ",  view : " + view);
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
    }

    protected void resetQueryInfo() {
        QueryFilterInfo filterInfo;
        Iterator ite2;
        AbstractObjectCollection coll;
        AbstractMDElement sub;
        if (this.getSubObjects() == null) {
            return;
        }
        Iterator ite = this.getSubObjects().iterator();
        while (ite.hasNext()) {
            sub = (SubObjectInfo)ite.next();
            ((SubObjectInfo)sub).setQuery(this);
        }
        ite = this.getUnits().iterator();
        while (ite.hasNext()) {
            PropertyUnitInfo unit = (PropertyUnitInfo)ite.next();
            unit.setQuery(this);
            coll = unit.getPropertyRefs();
            if (coll == null) continue;
            ite2 = coll.iterator();
            while (ite2.hasNext()) {
                PropertyRefInfo ref = (PropertyRefInfo)ite2.next();
                SubEntityInfo oldSub = ref.getSubEntity();
                if (oldSub == null) continue;
                SubEntityInfo newSub = QueryUtil.findSubEntityInfoByName(oldSub.getName(), this);
                if (newSub != null) {
                    ref.setSubEntity(newSub);
                    continue;
                }
                log.error((Object)("\u514b\u9686QueryInfo\u5bf9\u8c61\u5931\u8d25: cannot find object(" + oldSub.getName() + ")."));
            }
        }
        ite = this.getParameters().iterator();
        while (ite.hasNext()) {
            sub = (QueryParameterInfo)ite.next();
            ((QueryParameterInfo)sub).setQuery(this);
        }
        if (this.getDefaultFilter() != null && (coll = (filterInfo = this.getDefaultFilter()).getFilterItems()) != null) {
            ite2 = coll.iterator();
            while (ite2.hasNext()) {
                QueryFilterItemInfo item = (QueryFilterItemInfo)ite2.next();
                item.setFilter(filterInfo);
            }
        }
        ite = this.getDefaultSorters().iterator();
        while (ite.hasNext()) {
            sub = (QuerySorterItemInfo)ite.next();
            ((QuerySorterItemInfo)sub).setQuery(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMainObjectPKField(SubObjectInfo subObj) {
        ArrayList<QueryFieldInfo> list = this.getSelector().getFields();
        if (subObj == null) return null;
        while (subObj instanceof SubQueryInfo) {
            try {
                subObj = ((SubQueryInfo)subObj).getQueryRef().getMainObject();
            }
            catch (BOSException e) {}
        }
        if (subObj == null || !(subObj instanceof SubEntityInfo)) return null;
        SubEntityInfo subEntity = (SubEntityInfo)subObj;
        String logicKey = subEntity.getName() + "." + subEntity.getEntityRef().getLogicalKey().getKeyPropertys().get(0).getName();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            QueryFieldInfo fld = list.get(i);
            if (!this.isEntityPK(logicKey, fld)) continue;
            return fld.getName();
        }
        return null;
    }

    private boolean isEntityPK(String logicalKeyName, QueryFieldInfo fld) {
        PropertyRefCollection propRefs = fld.getPropertyRefs();
        if (propRefs.size() != 1 || StringUtils.isEmpty((String)logicalKeyName)) {
            return false;
        }
        PropertyRefInfo ref = propRefs.get(0);
        if (ref.getSubEntity() == null || ref.getRefProperty() == null) {
            return false;
        }
        return logicalKeyName.equalsIgnoreCase(ref.getSubEntity().getName() + "." + ref.getRefProperty().getName());
    }
}

