/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.RelationshipCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import java.util.List;

class RelationCreator {
    private EntityObjectInfo left;
    private EntityObjectInfo right;
    private LinkPropertyInfo lnkProp;

    RelationCreator(EntityObjectInfo left, EntityObjectInfo right, LinkPropertyInfo lnkProp) {
        this.left = left;
        this.right = right;
        this.lnkProp = lnkProp;
    }

    public RelationshipCollection create() {
        RelationshipCollection rels = new RelationshipCollection();
        if (this.left == null || this.right == null) {
            return rels;
        }
        PropertyCollection props = this.left.getInheritedNoDuplicatedProperties();
        for (int i = 0; i < props.size(); ++i) {
            LinkPropertyInfo prop;
            if (!(props.get(i) instanceof LinkPropertyInfo) || (!RelationCreator.isAvalidateLinkProperty(prop = (LinkPropertyInfo)props.get(i), this.left, true) || !RelationCreator.isAvalidateLinkProperty(prop, this.right, false)) && (!RelationCreator.isAvalidateLinkProperty(prop, this.left, false) || !RelationCreator.isAvalidateLinkProperty(prop, this.right, true))) continue;
            if (this.lnkProp != null) {
                if (!this.lnkProp.getName().equals(prop.getName())) continue;
                rels.add(prop.getRelationship());
                break;
            }
            rels.add(prop.getRelationship());
        }
        return rels;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAvalidateLinkProperty(LinkPropertyInfo lnkProp, EntityObjectInfo en, boolean isClient) {
        if (lnkProp == null) {
            return false;
        }
        String name = "";
        RelationshipInfo relation = lnkProp.getRelationship();
        if (relation == null) {
            throw new RuntimeException("lnkProp.getRelationship() is null,  property=" + lnkProp.getName());
        }
        if (isClient) {
            if (relation.getClientObject() == null) throw new RuntimeException("getClientObject() is null,  property=" + lnkProp.getName() + "  relation=" + relation.getFullName());
            name = relation.getClientObject().getFullName();
        } else {
            if (relation.getSupplierObject() == null) throw new RuntimeException("getSupplierObject() is null,  property=" + lnkProp.getName() + "  relation=" + relation.getFullName());
            name = relation.getSupplierObject().getFullName();
        }
        if (name.equals(en.getFullName())) {
            return true;
        }
        List sts = en.getSTList();
        for (EntityObjectInfo stEn : sts) {
            if (!name.equals(stEn.getFullName())) continue;
            return true;
        }
        EntityObjectInfo parent = en.getBaseEntity();
        return parent != null && RelationCreator.isAvalidateLinkProperty(lnkProp, parent, isClient);
    }
}

