/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.util.UnionType;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;

public class UnionQueryInfo
extends QueryInfo
implements Serializable {
    public UnionQueryInfo() {
    }

    protected UnionQueryInfo(boolean init) {
        super(init);
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.UNIONQUERY;
    }

    public String getFormulaString() {
        String s = this.getString("formulaString");
        if (StringUtils.isEmpty((String)s)) {
            s = this.getSubObjects().size() == 1 ? "#0" : "";
        }
        return s;
    }

    public void setFormulaString(String formula) {
        this.setString("formulaString", formula);
    }

    @Override
    public ValidateList validate() {
        super.validate();
        ValidateMetaData vld = this.getValidate();
        try {
            SubObjectInfo mainObj = this.getMainObject();
            SubObjectCollection unionObjs = this.getUnionObjects();
            for (int i = 0; i < unionObjs.size(); ++i) {
                if (!(unionObjs.get(i) instanceof SubQueryInfo)) continue;
                QueryInfo mainQuery = ((SubQueryInfo)mainObj).getQueryRef();
                QueryInfo subQuery = ((SubQueryInfo)unionObjs.get(i)).getQueryRef();
                this.equal(mainQuery, subQuery);
            }
        }
        catch (Exception e) {
            vld.addError(e.getMessage());
        }
        return vld.getValidateList();
    }

    private void equal(QueryInfo mainQuery, QueryInfo subQuery) throws BOSException {
        ArrayList<QueryFieldInfo> mainList = mainQuery.getSelector().getFields();
        ArrayList<QueryFieldInfo> subList = subQuery.getSelector().getFields();
        ValidateMetaData vld = this.getValidate();
        if (mainList.size() != subList.size()) {
            vld.addError("[" + mainQuery.getName() + "]'s selector size does't equal to [" + subQuery.getName() + "]");
        } else {
            for (int i = 0; i < mainList.size(); ++i) {
                QueryFieldInfo mainQueryField = mainList.get(i);
                QueryFieldInfo subQueryField = subList.get(i);
                if (mainQueryField.getReturnType().equals((Object)subQueryField.getReturnType())) continue;
                vld.addError("[" + mainQuery.getName() + "].queryField[" + mainQueryField.getName() + "]'s returnType does't equal to [" + subQuery.getName() + "].queryField" + subQueryField.getName());
            }
        }
    }

    @Override
    public SubObjectInfo getMainObject() throws BOSException {
        SubObjectCollection subObjs = this.getSubObjects();
        if (subObjs.size() < 1) {
            throw new BOSException("Union Query must include at least one query!");
        }
        for (int i = 0; i < subObjs.size(); ++i) {
            SubQueryInfo info;
            if (!(subObjs.get(i) instanceof SubQueryInfo) || !(info = (SubQueryInfo)subObjs.get(i)).getUnionType().equals((Object)UnionType.MAIN)) continue;
            return info;
        }
        throw new BOSException("Can't found main object please set main obj!");
    }

    public SubObjectCollection getUnionObjects() throws BOSException {
        SubObjectCollection subObjs = this.getSubObjects();
        SubObjectCollection unionObjs = new SubObjectCollection();
        unionObjs.addObjectCollection(subObjs);
        if (subObjs.size() <= 1) {
            throw new BOSException("Union Query must include at least two sub query!");
        }
        unionObjs.remove(this.getMainObject());
        if (unionObjs.size() == 0) {
            throw new InvalidMetaDataException("Can't find the union object.");
        }
        return unionObjs;
    }

    public void setUnionQueryField() throws BOSException {
        SubQueryInfo objQuery = null;
        QueryInfo base = null;
        SubObjectInfo obj = this.getMainObject();
        if (!(obj instanceof SubQueryInfo)) {
            throw new BOSException("Main Object type is not SubQueryInfo!");
        }
        objQuery = (SubQueryInfo)obj;
        base = objQuery.getQueryRef();
        if (objQuery.getUnionType().equals((Object)UnionType.MAIN) && base != null) {
            int n = base.getSelector().getFields().size();
            for (int i = 0; i < n; ++i) {
                QueryFieldInfo field = base.getSelector().getFields().get(i);
                if (field.getFormulaString().length() != 0) {
                    field.setFormulaString("");
                }
                field.getPropertyRefs().clear();
                PropertyRefInfo ref = new PropertyRefInfo();
                ref.setSubQuery(objQuery);
                ref.setRefUnit(field);
                field.getPropertyRefs().add(ref);
                this.getUnits().add(field);
            }
        } else {
            throw new BOSException("Main Object type is not SubQueryInfo!");
        }
    }
}

