/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query.token;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.query.token.CharReader;
import com.kingdee.bos.metadata.query.token.ConstToken;
import com.kingdee.bos.metadata.query.token.IToken;
import com.kingdee.bos.metadata.query.token.LogicToken;
import com.kingdee.bos.metadata.query.token.ObjectValueToken;
import com.kingdee.bos.metadata.query.token.OperatorToken;
import com.kingdee.bos.metadata.query.token.OtherToken;
import com.kingdee.bos.metadata.query.token.TokenKey;
import com.kingdee.bos.metadata.query.token.TokenList;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.ConstField;
import java.util.ArrayList;
import java.util.HashSet;

public class CollectionFormulaParser {
    private AbstractObjectCollection collection;
    private CharReader reader;
    public TokenList tokenList;
    private static final char KEYWORD = '#';
    private static final char MLCR = '[';
    private static final char MRCR = ']';
    private static final char DOT = '.';
    private static final char SQUT = '\'';
    private static final char DQUT = '\"';

    public CollectionFormulaParser(String formula, AbstractObjectCollection col) throws BOSException {
        this.reader = new CharReader(formula);
        this.collection = col;
        this.tokenList = new TokenList();
        this.parser();
    }

    private int getDiffObjectValueTokenSize() {
        ArrayList<ObjectValueToken> list = this.tokenList.getObjectValueTokenList();
        HashSet<AbstractObjectValue> set = new HashSet<AbstractObjectValue>();
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            set.add(list.get(i).getObjectValue());
        }
        return set.size();
    }

    private void parser() throws BOSException {
        while (!this.reader.isEos()) {
            IToken t;
            ConstField fld;
            this.reader.next();
            if (Character.isWhitespace(this.reader.get())) continue;
            if (this.isStringConstKey(this.reader.get())) {
                fld = new ConstField(this.getStringConst(this.reader.get()), ConstDataType.STRING);
                this.tokenList.add(new ConstToken(fld));
                continue;
            }
            if (this.reader.get() == '#') {
                int i = this.getKeyIndex();
                if (i == -1) continue;
                this.tokenList.add(new ObjectValueToken(this.collection.getObject(i)));
                continue;
            }
            if (TokenKey.isOperators(this.reader.get())) {
                this.tokenList.add(new OperatorToken(this.reader.get()));
                continue;
            }
            if (Character.isLetter(this.reader.get())) {
                t = this.getLogicString(this.reader.get());
                if (t == null) continue;
                this.tokenList.add(t);
                continue;
            }
            if (Character.isDigit(this.reader.get())) {
                fld = new ConstField(this.getNumber(this.reader.get()).toString(), ConstDataType.NUMBER);
                this.tokenList.add(new ConstToken(fld));
                continue;
            }
            t = new OtherToken(this.getOther(this.reader.get()));
            this.tokenList.add(t);
        }
    }

    private String getOther(char c) {
        String s = "" + c;
        while (!this.reader.isEos()) {
            this.reader.next();
            if (TokenKey.isOperators(this.reader.get())) {
                this.reader.previous();
                break;
            }
            s = s + this.reader.get();
        }
        return s;
    }

    private String getStringConst(char c) {
        String s = "";
        char begin = c;
        while (!this.reader.isEos()) {
            this.reader.next();
            if (begin == '\'') {
                if (this.reader.get() == '\'') break;
                s = s + this.reader.get();
                continue;
            }
            if (begin != '\"') continue;
            if (this.reader.get() == '\"') break;
            s = s + this.reader.get();
        }
        return s;
    }

    private boolean isStringConstKey(char c) {
        return c == '\'' || c == '\"';
    }

    private Object getNumber(char c) {
        String intString = "" + c;
        boolean isFloat = false;
        while (!this.reader.isEos()) {
            this.reader.next();
            if (Character.isDigit(this.reader.get()) || this.reader.get() == '.' && !isFloat) {
                intString = intString + this.reader.get();
                if (isFloat) continue;
                isFloat = this.reader.get() == '.';
                continue;
            }
            this.reader.previous();
            break;
        }
        if (isFloat) {
            return new Float(intString);
        }
        return new Integer(intString);
    }

    private int getInt(char c) {
        String intString = "" + c;
        while (!this.reader.isEos()) {
            this.reader.next();
            if (Character.isDigit(this.reader.get())) {
                intString = intString + this.reader.get();
                continue;
            }
            this.reader.previous();
            break;
        }
        return Integer.parseInt(intString);
    }

    private int getKeyIndex() {
        String intString = "";
        while (!this.reader.isEos()) {
            this.reader.next();
            if (Character.isDigit(this.reader.get())) {
                intString = intString + this.reader.get();
                continue;
            }
            this.reader.previous();
            break;
        }
        if (intString.length() == 0) {
            return -1;
        }
        return Integer.parseInt(intString);
    }

    private IToken getLogicString(char c) {
        String lgString = "" + c;
        while (!this.reader.isEos()) {
            this.reader.next();
            if (this.reader.get() == '(' || Character.isWhitespace(this.reader.get()) || this.reader.get() == '#') {
                this.reader.previous();
                break;
            }
            lgString = lgString + this.reader.get();
        }
        if (TokenKey.isLogicWord(lgString)) {
            return new LogicToken(lgString);
        }
        if (TokenKey.isBoolean(lgString)) {
            return new ConstToken(new ConstField(lgString, ConstDataType.BOOLEAN));
        }
        return new OtherToken(lgString);
    }
}

