/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryFilterInfo;
import com.kingdee.bos.metadata.query.QueryFilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QuerySorterItemInfo;
import com.kingdee.bos.metadata.query.SubEntityCollection;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.query.token.CollectionFormulaParser;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.QueryNodeObject;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.util.HierarchyTreeNode;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class QueryUtil {
    public static final String ON = " ON ";

    public static ColumnInfo getColumnInfoByProp(PropertyInfo prop, EntityObjectInfo entity) throws BOSException {
        if (prop == null || entity == null) {
            return null;
        }
        if (prop instanceof OwnPropertyInfo || prop instanceof LinkPropertyInfo) {
            return QueryUtil.getColumnInfoByProp0(prop, entity);
        }
        try {
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(ConfigMDUtil.getContext());
            MetaDataPK pk = MetaDataPK.create(entity.getFullName());
            loader.clear(MetaDataTypeList.ENTITY, pk);
            entity = loader.getEntity(pk);
            PropertyInfo newProp = entity.getPropertyByName(prop.getName());
            if (newProp instanceof OwnPropertyInfo || newProp instanceof LinkPropertyInfo) {
                return QueryUtil.getColumnInfoByProp0(newProp, entity);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new BOSException("Property: " + prop.getName() + " 's type is not correct. Please check " + entity.getFullName() + " 's " + prop.getName() + " property exists whether or not.");
    }

    public static ColumnInfo getColumnInfoByProp(PropertyInfo prop, SubEntityInfo subEn) throws BOSException {
        if (subEn == null) {
            return null;
        }
        return QueryUtil.getColumnInfoByProp(prop, subEn.getEntityRef());
    }

    private static ColumnInfo getColumnInfoByProp0(PropertyInfo prop, EntityObjectInfo entity) throws BOSException {
        ColumnInfo col;
        if (prop instanceof LinkPropertyInfo) {
            RelationshipInfo rel = ((LinkPropertyInfo)prop).getRelationship();
            if (rel == null || rel.getClientObject() == null || rel.getSupplierObject() == null) {
                return null;
            }
            if (CardinalityType.isUnbounded(rel.getSupplierCardinality()) && (entity != null && rel.getClientObject().getFullName().equals(entity.getFullName()) || CardinalityType.isUnbounded(rel.getClientCardinality()))) {
                PropertyCollection propCol = rel.getClientObject().getLogicalKeyPropertiesRuntime();
                if (propCol == null || propCol.size() != 1) {
                    return null;
                }
                return propCol.get(0).getMappingField();
            }
        }
        if ((col = MetaDataUtils.getColumnInfoByPropFromEntity(entity, prop)) == null && prop.getExtendedField() != null) {
            return prop.getExtendedField().getExtendedColumn();
        }
        return col;
    }

    public static ConstDataType getConstDataType(DataType type) {
        if (type.equals(DataType.INTEGER) || type.equals(DataType.LONG) || type.equals(DataType.SHORT) || type.equals(DataType.BYTE)) {
            return ConstDataType.INT;
        }
        if (type.equals(DataType.DOUBLE) || type.equals(DataType.DECIMAL) || type.equals(DataType.FLOAT)) {
            return ConstDataType.NUMBER;
        }
        if (type.equals(DataType.DATE)) {
            return ConstDataType.DATE;
        }
        if (type.equals(DataType.TIME)) {
            return ConstDataType.TIME;
        }
        if (type.equals(DataType.TIMESTAMP)) {
            return ConstDataType.TIMESTAMP;
        }
        if (type.equals(DataType.CHAR) || type.equals(DataType.STRING) || type.equals(DataType.BOSUUID) || type.equals(DataType.UUID)) {
            return ConstDataType.STRING;
        }
        if (type.equals(DataType.BOOLEAN)) {
            return ConstDataType.BOOLEAN;
        }
        if (type.equals(DataType.ENUM)) {
            return ConstDataType.ENUM;
        }
        return ConstDataType.OBJECT;
    }

    public static ConstDataType getConstDataType(SQLType type) {
        if (type.equals(SQLType.INT)) {
            return ConstDataType.INT;
        }
        if (type.equals(SQLType.NUMERIC)) {
            return ConstDataType.NUMBER;
        }
        if (type.equals(SQLType.DATETIME)) {
            return ConstDataType.DATE;
        }
        if (type.equals(SQLType.VARCHAR) || type.equals(SQLType.CHAR) || type.equals(SQLType.NCHAR) || type.equals(SQLType.NVARCHAR)) {
            return ConstDataType.STRING;
        }
        return ConstDataType.OBJECT;
    }

    public static ConstDataType getConstDataType(int sqlType) {
        switch (sqlType) {
            case -7: {
                return ConstDataType.BOOLEAN;
            }
            case -5: 
            case 4: {
                return ConstDataType.INT;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return ConstDataType.NUMBER;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return ConstDataType.STRING;
            }
            case 91: {
                return ConstDataType.DATE;
            }
            case 92: {
                return ConstDataType.TIME;
            }
            case 93: {
                return ConstDataType.TIMESTAMP;
            }
        }
        return ConstDataType.OBJECT;
    }

    public static int getColumnType(ConstDataType tp) {
        int colType = 12;
        if (tp.equals((Object)ConstDataType.INT)) {
            colType = 4;
        } else if (tp.equals((Object)ConstDataType.NUMBER)) {
            colType = 3;
        } else if (tp.equals((Object)ConstDataType.STRING)) {
            colType = 12;
        } else if (tp.equals((Object)ConstDataType.DATE)) {
            colType = 91;
        } else if (tp.equals((Object)ConstDataType.TIME)) {
            colType = 92;
        } else if (tp.equals((Object)ConstDataType.TIMESTAMP)) {
            colType = 93;
        } else if (tp.equals((Object)ConstDataType.BOOLEAN)) {
            colType = -7;
        } else if (tp.equals((Object)ConstDataType.OBJECT)) {
            colType = 2000;
        }
        return colType;
    }

    public static SubObjectInfo getMainObject(JoinQueryInfo jqy) throws BOSException {
        int i;
        SubObjectCollection subObjs = jqy.getSubObjects();
        if (subObjs.size() == 1) {
            return subObjs.get(0);
        }
        JoinCollection joins = jqy.getJoins();
        HashMap rightMap = new HashMap(joins.size());
        ArrayList<SubObjectInfo> mainList = new ArrayList<SubObjectInfo>(subObjs.size());
        if (joins.size() < subObjs.size() - 1) {
            throw new InvalidMetaDataException("Some subobject do not has join to link to the other subobject");
        }
        for (i = 0; i < joins.size(); ++i) {
            JoinInfo join = joins.get(i);
            if (join == null || join.getRightObject() == null) continue;
            rightMap.put(join.getRightObject().getName().toLowerCase(), null);
        }
        for (i = 0; i < subObjs.size(); ++i) {
            SubObjectInfo sub = subObjs.get(i);
            if (rightMap.containsKey(sub.getName().toLowerCase())) continue;
            mainList.add(sub);
        }
        if (mainList.size() == 0) {
            throw new InvalidMetaDataException("Can't find the main object.");
        }
        if (mainList.size() > 1) {
            throw new InvalidMetaDataException("There are more than one main object during the query.");
        }
        return (SubObjectInfo)mainList.get(0);
    }

    public static HierarchyTreeNode getTree(JoinQueryInfo jqy) throws BOSException {
        return QueryUtil.getTreeNode(QueryUtil.getMainObject(jqy), null);
    }

    private static HierarchyTreeNode getTreeNode(SubObjectInfo subObj, JoinInfo join) throws BOSException {
        HierarchyTreeNode node = QueryUtil.addSubNode(subObj, join);
        JoinCollection joins = subObj.getJoinsFromClient();
        for (int i = 0; i < joins.size(); ++i) {
            SubObjectInfo child = joins.get(i).getRightObject();
            if (child == null) {
                throw new InvalidMetaDataException("Join: " + joins.get(i).getName() + " 's right object is null.");
            }
            node.add(QueryUtil.getTreeNode(child, joins.get(i)));
        }
        return node;
    }

    private static Object getLinkField(JoinInfo join) {
        if (join == null) {
            return null;
        }
        if (join.getJoinItems().size() > 1) {
            return join;
        }
        JoinItemInfo item = join.getJoinItems().get(0);
        if (item.getLeftField() == null) {
            return null;
        }
        if (item.getLeftField().getPropertyRefs().size() > 1) {
            return join;
        }
        PropertyRefInfo ref = item.getLeftField().getPropertyRefs().get(0);
        if (ref.getSubEntity() != null && ref.getRefProperty() != null) {
            return ref.getRefProperty();
        }
        if (ref.getSubQuery() != null && ref.getRefUnit() != null) {
            return ref.getRefUnit();
        }
        return null;
    }

    private static HierarchyTreeNode addSubNode(SubObjectInfo subObj, JoinInfo join) throws BOSException {
        HierarchyTreeNode node;
        block5: {
            Object minor;
            block4: {
                minor = QueryUtil.getLinkField(join);
                node = new HierarchyTreeNode();
                if (!(subObj instanceof SubEntityInfo)) break block4;
                SubEntityInfo subEn = (SubEntityInfo)subObj;
                if (subEn.getEntityRef() == null) {
                    throw new InvalidMetaDataException("SubEntity: " + subEn.getName() + " 's EntityRef is null.");
                }
                node.setUserObject((Object)new QueryNodeObject(subEn, minor));
                PropertyCollection props = subEn.getEntityRef().getInheritedNoDuplicatedProperties();
                for (int i = 0; i < props.size(); ++i) {
                    if (props.get(i) == null || !(props.get(i) instanceof OwnPropertyInfo)) continue;
                    node.add(new HierarchyTreeNode((Object)new QueryNodeObject(props.get(i))));
                }
                break block5;
            }
            if (!(subObj instanceof SubQueryInfo)) break block5;
            SubQueryInfo subQu = (SubQueryInfo)subObj;
            if (subQu.getQueryRef() == null) {
                throw new InvalidMetaDataException("SubQuery: " + subQu.getName() + " 's QueryRef is null.");
            }
            node.setUserObject((Object)new QueryNodeObject(subQu, minor));
            QueryFieldCollection flds = subQu.getQueryRef().getUnits().getQueryFields();
            for (int i = 0; i < flds.size(); ++i) {
                if (flds.get(i) == null) continue;
                node.add(new HierarchyTreeNode((Object)new QueryNodeObject(flds.get(i))));
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processQuerySorter(QueryInfo jqy, SorterItemInfo sorter) throws BOSException {
        QueryInfo queryInfo = jqy;
        synchronized (queryInfo) {
            if (sorter == null) {
                return;
            }
            if (jqy instanceof UnionQueryInfo) {
                throw new BOSException("The union query is not supported now.");
            }
            QuerySorterItemInfo querySorter = new QuerySorterItemInfo(jqy);
            querySorter.setPropertyName(sorter.getPropertyName());
            querySorter.setSortType(sorter.getSortType());
            querySorter.setNLSSortType(sorter.getNLSSortType());
            jqy.getDefaultSorters().add(querySorter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processQueryFilter(QueryInfo jqy, FilterInfo filter) throws BOSException {
        QueryInfo queryInfo = jqy;
        synchronized (queryInfo) {
            if (filter == null) {
                return;
            }
            if (jqy instanceof UnionQueryInfo) {
                throw new BOSException("The union query is not supported now.");
            }
            QueryFilterInfo queryFilter = new QueryFilterInfo(jqy);
            queryFilter.setName("defaultFilter");
            queryFilter.setFormulaString(filter.getMaskString());
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                QueryFilterItemInfo queryFilterItem = new QueryFilterItemInfo(queryFilter);
                queryFilterItem.setPropertyName(item.getPropertyName());
                queryFilterItem.setCompareType(item.getCompareType());
                queryFilterItem.setCompareValue(item.getCompareValue());
                queryFilterItem.setFuncCol(item.isFuncCol());
                queryFilterItem.setExprReturnType(item.getExprReturnType());
                queryFilter.getFilterItems().add(queryFilterItem);
            }
            jqy.setDefaultFilter(queryFilter);
        }
    }

    public static String processMaskString(int size, String maskString) {
        if (StringUtils.isEmpty((String)maskString)) {
            maskString = "";
            for (int i = 0; i < size; ++i) {
                String temp = "#" + String.valueOf(i);
                maskString = maskString + temp + " and ";
            }
            if (size > 0) {
                maskString = maskString.substring(0, maskString.length() - 4);
            }
        }
        return maskString;
    }

    public static SubEntityInfo findSubEntityInfoByName(String name, QueryInfo query) {
        for (int i = 0; i < query.getSubObjects().size(); ++i) {
            SubEntityInfo subEn;
            SubObjectInfo sub = query.getSubObjects().get(i);
            if (!(sub instanceof SubEntityInfo) || !(subEn = (SubEntityInfo)sub).getName().equals(name)) continue;
            return subEn;
        }
        return null;
    }

    public static QueryFieldInfo getQueryFieldByName(QueryInfo query, String name) {
        QueryFieldCollection coll = query.getUnits().getQueryFields();
        if (coll == null || name == null) {
            return null;
        }
        for (int i = 0; i < coll.size(); ++i) {
            QueryFieldInfo info = coll.get(i);
            if (!info.getName().equalsIgnoreCase(name)) continue;
            return info;
        }
        return null;
    }

    public static boolean checkQueryFieldRefSubObjectInList(QueryInfo query, SubEntityCollection subEntitys, QueryFieldInfo field) throws BOSException {
        PropertyRefCollection coll = field.getPropertyRefs();
        for (int j = 0; j < coll.size(); ++j) {
            PropertyRefInfo ref = coll.get(j);
            SubEntityInfo subEntity = ref.getSubEntity();
            if (subEntity == null) continue;
            boolean bExist = false;
            for (int i = 0; i < subEntitys.size(); ++i) {
                if (!subEntity.getName().equals(subEntitys.get(i).getName())) continue;
                bExist = true;
                break;
            }
            if (bExist) continue;
            return false;
        }
        return true;
    }

    public static String getFilterString(QueryFilterInfo filter) throws BOSException {
        return QueryUtil.getFilterString(filter, false, null);
    }

    public static String getFilterString(QueryFilterInfo filter, boolean bParaType, Map paraMap) throws BOSException {
        String formulaString = QueryUtil.processMaskString(filter.getFilterItems().size(), filter.getFormulaString());
        CollectionFormulaParser paser = new CollectionFormulaParser(formulaString, filter.getFilterItems());
        String val = paser.tokenList.showValue(bParaType, paraMap);
        return QueryUtil.replaceContactFormulaString(val);
    }

    public static boolean isAliableEnum(QueryFieldInfo fld) {
        PropertyRefInfo ref;
        return fld.getPropertyRefs().size() == 1 && (ref = fld.getPropertyRefs().get(0)).getSubEntity() != null && ref.getRefProperty() != null && ref.getRefProperty() instanceof OwnPropertyInfo && ((OwnPropertyInfo)ref.getRefProperty()).getDataType().equals(DataType.ENUM);
    }

    public static ColInfo getColumn(QueryFieldInfo fld, Context ctx, boolean bIsAutoTranslateEnum) throws BOSException {
        ColInfo col = new ColInfo();
        col.columnName = fld.getName();
        col.columnLabel = fld.getDisplayName(ctx.getLocale());
        col.colType = bIsAutoTranslateEnum && QueryUtil.isAliableEnum(fld) ? 2000 : QueryUtil.getColumnType(fld.getReturnType());
        col.extendedProperties().put("FieldInfo", fld);
        return col;
    }

    public static String getJoinString(JoinInfo join) throws BOSException {
        CollectionFormulaParser paser = new CollectionFormulaParser(join.getFormulaString(), join.getJoinItems());
        return ON + paser.tokenList.showValue();
    }

    public static String getUnitString(PropertyUnitInfo item) throws BOSException {
        CollectionFormulaParser paser = new CollectionFormulaParser(item.getFormulaString(), item.getPropertyRefs());
        String val = paser.tokenList.showValue();
        return QueryUtil.replaceContactFormulaString(val);
    }

    public static String getOrgValueBySqlBinaryExpr(SqlBinaryOpExpr expr) throws ParserException {
        if (expr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        SqlExpr leftExpr = expr.left;
        SqlExpr rightExpr = expr.right;
        if (leftExpr == null || rightExpr == null) {
            throw new ParserException("error ,  SqlExpr value :" + expr);
        }
        if (leftExpr instanceof SqlBinaryOpExpr) {
            sb.append(QueryUtil.getOrgValueBySqlBinaryExpr((SqlBinaryOpExpr)leftExpr));
        } else {
            sb.append(leftExpr.getOrgValue());
        }
        sb.append(".");
        if (rightExpr instanceof SqlBinaryOpExpr) {
            sb.append(QueryUtil.getOrgValueBySqlBinaryExpr((SqlBinaryOpExpr)rightExpr));
        } else {
            sb.append(rightExpr.getOrgValue());
        }
        return sb.toString();
    }

    public static String replaceContactFormulaString(String formulaSql) throws BOSException {
        Lexer lexer = new Lexer(formulaSql);
        StringBuffer buff = new StringBuffer();
        boolean flag = false;
        try {
            while (true) {
                Token token = lexer.next();
                if (token.type != 12) {
                    if (flag) {
                        buff.append(' ');
                    }
                    if (token.type == 4 && token.value.equals("&")) {
                        buff.append("||");
                    } else if (token.type == 16) {
                        buff.append("/*+ ").append(token.value).append(" */");
                    } else {
                        token.output(buff);
                    }
                    flag = true;
                    continue;
                }
                break;
            }
        }
        catch (ParserException e) {
            throw new BOSException("error", (Throwable)e);
        }
        buff.append(' ');
        return buff.toString();
    }

    public static String getEntityAlias(String name) {
        String nameAlias = null;
        nameAlias = name != null && name.trim().length() > 30 ? Base64.encodeString((String)name).substring(0, 30) : name;
        return nameAlias;
    }
}

