/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.query.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.PropertyUnitCollectionDele;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.util.AbstractBuilder;
import com.kingdee.bos.metadata.query.util.BuilderState;
import com.kingdee.bos.metadata.query.util.QueryDeleUtil;
import com.kingdee.bos.metadata.query.util.QuerySqlAccessBase;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SelectBuilder
extends AbstractBuilder {
    protected static final Logger logger = Logger.getLogger(SelectBuilder.class);
    private StringBuffer select;
    private int top = 0;
    protected boolean isDistinct = true;
    private boolean hasTOPAndDISTINCT = false;
    protected boolean addOrder2Selector = false;
    private ArrayList<PropertyUnitDele> selectors = null;

    public SelectBuilder(QuerySqlAccessBase qsa) {
        super(qsa);
    }

    @Override
    public String getSql() throws BOSException {
        if (this.select == null) {
            this.buildSelect();
        }
        return this.select.toString();
    }

    public boolean hasTOPAndDISTINCT() {
        return this.hasTOPAndDISTINCT;
    }

    public void setTop(int top) {
        if (this.top != top) {
            if (this.select != null && top > 0 && this.top > 0) {
                String s = StringUtils.replace((String)this.select.toString(), (String)("TOP " + this.top), (String)("TOP " + top));
                this.select = new StringBuffer(s);
            } else {
                this.select = null;
            }
            this.top = top;
        }
    }

    public void setDistinct(boolean isDistinct) {
        if (this.isDistinct != isDistinct) {
            if (this.isDistinct && !this.hasTOPAndDISTINCT) {
                if (this.select != null) {
                    String s = StringUtils.replace((String)this.select.toString(), (String)" DISTINCT ", (String)" ");
                    this.select = new StringBuffer(s);
                }
            } else {
                this.select = null;
            }
            this.isDistinct = isDistinct;
        }
    }

    public void setAddOrder2Selector(boolean addOrder2Selector) {
        if (this.addOrder2Selector != addOrder2Selector) {
            this.select = null;
            this.addOrder2Selector = addOrder2Selector;
        }
    }

    private void buildSelect() throws BOSException {
        this.select = new StringBuffer();
        this.select.append("SELECT ");
        if (this.top > 0) {
            this.select.append("TOP ");
            this.select.append(this.top);
            this.select.append(" ");
        }
        if (this.query.getType() == 0) {
            if (this.isDistinct && this.query.isIsDistinct()) {
                if (this.top > 0) {
                    this.hasTOPAndDISTINCT = true;
                } else {
                    this.select.append(" DISTINCT ");
                }
            } else {
                this.isDistinct = false;
            }
            ArrayList<PropertyUnitDele> flds = this.getSelector();
            int count = 0;
            int n = flds.size();
            for (int i = 0; i < n; ++i) {
                PropertyUnitDele field;
                String s;
                if (count != 0) {
                    this.select.append(',');
                }
                if ((s = QueryDeleUtil.getUnitString(field = flds.get(i)).replaceAll("&", "||")) != null && s.trim().length() == 0) {
                    s = "''";
                }
                this.select.append(s);
                this.select.append(" AS ");
                this.select.append('\"');
                String alias = this.getSelectorAlias(field, i);
                this.select.append(alias);
                this.select.append('\"');
                ++count;
            }
        }
    }

    public ArrayList<PropertyUnitDele> getSelector() throws BOSException {
        if (this.selectors == null) {
            this.selectors = this.innerGetSelector();
        }
        return this.selectors;
    }

    protected ArrayList<PropertyUnitDele> innerGetSelector() throws BOSException {
        String itemName;
        int i;
        EntityViewInfo view = this.qsa.state.getView();
        if (view == null || view.getSelector().size() == 0) {
            return this.query.getSelector().getFields();
        }
        ArrayList<PropertyUnitDele> list = new ArrayList<PropertyUnitDele>();
        PropertyUnitCollectionDele units = this.query.getUnits();
        List<PropertyUnitDele> flds = units.getQuerySelectorFields();
        SelectorItemCollection selectors = view.getSelector();
        if (view.isAppendSelectors()) {
            list.addAll(flds);
        }
        int n = selectors.size();
        for (i = 0; i < n; ++i) {
            itemName = selectors.get(i).getPropertyName();
            if (StringUtils.isEmpty((String)itemName) || this.checkQueryFieldExist(list, itemName)) continue;
            PropertyUnitDele field = units.getQueryFieldByName(itemName);
            if (field == null) {
                field = QueryDeleUtil.processPropertyName(this.query, itemName, true);
                if (field != null) {
                    list.add(field);
                    continue;
                }
                throw new BOSException("Can't found QueryField : " + itemName + " From EntityView ");
            }
            field.setIsSelector(true);
            if (!StringUtils.isEmpty((String)selectors.get(i).getFormulaString())) {
                field.setFormulaString(selectors.get(i).getFormulaString());
            }
            list.add(field);
        }
        n = selectors.size();
        for (i = 0; i < n; ++i) {
            itemName = selectors.get(i).getPropertyName();
            String aliasName = selectors.get(i).getAliasName();
            if (StringUtils.isEmpty((String)aliasName)) continue;
            if (this.checkQueryFieldExist(list, aliasName)) {
                logger.error((Object)("Can't set AliasName[" + aliasName + "] From EntityView, It already exists."));
                continue;
            }
            PropertyUnitDele field = this.getQueryFieldByName(list, itemName);
            if (field == null) continue;
            field.setName(aliasName);
        }
        return list;
    }

    protected PropertyUnitDele getQueryFieldByName(List<PropertyUnitDele> list, String name) {
        if (name != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                PropertyUnitDele obj = list.get(i);
                if (!name.equalsIgnoreCase(obj.getName())) continue;
                return obj;
            }
        }
        return null;
    }

    protected boolean checkQueryFieldExist(ArrayList<PropertyUnitDele> list, String name) {
        return this.getQueryFieldByName(list, name) != null;
    }

    @Override
    public void clear(BuilderState.ChangeEvent e) {
        if (e.type == 0) {
            this.select = null;
            this.selectors = null;
        }
    }

    public void queryFieldMapSeletorAlias(Map<String, String> fieldMap) throws BOSException {
        if (fieldMap == null) {
            return;
        }
        ArrayList<PropertyUnitDele> flds = this.getSelector();
        int n = flds.size();
        for (int i = 0; i < n; ++i) {
            PropertyUnitDele field = flds.get(i);
            String fieldName = field.getName();
            if (!fieldMap.containsKey(fieldName)) continue;
            fieldMap.put(fieldName, this.getSelectorAlias(field, i));
        }
    }
}

