/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.rule;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.rule.RuleMethodCollection;
import com.kingdee.bos.metadata.rule.RulePropertyCollection;
import com.kingdee.bos.metadata.rule.RulePropertyInfo;
import com.kingdee.bos.metadata.rule.RuleUtils;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class RuleInfo
extends AbstractMetaDataValue
implements Serializable {
    public RuleInfo() {
        this.put("ruleProperties", new RulePropertyCollection());
        this.put("ruleMethods", new RuleMethodCollection());
    }

    protected RuleInfo(boolean init) {
        super(init);
        this.put("ruleProperties", new RulePropertyCollection());
        this.put("ruleMethods", new RuleMethodCollection());
    }

    public RulePropertyCollection getRuleProperties() {
        return (RulePropertyCollection)this.get("ruleProperties");
    }

    public RuleMethodCollection getRuleMethods() {
        return (RuleMethodCollection)this.get("ruleMethods");
    }

    @Override
    public ValidateList validate() {
        ValidateList el = super.validate();
        ValidateMetaData validate = new ValidateMetaData(el);
        RulePropertyCollection props = this.getRuleProperties();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            RulePropertyInfo prop = props.get(i);
            validate.validateJavaIdentifier("Rule property name", prop.getName());
        }
        Context cx = Context.enter();
        Scriptable scope = cx.initStandardObjects(null);
        try {
            Script script = cx.compileReader(scope, (Reader)new StringReader(RuleUtils.getScript(ContextManager.getContext(), this)), "", 0, new Object());
        }
        catch (Throwable t) {
            String msg = "script error:" + t.getLocalizedMessage();
            validate.addError(msg);
        }
        return validate.getValidateList();
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.RULE;
    }

    public String getScript() {
        StringBuffer script = new StringBuffer();
        int m = this.getRuleProperties().size();
        for (int i = 0; i < m; ++i) {
            RulePropertyInfo prop = this.getRuleProperties().get(i);
            if (prop.isSetter() || prop.getMetaEntity() != null) continue;
            script.append("var " + prop.getName() + ";\n");
        }
        int n = this.getRuleMethods().size();
        for (int i = 0; i < n; ++i) {
            String temp = this.getRuleMethods().get(i).getRuleContent();
            if (StringUtils.isEmpty((String)temp)) {
                temp = "";
            }
            script.append("function " + this.getRuleMethods().get(i).getName() + "() { \n");
            StringTokenizer token = new StringTokenizer(temp, "\n");
            while (token.hasMoreTokens()) {
                script.append("    " + token.nextToken() + "\n");
            }
            script.append("}\n");
        }
        return script.toString();
    }

    public String getPreviewScript() {
        StringBuffer script = new StringBuffer();
        int m = this.getRuleProperties().size();
        for (int i = 0; i < m; ++i) {
            RulePropertyInfo prop = this.getRuleProperties().get(i);
            script.append("var " + prop.getName() + ";\n");
        }
        int n = this.getRuleMethods().size();
        for (int i = 0; i < n; ++i) {
            String temp = this.getRuleMethods().get(i).getRuleContent();
            if (StringUtils.isEmpty((String)temp)) {
                temp = "";
            }
            script.append("function " + this.getRuleMethods().get(i).getName() + "() { \n");
            StringTokenizer token = new StringTokenizer(temp, "\n");
            while (token.hasMoreTokens()) {
                script.append("    " + token.nextToken() + "\n");
            }
            script.append("}\n");
        }
        return script.toString();
    }
}

