/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.rule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.StrategyInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.IEntityObjectCtrl;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.facade.IFacadeCtrl;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.rule.IRuleCtrl;
import com.kingdee.bos.metadata.rule.RuleInfo;
import com.kingdee.bos.metadata.rule.RuleMethodInfo;
import com.kingdee.bos.metadata.rule.RulePropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RuleUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.rule.RuleUtils");
    private static int COMMAND_TRANSLATE = 1;
    private static int COMMAND_DETRANSLATE = 2;
    private static int COMMAND_COMPILE = 3;

    public static String getScript(Context ctx, RuleInfo rule) {
        int i;
        RuleInfo newRule = new RuleInfo();
        for (i = 0; i < rule.getRuleProperties().size(); ++i) {
            newRule.getRuleProperties().add(rule.getRuleProperties().get(i));
        }
        for (i = 0; i < rule.getRuleMethods().size(); ++i) {
            RuleMethodInfo newMethod = new RuleMethodInfo();
            RuleMethodInfo method = rule.getRuleMethods().get(i);
            newMethod.setName(method.getName());
            newMethod.setRuleContent(method.getRuleContent());
            newRule.getRuleMethods().add(newMethod);
        }
        RuleUtils.translate(ctx, newRule);
        RuleUtils.compile(newRule);
        return newRule.getPreviewScript();
    }

    public static void translate(Context ctx, RuleInfo rule) {
        RuleUtils.exeCommand(ctx, rule, COMMAND_TRANSLATE);
    }

    public static synchronized void deTranslate(Context ctx, RuleInfo rule) {
        RuleUtils.exeCommand(ctx, rule, COMMAND_DETRANSLATE);
    }

    public static void compile(RuleInfo rule) {
        RuleUtils.exeCommand(null, rule, COMMAND_COMPILE);
    }

    public static void interpret() {
    }

    private static void compile(Map props, RuleMethodInfo method) {
        String content = method.getRuleContent();
        StringBuffer bf = new StringBuffer();
        if (content == null) {
            return;
        }
        while (true) {
            int i = content.indexOf(91);
            int j = content.indexOf(93);
            if (i == -1 || j == -1 || i > j) break;
            boolean flag = false;
            String temp = content.substring(i, j + 1);
            String[] keys = props.keySet().toArray(new String[0]);
            for (int k = 0; k < keys.length; ++k) {
                if (!temp.startsWith("[" + keys[k]) || Character.isJavaIdentifierPart(temp.charAt(keys[k].length() + 1))) continue;
                flag = true;
                break;
            }
            if (flag) {
                bf.append(content.substring(0, i));
                bf.append(content.substring(i + 1, j));
                content = content.substring(j + 1, content.length());
                continue;
            }
            bf.append(content.substring(0, j + 1));
            content = content.substring(j + 1, content.length());
        }
        bf.append(content);
        method.setRuleContent(bf.toString());
    }

    private static void deTranslate(Context ctx, HashMap props, RuleMethodInfo method) {
        RuleUtils.interpret_init(ctx, props, method, COMMAND_DETRANSLATE);
    }

    private static void translate(Context ctx, HashMap props, RuleMethodInfo method) {
        RuleUtils.interpret_init(ctx, props, method, COMMAND_TRANSLATE);
    }

    private static void interpret_init(Context ctx, HashMap props, RuleMethodInfo method, int command) {
        IFacadeCtrl facadeCtrl;
        IEntityObjectCtrl entityCtrl;
        block7: {
            entityCtrl = null;
            facadeCtrl = null;
            try {
                entityCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject(ctx, MetaDataTypeList.ENTITY);
                facadeCtrl = (IFacadeCtrl)BOSObjectFactory.createBOSObject(ctx, MetaDataTypeList.FACADE);
            }
            catch (BOSException bose) {
                logger.error((Object)bose);
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)"Cannot create IEntityObjectCtrl or IFacadeCtrl!");
            }
        }
        StringBuffer bf = new StringBuffer();
        String script = method.getRuleContent();
        if (StringUtils.isEmpty((String)script)) {
            return;
        }
        while (true) {
            int i = script.indexOf(91);
            int j = script.indexOf(93);
            if (i == -1 || j == -1 || i > j) break;
            String temp = script.substring(i + 1, j);
            bf.append(script.substring(0, i + 1));
            if (command == COMMAND_TRANSLATE) {
                bf.append(RuleUtils.translate(ctx, props, entityCtrl, facadeCtrl, temp));
            } else if (command == COMMAND_DETRANSLATE) {
                bf.append(RuleUtils.deTranslate(ctx, props, temp));
            }
            bf.append("]");
            script = script.substring(j + 1, script.length());
        }
        bf.append(script);
        method.setRuleContent(bf.toString());
    }

    private static String translate(Context ctx, HashMap props, IEntityObjectCtrl entityCtrl, IFacadeCtrl facadeCtrl, String statement) {
        String script = statement;
        if (script.indexOf(91) != -1 || script.indexOf(93) != -1) {
            return statement;
        }
        String[] keys = props.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            RulePropertyInfo prop = (RulePropertyInfo)props.get(key);
            String alias = prop.getAlias();
            if (StringUtils.isEmpty((String)alias)) continue;
            MetaDataInfo metaInfo = prop.getMetaEntity();
            if (!script.startsWith(alias)) continue;
            StringBuffer sb = new StringBuffer();
            StringTokenizer token = new StringTokenizer(script, ".");
            Vector<String> source = new Vector<String>();
            Vector<String> target = new Vector<String>();
            if (token.countTokens() == 1) {
                statement = prop.getName();
                target.add(prop.getName());
            } else {
                while (token.hasMoreTokens()) {
                    source.add(token.nextToken());
                }
                target.add(prop.getName());
            }
            if (prop.isSetter() && prop.getMetaEntity() != null) {
                int j;
                if (!BOSObjectType.create((String)metaInfo.getMetaDataType()).equals((Object)MetaDataTypeList.ENTITY)) {
                    logger.error((Object)"Invalidate refmetadata type!");
                    break;
                }
                EntityObjectInfo entity = null;
                try {
                    entity = entityCtrl.getValue(MetaDataPK.create(metaInfo.getPackage(), metaInfo.getName()));
                }
                catch (BOSException bose) {
                    logger.error((Object)bose);
                    logger.error((Object)"Cannot get the businessObjectInfo");
                    break;
                }
                boolean matchFlag = true;
                for (j = 1; j < source.size(); ++j) {
                    String temp = (String)source.get(j);
                    PropertyCollection entityProps = entity.getInheritedProperties();
                    int n = entityProps.size();
                    boolean flag = false;
                    for (int k = 0; k < n; ++k) {
                        PropertyInfo entityProp = entityProps.get(k);
                        if (StringUtils.isEmpty((String)entityProp.getAlias()) || !temp.equals(entityProp.getAlias())) continue;
                        target.add(entityProp.getName());
                        if (j != source.size() - 1) {
                            if (!(entityProp instanceof LinkPropertyInfo)) {
                                logger.error((Object)"The scirpt is invalidated!");
                                matchFlag = false;
                                break;
                            }
                            RelationshipInfo relation = ((LinkPropertyInfo)entityProp).getRelationship();
                            CardinalityType cardType = null;
                            if (entity.getFullName().equals(relation.getClientObject().getFullName())) {
                                entity = relation.getSupplierObject();
                                cardType = relation.getSupplierCardinality();
                            } else {
                                entity = relation.getClientObject();
                                cardType = relation.getClientCardinality();
                            }
                            if ((cardType == CardinalityType.ZERO_TO_UNBOUNDED || cardType == CardinalityType.ONE_TO_UNBOUNDED) && j < source.size() - 1) {
                                String tmp = (String)source.get(j + 1);
                                if (tmp.startsWith("get(")) {
                                    target.add(tmp);
                                    ++j;
                                    flag = true;
                                    break;
                                }
                                flag = false;
                                break;
                            }
                        }
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    matchFlag = false;
                    break;
                }
                if (matchFlag) {
                    sb.append(target.get(0));
                    for (j = 1; j < target.size(); ++j) {
                        sb.append("." + target.get(j));
                    }
                } else {
                    sb.append(statement);
                }
            } else if (!prop.isSetter() && prop.getMetaEntity() != null) {
                BusinessObjectInfo bo;
                block33: {
                    if (token.countTokens() > 2) {
                        logger.error((Object)("Invalidate script" + script));
                    }
                    bo = null;
                    try {
                        BOSObjectType type = BOSObjectType.create((String)metaInfo.getMetaDataType());
                        if (type.equals((Object)MetaDataTypeList.ENTITY)) {
                            bo = entityCtrl.getValue(MetaDataPK.create(metaInfo.getPackage(), metaInfo.getName()));
                            break block33;
                        }
                        if (!type.equals((Object)MetaDataTypeList.FACADE)) break block33;
                        bo = facadeCtrl.getValue(MetaDataPK.create(metaInfo.getPackage(), metaInfo.getName()));
                    }
                    catch (BOSException bose) {
                        logger.error((Object)bose);
                        break;
                    }
                }
                if (bo == null) break;
                boolean matchFlag = false;
                if (source.size() == 2) {
                    String name = (String)source.get(1);
                    MethodCollection methods = bo.getMethods();
                    int n = methods.size();
                    for (int j = 0; j < n; ++j) {
                        MethodInfo method = methods.get(j);
                        if (!name.equals(method.getAlias())) continue;
                        target.add(method.getName());
                        matchFlag = true;
                        break;
                    }
                }
                if (matchFlag) {
                    sb.append(target.get(0));
                    for (int j = 1; j < target.size(); ++j) {
                        sb.append("." + target.get(j));
                    }
                } else {
                    sb.append(statement);
                }
            } else {
                if (token.countTokens() > 1) {
                    logger.error((Object)("Invalidate script" + script));
                    break;
                }
                sb.append(prop.getName());
            }
            statement = sb.toString();
            break;
        }
        return statement;
    }

    private static String deTranslate(Context ctx, HashMap props, String statement) {
        String[] propNames = props.keySet().toArray(new String[0]);
        for (int i = 0; i < propNames.length; ++i) {
            char end;
            char start;
            StringBuffer sb = new StringBuffer();
            int j = statement.indexOf(propNames[i]);
            if (j == -1 || j > 0 && (Character.isJavaIdentifierStart(start = statement.charAt(j - 1)) || Character.isJavaIdentifierPart(end = statement.charAt(j + propNames[i].length())))) continue;
            RulePropertyInfo ruleProp = (RulePropertyInfo)props.get(propNames[i]);
            sb.append(statement.substring(0, j));
            sb.append(RuleUtils.deTranslate(ctx, ruleProp, statement.substring(j, statement.length()).trim()));
            statement = sb.toString();
        }
        return statement;
    }

    private static String deTranslate(Context ctx, RulePropertyInfo prop, String script) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer token = new StringTokenizer(script, ".");
        Vector<String> source = new Vector<String>();
        Vector<String> target = new Vector<String>();
        if (token.countTokens() == 1) {
            script = prop.getName();
            target.add(prop.getAlias());
        } else {
            while (token.hasMoreTokens()) {
                source.add(token.nextToken());
            }
            target.add(prop.getAlias());
        }
        MetaDataInfo metaInfo = prop.getMetaEntity();
        if (prop.isSetter() && prop.getMetaEntity() != null) {
            boolean matchFlag = true;
            EntityObjectInfo entity = null;
            try {
                IEntityObjectCtrl entityCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject(ctx, MetaDataTypeList.ENTITY);
                entity = entityCtrl.getValue(MetaDataPK.create(metaInfo.getPackage(), metaInfo.getName()));
            }
            catch (BOSException bose) {
                logger.error((Object)bose);
                logger.error((Object)"Cannot get the businessObjectInfo");
            }
            for (int i = 1; i < source.size(); ++i) {
                if (entity == null) {
                    matchFlag = false;
                    break;
                }
                PropertyCollection props = entity.getInheritedProperties();
                int n = props.size();
                boolean flag = false;
                for (int j = 0; j < n; ++j) {
                    PropertyInfo entityProp = props.get(j);
                    if (!source.get(i).equals(entityProp.getName())) continue;
                    if (entityProp.getAlias() == null) {
                        flag = false;
                        break;
                    }
                    target.add(entityProp.getAlias());
                    flag = true;
                    if (!(entityProp instanceof LinkPropertyInfo)) break;
                    RelationshipInfo relation = ((LinkPropertyInfo)entityProp).getRelationship();
                    CardinalityType cardType = null;
                    if (entity.getFullName().equals(relation.getClientObject().getFullName())) {
                        entity = relation.getSupplierObject();
                        cardType = relation.getSupplierCardinality();
                    } else {
                        entity = relation.getClientObject();
                        cardType = relation.getClientCardinality();
                    }
                    if (cardType != CardinalityType.ZERO_TO_UNBOUNDED && cardType != CardinalityType.ONE_TO_UNBOUNDED || i >= source.size() - 1) break;
                    String tmp = (String)source.get(i + 1);
                    if (tmp.startsWith("get(")) {
                        target.add(tmp);
                        ++i;
                        flag = true;
                        break;
                    }
                    flag = false;
                    break;
                }
                if (flag) continue;
                matchFlag = false;
                break;
            }
            if (matchFlag) {
                sb.append(target.get(0));
                for (int j = 1; j < target.size(); ++j) {
                    sb.append("." + target.get(j));
                }
            } else {
                sb.append(script);
            }
            script = sb.toString();
        } else if (!prop.isSetter() && prop.getMetaEntity() != null) {
            if (token.countTokens() > 2) {
                logger.error((Object)("Invalidate script" + script));
            }
            BusinessObjectInfo bo = null;
            try {
                BOSObjectType type = BOSObjectType.create((String)metaInfo.getMetaDataType());
                if (type.equals((Object)MetaDataTypeList.ENTITY)) {
                    IEntityObjectCtrl entityCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject(ctx, MetaDataTypeList.ENTITY);
                    bo = entityCtrl.getValue(MetaDataPK.create(metaInfo.getPackage(), metaInfo.getName()));
                } else if (type.equals((Object)MetaDataTypeList.FACADE)) {
                    IFacadeCtrl facadeCtrl = (IFacadeCtrl)BOSObjectFactory.createBOSObject(ctx, MetaDataTypeList.FACADE);
                    bo = facadeCtrl.getValue(MetaDataPK.create(metaInfo.getPackage(), metaInfo.getName()));
                }
            }
            catch (BOSException bose) {
                logger.error((Object)bose);
            }
            boolean matchFlag = false;
            if (bo != null) {
                if (source.size() == 2) {
                    String name = (String)source.get(1);
                    MethodCollection methods = bo.getMethods();
                    int n = methods.size();
                    for (int j = 0; j < n; ++j) {
                        MethodInfo method = methods.get(j);
                        if (!name.equals(method.getName())) continue;
                        if (method.getAlias() == null) {
                            matchFlag = false;
                        } else {
                            target.add(method.getAlias());
                            matchFlag = true;
                        }
                        break;
                    }
                } else if (source.size() == 0) {
                    matchFlag = true;
                }
            } else {
                matchFlag = false;
            }
            if (matchFlag) {
                sb.append(target.get(0));
                for (int j = 1; j < target.size(); ++j) {
                    sb.append("." + target.get(j));
                }
            } else {
                sb.append(script);
            }
            script = sb.toString();
        } else {
            if (token.countTokens() > 1) {
                logger.error((Object)("Invalidate script" + script));
            }
            if (prop.getAlias() == null) {
                return script;
            }
            script = prop.getAlias();
        }
        return script;
    }

    public static String[] generateInvokeRuleCode(MethodInfo method) {
        Vector<String> vect = new Vector<String>();
        String item = null;
        StrategyInfo strategy = method.getStrategy();
        if (strategy == null) {
            return new String[0];
        }
        RuleInfo rule = strategy.getRule();
        String pgName = rule.getPackage();
        String ruleName = rule.getName();
        pgName = pgName == null ? null : "\"" + pgName + "\"";
        ruleName = "\"" + ruleName + "\"";
        item = "RuleExecutor exec = new RuleExecutor(ctx, MetaDataPK.create(" + pgName + ", " + ruleName + "));";
        vect.add(item);
        int n = strategy.getParamMappings().size();
        for (int i = 0; i < n; ++i) {
            String methodName = strategy.getParamMappings().get(i).getMethodParam().getName();
            String propName = strategy.getParamMappings().get(i).getRuleProperty().getName();
            propName = "\"" + propName + "\"";
            item = "exec.addParameter(" + propName + ", " + methodName + ");";
            vect.add(item);
        }
        item = "exec.addParameter(\"THIS\", this);";
        String funcName = strategy.getRuleMethod().getName();
        funcName = "\"" + funcName + "\"";
        item = "exec.executeFunction(" + funcName + ");";
        vect.add(item);
        return vect.toArray(new String[0]);
    }

    private static synchronized void exeCommand(Context ctx, RuleInfo rule, int command) {
        int i;
        int n = rule.getRuleProperties().size();
        if (n <= 0) {
            return;
        }
        HashMap<String, RulePropertyInfo> props = new HashMap<String, RulePropertyInfo>();
        for (i = 0; i < n; ++i) {
            RulePropertyInfo prop = rule.getRuleProperties().get(i);
            props.put(prop.getName(), prop);
        }
        n = rule.getRuleMethods().size();
        if (n <= 0) {
            return;
        }
        for (i = 0; i < n; ++i) {
            RuleMethodInfo method = rule.getRuleMethods().get(i);
            if (command == COMMAND_TRANSLATE) {
                RuleUtils.translate(ctx, props, method);
                continue;
            }
            if (command == COMMAND_DETRANSLATE) {
                RuleUtils.deTranslate(ctx, props, method);
                continue;
            }
            if (command != COMMAND_COMPILE) continue;
            RuleUtils.compile(props, method);
        }
    }

    public static void main(String[] args) {
        try {
            Context ctx = new Context(null, "Test", "Test", Locale.SIMPLIFIED_CHINESE);
            IRuleCtrl rule = (IRuleCtrl)BOSObjectFactory.createBOSObject(ctx, MetaDataTypeList.RULE);
            RuleInfo ruleInfo = rule.getValue(MetaDataPK.create("gl", "VoucherRules"));
            RuleUtils.translate(ctx, ruleInfo);
            System.out.println(ruleInfo.getRuleMethods().get(0).getRuleContent());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

