/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.rule.formula;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.util.InvalidDataException;

public final class FormulaUtils {
    public static String processFromula(String formula) {
        StringBuffer sb = new StringBuffer();
        int[] i = new int[1];
        int len = 0;
        i[0] = 0;
        len = formula.length();
        while (i[0] < len) {
            char c = formula.charAt(i[0]);
            block0 : switch (c) {
                case '\"': {
                    sb.append(c);
                    i[0] = i[0] + 1;
                    while (i[0] < len) {
                        c = formula.charAt(i[0]);
                        if (c == '\\') {
                            sb.append(c);
                            i[0] = i[0] + 1;
                            sb.append(formula.charAt(i[0]));
                        } else {
                            if (c == '\"') {
                                sb.append(c);
                                i[0] = i[0] + 1;
                                break block0;
                            }
                            sb.append(formula.charAt(i[0]));
                        }
                        i[0] = i[0] + 1;
                    }
                    break;
                }
                case '\'': {
                    sb.append(c);
                    i[0] = i[0] + 1;
                    sb.append(formula.charAt(i[0]));
                    i[0] = i[0] + 1;
                    sb.append(formula.charAt(i[0]));
                    break;
                }
                case ']': {
                    sb.append(' ');
                    sb.append(c);
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            i[0] = i[0] + 1;
        }
        return sb.toString();
    }

    public static int sequence(EntityObjectInfo entity, IObjectValue ov) {
        PropertyCollection props = entity.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            RelationshipInfo relation;
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof LinkPropertyInfo) || !(relation = ((LinkPropertyInfo)prop).getRelationship()).getType().equals((Object)RelationshipType.COMPOSITION) || !relation.getSupplierObject().equals(entity)) continue;
            String supplierPropName = relation.getSupplierProperty().getName();
            String clientPropName = relation.getClientProperty().getName();
            IObjectValue parent = (IObjectValue)ov.get(supplierPropName);
            if (parent == null) {
                throw new InvalidDataException("Cannot get the parent entity!");
            }
            IObjectCollection oc = (IObjectCollection)parent.get(clientPropName);
            if (oc == null) {
                throw new InvalidDataException("Cannot get the child collection!");
            }
            return oc.indexOf(ov);
        }
        throw new InvalidDataException("Cannot generate the sequence number!");
    }

    public static void main(String[] args) {
        String formula = "[a.b.c] + [a.b.get(\"abcdefghij\\\"klm]k\")] - [c.d.get(']')] + \"[aa+b+c+d]\"";
        System.out.println(FormulaUtils.processFromula(formula));
    }
}

