/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.rule.formula;

import com.kingdee.bos.metadata.rule.formula.AddFunction;
import com.kingdee.bos.metadata.rule.formula.Function;
import com.kingdee.bos.metadata.rule.formula.IsNullFunction;
import com.kingdee.bos.metadata.rule.formula.SequenceFunction;
import com.kingdee.util.InvalidDataException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;

public class SystemFunctions {
    private static Map functions = new Hashtable();

    public static void addFunction(String funcName, Class func) {
        if (!Function.class.isAssignableFrom(func)) {
            throw new InvalidDataException("Invalid system function! The class must extend the Function!");
        }
        functions.put(funcName, func);
    }

    public static Map getFunctions() {
        return functions;
    }

    public static Function getFunction(Map context, String name) {
        try {
            if (SystemFunctions.isSystemFunction(name)) {
                Constructor ct = ((Class)functions.get(name)).getConstructor(Map.class);
                return (Function)ct.newInstance(context);
            }
            return null;
        }
        catch (IllegalAccessException ile) {
            throw new InvalidDataException(ile.getMessage());
        }
        catch (InstantiationException ie) {
            throw new InvalidDataException(ie.getMessage());
        }
        catch (InvocationTargetException ite) {
            throw new InvalidDataException(ite.getMessage());
        }
        catch (NoSuchMethodException me) {
            throw new InvalidDataException(me.getMessage());
        }
    }

    public static boolean isSystemFunction(String funcName) {
        return functions.containsKey(funcName);
    }

    public static void removeFunction(String funcName) {
        functions.remove(funcName);
    }

    protected static void regsterFunctions() {
        SystemFunctions.addFunction("test_add", AddFunction.class);
        SystemFunctions.addFunction("SEQUENCE", SequenceFunction.class);
        SystemFunctions.addFunction("isnull", IsNullFunction.class);
    }
}

