/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.ui;

import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.OtherCollection;
import com.kingdee.bos.metadata.ui.StatusCollection;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.ui.dtp.model.ComponentNameManager;
import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractUIObjectInfo
extends AbstractMetaDataValue
implements Cloneable,
Serializable {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.ui.AbstractUIObjectInfo");
    protected static final String COMPONENTS = "components";
    protected static final String DATAOBJECTS = "dataObjects";
    protected static final String ACTIONS = "actions";
    protected static final String OTHERS = "others";
    protected static final String STATUSES = "statuses";
    protected static final String RELEASE_PACKAGE = "releasePackage";
    protected static final String RELEASE_CLASS = "releaseClass";
    protected static final String PARENT = "parent";
    protected static final String TITLE = "title";
    protected static final String RULESET = "ruleSet";
    protected static final String BIZUNITPK = "bizUnitPK";
    private static final String DEFAULTBUTTON = "defaultbutton";
    private String parentFullName = "";
    public static Locale defaultLocale;
    public static Locale currentLocale;
    private ComponentNameManager nameManager;
    private boolean isAssembled = false;
    private boolean isGenAgent = false;
    private ComponentInfo toolBars = null;
    public static final String TEMPLATE_UI_CLASS = "template_ui_class";
    public static final String TEMPLATE_EDITUI_CLASS = "template_editui_class";
    public static final String DYN_EDITUI_CLASS = "dyn_editui_class";

    public AbstractUIObjectInfo() {
        Locale l = ContextUtils.getOriginalLocaleFromEnv();
        this.setDefaultLocale(l);
        defaultLocale = l;
        currentLocale = l;
    }

    protected AbstractUIObjectInfo(boolean init) {
        super(init);
    }

    public void setParentFullName(String parentFullName) {
        this.parentFullName = parentFullName;
    }

    public String getParentFullName() {
        return this.parentFullName;
    }

    public String getReleasePackage() {
        return this.getString(RELEASE_PACKAGE);
    }

    public void setReleasePackage(String name) {
        this.setString(RELEASE_PACKAGE, name);
    }

    public String getReleaseClass() {
        return this.getString(RELEASE_CLASS);
    }

    public void setReleaseClass(String name) {
        this.setString(RELEASE_CLASS, name);
    }

    public Locale getCurrentLocale() {
        return currentLocale;
    }

    public void setCurrentLocale(Locale curLocale) {
        currentLocale = curLocale;
    }

    public ComponentCollection getComponents() {
        Object obj = this.get(COMPONENTS);
        if (obj == null) {
            ComponentCollection collection = new ComponentCollection();
            this.put(COMPONENTS, collection);
            return collection;
        }
        return (ComponentCollection)obj;
    }

    public void setComponents(ComponentCollection components) {
        this.put(COMPONENTS, components);
    }

    public boolean containsComponentInfo(String componentName) {
        return this.getComponents().containsKey(componentName);
    }

    public boolean containsComponentInfo(ComponentInfo component) {
        return this.getComponents().contains(component);
    }

    public DataObjectCollection getDataObjects() {
        Object obj = this.get(DATAOBJECTS);
        if (obj == null) {
            DataObjectCollection collection = new DataObjectCollection();
            this.put(DATAOBJECTS, collection);
            return collection;
        }
        return (DataObjectCollection)obj;
    }

    public void setDataObjects(DataObjectCollection dataObjects) {
        this.put(DATAOBJECTS, dataObjects);
    }

    public ActionCollection getActions() {
        Object obj = this.get(ACTIONS);
        if (obj == null) {
            ActionCollection collection = new ActionCollection();
            this.put(ACTIONS, collection);
            return collection;
        }
        return (ActionCollection)obj;
    }

    public ActionCollection getOwnedActions() {
        ActionCollection collection = new ActionCollection();
        ActionCollection allCollection = this.getActions();
        if (!allCollection.isEmpty()) {
            int j = allCollection.size();
            for (int i = 0; i < j; ++i) {
                ActionInfo info = allCollection.get(i);
                if (info.isHerited()) continue;
                collection.add(info);
            }
        }
        return collection;
    }

    public ComponentInfo getMainPanelComponent() {
        Iterator iter = this.getComponents().iterator();
        ComponentInfo panel = null;
        while (iter.hasNext()) {
            panel = (ComponentInfo)iter.next();
            if (panel.getParent() != null || !"com.kingdee.bos.ctrl.swing.KDPanel".equals(panel.getClassType())) continue;
            return panel;
        }
        return null;
    }

    public ComponentInfo getToolbarsPanel() {
        if (this.toolBars == null) {
            this.toolBars = new ComponentInfo();
            this.toolBars.setContainer(true);
            this.toolBars.setClassType("com.kingdee.bos.ctrl.swing.KDToolBarPanel");
            LayoutInfo info = new LayoutInfo();
            info.setType("FlowLayout");
            this.toolBars.setLayoutInfo(info);
            Iterator iter = this.getComponents().iterator();
            while (iter.hasNext()) {
                ComponentInfo toolbar = (ComponentInfo)iter.next();
                if (!"com.kingdee.bos.ctrl.swing.KDToolBar".equals(toolbar.getClassType()) || toolbar.getParent() != null && toolbar.getParent().getClassType() != null) continue;
                toolbar.setLayoutInfo(info);
                this.toolBars.addChild(this, toolbar);
            }
        }
        return this.toolBars;
    }

    public ComponentInfo getMenubarComponent() {
        Iterator iter = this.getComponents().iterator();
        ComponentInfo menuBar = null;
        while (iter.hasNext()) {
            menuBar = (ComponentInfo)iter.next();
            if (menuBar.getParent() != null || !"com.kingdee.bos.ctrl.swing.KDMenuBar".equals(menuBar.getClassType())) continue;
            return menuBar;
        }
        return null;
    }

    public ActionInfo getActionByName(String instanceName) {
        if (StringUtils.isEmpty((String)instanceName)) {
            return null;
        }
        ActionCollection actions = this.getActions();
        return actions.getActionByName(instanceName);
    }

    public ActionInfo getActionByClassName(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return null;
        }
        ActionCollection actions = this.getActions();
        return actions.getActionByClassName(className);
    }

    public void setActions(ActionCollection actions) {
        this.put(ACTIONS, actions);
    }

    public OtherCollection getOthers() {
        Object obj = this.get(OTHERS);
        if (obj == null) {
            OtherCollection collection = new OtherCollection();
            this.put(OTHERS, collection);
            return collection;
        }
        return (OtherCollection)obj;
    }

    public void setOthers(OtherCollection others) {
        this.put(OTHERS, others);
    }

    public StatusCollection getStatuses() {
        Object obj = this.get(STATUSES);
        if (obj == null) {
            StatusCollection collection = new StatusCollection();
            this.put(STATUSES, collection);
            return collection;
        }
        return (StatusCollection)obj;
    }

    public void setStatuses(StatusCollection statuses) {
        this.put(STATUSES, statuses);
    }

    public RuleSetInfo getRuleSet() {
        return (RuleSetInfo)this.get(RULESET);
    }

    public void setRuleSet(RuleSetInfo info) {
        this.put(RULESET, info);
    }

    @Override
    public String toString() {
        return this.getPackage() + "." + this.getName();
    }

    @Override
    public ValidateList validate() {
        return super.validate();
    }

    public ComponentCollection getOrderedComponents() {
        int i;
        ComponentCollection componentCollection = this.getComponents();
        ComponentCollection orderedComponentCollection = new ComponentCollection();
        ArrayList componentList = this.getAllTabIndexWidgets(componentCollection);
        int len = componentList.size();
        for (i = 0; i < len - 1; ++i) {
            for (int j = 0; j < len - i - 1; ++j) {
                ComponentInfo componentInfo = (ComponentInfo)componentList.get(j);
                ComponentInfo nextComponentInfo = (ComponentInfo)componentList.get(j + 1);
                if (componentInfo.getTabIndex() <= nextComponentInfo.getTabIndex()) continue;
                componentList.set(j + 1, componentInfo);
                componentList.set(j, nextComponentInfo);
            }
        }
        for (i = 0; i < len; ++i) {
            ComponentInfo componentInfo = (ComponentInfo)componentList.get(i);
            if (componentInfo.getTabIndex() <= 0) continue;
            orderedComponentCollection.add(componentInfo);
        }
        return orderedComponentCollection.size() > 0 ? orderedComponentCollection : null;
    }

    private ArrayList getAllTabIndexWidgets(ComponentCollection componentCollection) {
        ArrayList<ComponentInfo> result = new ArrayList<ComponentInfo>();
        for (int i = 0; i < componentCollection.size(); ++i) {
            ComponentInfo componentInfo = componentCollection.get(i);
            if (!(componentInfo.getClassType().equals("com.kingdee.bos.ctrl.swing.KDToolBar") || componentInfo.getClassType().equals("com.kingdee.bos.ctrl.swing.KDMenuBar") || componentInfo.isContainer())) {
                result.add(componentInfo);
            }
            if (!componentInfo.isContainer()) continue;
            ArrayList subResult = this.getAllTabIndexWidgets(componentInfo.getComponents());
            for (int j = 0; j < subResult.size(); ++j) {
                result.add((ComponentInfo)subResult.get(j));
            }
        }
        return result;
    }

    public String getTitle() {
        return this.getTitle(null);
    }

    public void setTitle(String title) {
        this.setTitle(title, null);
    }

    public String getTitle(Locale locale) {
        return (String)this.get(TITLE, locale);
    }

    public void setTitle(String title, Locale locale) {
        this.put(TITLE, title, locale);
    }

    public String getBizUnitPK() {
        return (String)this.get(BIZUNITPK);
    }

    public void setBizUnitPK(String bizUnitPK) {
        this.put(BIZUNITPK, bizUnitPK);
    }

    @Override
    public synchronized Object clone() {
        AbstractUIObjectInfo model = (AbstractUIObjectInfo)super.clone();
        model.setNameManager(this.nameManager);
        return model;
    }

    public void initNameSpace() {
        this.getNameManager();
        this.initComponentsNameSpace(this.getComponents());
        this.initActionNameSpace(this.getActions());
        this.initStatusNameSpace(this.getStatuses());
        this.initDataObjectNameSpace(this.getDataObjects());
        this.initOtherNameSpace(this.getOthers());
    }

    protected void initOtherNameSpace(OtherCollection collection) {
        if (collection == null) {
            return;
        }
        int size = collection.size();
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
        }
    }

    protected void initDataObjectNameSpace(DataObjectCollection collection) {
        if (collection == null) {
            return;
        }
        int size = collection.size();
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.nameManager.put(collection.get(i).getName());
        }
    }

    protected void initComponentsNameSpace(ComponentCollection collection) {
        if (collection == null) {
            return;
        }
        int size = collection.size();
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.nameManager.put(collection.get(i).getName());
            if (collection.get(i).isContainer() && collection.get(i).getLayoutInfo() != null && !StringUtils.isEmpty((String)collection.get(i).getLayoutInfo().getName())) {
                this.nameManager.put(collection.get(i).getLayoutInfo().getName());
            }
            this.initComponentsNameSpace(collection.get(i).getComponents());
        }
    }

    protected void initActionNameSpace(ActionCollection collection) {
        if (collection == null) {
            return;
        }
        int size = collection.size();
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.nameManager.put(collection.get(i).getName());
            this.nameManager.put(collection.get(i).getClassName());
        }
    }

    protected void initStatusNameSpace(StatusCollection collection) {
        if (collection == null) {
            return;
        }
        int size = collection.size();
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.nameManager.put(collection.get(i).getName());
        }
    }

    public ComponentNameManager getNameManager() {
        if (this.nameManager == null) {
            this.nameManager = new ComponentNameManager();
        }
        return this.nameManager;
    }

    protected void setNameManager(ComponentNameManager nameManager) {
        if (nameManager != null) {
            this.nameManager = nameManager;
        }
    }

    public static void copyExtendedProperties(IObjectValue srcObj, IObjectValue desObj) {
        if (srcObj == null || desObj == null) {
            return;
        }
        Map extProps = srcObj.getExtendedProperties();
        for (Object key : extProps.keySet()) {
            desObj.getExtendedProperties().put(key, extProps.get(key));
        }
    }

    @Override
    public void setUserDefined(boolean isUserDefined) {
        this.put("userDefined", isUserDefined);
    }

    @Override
    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public boolean isAssembled() {
        return this.isAssembled;
    }

    public void setAssembled(boolean isAssembled) {
        this.isAssembled = isAssembled;
    }

    public boolean isGenAgent() {
        return this.isGenAgent;
    }

    void setGenAgent(boolean isGenAgent) {
        this.isGenAgent = isGenAgent;
    }

    public void setDefaultButton(String btnName) {
        this.setString(DEFAULTBUTTON, btnName);
    }

    public String getDefaultButton() {
        return this.getString(DEFAULTBUTTON);
    }

    public ComponentInfo getDefaultBtnComponent() {
        String name = this.getDefaultButton();
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        return this.getComponents().getComponentInfo(name);
    }

    public boolean isUIPNavigable() {
        Iterator iter = this.getActions().iterator();
        boolean ret = false;
        while (iter.hasNext() && !ret) {
            ActionInfo info = (ActionInfo)iter.next();
            if (info.isHerited()) continue;
            ret = info.isUIPNavigator();
        }
        return ret;
    }

    public boolean isPIUI() {
        return this.getExtendedProperty("PI_Extend") != null;
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeBoolean(this.isAssembled);
        marshaller.writeBoolean(this.isGenAgent);
        marshaller.writeObject((Object)this.parentFullName);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.isAssembled = unmarshaller.readBoolean();
        this.isGenAgent = unmarshaller.readBoolean();
        this.parentFullName = (String)unmarshaller.readObject();
    }

    public void setTemplateUIClass(String pk) {
        super.setExtendedProperty(TEMPLATE_UI_CLASS, pk);
    }

    public String getTemplateUIClass() {
        return super.getExtendedProperty(TEMPLATE_UI_CLASS);
    }

    public void setTemplateEditUIClass(String pk) {
        super.setExtendedProperty(TEMPLATE_EDITUI_CLASS, pk);
    }

    public String getTemplateEditUIClass() {
        return super.getExtendedProperty(TEMPLATE_EDITUI_CLASS);
    }

    public void setDynEditUIClass(String pk) {
        super.setExtendedProperty(DYN_EDITUI_CLASS, pk);
    }

    public String getDynEditUIClass() {
        return super.getExtendedProperty(DYN_EDITUI_CLASS);
    }

    static {
        currentLocale = defaultLocale = ContextUtils.getOriginalLocaleFromEnv();
    }
}

