/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.ui;

import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class ActionExtendPropertyHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.ui.ActionExtendPropertyHelper");
    private static final String ROOT_ELEMENT = "ExtendProperty";
    private static final String ITEM_ELEMENT = "item";
    private Hashtable valueMap = new Hashtable();

    public ActionExtendPropertyHelper(String xml) {
        this.parseXml(xml);
    }

    public String getValue(String key) {
        return (String)this.valueMap.get(key);
    }

    public String setValue(String key, String value) {
        return this.valueMap.put(key, value);
    }

    public boolean containsKey(String key) {
        return this.valueMap.containsKey(key);
    }

    public boolean removeItem(String key) {
        Object obj = this.valueMap.remove(key);
        return obj != null;
    }

    public void removeAll() {
        this.valueMap.clear();
    }

    public String toXmlString() {
        return ActionExtendPropertyHelper.genXmlString(this.getKeyValuePairs());
    }

    public List getKeyValuePairs() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        Set keys = this.valueMap.keySet();
        for (String key : keys) {
            String value = this.getValue(key);
            list.add(new String[]{key, value});
        }
        return list;
    }

    public static String genXMLString(List keyValuePairs) {
        return ActionExtendPropertyHelper.genXmlString(keyValuePairs);
    }

    private void parseXml(String xml) {
        if (StringUtils.isEmpty((String)xml)) {
            return;
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build((Reader)new StringReader(xml));
            Element root = doc.getRootElement();
            for (Element element : root.getChildren()) {
                String key = element.getAttributeValue("key");
                String value = element.getAttributeValue("value");
                this.valueMap.put(key, value);
            }
        }
        catch (JDOMException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"error", (Throwable)e);
        }
    }

    private static String genXmlString(List keyValuePairs) {
        String rv = "";
        if (keyValuePairs == null) {
            return rv;
        }
        Element rootElement = new Element(ROOT_ELEMENT);
        Document document = new Document(rootElement);
        XMLOutputter outputter = new XMLOutputter();
        for (int i = 0; i < keyValuePairs.size(); ++i) {
            String[] item = (String[])keyValuePairs.get(i);
            Element element = new Element(ITEM_ELEMENT);
            element.setAttribute("key", item[0]);
            element.setAttribute("value", item[1]);
            rootElement.addContent(element);
        }
        rv = outputter.outputString(document);
        return rv;
    }
}

