/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.ui;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.IMetaDataCtrl;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.IEntityObjectCtrl;
import com.kingdee.bos.metadata.query.IJoinQuery;
import com.kingdee.bos.metadata.query.IUnionQuery;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class DataObjectInfo
extends AbstractMDElement
implements Serializable {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.ui.DataObjectInfo");
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String DESCRIPTION = "description";
    public static final String OBJECTTYPE = "objectType";
    public static final String HERITED = "herited";
    private boolean override = false;
    private boolean writeCode = false;
    private transient IObjectValue instance;

    public DataObjectInfo() {
        this.setDefaultLocale(ContextManager.getContext().getLocale());
        this.setPKField(NAME);
    }

    public IObjectValue getInstance() {
        if (this.instance == null && MetaDataTypeList.ENTITY.toString().equals(this.getObjectType())) {
            String fileName = this.getType();
            try {
                IEntityObjectCtrl enumCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject(ContextManager.getContext(), MetaDataTypeList.ENTITY);
                this.instance = enumCtrl.getValue(MetaDataPK.create(fileName));
            }
            catch (Exception e) {
                log.error((Object)"cannot get data object instance", (Throwable)e);
            }
        }
        return this.instance;
    }

    public void clearInstance() {
        this.instance = null;
    }

    public IObjectValue getInstanceOfQueryForBim() {
        IMetaDataCtrl enumCtrl;
        String fileName;
        QueryInfo queryInstance = null;
        if (MetaDataTypeList.JOINQUERY.toString().equals(this.getObjectType())) {
            fileName = this.getType();
            try {
                enumCtrl = (IJoinQuery)BOSObjectFactory.createBOSObject(ContextManager.getContext(), MetaDataTypeList.JOINQUERY);
                queryInstance = enumCtrl.getValue(MetaDataPK.create(fileName));
            }
            catch (Exception e) {
                log.error((Object)"cannot get data object instance", (Throwable)e);
            }
        }
        if (MetaDataTypeList.UNIONQUERY.toString().equals(this.getObjectType())) {
            fileName = this.getType();
            try {
                enumCtrl = (IUnionQuery)BOSObjectFactory.createBOSObject(ContextManager.getContext(), MetaDataTypeList.UNIONQUERY);
                queryInstance = enumCtrl.getValue(MetaDataPK.create(fileName));
            }
            catch (Exception e) {
                log.error((Object)"cannot get data object instance", (Throwable)e);
            }
        }
        return queryInstance;
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"dtoj");
    }

    public String getName() {
        return this.getString(NAME);
    }

    public void setName(String name) {
        this.setString(NAME, name);
    }

    public String getType() {
        return this.getString(TYPE);
    }

    public void setType(String type) {
        this.setString(TYPE, type);
    }

    public String getObjectType() {
        return this.getString(OBJECTTYPE);
    }

    public void setObjectType(String objectType) {
        this.setString(OBJECTTYPE, objectType);
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public void setDescription(String desc) {
        this.setString(DESCRIPTION, desc);
    }

    public boolean isHerited() {
        return this.getBoolean(HERITED);
    }

    public void setHerited(boolean herited) {
        this.setBoolean(HERITED, herited);
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setWriteCode(boolean writeCode) {
        this.writeCode = writeCode;
    }

    public boolean isWriteCode() {
        return this.writeCode;
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public void setUserDefined(boolean userDefined) {
        this.setBoolean("userDefined", userDefined);
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeBoolean(this.override);
        marshaller.writeBoolean(this.writeCode);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.override = unmarshaller.readBoolean();
        this.writeCode = unmarshaller.readBoolean();
    }
}

