/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.ui;

import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public class UIControlOrderHelper {
    private static UIControlOrderHelper instance;

    private UIControlOrderHelper() {
    }

    public static UIControlOrderHelper getInstance() {
        if (instance == null) {
            instance = new UIControlOrderHelper();
        }
        return instance;
    }

    public void orderUIControl(AbstractUIObjectInfo model) {
        if (model == null) {
            return;
        }
        ComponentCollection collection = model.getComponents();
        ComponentInfo toolBar = null;
        ComponentInfo menuBar = null;
        ComponentInfo tempInfo = null;
        Iterator iter = collection.iterator();
        String classType = null;
        while (iter.hasNext()) {
            tempInfo = (ComponentInfo)iter.next();
            classType = tempInfo.getClassType();
            if ("com.kingdee.bos.ctrl.swing.KDMenuBar".equals(classType)) {
                menuBar = tempInfo;
                continue;
            }
            if (!"com.kingdee.bos.ctrl.swing.KDToolBar".equals(classType)) continue;
            toolBar = tempInfo;
        }
        if (toolBar != null) {
            this.orderToolBar(toolBar);
        }
        if (menuBar != null) {
            this.orderMenuBar(menuBar);
        }
    }

    public void orderUIControl(WebUIObjectInfo model) {
        if (model == null) {
            return;
        }
        ComponentCollection collection = model.getComponents();
        ComponentInfo toolBar = null;
        ComponentInfo menuBar = null;
        ComponentInfo tempInfo = null;
        Iterator iter = collection.iterator();
        String classType = null;
        while (iter.hasNext()) {
            tempInfo = (ComponentInfo)iter.next();
            classType = tempInfo.getClassType();
            if ("com.kingdee.bos.ctrl.swing.KDMenuBar".equals(classType)) {
                menuBar = tempInfo;
                continue;
            }
            if (!"com.kingdee.bos.ctrl.swing.KDToolBar".equals(classType)) continue;
            toolBar = tempInfo;
        }
        if (toolBar != null) {
            this.orderToolBar(toolBar);
        }
        if (menuBar != null) {
            this.orderMenuBar(menuBar);
        }
    }

    public void orderToolBar(ComponentInfo toolbar) {
        if (toolbar == null || !"com.kingdee.bos.ctrl.swing.KDToolBar".equals(toolbar.getClassType()) && !"com.kingdee.bos.ctrl.web.ToolBar".equals(toolbar.getClassType())) {
            return;
        }
        ComponentCollection ret = this.orderByConstraint(toolbar.getComponents(), true);
        toolbar.setComponents(ret);
    }

    private void orderMenuBar(ComponentInfo menubar) {
        if (menubar == null || !"com.kingdee.bos.ctrl.swing.KDMenuBar".equals(menubar.getClassType())) {
            return;
        }
        ComponentCollection ret = this.orderByConstraint(menubar.getComponents(), true);
        menubar.setComponents(ret);
    }

    private ComponentCollection orderByConstraint(ComponentCollection oldCollection, boolean isRecursive) {
        ComponentCollection newCollection;
        if (oldCollection == null || oldCollection.size() <= 1) {
            return oldCollection;
        }
        Object[] tempControls = oldCollection.toArray();
        Arrays.sort(tempControls, new ConstraintComparator());
        try {
            newCollection = (ComponentCollection)oldCollection.getClass().newInstance();
        }
        catch (Exception e) {
            return oldCollection;
        }
        for (int i = 0; i < tempControls.length; ++i) {
            newCollection.add((ComponentInfo)tempControls[i]);
        }
        if (isRecursive) {
            int j = newCollection.size();
            for (int i = 0; i < j; ++i) {
                ComponentInfo tempInfo = newCollection.get(i);
                if (!"com.kingdee.bos.ctrl.swing.KDMenu".equals(tempInfo.getClassType())) continue;
                tempInfo.setComponents(this.orderByConstraint(tempInfo.getComponents(), true));
            }
        }
        return newCollection;
    }

    private static class ConstraintComparator
    implements Comparator {
        private ConstraintComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof ComponentInfo && o2 instanceof ComponentInfo) {
                Object constraint1 = ((ComponentInfo)o1).getConstraint();
                Object constraint2 = ((ComponentInfo)o2).getConstraint();
                if (constraint1 == null || !(constraint1 instanceof Integer)) {
                    constraint1 = 0;
                }
                if (constraint2 == null || !(constraint2 instanceof Integer)) {
                    constraint2 = 0;
                }
                return ((Integer)constraint1).compareTo((Integer)constraint2);
            }
            return 0;
        }
    }
}

