/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class EntryFilter {
    public static final int TYPE_BLACK = 0;
    public static final int TYPE_WHITE = 1;
    private final int filterType;
    private List white = new ArrayList(3);
    private List whiteCache = new ArrayList(3);
    private List black = new ArrayList(3);
    private List blackCache = new ArrayList(3);

    public EntryFilter() {
        this(0);
    }

    public EntryFilter(int type) {
        this.filterType = type;
    }

    public void addCondition(String condition) {
        switch (this.filterType) {
            case 1: {
                this.white.add(condition);
                this.whiteCache.add(Pattern.compile(condition));
                break;
            }
            case 0: {
                this.black.add(condition);
                this.blackCache.add(Pattern.compile(condition));
                break;
            }
        }
    }

    public boolean match(String entry) {
        switch (this.filterType) {
            case 1: {
                int imax = this.whiteCache.size();
                for (int i = 0; i < imax; ++i) {
                    Pattern p = (Pattern)this.whiteCache.get(i);
                    if (!p.matcher(entry).matches()) continue;
                    return true;
                }
                return false;
            }
            case 0: {
                int imax = this.blackCache.size();
                for (int i = 0; i < imax; ++i) {
                    Pattern p = (Pattern)this.blackCache.get(i);
                    if (!p.matcher(entry).matches()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

