/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.upgrade;

import java.io.Serializable;

public class Version
implements Serializable {
    public static final String SPLIT = ".";
    private String major = "0";
    private String minor = "0";
    private String build = "0";
    private String custm = "0";

    public Version(String ver) {
        if (ver == null) {
            ver = "";
        }
        String[] nodes = ver.split("\\.");
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] != null && !"".equals(nodes[i])) continue;
            nodes[i] = "0";
        }
        String[] fnodes = new String[4];
        if (nodes.length > 4) {
            System.arraycopy(nodes, 0, fnodes, 0, 4);
        } else {
            System.arraycopy(nodes, 0, fnodes, 0, nodes.length);
        }
        for (int i = nodes.length; i < fnodes.length; ++i) {
            fnodes[i] = "0";
        }
        this.major = fnodes[0];
        this.minor = fnodes[1];
        this.build = fnodes[2];
        this.custm = fnodes[3];
    }

    public boolean isM1FromM0(Version base) {
        return this.getMajor().equals(base.getMajor()) && this.getMinor().equals(base.getMinor()) && this.getBuild().equals(base.getBuild()) && "0".equals(base.getCustm());
    }

    public boolean isM2FromM0(Version base) {
        return this.getMajor().equals(base.getMajor()) && this.getMinor().equals(base.getMinor()) && "0".equals(this.getCustm()) && "0".equals(base.getCustm());
    }

    public String getBuild() {
        return this.build;
    }

    public String getCustm() {
        return this.custm;
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String freshCustm(String c) {
        if (null == c || "".equals(c)) {
            this.custm = "0";
            return "0";
        }
        this.custm = c;
        return c;
    }

    public int hashCode() {
        return this.major.hashCode() + this.minor.hashCode() + this.build.hashCode() + this.custm.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Version) {
            Version v = (Version)o;
            return this.toString().equals(v.toString());
        }
        return false;
    }

    public String toString() {
        return this.major + SPLIT + this.minor + SPLIT + this.build + SPLIT + this.custm;
    }
}

