/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.util;

import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

public class MetaDataFix {
    static String L1 = "en_US";
    static String L2 = "zh_CN";
    static String L3 = "zh_TW";
    static String L4 = "zh_HK";
    private static Logger logger = Logger.getLogger(MetaDataFix.class);

    public static void fixAlias(String dir, final String fileType, Map methodsName) {
        File dirFile = new File(dir);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith("." + fileType);
            }
        };
        MetaDataFix.fixAlias0(dirFile, filter, methodsName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fixAlias0(File file, FileFilter filter, Map methodsName) {
        File[] children = file.listFiles(filter);
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isDirectory()) {
                MetaDataFix.fixAlias0(child, filter, methodsName);
                continue;
            }
            FileInputStream is = null;
            boolean modify = false;
            Element root = null;
            try {
                is = new FileInputStream(child);
                root = XMLParser.parseXML((InputStream)is).getRootElement();
                Namespace ns = root.getNamespace();
                Element resource = root.getChild("resource", ns);
                List rsList = resource.getChildren("rs", ns);
                for (Element rs : rsList) {
                    String key = rs.getAttributeValue("key");
                    for (Map.Entry entry : methodsName.entrySet()) {
                        String name = (String)entry.getKey();
                        Map map = (Map)entry.getValue();
                        if (!key.endsWith("methods.method[" + name + "].alias")) continue;
                        List langList = rs.getChildren("lang", ns);
                        for (Element lang : langList) {
                            String value = lang.getAttributeValue("value");
                            if (!"null".equalsIgnoreCase(value) && value.length() != 0) continue;
                            String locale = lang.getAttributeValue("locale");
                            lang.setAttribute("value", (String)map.get(locale));
                            modify = true;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error: " + child), (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
            }
            OutputStream os = null;
            try {
                if (!modify) continue;
                logger.info((Object)(child.getCanonicalPath() + " is modified."));
                os = new FileOutputStream(child);
                XmlUtils.output(root.getDocument(), os);
                os.close();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                if (os == null) continue;
                try {
                    os.close();
                    continue;
                }
                catch (IOException e1) {
                    logger.error((Object)e1, (Throwable)e1);
                }
            }
        }
    }

    public static void main(String[] args) {
        String dir = null;
        if (args.length > 0 && args[0] != null) {
            dir = args[0];
        } else {
            System.out.println("\u8f93\u5165\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u8981\u4fee\u6b63\u7684\u5143\u6570\u636e\u7684\u8def\u5f84");
            System.exit(1);
        }
        HashMap methodsName = new HashMap();
        HashMap<String, String> getValue = new HashMap<String, String>(8);
        getValue.put(L1, "getValue");
        getValue.put(L2, "\u53d6\u503c");
        getValue.put(L3, "\u53d6\u503c");
        getValue.put(L4, "\u53d6\u503c");
        methodsName.put("getValue", getValue);
        HashMap<String, String> getCollection = new HashMap<String, String>(8);
        getCollection.put(L1, "getCollection");
        getCollection.put(L2, "\u53d6\u96c6\u5408");
        getCollection.put(L3, "\u53d6\u96c6\u5408");
        getCollection.put(L4, "\u53d6\u96c6\u5408");
        methodsName.put("getCollection", getCollection);
        HashMap<String, String> exists = new HashMap<String, String>(8);
        exists.put(L1, "exists");
        exists.put(L2, "\u5b58\u5728");
        exists.put(L3, "\u5b58\u5728");
        exists.put(L4, "\u5b58\u5728");
        methodsName.put("exists", exists);
        HashMap<String, String> addnew = new HashMap<String, String>(8);
        addnew.put(L1, "addnew");
        addnew.put(L2, "\u65b0\u589e");
        addnew.put(L3, "\u65b0\u589e");
        addnew.put(L4, "\u65b0\u589e");
        methodsName.put("addnew", addnew);
        HashMap<String, String> update = new HashMap<String, String>(8);
        update.put(L1, "update");
        update.put(L2, "\u66f4\u65b0");
        update.put(L3, "\u66f4\u65b0");
        update.put(L4, "\u66f4\u65b0");
        methodsName.put("update", update);
        HashMap<String, String> delete = new HashMap<String, String>(8);
        delete.put(L1, "delete");
        delete.put(L2, "\u5220\u9664");
        delete.put(L3, "\u522a\u9664");
        delete.put(L4, "\u522a\u9664");
        methodsName.put("delete", delete);
        HashMap<String, String> getPKList = new HashMap<String, String>(8);
        getPKList.put(L1, "getPKList");
        getPKList.put(L2, "\u53d6\u4e3b\u952e");
        getPKList.put(L3, "\u53d6\u4e3b\u9375");
        getPKList.put(L4, "\u53d6\u4e3b\u9375");
        methodsName.put("getPKList", getPKList);
        HashMap<String, String> updatePartial = new HashMap<String, String>(8);
        updatePartial.put(L1, "updatePartial");
        updatePartial.put(L2, "\u5c40\u90e8\u66f4\u65b0");
        updatePartial.put(L3, "\u5c40\u90e8\u66f4\u65b0");
        updatePartial.put(L4, "\u5c40\u90e8\u66f4\u65b0");
        methodsName.put("updatePartial", updatePartial);
        HashMap<String, String> updateBigObject = new HashMap<String, String>(8);
        updateBigObject.put(L1, "updateBigObject");
        updateBigObject.put(L2, "\u66f4\u65b0\u5927\u5bf9\u8c61");
        updateBigObject.put(L3, "\u66f4\u65b0\u5927\u5c0d\u8c61");
        updateBigObject.put(L4, "\u66f4\u65b0\u5927\u5c0d\u8c61");
        methodsName.put("updateBigObject", updateBigObject);
        logger.info((Object)"Begin fixAlias ......");
        LowTimer timer = new LowTimer();
        MetaDataFix.fixAlias(dir, "entity", methodsName);
        logger.info((Object)("End fixAlias used " + (int)timer.Value() + " seconds"));
    }

    public static void fixTable(String dir) {
        File dirFile = new File(dir);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".table");
            }
        };
        MetaDataFix.fixTable0(dirFile, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fixTable0(File file, FileFilter filter) {
        File[] children = file.listFiles(filter);
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isDirectory()) {
                MetaDataFix.fixTable0(child, filter);
                continue;
            }
            FileInputStream is = null;
            boolean modify = false;
            Element root = null;
            try {
                is = new FileInputStream(child);
                root = XMLParser.parseXML((InputStream)is).getRootElement();
                Namespace ns = root.getNamespace();
                Element columns = root.getChild("columns", ns);
                if (columns == null) continue;
                List colEles = columns.getChildren("column", ns);
                for (Element col : colEles) {
                    Element prsEle;
                    Element sqlTypeEle;
                    String sqlType = col.getChildText("sqlType", ns);
                    String scale = col.getChildText("scale", ns);
                    String precision = col.getChildText("precision", ns);
                    if ("28".equals(precision)) {
                        if (!"16".equals(scale) && !"10".equals(scale) || !"NUMERIC".equalsIgnoreCase(sqlType) && !"decimal".equalsIgnoreCase(sqlType)) continue;
                        sqlTypeEle = col.getChild("sqlType", ns);
                        sqlTypeEle.setText("decimal");
                        prsEle = col.getChild("precision", ns);
                        prsEle.setText("21");
                        Element scEle = col.getChild("scale", ns);
                        scEle.setText("8");
                        modify = true;
                        continue;
                    }
                    if (!"19".equals(precision) || !"4".equals(scale) || !"NUMERIC".equalsIgnoreCase(sqlType) && !"decimal".equalsIgnoreCase(sqlType)) continue;
                    sqlTypeEle = col.getChild("sqlType", ns);
                    sqlTypeEle.setText("decimal");
                    prsEle = col.getChild("precision", ns);
                    prsEle.setText("17");
                    modify = true;
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
            }
            OutputStream os = null;
            try {
                if (!modify) continue;
                logger.info((Object)(child.getCanonicalPath() + " is modified."));
                os = new FileOutputStream(child);
                XmlUtils.output(root.getDocument(), os);
                os.close();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                if (os == null) continue;
                try {
                    os.close();
                    continue;
                }
                catch (IOException e1) {
                    logger.error((Object)e1, (Throwable)e1);
                }
            }
        }
    }

    public static void importEntityColumnDescription2Table(String metadataPath) {
        File dirFile = new File(metadataPath);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".entity");
            }
        };
        MetaDataFix.importEntityColumnDescription2Table0(metadataPath, dirFile, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importEntityColumnDescription2Table0(String metadataPath, File mdSubPath, FileFilter filter) {
        File[] children = mdSubPath.listFiles(filter);
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isDirectory()) {
                MetaDataFix.importEntityColumnDescription2Table0(metadataPath, child, filter);
                continue;
            }
            FileInputStream entityIs = null;
            FileInputStream tableIs = null;
            Element entityRoot = null;
            Element tableRoot = null;
            boolean modify = false;
            File tableFile = null;
            try {
                entityIs = new FileInputStream(child);
                entityRoot = XMLParser.parseXML((InputStream)entityIs).getRootElement();
                Namespace entityNs = entityRoot.getNamespace();
                Element table = entityRoot.getChild("table", entityNs);
                if (table == null) continue;
                List keys = table.getChildren("key", entityNs);
                String pkg = "";
                String name = "";
                for (Element key : keys) {
                    if ("package".equals(key.getAttributeValue("name"))) {
                        pkg = key.getAttributeValue("value");
                        continue;
                    }
                    if (!"name".equals(key.getAttributeValue("name"))) continue;
                    name = key.getAttributeValue("value");
                }
                pkg = pkg.replace('.', '/');
                StringBuffer sb = new StringBuffer(metadataPath);
                sb.append("/").append(pkg).append("/").append(name).append('.').append("table");
                tableFile = new File(sb.toString());
                tableIs = new FileInputStream(tableFile);
                tableRoot = XMLParser.parseXML((InputStream)tableIs).getRootElement();
                Namespace tableNs = entityRoot.getNamespace();
                Map entityKeyToRs = MetaDataFix.keyToRs(entityRoot);
                HashMap<String, Rs> entityMap = new HashMap<String, Rs>();
                Element props = entityRoot.getChild("properties", entityNs);
                List propsList = props.getChildren();
                for (Element prop : propsList) {
                    Element mappingField = prop.getChild("mappingField", tableNs);
                    if (mappingField == null) continue;
                    Element key = mappingField.getChild("key", tableNs);
                    String mf = key.getAttributeValue("value");
                    String string = prop.getChildText("alias", entityNs);
                    String des = prop.getChildText("description", entityNs);
                    Rs rs = new Rs((Element)entityKeyToRs.get(string), (Element)entityKeyToRs.get(des));
                    entityMap.put(mf, rs);
                }
                Map tableKeyToRs = MetaDataFix.keyToRs(tableRoot);
                HashMap<String, Rs> tableMap = new HashMap<String, Rs>();
                Element columns = tableRoot.getChild("columns", tableNs);
                List cols = columns.getChildren("column", tableNs);
                for (Element element : cols) {
                    String nm = element.getChildText("name", tableNs);
                    String alias = element.getChildText("alias", tableNs);
                    String des = element.getChildText("description", tableNs);
                    Rs rs = new Rs((Element)tableKeyToRs.get(alias), (Element)tableKeyToRs.get(des));
                    tableMap.put(nm, rs);
                }
                for (Map.Entry entry : entityMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Rs entityRs = (Rs)entry.getValue();
                    Rs tableRs = (Rs)tableMap.get(key);
                    boolean mdf = MetaDataFix.copyElement(entityRs.alis, tableRs.alis);
                    if (mdf) {
                        modify = mdf;
                    }
                    if (!(mdf = MetaDataFix.copyElement(entityRs.description, tableRs.description))) continue;
                    modify = mdf;
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                logger.error((Object)("Error: " + child));
            }
            finally {
                if (entityIs != null) {
                    try {
                        entityIs.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
                if (tableIs != null) {
                    try {
                        tableIs.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
            }
            OutputStream os = null;
            try {
                if (!modify) continue;
                logger.info((Object)(tableFile.getCanonicalPath() + " is modified."));
                os = new FileOutputStream(tableFile);
                XmlUtils.output(tableRoot.getDocument(), os);
                os.close();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                if (os == null) continue;
                try {
                    os.close();
                    continue;
                }
                catch (IOException e1) {
                    logger.error((Object)e1, (Throwable)e1);
                }
            }
        }
    }

    private static boolean copyElement(Element entityRs, Element tableRs) {
        boolean modify = false;
        if (entityRs != null && tableRs != null) {
            List entityLangs = entityRs.getChildren("lang", entityRs.getNamespace());
            HashMap<String, String> langToValue = new HashMap<String, String>();
            for (Element lang : entityLangs) {
                langToValue.put(lang.getAttributeValue("locale"), lang.getAttributeValue("value"));
            }
            List tableLangs = tableRs.getChildren("lang", tableRs.getNamespace());
            for (Element lang : tableLangs) {
                String lg;
                String value;
                String v = lang.getAttributeValue("value");
                if (!"null".equalsIgnoreCase(v) && !StringUtils.isEmpty((String)v) || "null".equalsIgnoreCase(value = (String)langToValue.get(lg = lang.getAttributeValue("locale"))) || StringUtils.isEmpty((String)value)) continue;
                lang.setAttribute("value", value);
                modify = true;
            }
        }
        return modify;
    }

    private static Map keyToRs(Element root) {
        Namespace ns = root.getNamespace();
        Element resource = root.getChild("resource", ns);
        List rsList = resource.getChildren("rs", ns);
        HashMap<String, Element> deyToRs = new HashMap<String, Element>();
        for (Element rs : rsList) {
            String key = rs.getAttributeValue("key");
            deyToRs.put(key, rs);
        }
        return deyToRs;
    }

    private static class Rs {
        Element alis;
        Element description;

        Rs(Element alis, Element description) {
            this.alis = alis;
            this.description = description;
        }
    }
}

