/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.management.PackageCtrl;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class PackageCodeUpdater {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.util.PackageCodeUpdater");
    private String configFileName = null;
    private String metadataRootPathName = null;
    private PackageCtrl packageCtrl = null;
    private Map packageCodeList = null;

    public static void main(String[] args) throws IOException {
        if (args == null || args.length != 2) {
            log.debug((Object)"\u8bf7\u8f93\u5165\u53c2\u6570\uff1a\u5305\u7684\u914d\u7f6e\u6587\u4ef6\u540d\u548c\u5143\u6570\u636e\u6839\u76ee\u5f55\uff0c\u5982PackageCodeUpdater C:\\\u5b50\u7cfb\u7edf\u7b80\u79f0.txt C:\\metadata");
            return;
        }
        new PackageCodeUpdater().update(args[0], args[1]);
    }

    public void update(String configFileName, String metadataRootPathName) throws IOException {
        File configFile = new File(configFileName);
        File metadataRootPath = new File(metadataRootPathName);
        if (!configFile.exists()) {
            log.debug((Object)("\u5305\u7684\u914d\u7f6e\u6587\u4ef6" + configFileName + "\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        if (!metadataRootPath.exists()) {
            log.debug((Object)("\u5143\u6570\u636e\u6839\u76ee\u5f55" + metadataRootPathName + "\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        this.configFileName = configFile.getAbsolutePath();
        this.metadataRootPathName = metadataRootPath.getAbsolutePath();
        this.packageCodeList = this.getPackageCodeList();
        try {
            this.packageCtrl = new PackageCtrl(this.getContext());
        }
        catch (Exception e) {
            log.debug((Object)("\u5143\u5143\u6570\u636e\u88c5\u8f7d\u5931\u8d25\uff01\u53ef\u80fd\u5f15\u7528\u7684\u7c7b\u8def\u5f84\u4e2d\u6ca1\u6709metametas.jar\u5305\u3002\n" + e.toString()));
            return;
        }
        log.debug((Object)"\u5f00\u59cb\u904d\u5386\u5143\u6570\u636e\u76ee\u5f55...");
        this.browseAndUpdatePackage(null);
        log.debug((Object)"\u5305\u5143\u6570\u636e\u4ee3\u7801\u66f4\u65b0\u5b8c\u6bd5\u3002");
        this.packageCodeList.clear();
    }

    private static String getFullPackageName(String packageName) {
        int lastDotPos = packageName.lastIndexOf(".");
        if (lastDotPos > 0) {
            return packageName + "." + packageName.substring(lastDotPos + 1);
        }
        return packageName + "." + packageName;
    }

    private void browseAndUpdatePackage(String parentPackageName) {
        this.updatePackageCode(parentPackageName);
        File currentPath = null;
        currentPath = StringUtils.isEmpty((String)parentPackageName) ? new File(this.metadataRootPathName) : new File(this.metadataRootPathName + "\\" + StringUtils.replace((String)parentPackageName, (String)".", (String)"\\"));
        File[] subFiles = currentPath.listFiles();
        int n = subFiles.length;
        for (int i = 0; i < n; ++i) {
            if (!subFiles[i].isDirectory()) continue;
            if (StringUtils.isEmpty((String)parentPackageName)) {
                this.browseAndUpdatePackage(subFiles[i].getName());
                continue;
            }
            this.browseAndUpdatePackage(parentPackageName + "." + subFiles[i].getName());
        }
    }

    private void updatePackageCode(String packageName) {
        if (StringUtils.isEmpty((String)packageName)) {
            return;
        }
        String fullPackageName = PackageCodeUpdater.getFullPackageName(packageName);
        String packageCode = null;
        if (this.packageCodeList.containsKey(fullPackageName)) {
            packageCode = (String)this.packageCodeList.get(fullPackageName);
        }
        PackageInfo info = null;
        MetaDataPK metadataPK = null;
        try {
            metadataPK = MetaDataPK.create(fullPackageName);
            info = this.packageCtrl.exists(metadataPK) ? this.packageCtrl.getValue(metadataPK) : null;
        }
        catch (BOSException e) {
            // empty catch block
        }
        if (info != null) {
            info.setBasicCode(packageCode);
            try {
                if (packageCode == null) {
                    log.debug((Object)("\u8bbe\u7f6e\u5305" + fullPackageName + "\u7b80\u7801\u4e3a\u7a7a!"));
                } else {
                    log.debug((Object)("\u8bbe\u7f6e\u5305" + fullPackageName + "\u7b80\u7801\u4e3a" + packageCode));
                }
                this.packageCtrl.update(metadataPK, info);
            }
            catch (BOSException e) {
                log.debug((Object)("\u5143\u6570\u636e\u5f15\u64ce\u4fdd\u5b58\u5305" + fullPackageName + "\u5931\u8d25\uff01" + "\n" + e.toString()));
            }
        }
    }

    private Context getContext() {
        Context ctx = new Context();
        ctx.put((Object)"current_mode", (Object)"DEBUG");
        ctx.put((Object)"METADATAPATH", (Object)this.metadataRootPathName);
        return ctx;
    }

    private Map getPackageCodeList() throws IOException {
        Hashtable<String, String> packageCodeList = new Hashtable<String, String>();
        FileInputStream inStream = new FileInputStream(new File(this.configFileName));
        InputStreamReader reader = new InputStreamReader(inStream);
        StringBuffer buffer = new StringBuffer("");
        char[] charArray = new char[1];
        while (reader.read(charArray) != -1) {
            buffer.append(charArray);
        }
        String[] lines = StringUtils.split((String)buffer.toString(), (String)"\n");
        String packageName = null;
        String packageCode = null;
        int n = lines.length;
        for (int i = 0; i < n; ++i) {
            int dotPos = lines[i].indexOf(",");
            if (dotPos <= 0) continue;
            packageName = lines[i].substring(0, dotPos);
            packageCode = lines[i].substring(dotPos + 1);
            packageName = PackageCodeUpdater.getFullPackageName(packageName.trim());
            packageCode = packageCode.trim();
            packageCodeList.put(packageName, packageCode);
        }
        ((InputStream)inStream).close();
        return packageCodeList;
    }
}

