/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.validate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.validate.CheckItemSet;
import java.io.File;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class CheckItems
extends CheckItemSet {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.validate.CheckItems");
    private static final String DEFAULT_FILE = "default_checks.xml";
    public static final String CHECK_FILE = "checks.xml";
    private static CheckItems fgCheckItems;
    private File checkFile;

    public static void init(String fileName) {
        assert (fileName != null && fileName.length() > 0);
        if (fgCheckItems == null) {
            fgCheckItems = new CheckItems(new File(fileName));
        }
    }

    public static CheckItems getInstance() {
        if (fgCheckItems == null) {
            fgCheckItems = new CheckItems();
        }
        return fgCheckItems;
    }

    private CheckItems() {
        super("checkitem");
        try {
            this.addFromStream(CheckItems.getDefaultsAsStream(), true, true);
        }
        catch (BOSException e) {
            logger.debug((Object)"", (Throwable)e);
        }
    }

    private CheckItems(File file) {
        super("checkitem");
        this.checkFile = file;
        this.create(file);
    }

    private void create(File file) {
        try {
            if (file.exists()) {
                this.addFromFile(file, true);
            } else {
                this.addFromStream(CheckItems.getDefaultsAsStream(), true, true);
                this.saveToFile(file);
            }
        }
        catch (BOSException e) {
            logger.debug((Object)"", (Throwable)e);
            this.clear();
        }
    }

    public void reset() throws BOSException {
        this.clear();
        this.addFromFile(this.getCheckFile(), true);
    }

    public void restoreDefaults() throws BOSException {
        this.clear();
        this.addFromStream(CheckItems.getDefaultsAsStream(), true, true);
    }

    public void save() throws BOSException {
        this.saveToFile(this.getCheckFile());
    }

    private static InputStream getDefaultsAsStream() {
        return CheckItems.class.getResourceAsStream(DEFAULT_FILE);
    }

    private File getCheckFile() {
        return this.checkFile;
    }
}

