/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.validate;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.validate.ValidateItem;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateListAdapter;
import com.kingdee.bos.metadata.validate.VerifyOperator;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class ValidateMetaData
implements Serializable {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.validate.logger");
    public static final int PACKAGE_MAX_LENGTH = 255;
    public static final int NAME_MAX_LENGTH = 255;
    protected final ValidateList el;
    private VerifyOperator operator;

    public ValidateMetaData() {
        this(null);
    }

    public ValidateMetaData(ValidateList el) {
        this.el = el == null ? new ValidateList() : el;
        this.operator = new VerifyOperator();
        this.operator.getVerifyReport().registerListener(new ValidateListAdapter(this));
    }

    public void addWarning(String msg) {
        logger.warn((Object)("Warning: " + msg));
    }

    public void addError(String msg) {
        this.el.addItem(new ValidateItem(msg, 1));
    }

    public void addFatal(String msg) {
        this.el.addItem(new ValidateItem(msg, 2));
    }

    public void addValidateList(ValidateList el) {
        this.el.addList(el);
    }

    public ValidateList getValidateList() {
        return this.el;
    }

    public void validatePackageName(String name) {
        if (!StringUtils.isEmpty((String)name)) {
            this.validateLength("Package", name, 255);
            String[] pks = StringUtils.split((String)name, (String)".");
            for (int i = 0; i < pks.length; ++i) {
                if (StringUtils.isFileName((String)pks[i])) continue;
                this.addError("Invalid Package name: " + name);
                break;
            }
        }
    }

    public void validateEASPolice(AbstractMetaDataValue value) {
    }

    public void validateMetaDataName(String name) {
        if (this.validateEmpty("Name", name)) {
            this.validateLength("Name", name, 255);
            if (!StringUtils.isFileName((String)name)) {
                this.addError("Invalid name: " + name);
            }
            if (name.indexOf(46) > -1) {
                this.addError("Name cannot includes char '.'");
            }
        }
    }

    public boolean validateEmpty(String name, String val) {
        if (StringUtils.isEmpty((String)val)) {
            this.addFatal(name + " can't be empty.");
            return false;
        }
        return true;
    }

    public void validateLength(String name, String str, int len) {
        if (str.length() > len) {
            this.addError(name + "'s length must less than " + len + ": " + str);
        }
    }

    public void validateClassName(String name, String str) {
        if (StringUtils.isEmpty((String)str)) {
            this.addWarning(name + " empty.");
        } else if (!StringUtils.isJavaClassName((String)str)) {
            this.addError("Invalid " + name + ": '" + str + "' is not a valid JAVA class name.");
        }
    }

    public void validateJavaIdentifier(String name, String str) {
        if (StringUtils.isEmpty((String)str)) {
            this.addFatal(name + " can not be empty.");
        } else if (!StringUtils.isJavaIdentifier((String)str)) {
            this.addError("Invalid " + name + ": '" + str + "' is not a valid JAVA Identifier.");
        }
    }

    public void validateKsqlIdentifier(String name, String str) {
        if (StringUtils.isEmpty((String)str)) {
            this.addFatal(name + " can not be empty.");
        } else if (!StringUtils.isKsqlIdentifier((String)str)) {
            this.addError("Invalid " + name + ": '" + str + "' is not a valid DBMS Identifier.");
        }
    }
}

