/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.validate.impl;

import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.validate.VerifyReport;
import com.kingdee.bos.metadata.validate.VerifyUnit;
import com.kingdee.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckMethod
extends VerifyUnit {
    private static final String METHOD_REGEX = "\\p{Lower}{1}\\p{ASCII}*";

    @Override
    public boolean check(VerifyReport report) {
        assert (this.getTarget() instanceof BusinessObjectInfo);
        BusinessObjectInfo biz = (BusinessObjectInfo)this.getTarget();
        MethodCollection methods = biz.getMethods();
        Pattern pattern = Pattern.compile(METHOD_REGEX);
        int size = methods.size();
        for (int i = 0; i < size; ++i) {
            MethodInfo method = methods.get(i);
            if (!StringUtils.isJavaIdentifier((String)method.getName())) {
                return false;
            }
            Matcher m = pattern.matcher(method.getName());
            if (!m.matches()) {
                return false;
            }
            ParameterCollection paras = method.getParameters();
            int pSize = paras.size();
            for (int j = 0; j < pSize; ++j) {
                if (!StringUtils.isJavaIdentifier((String)paras.get(j).getName())) {
                    return false;
                }
                m = pattern.matcher(paras.get(j).getName());
                if (m.matches()) continue;
                return false;
            }
        }
        return true;
    }
}

