/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.validate.impl;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.validate.VerifyReport;
import com.kingdee.bos.metadata.validate.VerifyUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckTableFieldName
extends VerifyUnit {
    private static final String FIELD1_REGEX = "F\\p{Upper}{2}";
    private static final String FIELD2_REGEX = "F\\p{Upper}{1}\\p{ASCII}*";
    private static final String C_FIELD1_REGEX = "CF\\p{Upper}{2}";
    private static final String C_FIELD2_REGEX = "CF\\p{Upper}{1}\\p{ASCII}*";

    @Override
    public boolean check(VerifyReport report) {
        assert (this.getTarget() instanceof AbstractTableInfo);
        AbstractTableInfo table = (AbstractTableInfo)this.getTarget();
        ColumnCollection columns = table.getColumns();
        String reg1 = isDevelopVersion ? FIELD1_REGEX : C_FIELD1_REGEX;
        String reg2 = isDevelopVersion ? FIELD2_REGEX : C_FIELD2_REGEX;
        Pattern pattern1 = Pattern.compile(reg1);
        Pattern pattern2 = Pattern.compile(reg2);
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            String n = columns.get(i).getName();
            Matcher m1 = pattern1.matcher(n);
            Matcher m2 = pattern2.matcher(n);
            if (m2.matches() || m1.matches()) continue;
            report.addWarning("\u8868\u5b57\u6bb5\u540d\u79f0\u4e0d\u7b26\u5408\u89c4\u8303 :" + n);
            return false;
        }
        return true;
    }
}

