/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.view;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.view.ExtendedPropertyFilter;
import com.kingdee.bos.metadata.view.IMetaDataBriefViewFilter;
import com.kingdee.bos.metadata.view.SubSystemHideFilter;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import java.util.Vector;

public class DefaultMetaDataBriefViewFilter
implements IMetaDataBriefViewFilter {
    private String pkgPrefix = null;
    private String baseEntityFullName = null;
    private final Vector<BOSObjectType> metaDataTypeFilters = new Vector(2);
    private final Vector<ExtendedPropertyFilter> extPropFilters = new Vector(2);
    private final Vector<SubSystemHideFilter> hideFilters = new Vector(1);

    protected DefaultMetaDataBriefViewFilter() {
    }

    @Override
    public void setEntityChainFilter(String baseEntityFullName) {
        this.baseEntityFullName = baseEntityFullName;
    }

    @Override
    public void addExtendedPropertyFilter(String extPropName, String extPropValue) {
        this.addExtendedPropertyFilter(extPropName, extPropValue, null);
    }

    @Override
    public void addExtendedPropertyFilter(String extPropName, String extPropValue, Locale locale) {
        this.addExtendedPropertyFilter(null, extPropName, extPropValue, locale);
    }

    @Override
    public void addExtendedPropertyFilter(BOSObjectType bosType, String extPropName, String extPropValue) {
        this.addExtendedPropertyFilter(bosType, extPropName, extPropValue, null);
    }

    @Override
    public void addExtendedPropertyFilter(BOSObjectType bosType, String extPropName, String extPropValue, Locale locale) {
        this.addExtendedPropertyFilter(new ExtendedPropertyFilter(bosType, extPropName, extPropValue, locale));
    }

    @Override
    public void addExtendedPropertyFilter(ExtendedPropertyFilter filter) {
        this.extPropFilters.add(filter);
    }

    @Override
    public void addMetaDataTypeFilter(BOSObjectType bosType) {
        this.metaDataTypeFilters.add(bosType);
    }

    @Override
    public void addSubSystemHideFilter(SubSystemHideFilter filter) {
        this.hideFilters.add(filter);
    }

    @Override
    public String getEntityChainFilter() {
        return this.baseEntityFullName;
    }

    @Override
    public ExtendedPropertyFilter[] getExtendedPropertyFilters() {
        return this.extPropFilters.toArray(new ExtendedPropertyFilter[0]);
    }

    @Override
    public BOSObjectType[] getMetaDataTypeFilters() {
        return this.metaDataTypeFilters.toArray(new BOSObjectType[0]);
    }

    @Override
    public String getPackagePrefix() {
        return this.pkgPrefix;
    }

    @Override
    public void setPackagePrefix(String pkgPrefix) {
        this.pkgPrefix = pkgPrefix;
    }

    @Override
    public boolean isAccept(AbstractMetaDataValue metaData) {
        BOSObjectType[] bosTypes = this.getMetaDataTypeFilters();
        boolean flag = false;
        int len = bosTypes.length;
        for (int i = 0; i < len; ++i) {
            if (!metaData.getBOSType().equals((Object)bosTypes[i])) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        String tmpPkgPrefix = metaData.getPackage();
        flag = false;
        if (this.pkgPrefix != null) {
            if (tmpPkgPrefix == null) {
                flag = false;
            } else if (this.pkgPrefix.equalsIgnoreCase(tmpPkgPrefix) || tmpPkgPrefix.startsWith(this.pkgPrefix + ".")) {
                flag = true;
            }
        } else {
            flag = true;
        }
        if (!flag) {
            return false;
        }
        for (SubSystemHideFilter f : this.hideFilters) {
            if (!f.hidden(metaData.getFullName())) continue;
            return false;
        }
        ExtendedPropertyFilter[] tmpExtFilters = this.getExtendedPropertyFilters();
        ExtendedPropertyFilter tmpExtFilter = null;
        String value = null;
        int j = 0;
        int len2 = tmpExtFilters.length;
        for (int i = 0; i < len2; ++i) {
            tmpExtFilter = tmpExtFilters[i];
            if (tmpExtFilter.getBosType() != null && !metaData.getBOSType().equals((Object)tmpExtFilter.getBosType())) continue;
            value = metaData.getExtendedProperty(tmpExtFilter.getPropName());
            if (tmpExtFilter.getPropValue() == null) {
                if (value == null) {
                    j = 1;
                    break;
                }
            } else if (tmpExtFilter.getPropValue().equalsIgnoreCase(value)) {
                j = 1;
                break;
            }
            if (i != len2 - 1 || j != 0) continue;
            j = -1;
        }
        if (j == -1) {
            return false;
        }
        flag = false;
        if (metaData instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)metaData;
            if (entity.isAbstract()) {
                return false;
            }
            if (!StringUtils.isEmpty((String)this.baseEntityFullName)) {
                while (entity != null) {
                    if (entity.getFullName().equalsIgnoreCase(this.baseEntityFullName)) {
                        flag = true;
                        break;
                    }
                    entity = entity.getBaseEntity();
                }
                if (!flag) {
                    return false;
                }
            }
        }
        return true;
    }
}

