/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webcomponent;

import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.metadata.webcommon.ReleaseCollection;
import com.kingdee.bos.metadata.webcommon.VersionInfo;
import com.kingdee.bos.metadata.webcommon.WebResourceCollection;
import com.kingdee.bos.metadata.webcomponent.CreatorCollection;
import com.kingdee.bos.metadata.webcomponent.DependencyCollection;
import com.kingdee.bos.metadata.webcomponent.EventCollection;
import com.kingdee.bos.metadata.webcomponent.MacroCollection;
import com.kingdee.bos.metadata.webcomponent.MaintainorCollection;
import com.kingdee.bos.metadata.webcomponent.PropertyCollection;
import com.kingdee.bos.metadata.webcomponent.ReleaseTemplateCollection;
import com.kingdee.bos.metadata.webpage.ScriptCollection;
import com.kingdee.bos.metadata.webpage.StyleSheetCollection;
import com.kingdee.bos.metadata.webpage.WebActionCollection;
import com.kingdee.bos.metadata.webpage.WebActionInfo;
import com.kingdee.bos.ui.dtp.model.ComponentNameManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WebComponentObjectInfo
extends AbstractUIObjectInfo
implements Cloneable,
Serializable {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.webcomponent.WebComponentObjectInfo");
    protected static final String SCRIPTS = "scripts";
    protected static final String METAS = "metas";
    protected static final String STYLESHEETS = "styleSheets";
    protected static final String COMPONENTS = "components";
    protected static final String DATAOBJECTS = "dataObjects";
    protected static final String ACTIONS = "actions";
    protected static final String OTHERS = "others";
    protected static final String STATUSES = "statuses";
    protected static final String RELEASE_PACKAGE = "releasePackage";
    protected static final String RELEASE_CLASS = "releaseClass";
    protected static final String PARENT = "parent";
    protected static final String TITLE = "title";
    protected static final String RULESET = "ruleSet";
    protected static final String BIZUNITPK = "bizUnitPK";
    protected static final String TAG = "tag";
    protected static final String NAMESPACE = "nameSpace";
    protected static final String TAGNAME = "tagName";
    protected static final String BUSINESSSPECIFICATION = "businessSpecification";
    protected static final String TECHNOLOGY = "technology";
    protected static final String ISSHOWCOMPONENT = "isShowComponent";
    protected static final String COMMUNITY = "community";
    protected static final String VERSION = "version";
    protected static final String WEBRESOURCES = "webResources";
    protected static final String CREATORS = "creators";
    protected static final String DEPENDENCIES = "dependencies";
    protected static final String EVENTS = "events";
    protected static final String PROPERTIES = "properties";
    protected static final String MAINTAINORS = "maintainors";
    protected static final String MACROS = "macros";
    protected static final String RELEASE_TEMPLATES = "releaseTemplates";
    protected static final String RELEASES = "releases";
    protected static final String WEBACTIONS = "webActions";
    protected static final String SUPPORTVALIDATOR = "supportValidator";
    protected static final String SMALLICON = "smallicon";
    protected static final String LARGEICON = "largeicon";
    protected static final String DISPLAYPIC = "displayPic";
    protected static final String ENABLETABINDEX = "enableTabIndex";
    protected static final String CALLFUNCTION = "callFunction";
    private String parentFullName = "";
    protected static final String CODECONTENT = "codeContent";
    protected static final String TEMPLATECONTENT = "templateContent";
    public static Locale defaultLocale;
    public static Locale currentLocale;
    private ComponentNameManager nameManager;
    private boolean isAssembled = false;
    private boolean isGenAgent = false;

    public WebComponentObjectInfo() {
        this.setDefaultLocale(ContextManager.getContext().getLocale());
        defaultLocale = ContextManager.getContext().getLocale();
    }

    @Override
    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        ComponentCollection components = this.getComponents();
        for (int i = 0; i < components.size(); ++i) {
            ComponentInfo comp = components.get(i);
            if ("com.kingdee.bos.ctrl.web.DrawImage".equals(comp.getClassType())) {
                PropertyInfo propValue = comp.getPropertyByName("value");
                PropertyInfo propDraw = comp.getPropertyByName("draw");
                if (propValue != null || propDraw != null) continue;
                vld.addError("DrawImage component <" + comp.getName() + "> must set value or draw property");
                continue;
            }
            if (!"com.kingdee.bos.ctrl.web.EditDataGrid".equalsIgnoreCase(comp.getClassType())) continue;
            for (int j = 0; j < comp.getComponents().size(); ++j) {
                ComponentInfo info = comp.getComponents().get(j);
                if (!"com.kingdee.bos.ctrl.web.EditableColumn".equalsIgnoreCase(info.getClassType()) || info.getComponents().size() != 1) continue;
                ComponentInfo editor = info.getComponents().get(0);
                PropertyBindingCollection col = info.getPropertyBindings();
                int size = col.size();
                for (int k = 0; k < size; ++k) {
                    String field;
                    if (!"value".equalsIgnoreCase(col.get(k).getPropertyName()) || StringUtils.isEmpty((String)(field = col.get(k).getBingdingField())) || !(field = field.substring(field.lastIndexOf(".") + 1)).equalsIgnoreCase(editor.getName())) continue;
                    vld.addError("<" + editor.getName() + ">'s name is not allowed");
                }
            }
        }
        ValidateList list = super.validate();
        list.addList(vld.getValidateList());
        return list;
    }

    protected WebComponentObjectInfo(boolean init) {
        super(init);
    }

    @Override
    public ComponentInfo getMainPanelComponent() {
        Iterator iter = this.getComponents().iterator();
        ComponentInfo panel = null;
        while (iter.hasNext()) {
            panel = (ComponentInfo)iter.next();
            if (panel.getParent() != null || !"com.kingdee.bos.ctrl.web.RootPane".equals(panel.getClassType())) continue;
            return panel;
        }
        return null;
    }

    public String getTag() {
        return (String)this.get(TAG);
    }

    public void setTag(String tag) {
        this.put(TAG, tag);
    }

    public String getTagName() {
        return (String)this.get(TAGNAME);
    }

    public void setTagName(String tagName) {
        this.put(TAGNAME, tagName);
    }

    public String getCallFunction() {
        return (String)this.get(CALLFUNCTION);
    }

    public void setCallFunction(String callFunction) {
        this.put(CALLFUNCTION, callFunction);
    }

    public String getNameSpace() {
        return (String)this.get(NAMESPACE);
    }

    public void setNameSpace(String nameSpace) {
        this.put(NAMESPACE, nameSpace);
    }

    public String getBusinessSpecification() {
        return (String)this.get(BUSINESSSPECIFICATION);
    }

    public void setBusinessSpecification(String businessSpecification) {
        this.put(BUSINESSSPECIFICATION, businessSpecification);
    }

    public String getTechnology() {
        return (String)this.get(TECHNOLOGY);
    }

    public void setTechnology(String technology) {
        this.put(TECHNOLOGY, technology);
    }

    public String getCommunity() {
        return (String)this.get(COMMUNITY);
    }

    public void setCommunity(String community) {
        this.put(COMMUNITY, community);
    }

    public Boolean isIsShowComponent() {
        return (Boolean)this.get(ISSHOWCOMPONENT);
    }

    public void setIsShowComponent(Boolean isShowComponent) {
        this.put(ISSHOWCOMPONENT, isShowComponent);
    }

    public Boolean isSupportValidator() {
        return this.getBoolean(SUPPORTVALIDATOR);
    }

    public void setSupportValidator(Boolean supportValidator) {
        this.put(SUPPORTVALIDATOR, supportValidator);
    }

    public WebComponentObjectInfo getParent() {
        return (WebComponentObjectInfo)this.get(PARENT);
    }

    public void setParent(WebComponentObjectInfo info) {
        this.put(PARENT, info);
    }

    public WebComponentObjectInfo cloneOnlySelf() {
        WebComponentObjectInfo info = null;
        try {
            info = (WebComponentObjectInfo)this.getClass().newInstance();
            info.setName(this.getName());
            info.setPackage(this.getPackage());
            info.setDescription(this.getDescription());
            info.setParent(this.getParent());
            info.setParentFullName(this.getParentFullName());
            info.setPKField(this.getPKField());
            info.setRuleSet(this.getRuleSet());
            info.setProperties(this.getProperties());
            WebComponentObjectInfo.copyExtendedProperties(this, info);
            info.setBizUnitPK(this.getBizUnitPK());
            info.setUserDefined(this.isUserDefined());
            info.setIsShowComponent(this.isIsShowComponent());
            info.setNameManager(this.nameManager);
            info.setEvents(this.getEvents());
        }
        catch (InstantiationException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return info;
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.WEBCOMPONENTOBJECT;
    }

    public ScriptCollection getScripts() {
        Object obj = this.get(SCRIPTS);
        if (obj == null) {
            ScriptCollection collection = new ScriptCollection();
            this.put(SCRIPTS, collection);
            return collection;
        }
        return (ScriptCollection)obj;
    }

    public ScriptCollection getInheritedScripts() {
        ScriptCollection scripts = new ScriptCollection();
        ArrayList<WebComponentObjectInfo> webUIObjects = new ArrayList<WebComponentObjectInfo>();
        webUIObjects.add(this);
        WebComponentObjectInfo parent = this;
        while ((parent = parent.getParent()) != null) {
            webUIObjects.add(parent);
        }
        for (int i = webUIObjects.size() - 1; i >= 0; --i) {
            WebComponentObjectInfo webUIObjectInfo = (WebComponentObjectInfo)webUIObjects.get(i);
            scripts.addObjectCollection(webUIObjectInfo.getScripts());
        }
        return scripts;
    }

    public StyleSheetCollection getStyleSheets() {
        Object obj = this.get(STYLESHEETS);
        if (obj == null) {
            StyleSheetCollection collection = new StyleSheetCollection();
            this.put(STYLESHEETS, collection);
            return collection;
        }
        return (StyleSheetCollection)obj;
    }

    public StyleSheetCollection getInheritedStyleSheets() {
        StyleSheetCollection styleSheets = new StyleSheetCollection();
        ArrayList<WebComponentObjectInfo> webUIObjects = new ArrayList<WebComponentObjectInfo>();
        webUIObjects.add(this);
        WebComponentObjectInfo parent = this;
        while ((parent = parent.getParent()) != null) {
            webUIObjects.add(parent);
        }
        for (int i = webUIObjects.size() - 1; i >= 0; --i) {
            WebComponentObjectInfo webUIObjectInfo = (WebComponentObjectInfo)webUIObjects.get(i);
            styleSheets.addObjectCollection(webUIObjectInfo.getStyleSheets());
        }
        return styleSheets;
    }

    public void setScripts(ScriptCollection scripts) {
        this.put(SCRIPTS, scripts);
    }

    public void setStyleSheets(StyleSheetCollection styleSheets) {
        this.put(STYLESHEETS, styleSheets);
    }

    public void setEvents(EventCollection events) {
        this.put(EVENTS, events);
    }

    public void setProperties(PropertyCollection properties) {
        this.put(PROPERTIES, properties);
    }

    public void setCreators(CreatorCollection creators) {
        this.put(CREATORS, creators);
    }

    public void setMaintainors(MaintainorCollection maintainors) {
        this.put(MAINTAINORS, maintainors);
    }

    public void setVersion(VersionInfo version) {
        this.put(VERSION, version);
    }

    public void setWebResources(WebResourceCollection webResources) {
        this.put(WEBRESOURCES, webResources);
    }

    public void setDependencies(DependencyCollection dependencies) {
        this.put(DEPENDENCIES, dependencies);
    }

    public void setMacros(MacroCollection macros) {
        this.put(MACROS, macros);
    }

    public EventCollection getEvents() {
        Object obj = this.get(EVENTS);
        if (obj == null) {
            EventCollection collection = new EventCollection();
            this.put(EVENTS, collection);
            return collection;
        }
        return (EventCollection)obj;
    }

    public PropertyCollection getProperties() {
        Object obj = this.get(PROPERTIES);
        if (obj == null) {
            PropertyCollection collection = new PropertyCollection();
            this.put(PROPERTIES, collection);
            return collection;
        }
        return (PropertyCollection)obj;
    }

    public CreatorCollection getCreators() {
        Object obj = this.get(CREATORS);
        if (obj == null) {
            CreatorCollection collection = new CreatorCollection();
            this.put(CREATORS, collection);
            return collection;
        }
        return (CreatorCollection)obj;
    }

    public ReleaseTemplateCollection getReleaseTemplates() {
        Object obj = this.get(RELEASE_TEMPLATES);
        if (obj == null) {
            ReleaseTemplateCollection collection = new ReleaseTemplateCollection();
            this.put(RELEASE_TEMPLATES, collection);
            return collection;
        }
        return (ReleaseTemplateCollection)obj;
    }

    public ReleaseCollection getReleases() {
        Object obj = this.get(RELEASES);
        if (obj == null) {
            ReleaseCollection collection = new ReleaseCollection();
            this.put(RELEASES, collection);
            return collection;
        }
        return (ReleaseCollection)obj;
    }

    public MaintainorCollection getMaintainors() {
        Object obj = this.get(MAINTAINORS);
        if (obj == null) {
            MaintainorCollection collection = new MaintainorCollection();
            this.put(MAINTAINORS, collection);
            return collection;
        }
        return (MaintainorCollection)obj;
    }

    public VersionInfo getVersion() {
        Object obj = this.get(VERSION);
        if (obj == null) {
            VersionInfo info = new VersionInfo();
            this.put(VERSION, info);
            return info;
        }
        return (VersionInfo)obj;
    }

    public WebResourceCollection getWebResources() {
        Object obj = this.get(WEBRESOURCES);
        if (obj == null) {
            WebResourceCollection collection = new WebResourceCollection();
            this.put(WEBRESOURCES, collection);
            return collection;
        }
        return (WebResourceCollection)obj;
    }

    public DependencyCollection getDependencies() {
        Object obj = this.get(DEPENDENCIES);
        if (obj == null) {
            DependencyCollection collection = new DependencyCollection();
            this.put(DEPENDENCIES, collection);
            return collection;
        }
        return (DependencyCollection)obj;
    }

    public MacroCollection getMacros() {
        Object obj = this.get(MACROS);
        if (obj == null) {
            MacroCollection collection = new MacroCollection();
            this.put(MACROS, collection);
            return collection;
        }
        return (MacroCollection)obj;
    }

    public EventCollection getInheritedEvents() {
        EventCollection col = new EventCollection();
        ArrayList<WebComponentObjectInfo> webUIObjects = new ArrayList<WebComponentObjectInfo>();
        webUIObjects.add(this);
        WebComponentObjectInfo parent = this;
        while ((parent = parent.getParent()) != null) {
            webUIObjects.add(parent);
        }
        for (int i = webUIObjects.size() - 1; i >= 0; --i) {
            WebComponentObjectInfo webUIObjectInfo = (WebComponentObjectInfo)webUIObjects.get(i);
            col.addObjectCollection(webUIObjectInfo.getEvents());
        }
        return col;
    }

    public PropertyCollection getInheritedProperties() {
        PropertyCollection col = new PropertyCollection();
        ArrayList<WebComponentObjectInfo> webUIObjects = new ArrayList<WebComponentObjectInfo>();
        webUIObjects.add(this);
        WebComponentObjectInfo parent = this;
        while ((parent = parent.getParent()) != null) {
            webUIObjects.add(parent);
        }
        for (int i = webUIObjects.size() - 1; i >= 0; --i) {
            WebComponentObjectInfo webUIObjectInfo = (WebComponentObjectInfo)webUIObjects.get(i);
            col.addObjectCollection(webUIObjectInfo.getProperties());
        }
        return col;
    }

    public DependencyCollection getInheritedDependencies() {
        DependencyCollection col = new DependencyCollection();
        ArrayList<WebComponentObjectInfo> webUIObjects = new ArrayList<WebComponentObjectInfo>();
        webUIObjects.add(this);
        WebComponentObjectInfo parent = this;
        while ((parent = parent.getParent()) != null) {
            webUIObjects.add(parent);
        }
        for (int i = webUIObjects.size() - 1; i >= 0; --i) {
            WebComponentObjectInfo webUIObjectInfo = (WebComponentObjectInfo)webUIObjects.get(i);
            col.addObjectCollection(webUIObjectInfo.getDependencies());
        }
        return col;
    }

    public MacroCollection getInheritedMacros() {
        MacroCollection col = new MacroCollection();
        ArrayList<WebComponentObjectInfo> webUIObjects = new ArrayList<WebComponentObjectInfo>();
        webUIObjects.add(this);
        WebComponentObjectInfo parent = this;
        while ((parent = parent.getParent()) != null) {
            webUIObjects.add(parent);
        }
        for (int i = webUIObjects.size() - 1; i >= 0; --i) {
            WebComponentObjectInfo webUIObjectInfo = (WebComponentObjectInfo)webUIObjects.get(i);
            col.addObjectCollection(webUIObjectInfo.getMacros());
        }
        return col;
    }

    public String getCodeContent() {
        return (String)this.get(CODECONTENT);
    }

    public void setTemplateContent(String templateContent) {
        this.put(TEMPLATECONTENT, templateContent);
    }

    public String getTemplateContent() {
        return this.getString(TEMPLATECONTENT);
    }

    public WebActionCollection getWebActions() {
        Object obj = this.get(WEBACTIONS);
        if (obj == null) {
            WebActionCollection collection = new WebActionCollection();
            this.put(WEBACTIONS, collection);
            return collection;
        }
        return (WebActionCollection)obj;
    }

    public WebActionInfo getWebActionByName(String instanceName) {
        if (StringUtils.isEmpty((String)instanceName)) {
            return null;
        }
        WebActionCollection actions = this.getWebActions();
        return actions.getActionByName(instanceName);
    }

    public void setWebActions(WebActionCollection webActions) {
        this.put(WEBACTIONS, webActions);
    }

    static {
        currentLocale = defaultLocale = ContextManager.getContext().getLocale();
    }
}

