/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webpage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.CheckReportFilter;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.dao.xml.IXMLDAO;
import com.kingdee.bos.dao.xml.XMLDAO;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizrule.common.AbstractExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.ActionCollection;
import com.kingdee.bos.metadata.bizrule.common.ActionInfo;
import com.kingdee.bos.metadata.bizrule.common.ConditionCollection;
import com.kingdee.bos.metadata.bizrule.common.ConditionInfo;
import com.kingdee.bos.metadata.bizrule.common.ExpressionCollection;
import com.kingdee.bos.metadata.bizrule.common.ExpressionType;
import com.kingdee.bos.metadata.bizrule.common.GroupExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.MethodInfo;
import com.kingdee.bos.metadata.bizrule.common.ParameterCollection;
import com.kingdee.bos.metadata.bizrule.common.SimpleExpressionInfo;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.webpage.IWebPageObjectCtrl;
import com.kingdee.bos.metadata.webpage.WebPageObjectAssembler;
import com.kingdee.bos.metadata.webpage.WebPageObjectCollection;
import com.kingdee.bos.metadata.webpage.WebPageObjectInfo;
import com.kingdee.bos.metadata.webrelease.ReleaseBridgeManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class WebPageObjectCtrl
extends AbstractMetaDataCtrl
implements IWebPageObjectCtrl {
    private static final Logger logger = Logger.getLogger(WebPageObjectCtrl.class);
    public static final String UI_TYPE = "uitype";
    public static final String EVENT_SCENCE = "scene";
    public static final String EVENT_SCENCE_SERVER = "server";
    public static final String EVENT_SCENCE_CLIENT = "client";
    public static final String UI_TYPE_WEBFORM = "WebForm";

    public WebPageObjectCtrl(Context ctx) {
        super(ctx);
        super.registerInterface(IWebPageObjectCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.ui", "uiObject"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.webpage", "webPageObject"));
    }

    public WebPageObjectCtrl() {
        super.registerInterface(IWebPageObjectCtrl.class, (Object)this);
    }

    @Override
    public BOSObjectType getType() {
        return MetaDataTypeList.WEBPAGEOBJECT;
    }

    @Override
    public void addnew(IMetaDataPK pk, WebPageObjectInfo uiObjectInfo) throws BOSException {
        ComponentCollection components = uiObjectInfo.getComponents();
        uiObjectInfo.setComponents(this.treeToCol(components));
        this.getDAO().addnew(pk, uiObjectInfo);
        uiObjectInfo.setComponents(components);
    }

    @Override
    public IMetaDataPK addnew(WebPageObjectInfo uiObjectInfo) throws BOSException {
        ComponentCollection components = uiObjectInfo.getComponents();
        uiObjectInfo.setComponents(this.treeToCol(components));
        IMetaDataPK metaDataPK = (IMetaDataPK)this.getDAO().addnew(uiObjectInfo);
        uiObjectInfo.setComponents(components);
        return metaDataPK;
    }

    @Override
    public void remove(IMetaDataPK metaType) throws BOSException {
        this.getDAO().delete(metaType);
    }

    @Override
    public void update(IMetaDataPK metaType, WebPageObjectInfo uiObjectInfo) throws BOSException {
        WebPageObjectInfo model = uiObjectInfo;
        if (model.isAssembled()) {
            model = WebPageObjectAssembler.parseWebPage(this.getContext(), model);
        }
        this.getDAO().update(metaType, model);
    }

    @Override
    public boolean exists(IMetaDataPK metaType) throws BOSException {
        return this.getDAO().exists(metaType);
    }

    @Override
    public WebPageObjectInfo getValue(IMetaDataPK metaType) throws BOSException {
        WebPageObjectInfo uiObjectInfo = (WebPageObjectInfo)this.getDAO().getValue(metaType);
        this.afterLoad(uiObjectInfo);
        return uiObjectInfo;
    }

    @Override
    public synchronized WebPageObjectInfo getValueNotCache(IMetaDataPK metaType) throws BOSException {
        XMLDAO.clearCache(this.getContext(), MetaDataTypeList.WEBPAGEOBJECT);
        WebPageObjectInfo uiObjectInfo = (WebPageObjectInfo)this.getDAO().getValue(metaType);
        XMLDAO.clearCache(this.getContext(), MetaDataTypeList.WEBPAGEOBJECT);
        this.afterLoad(uiObjectInfo);
        return uiObjectInfo;
    }

    @Override
    public WebPageObjectInfo getAllValue(IMetaDataPK metaType) throws BOSException {
        return this.getAllValue(metaType, true);
    }

    @Override
    public WebPageObjectInfo getAllValue(IMetaDataPK metaType, boolean isClearCache) throws BOSException {
        long startTime = 0L;
        startTime = System.currentTimeMillis();
        WebPageObjectInfo uiObjectInfo = isClearCache ? this.getValueNotCache(metaType) : this.getValue(metaType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u88c5\u8f7d\u5143\u6570\u636e" + metaType.getFullName() + "\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
            startTime = System.currentTimeMillis();
        }
        uiObjectInfo = WebPageObjectAssembler.assembleWebPage(this.getContext(), uiObjectInfo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u62fc\u88c5\u5b8c\u6574UI\u5bf9\u8c61" + metaType.getFullName() + "\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
        }
        return uiObjectInfo;
    }

    private WebPageObjectInfo getUncheckValue(IMetaDataPK metaType) throws BOSException {
        long startTime = System.currentTimeMillis();
        WebPageObjectInfo uiObjectInfo = this.getValueNotCache(metaType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u53d1\u5e03UI " + metaType.getFullName() + "\u8fc7\u7a0b\u4e2d\uff0c\u88c5\u8f7dUI\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
            startTime = System.currentTimeMillis();
        }
        uiObjectInfo = WebPageObjectAssembler.assembleWebPage(this.getContext(), uiObjectInfo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u53d1\u5e03UI " + metaType.getFullName() + "\u8fc7\u7a0b\u4e2d\uff0c\u62fc\u88c5UI\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
        }
        return uiObjectInfo;
    }

    public WebPageObjectCollection getCollection() throws BOSException {
        WebPageObjectCollection uiObjects = (WebPageObjectCollection)this.getDAO().getCollection();
        int n = uiObjects.size();
        for (int i = 0; i < n; ++i) {
            WebPageObjectInfo uiObjectInfo = uiObjects.get(i);
            uiObjectInfo.setComponents(this.colToTree(uiObjectInfo.getComponents()));
            this.afterLoad(uiObjectInfo);
        }
        return uiObjects;
    }

    public WebPageObjectCollection getCollection(String pgName) throws BOSException {
        WebPageObjectCollection uiObjects = (WebPageObjectCollection)((IXMLDAO)this.getDAO()).getCollection(pgName);
        int n = uiObjects.size();
        for (int i = 0; i < n; ++i) {
            WebPageObjectInfo uiObjectInfo = uiObjects.get(i);
            uiObjectInfo.setComponents(this.colToTree(uiObjectInfo.getComponents()));
            this.afterLoad(uiObjectInfo);
        }
        return uiObjects;
    }

    @Override
    public IMetaDataPK[] getPKList() throws BOSException {
        return (IMetaDataPK[])this.getDAO().getPKList();
    }

    @Override
    public IMetaDataPK[] getPKList(String pgName) throws BOSException {
        return (IMetaDataPK[])((IXMLDAO)this.getDAO()).getPKList(pgName);
    }

    @Override
    public IObjectValue load(InputStream is) throws DataAccessException {
        WebPageObjectInfo uiObjectInfo = (WebPageObjectInfo)super.load(is);
        this.afterLoad(uiObjectInfo);
        return uiObjectInfo;
    }

    WebPageObjectInfo _load(IMetaDataPK metaType) throws BOSException {
        return this.getValueNotCache(metaType);
    }

    @Override
    public void store(IObjectValue ov, OutputStream os) throws DataAccessException {
        super.store(ov, os);
    }

    private String getObjectID(IObjectValue info) {
        if (info == null) {
            return null;
        }
        String id = info.getString("id");
        if (StringUtils.isEmpty((String)id)) {
            id = Uuid.create().toString();
            info.setString("id", id);
        }
        return id;
    }

    private Hashtable transToHashtable(IObjectCollection col) {
        Hashtable<String, IObjectValue> table = new Hashtable<String, IObjectValue>();
        if (col != null) {
            int m = col.size();
            for (int j = 0; j < m; ++j) {
                String id = this.getObjectID(col.getObject(j));
                table.put(id, col.getObject(j));
            }
        }
        return table;
    }

    private void setExpressionsToMethod(MethodInfo methodInfo, ExpressionCollection expCol, Hashtable table) {
        if (methodInfo == null) {
            return;
        }
        ParameterCollection paramCol = methodInfo.getParameters();
        int m = paramCol.size();
        for (int i = 0; i < m; ++i) {
            String expressionID = paramCol.get(i).getString("expressionID");
            paramCol.get(i).setExpression((AbstractExpressionInfo)table.get(expressionID));
        }
    }

    private void setExpressionsToExp(AbstractExpressionInfo expInfo, ExpressionCollection expCol, Hashtable table) {
        String id = expInfo.getString("id");
        if (expInfo instanceof GroupExpressionInfo) {
            GroupExpressionInfo geInfo = (GroupExpressionInfo)expInfo;
            geInfo.getExpressions().clear();
            int n = expCol.size();
            for (int i = 0; i < n; ++i) {
                String parentID = expCol.get(i).getString("parentID");
                if (!id.equals(parentID)) continue;
                geInfo.getExpressions().add(expCol.get(i));
            }
        } else if (expInfo instanceof SimpleExpressionInfo) {
            String ownerID;
            SimpleExpressionInfo seInfo = (SimpleExpressionInfo)expInfo;
            if (seInfo.getType() == ExpressionType.METHODINVOKE) {
                String ownerID2;
                if (seInfo.getMethod() != null && !StringUtils.isEmpty((String)(ownerID2 = seInfo.getMethod().getString("ownerID")))) {
                    seInfo.getMethod().setOwner((SimpleExpressionInfo)table.get(ownerID2));
                }
                this.setExpressionsToMethod(seInfo.getMethod(), expCol, table);
            } else if (seInfo.getType() == ExpressionType.PROPERTYACCESS && seInfo.getProperty() != null && !StringUtils.isEmpty((String)(ownerID = seInfo.getProperty().getString("ownerID")))) {
                seInfo.getProperty().setOwner((SimpleExpressionInfo)table.get(ownerID));
            }
        }
    }

    private void afterLoad(WebPageObjectInfo info) {
        ConditionCollection conditions;
        String expressionID;
        RuleSetInfo rsInfo = info.getRuleSet();
        if (rsInfo == null || rsInfo.getBoolean("_hasReConstruct")) {
            return;
        }
        ExpressionCollection expCol = (ExpressionCollection)rsInfo.get("expressions");
        if (expCol == null) {
            expCol = new ExpressionCollection();
        }
        Hashtable expTable = this.transToHashtable(expCol);
        int n = expCol.size();
        for (int i = 0; i < n; ++i) {
            this.setExpressionsToExp(expCol.get(i), expCol, expTable);
        }
        ActionCollection actions = (ActionCollection)rsInfo.get("actions");
        if (actions != null) {
            int n2 = actions.size();
            for (int i = 0; i < n2; ++i) {
                ActionInfo action = actions.get(i);
                expressionID = action.getString("expressionID");
                if (StringUtils.isEmpty((String)expressionID)) continue;
                action.setExpression((AbstractExpressionInfo)expTable.get(expressionID));
            }
        }
        if ((conditions = (ConditionCollection)rsInfo.get("conditions")) != null) {
            int n3 = conditions.size();
            for (int i = 0; i < n3; ++i) {
                ConditionInfo condition = conditions.get(i);
                expressionID = condition.getString("expressionID");
                if (StringUtils.isEmpty((String)expressionID)) continue;
                condition.setExpression((AbstractExpressionInfo)expTable.get(expressionID));
            }
        }
        rsInfo.setBoolean("_hasReConstruct", true);
    }

    private ComponentCollection treeToCol(ComponentCollection components) {
        ComponentCollection col = new ComponentCollection();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            this.addToCol(components.get(i), col);
        }
        return col;
    }

    private void addToCol(ComponentInfo info, ComponentCollection col) {
        col.add(info);
        int n = info.getComponents().size();
        for (int i = 0; i < n; ++i) {
            this.addToCol(info.getComponents().get(i), col);
        }
    }

    private ComponentCollection colToTree(ComponentCollection components) {
        ComponentCollection col = new ComponentCollection();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            if (components.get(i).getParent() == null) {
                col.add(components.get(i));
                continue;
            }
            components.get(i).getParent().getComponents().add(components.get(i));
        }
        return col;
    }

    @Override
    public void deploy(AbstractMetaDataValue ui, DeployOptionInfo options) throws BOSException {
        block4: {
            super.deploy(ui, options);
            if (!(ui instanceof WebPageObjectInfo)) {
                return;
            }
            WebPageObjectInfo model = (WebPageObjectInfo)ui;
            long startTime = System.currentTimeMillis();
            String frameworkPackge = "com.kingdee.eas.framework.web";
            if (!frameworkPackge.equals(ui.getPackage()) && model.getMainPanelComponent() != null) {
                try {
                    ReleaseBridgeManager.getInstance().getReleaseBridge().webClientCodeRender(this.getContext(), model, options);
                    ReleaseBridgeManager.getInstance().getReleaseBridge().webServerCodeRender(this.getContext(), model, options);
                }
                catch (Throwable e) {
                    if (e instanceof NoSuchMethodError) break block4;
                    throw new BOSException(e);
                }
            }
        }
    }

    @Override
    public void deploy(IMetaDataPK pk, DeployOptionInfo options) throws BOSException {
        block3: {
            super.deploy(pk, options);
            long startTime = System.currentTimeMillis();
            WebPageObjectInfo model = this.getUncheckValue(pk);
            String frameworkPackge = "com.kingdee.eas.framework.web";
            Context ctx = this.getContext();
            ctx.put((Object)"deployOptionInfo", (Object)options);
            if (!frameworkPackge.equals(model.getPackage()) && model.getMainPanelComponent() != null) {
                try {
                    ReleaseBridgeManager.getInstance().getReleaseBridge().webClientCodeRender(ctx, model, options);
                    ReleaseBridgeManager.getInstance().getReleaseBridge().webServerCodeRender(ctx, model, options);
                }
                catch (Throwable e) {
                    if (e instanceof NoSuchMethodError) break block3;
                    throw new BOSException(e);
                }
            }
        }
    }

    @Override
    public WebPageObjectCollection getRawCollection() throws BOSException {
        return (WebPageObjectCollection)this.getDAO().getCollection();
    }

    @Override
    public WebPageObjectCollection getRawCollection(String pgName) throws BOSException {
        return (WebPageObjectCollection)((IXMLDAO)this.getDAO()).getCollection(pgName);
    }

    @Override
    public void rawUpdate(IMetaDataPK metaType, WebPageObjectInfo uiObjectInfo) throws BOSException {
        this.getDAO().update(metaType, uiObjectInfo);
    }

    private boolean isGenAgent(DeployOptionInfo options, WebPageObjectInfo model) {
        boolean ret = options.needToGenAgent(MetaDataTypeList.WEBPAGEOBJECT, new MetaDataPK(model.getFullName()));
        if (!ret) {
            return false;
        }
        return ret;
    }

    @Override
    public void check(IMetaDataPK pk, CheckReportFilter filter, ICheckReport report, OutputStream os) throws BOSException {
        super.check(pk, filter, report, os);
    }

    public static void beforeSave(WebPageObjectInfo ui) {
        WebPageObjectCtrl.reorder(ui);
    }

    private static void reorder(WebPageObjectInfo ui) {
        if (ui != null && ui.getMainPanelComponent() != null) {
            ComponentCollection col = new ComponentCollection();
            col.add(ui.getMainPanelComponent());
            WebPageObjectCtrl.reorder(col, ui.getMainPanelComponent());
            ui.setComponents(col);
        }
    }

    private static void reorder(ComponentCollection newCollection, ComponentInfo comp) {
        newCollection.addObjectCollection(comp.getComponents());
        Iterator iter = comp.getComponents().iterator();
        while (iter.hasNext()) {
            ComponentInfo child = (ComponentInfo)iter.next();
            WebPageObjectCtrl.reorder(newCollection, child);
        }
    }
}

