/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webpage;

import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.WebEventCollection;
import com.kingdee.bos.metadata.ui.WebEventInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.metadata.webcommon.WebResourceCollection;
import com.kingdee.bos.metadata.webpage.MetaCollection;
import com.kingdee.bos.metadata.webpage.PageFunctionCollection;
import com.kingdee.bos.metadata.webpage.ScriptCollection;
import com.kingdee.bos.metadata.webpage.StyleSheetCollection;
import com.kingdee.bos.metadata.webpage.WebActionCollection;
import com.kingdee.bos.metadata.webpage.WebActionInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WebPageObjectInfo
extends AbstractUIObjectInfo
implements Cloneable,
Serializable {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.webui.WebUIObjectInfo");
    protected static final String SCRIPTS = "scripts";
    protected static final String METAS = "metas";
    protected static final String STYLESHEETS = "styleSheets";
    protected static final String COMPONENTS = "components";
    protected static final String DATAOBJECTS = "dataObjects";
    protected static final String ACTIONS = "actions";
    protected static final String OTHERS = "others";
    protected static final String STATUSES = "statuses";
    protected static final String RELEASE_PACKAGE = "releasePackage";
    protected static final String RELEASE_CLASS = "releaseClass";
    protected static final String PARENT = "parent";
    protected static final String WEBRESOURCES = "webResources";
    protected static final String PAGEFUNCTIONS = "pageFunctions";
    protected static final String TITLE = "title";
    protected static final String RULESET = "ruleSet";
    protected static final String BIZUNITPK = "bizUnitPK";
    protected static final String WEBACTIONS = "webActions";
    protected static final String WEBEVENTS = "webEvents";
    private String parentFullName = "";
    public static Locale defaultLocale;
    public static Locale currentLocale;
    private boolean isAssembled = false;
    private boolean isGenAgent = false;
    protected static final String PAGE_TYPE = "uitype";
    public static final String NULL_WEB_PAGE = "null";
    public static final String EDIT_WEB_PAGE = "edit";
    public static final String LIST_WEB_PAGE = "list";
    public static final String VIEW_WEB_PAGE = "view";
    public static final String SUMMRAY_WEB_PAGE = "summary";

    public WebPageObjectInfo() {
        this.setDefaultLocale(ContextManager.getContext().getLocale());
        defaultLocale = ContextManager.getContext().getLocale();
    }

    @Override
    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        ComponentCollection components = this.getComponents();
        for (int i = 0; i < components.size(); ++i) {
            ComponentInfo comp = components.get(i);
            if ("com.kingdee.bos.ctrl.web.DrawImage".equals(comp.getClassType())) {
                PropertyInfo propValue = comp.getPropertyByName("value");
                PropertyInfo propDraw = comp.getPropertyByName("draw");
                if (propValue != null || propDraw != null) continue;
                vld.addError("DrawImage component <" + comp.getName() + "> must set value or draw property");
                continue;
            }
            if (!"com.kingdee.bos.ctrl.web.EditDataGrid".equalsIgnoreCase(comp.getClassType())) continue;
            for (int j = 0; j < comp.getComponents().size(); ++j) {
                ComponentInfo info = comp.getComponents().get(j);
                if (!"com.kingdee.bos.ctrl.web.EditableColumn".equalsIgnoreCase(info.getClassType()) || info.getComponents().size() != 1) continue;
                ComponentInfo editor = info.getComponents().get(0);
                PropertyBindingCollection col = info.getPropertyBindings();
                int size = col.size();
                for (int k = 0; k < size; ++k) {
                    String field;
                    if (!"value".equalsIgnoreCase(col.get(k).getPropertyName()) || StringUtils.isEmpty((String)(field = col.get(k).getBingdingField())) || !(field = field.substring(field.lastIndexOf(".") + 1)).equalsIgnoreCase(editor.getName())) continue;
                    vld.addError("<" + editor.getName() + ">'s name is not allowed");
                }
            }
        }
        ValidateList list = super.validate();
        list.addList(vld.getValidateList());
        return list;
    }

    protected WebPageObjectInfo(boolean init) {
        super(init);
    }

    @Override
    public ComponentInfo getMainPanelComponent() {
        Iterator iter = this.getComponents().iterator();
        ComponentInfo panel = null;
        while (iter.hasNext()) {
            panel = (ComponentInfo)iter.next();
            if (panel.getParent() != null || !"com.kingdee.bos.ctrl.web.RootPane".equals(panel.getClassType())) continue;
            return panel;
        }
        return null;
    }

    public WebPageObjectInfo getParent() {
        return (WebPageObjectInfo)this.get(PARENT);
    }

    public void setParent(WebPageObjectInfo info) {
        this.put(PARENT, info);
    }

    public WebPageObjectInfo cloneOnlySelf() {
        WebPageObjectInfo info = null;
        try {
            info = (WebPageObjectInfo)this.getClass().newInstance();
            info.setName(this.getName());
            info.setPackage(this.getPackage());
            info.setDescription(this.getDescription());
            info.setParent(this.getParent());
            info.setParentFullName(this.getParentFullName());
            info.setPKField(this.getPKField());
            info.setPageType(this.getPageType());
            info.setRuleSet(this.getRuleSet());
            WebPageObjectInfo.copyExtendedProperties(this, info);
            info.setBizUnitPK(this.getBizUnitPK());
            info.setUserDefined(this.isUserDefined());
            info.setNameManager(this.getNameManager());
        }
        catch (InstantiationException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return info;
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.WEBPAGEOBJECT;
    }

    public ScriptCollection getScripts() {
        Object obj = this.get(SCRIPTS);
        if (obj == null) {
            ScriptCollection collection = new ScriptCollection();
            this.put(SCRIPTS, collection);
            return collection;
        }
        return (ScriptCollection)obj;
    }

    public ScriptCollection getInheritedScripts() {
        ScriptCollection scripts = new ScriptCollection();
        ArrayList<WebPageObjectInfo> webUIObjects = new ArrayList<WebPageObjectInfo>();
        webUIObjects.add(this);
        WebPageObjectInfo parent = this;
        while ((parent = parent.getParent()) != null) {
            webUIObjects.add(parent);
        }
        for (int i = webUIObjects.size() - 1; i >= 0; --i) {
            WebPageObjectInfo webUIObjectInfo = (WebPageObjectInfo)webUIObjects.get(i);
            scripts.addObjectCollection(webUIObjectInfo.getScripts());
        }
        return scripts;
    }

    public WebResourceCollection getWebResources() {
        Object obj = this.get(WEBRESOURCES);
        if (obj == null) {
            WebResourceCollection collection = new WebResourceCollection();
            this.put(WEBRESOURCES, collection);
            return collection;
        }
        return (WebResourceCollection)obj;
    }

    public PageFunctionCollection getPageFunctions() {
        Object obj = this.get(PAGEFUNCTIONS);
        if (obj == null) {
            PageFunctionCollection collection = new PageFunctionCollection();
            this.put(PAGEFUNCTIONS, collection);
            return collection;
        }
        return (PageFunctionCollection)obj;
    }

    public WebActionCollection getWebActions() {
        Object obj = this.get(WEBACTIONS);
        if (obj == null) {
            WebActionCollection collection = new WebActionCollection();
            this.put(WEBACTIONS, collection);
            return collection;
        }
        return (WebActionCollection)obj;
    }

    public WebActionInfo getWebActionByName(String instanceName) {
        if (StringUtils.isEmpty((String)instanceName)) {
            return null;
        }
        WebActionCollection actions = this.getWebActions();
        return actions.getActionByName(instanceName);
    }

    public StyleSheetCollection getStyleSheets() {
        Object obj = this.get(STYLESHEETS);
        if (obj == null) {
            StyleSheetCollection collection = new StyleSheetCollection();
            this.put(STYLESHEETS, collection);
            return collection;
        }
        return (StyleSheetCollection)obj;
    }

    public StyleSheetCollection getInheritedStyleSheets() {
        StyleSheetCollection styleSheets = new StyleSheetCollection();
        ArrayList<WebPageObjectInfo> webUIObjects = new ArrayList<WebPageObjectInfo>();
        webUIObjects.add(this);
        WebPageObjectInfo parent = this;
        while ((parent = parent.getParent()) != null) {
            webUIObjects.add(parent);
        }
        for (int i = webUIObjects.size() - 1; i >= 0; --i) {
            WebPageObjectInfo webUIObjectInfo = (WebPageObjectInfo)webUIObjects.get(i);
            styleSheets.addObjectCollection(webUIObjectInfo.getStyleSheets());
        }
        return styleSheets;
    }

    public MetaCollection getMetas() {
        Object obj = this.get(METAS);
        if (obj == null) {
            MetaCollection collection = new MetaCollection();
            this.put(METAS, collection);
            return collection;
        }
        return (MetaCollection)obj;
    }

    public void setScripts(ScriptCollection scripts) {
        this.put(SCRIPTS, scripts);
    }

    public void setStyleSheets(StyleSheetCollection styleSheets) {
        this.put(STYLESHEETS, styleSheets);
    }

    public void setMetas(MetaCollection metas) {
        this.put(METAS, metas);
    }

    public void setWebResources(WebResourceCollection webResources) {
        this.put(WEBRESOURCES, webResources);
    }

    public void setPageFunctions(PageFunctionCollection pageFunctions) {
        this.put(PAGEFUNCTIONS, pageFunctions);
    }

    public void setWebActions(WebActionCollection webActions) {
        this.put(WEBACTIONS, webActions);
    }

    public String getPageType() {
        return (String)this.get(PAGE_TYPE);
    }

    public void setPageType(String type) {
        this.put(PAGE_TYPE, type);
    }

    @Override
    public DataObjectCollection getDataObjects() {
        Object obj = this.get(DATAOBJECTS);
        if (obj == null) {
            DataObjectCollection collection = new DataObjectCollection();
            this.put(DATAOBJECTS, collection);
            return collection;
        }
        return (DataObjectCollection)obj;
    }

    @Override
    public void setDataObjects(DataObjectCollection dataObjects) {
        this.put(DATAOBJECTS, dataObjects);
    }

    @Override
    public void initNameSpace() {
        super.initNameSpace();
        this.initWebActionNameSpace(this.getWebActions());
    }

    public WebActionCollection getOwnedWebActions() {
        return this.getWebActions();
    }

    protected void initWebActionNameSpace(WebActionCollection collection) {
        if (collection == null) {
            return;
        }
        int size = collection.size();
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.getNameManager().put(collection.get(i).getActionName());
        }
    }

    public WebEventCollection getWebEvents() {
        Object obj = this.get(WEBEVENTS);
        if (obj == null) {
            WebEventCollection collection = new WebEventCollection();
            this.put(WEBEVENTS, collection);
            return collection;
        }
        return (WebEventCollection)obj;
    }

    public WebEventInfo getWebEventByName(String instanceName) {
        if (StringUtils.isEmpty((String)instanceName)) {
            return null;
        }
        WebEventCollection events = this.getWebEvents();
        return events.getEventByName(instanceName);
    }

    public void setWebEvents(WebEventCollection webEvents) {
        this.put(WEBEVENTS, webEvents);
    }

    static {
        currentLocale = defaultLocale = ContextManager.getContext().getLocale();
    }
}

