/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.webui;

import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.metadata.webui.ScriptCollection;
import com.kingdee.bos.metadata.webui.StyleSheetCollection;
import com.kingdee.bos.metadata.webui.WebMetaCollection;
import com.kingdee.bos.ui.dtp.model.ComponentNameManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WebUIObjectInfo
extends AbstractUIObjectInfo
implements Cloneable,
Serializable {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.webui.WebUIObjectInfo");
    protected static final String SCRIPTS = "scripts";
    protected static final String METAS = "metas";
    protected static final String STYLESHEETS = "styleSheets";
    protected static final String COMPONENTS = "components";
    protected static final String DATAOBJECTS = "dataObjects";
    protected static final String ACTIONS = "actions";
    protected static final String OTHERS = "others";
    protected static final String STATUSES = "statuses";
    protected static final String RELEASE_PACKAGE = "releasePackage";
    protected static final String RELEASE_CLASS = "releaseClass";
    protected static final String PARENT = "parent";
    protected static final String TITLE = "title";
    protected static final String RULESET = "ruleSet";
    protected static final String BIZUNITPK = "bizUnitPK";
    private static final String DEFAULTBUTTON = "defaultbutton";
    private String parentFullName = "";
    public static Locale defaultLocale;
    public static Locale currentLocale;
    private ComponentNameManager nameManager;
    private boolean isAssembled = false;
    private boolean isGenAgent = false;

    public WebUIObjectInfo() {
        this.setDefaultLocale(ContextManager.getContext().getLocale());
        defaultLocale = ContextManager.getContext().getLocale();
    }

    @Override
    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        ComponentCollection components = this.getComponents();
        for (int i = 0; i < components.size(); ++i) {
            ComponentInfo comp = components.get(i);
            if ("com.kingdee.bos.ctrl.web.DrawImage".equals(comp.getClassType())) {
                PropertyInfo propValue = comp.getPropertyByName("value");
                PropertyInfo propDraw = comp.getPropertyByName("draw");
                if (propValue != null || propDraw != null) continue;
                vld.addError("DrawImage component <" + comp.getName() + "> must set value or draw property");
                continue;
            }
            if (!"com.kingdee.bos.ctrl.web.EditDataGrid".equalsIgnoreCase(comp.getClassType())) continue;
            for (int j = 0; j < comp.getComponents().size(); ++j) {
                ComponentInfo info = comp.getComponents().get(j);
                if (!"com.kingdee.bos.ctrl.web.EditableColumn".equalsIgnoreCase(info.getClassType()) || info.getComponents().size() != 1) continue;
                ComponentInfo editor = info.getComponents().get(0);
                PropertyBindingCollection col = info.getPropertyBindings();
                int size = col.size();
                for (int k = 0; k < size; ++k) {
                    String field;
                    if (!"value".equalsIgnoreCase(col.get(k).getPropertyName()) || StringUtils.isEmpty((String)(field = col.get(k).getBingdingField())) || !(field = field.substring(field.lastIndexOf(".") + 1)).equalsIgnoreCase(editor.getName())) continue;
                    vld.addError("<" + editor.getName() + ">'s name is not allowed");
                }
            }
        }
        ValidateList list = super.validate();
        list.addList(vld.getValidateList());
        return list;
    }

    protected WebUIObjectInfo(boolean init) {
        super(init);
    }

    @Override
    public ComponentInfo getMainPanelComponent() {
        Iterator iter = this.getComponents().iterator();
        ComponentInfo panel = null;
        while (iter.hasNext()) {
            panel = (ComponentInfo)iter.next();
            if (panel.getParent() != null || !"com.kingdee.bos.ctrl.web.RootPane".equals(panel.getClassType())) continue;
            return panel;
        }
        return null;
    }

    public WebUIObjectInfo getParent() {
        return (WebUIObjectInfo)this.get(PARENT);
    }

    public void setParent(WebUIObjectInfo info) {
        this.put(PARENT, info);
    }

    public WebUIObjectInfo cloneOnlySelf() {
        WebUIObjectInfo info = null;
        try {
            info = (WebUIObjectInfo)this.getClass().newInstance();
            info.setName(this.getName());
            info.setPackage(this.getPackage());
            info.setDescription(this.getDescription());
            info.setParent(this.getParent());
            info.setParentFullName(this.getParentFullName());
            info.setPKField(this.getPKField());
            info.setRuleSet(this.getRuleSet());
            WebUIObjectInfo.copyExtendedProperties(this, info);
            info.setBizUnitPK(this.getBizUnitPK());
            info.setUserDefined(this.isUserDefined());
            info.setNameManager(this.nameManager);
        }
        catch (InstantiationException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return info;
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.WEBUIOBJECT;
    }

    public ScriptCollection getScripts() {
        Object obj = this.get(SCRIPTS);
        if (obj == null) {
            ScriptCollection collection = new ScriptCollection();
            this.put(SCRIPTS, collection);
            return collection;
        }
        return (ScriptCollection)obj;
    }

    public ScriptCollection getInheritedScripts() {
        ScriptCollection scripts = new ScriptCollection();
        ArrayList<WebUIObjectInfo> webUIObjects = new ArrayList<WebUIObjectInfo>();
        webUIObjects.add(this);
        WebUIObjectInfo parent = this;
        while ((parent = parent.getParent()) != null) {
            webUIObjects.add(parent);
        }
        for (int i = webUIObjects.size() - 1; i >= 0; --i) {
            WebUIObjectInfo webUIObjectInfo = (WebUIObjectInfo)webUIObjects.get(i);
            scripts.addObjectCollection(webUIObjectInfo.getScripts());
        }
        return scripts;
    }

    public WebMetaCollection getMetas() {
        Object obj = this.get(METAS);
        if (obj == null) {
            WebMetaCollection collection = new WebMetaCollection();
            this.put(METAS, collection);
            return collection;
        }
        return (WebMetaCollection)obj;
    }

    public WebMetaCollection getInheritedMetas() {
        WebMetaCollection metas = new WebMetaCollection();
        ArrayList<WebUIObjectInfo> webUIObjects = new ArrayList<WebUIObjectInfo>();
        webUIObjects.add(this);
        WebUIObjectInfo parent = this;
        while ((parent = parent.getParent()) != null) {
            webUIObjects.add(parent);
        }
        for (int i = webUIObjects.size() - 1; i >= 0; --i) {
            WebUIObjectInfo webUIObjectInfo = (WebUIObjectInfo)webUIObjects.get(i);
            metas.addObjectCollection(webUIObjectInfo.getMetas());
        }
        return metas;
    }

    public StyleSheetCollection getStyleSheets() {
        Object obj = this.get(STYLESHEETS);
        if (obj == null) {
            StyleSheetCollection collection = new StyleSheetCollection();
            this.put(STYLESHEETS, collection);
            return collection;
        }
        return (StyleSheetCollection)obj;
    }

    public StyleSheetCollection getInheritedStyleSheets() {
        StyleSheetCollection styleSheets = new StyleSheetCollection();
        ArrayList<WebUIObjectInfo> webUIObjects = new ArrayList<WebUIObjectInfo>();
        webUIObjects.add(this);
        WebUIObjectInfo parent = this;
        while ((parent = parent.getParent()) != null) {
            webUIObjects.add(parent);
        }
        for (int i = webUIObjects.size() - 1; i >= 0; --i) {
            WebUIObjectInfo webUIObjectInfo = (WebUIObjectInfo)webUIObjects.get(i);
            styleSheets.addObjectCollection(webUIObjectInfo.getStyleSheets());
        }
        return styleSheets;
    }

    public void setScripts(ScriptCollection scripts) {
        this.put(SCRIPTS, scripts);
    }

    public void setStyleSheets(StyleSheetCollection styleSheets) {
        this.put(STYLESHEETS, styleSheets);
    }

    public void setMetas(WebMetaCollection metas) {
        this.put(METAS, metas);
    }

    static {
        currentLocale = defaultLocale = ContextManager.getContext().getLocale();
    }
}

