/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.trace;

import com.kingdee.bos.orm.trace.InnerTraceCodeBuilder;
import com.kingdee.bos.orm.trace.TraceCodeBuildException;
import com.kingdee.bos.orm.trace.XMLHelper;
import com.kingdee.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;

public class TraceCodeBuilder {
    public static final String TRACECODESAVEROOTPATH = "./ormrpc_trace";
    public static final String TRACECODEDEFAULTPACKAGE = "mytrace";
    public static final String TRACEOBJECTSUFFIX = ".data";
    public static final String TRACEXMLOBJECTSUFFIX = ".xml";

    public static void build(String logFileName) throws IOException, TraceCodeBuildException {
        TraceCodeBuilder.build(logFileName, TRACECODESAVEROOTPATH);
    }

    public static void build(String logFileName, String outputDir) throws IOException, TraceCodeBuildException {
        String clsName = logFileName;
        clsName = logFileName.lastIndexOf(File.separatorChar) != -1 ? "Test" + logFileName.substring(logFileName.lastIndexOf(File.separatorChar) + 1, logFileName.lastIndexOf(46)).replace(' ', '_') : "Test" + logFileName.substring(0, logFileName.lastIndexOf(46)).replace(' ', '_');
        TraceCodeBuilder.build(logFileName, TRACECODEDEFAULTPACKAGE, clsName, outputDir);
    }

    public static void build(String logFileName, String pkgName, String clsName) throws IOException, TraceCodeBuildException {
        TraceCodeBuilder.build(logFileName, pkgName, clsName, TRACECODESAVEROOTPATH);
    }

    public static void build(String logFileName, String pkgName, String clsName, String outputDir) throws IOException, TraceCodeBuildException {
        TraceCodeBuilder.build(logFileName, pkgName, clsName, outputDir, 30);
    }

    public static void build(String logFileName, String pkgName, String clsName, String outputDir, int methodCount) throws IOException, TraceCodeBuildException {
        outputDir = outputDir + File.separatorChar + "src";
        HashMap traceObjs = new HashMap();
        String src = InnerTraceCodeBuilder.build(logFileName, pkgName, clsName, traceObjs, methodCount);
        TraceCodeBuilder.storeJavaSrc(outputDir, pkgName, clsName, src);
        TraceCodeBuilder.storeTraceObjects(outputDir, pkgName, clsName, traceObjs);
    }

    private static void storeJavaSrc(String outputDir, String pkgName, String clsName, String src) throws IOException {
        File srcFile = TraceCodeBuilder.getFile(outputDir, pkgName, clsName, ".java");
        OutputStreamWriter srcOs = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(srcFile)), "UTF-8");
        srcOs.write(src);
        srcOs.flush();
        srcOs.close();
    }

    private static void storeTraceObjects(String outputDir, String pkgName, String clsName, Map traceObjs) throws IOException {
        Iterator objIt = traceObjs.entrySet().iterator();
        Object key = null;
        Object value = null;
        HashMap<Object, Object> xmlObjs = new HashMap<Object, Object>();
        while (objIt.hasNext()) {
            Map.Entry entry = objIt.next();
            key = entry.getKey();
            value = entry.getValue();
            xmlObjs.put(key, value);
        }
        TraceCodeBuilder.storeXmlObjects(outputDir, pkgName, clsName, xmlObjs);
    }

    private static void storeXmlObjects(String outputDir, String pkgName, String clsName, Map xmlObjs) throws IOException {
        File dataFile = TraceCodeBuilder.getFile(outputDir, pkgName, clsName, TRACEXMLOBJECTSUFFIX);
        BufferedOutputStream dataOS = new BufferedOutputStream(new FileOutputStream(dataFile));
        XMLHelper.getInstance().storeObjects(xmlObjs, dataOS);
        ((OutputStream)dataOS).flush();
        ((OutputStream)dataOS).close();
    }

    private static File getFile(String outputDir, String pkgName, String clsName, String suffix) {
        File dataFile;
        File root = new File(outputDir);
        String fullClassName = clsName;
        if (!StringUtils.isEmpty((String)pkgName)) {
            fullClassName = pkgName + "." + clsName;
        }
        if (!(dataFile = new File(root, fullClassName.replace('.', File.separatorChar) + suffix)).getParentFile().exists()) {
            dataFile.getParentFile().mkdirs();
        }
        return dataFile;
    }

    private static JDOMFactory getJDOMFactory() {
        return new DefaultJDOMFactory();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: ");
            System.out.println("\tTraceCodeBuilder LogFileName SrcOutputDir");
            System.out.println("\tTraceCodeBuilder LogFileName PkgName ClassName SrcOutputDir");
            return;
        }
        if (args.length == 1) {
            TraceCodeBuilder.build(args[0]);
        } else if (args.length == 2) {
            TraceCodeBuilder.build(args[0], args[1]);
        } else if (args.length == 4) {
            TraceCodeBuilder.build(args[0], args[1], args[2], args[3]);
        }
    }
}

