/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.trace;

import com.kingdee.bos.orm.trace.XMLHelper;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TraceObjectLoader {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.orm.trace.TraceObjectLoader");
    private final Map cache = new HashMap();

    public TraceObjectLoader(Class clz) {
        this.load(clz);
    }

    public Object getObject(String objId) {
        return this.cache.get(objId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(Class clz) {
        InputStream objIs = clz.getClassLoader().getResourceAsStream(clz.getName().replace('.', '/') + ".data");
        InputStream xmlIs = clz.getClassLoader().getResourceAsStream(clz.getName().replace('.', '/') + ".xml");
        if (objIs == null && xmlIs == null) assert (false) : "Cannot load traceobject " + clz.getName();
        if (objIs != null) {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(objIs);
                String key = null;
                Object value = null;
                while (true) {
                    try {
                        key = (String)ois.readObject();
                    }
                    catch (Exception e) {
                        break;
                    }
                    value = ois.readObject();
                    this.cache.put(key, value);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                assert (false) : e.getMessage();
            }
            finally {
                try {
                    ois.close();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        if (xmlIs != null) {
            try {
                XMLHelper.getInstance().loadObjects(xmlIs, this.cache);
            }
            catch (Exception e) {
                logger.error((Object)e);
                assert (false) : e.getMessage();
            }
            finally {
                try {
                    xmlIs.close();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    public synchronized void clear() {
        this.cache.clear();
    }
}

