/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.trace.compatible;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.orm.trace.compatible.IProxyObject;
import com.kingdee.bos.orm.trace.compatible.ProxyObjectFactory;
import com.kingdee.bos.util.BOSObjectType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class CompatibleHelper {
    public static final String Compatible_Sys_PropertyName = "rpctrace.loader.compatibility";
    public static final String COMPATIBLE_IGNORE = "ignore";
    public static final String COMPATIBLE_AUTO = "auto";
    public static final String COMPATIBLE_FORCE = "force";
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.orm.trace.compatible.CompatibleHelper");
    private static List notEntityBOSTypeCache = new ArrayList();

    public static boolean onwerPropertyExistbyServer(BOSObjectType type, String name, String propertyType) throws BOSException {
        IProxyObject objectProxy = ProxyObjectFactory.getRemoteInstance();
        return objectProxy.onwerPropertyExist(type, name, propertyType);
    }

    public static boolean isEntity(BOSObjectType type) {
        BusinessObjectInfo bo = null;
        if (notEntityBOSTypeCache.contains(type)) {
            return false;
        }
        try {
            bo = MetaDataUtils.getBOFromCache(null, type);
        }
        catch (BOSException e) {
            logger.error((Object)"\u88c5\u8f7dEntity\u5143\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
        catch (MetaDataNotFoundException mdnfe) {
            logger.warn((Object)("BOSObjectType [" + type + "] \u6ca1\u6709BO\u5143\u6570\u636e\u5bf9\u5e94!"));
        }
        if (bo != null && bo instanceof EntityObjectInfo) {
            return true;
        }
        notEntityBOSTypeCache.add(type);
        return false;
    }

    public static int onwerPropertyExist(BOSObjectType type, String name, String propertyType) {
        BusinessObjectInfo bo = null;
        try {
            bo = MetaDataUtils.getBOFromCache(null, type);
        }
        catch (BOSException e) {
            logger.error((Object)"\u88c5\u8f7dEntity\u5143\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
        catch (MetaDataNotFoundException mdnfe) {
            logger.warn((Object)("BOSObjectType [" + type + "] \u6ca1\u6709BO\u5143\u6570\u636e\u5bf9\u5e94!"));
        }
        if (bo == null || !(bo instanceof EntityObjectInfo)) {
            return -1;
        }
        PropertyCollection properties = ((EntityObjectInfo)bo).getInheritedNoDuplicatedPropertiesRuntime();
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            OwnPropertyInfo ownProperty;
            PropertyInfo property = (PropertyInfo)it.next();
            if (!property.getName().equals(name)) continue;
            if (property instanceof OwnPropertyInfo && (ownProperty = (OwnPropertyInfo)property).getDataType().getName().equals(propertyType)) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public static boolean hasNewProperty(BOSObjectType bosType, Element entityElem) {
        BusinessObjectInfo bo = null;
        try {
            bo = MetaDataUtils.getBOFromCache(null, bosType);
        }
        catch (BOSException e) {
            logger.error((Object)"\u88c5\u8f7dEntity\u5143\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
        if (bo == null || !(bo instanceof EntityObjectInfo)) {
            return false;
        }
        PropertyCollection properties = ((EntityObjectInfo)bo).getInheritedNoDuplicatedPropertiesRuntime();
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            PropertyInfo property = (PropertyInfo)it.next();
            Iterator entityIt = entityElem.getChildren().iterator();
            Element propElem = null;
            boolean has = false;
            while (entityIt.hasNext()) {
                propElem = (Element)entityIt.next();
                String name = propElem.getAttributeValue("name");
                if (!property.getName().equals(name)) continue;
                has = true;
                break;
            }
            if (has) continue;
            logger.info((Object)("\u53d1\u73b0\u65b0\u589e\u5c5e\u6027:" + property.getName()));
            return true;
        }
        return false;
    }

    public static boolean dataExistByPK(IObjectValue ov) throws BOSException {
        IProxyObject objectProxy = ProxyObjectFactory.getRemoteInstance();
        String pkField = ov.getPKField();
        ObjectUuidPK uuidPk = new ObjectUuidPK(ov.getBOSUuid(pkField));
        return objectProxy.exists(ov.getBOSType(), uuidPk);
    }

    public static IObjectValue randomSelectRecored(BOSObjectType type) throws BOSException {
        IProxyObject objectProxy = ProxyObjectFactory.getRemoteInstance();
        IObjectPK[] pks = objectProxy.getPKList(type);
        return objectProxy.getValue(type, pks[0]);
    }

    public static IObjectValue refreshRecored(IObjectValue ov) throws BOSException {
        IProxyObject objectProxy = ProxyObjectFactory.getRemoteInstance();
        String pkField = ov.getPKField();
        ObjectUuidPK uuidPk = new ObjectUuidPK(ov.getBOSUuid(pkField));
        if (objectProxy.exists(ov.getBOSType(), uuidPk)) {
            logger.info((Object)"\u627e\u5230\u6570\u636e\u5e93\u4e2d\u7684\u8bb0\u5f55,\u5237\u65b0\u8bb0\u5f55\uff01");
            return objectProxy.getValue(ov.getBOSType(), uuidPk);
        }
        IObjectPK[] pks = objectProxy.getPKList(ov.getBOSType());
        if (pks.length > 0) {
            logger.info((Object)"\u6ca1\u6709\u627e\u5230\u6570\u636e\u5e93\u4e2d\u8be5\u7684\u8bb0\u5f55,\u968f\u673a\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01");
            return objectProxy.getValue(ov.getBOSType(), pks[0]);
        }
        logger.warn((Object)"\u6570\u636e\u5e93\u4e2d\u6ca1\u6709\u4efb\u4f55\u8bb0\u5f55,\u5ffd\u7565\uff01");
        return ov;
    }
}

