/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service;

import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;

public class ORMServiceLocation {
    public static final String CONFIG_ITEM_SERVICE = "ORMServiceLocation";
    public static final String CONFIG_KEY_SERVERURL = "serviceURL";
    private final String serviceURL;

    public ORMServiceLocation(String serviceConfigItem) {
        String item = "ORMServiceLocation/" + serviceConfigItem;
        ConfigurationItem configItem = Configuration.getInstance().getConfigItemByPath(item);
        if (configItem == null) {
            this.serviceURL = null;
        } else {
            String url = configItem.getProperty(CONFIG_KEY_SERVERURL);
            if (url != null) {
                url = url.trim();
            }
            this.serviceURL = url;
        }
    }

    public boolean isLocal() {
        return this.serviceURL == null || this.serviceURL.length() == 0;
    }

    public String getServiceURL() {
        if (this.isLocal()) {
            return "tcp://127.0.0.1";
        }
        return this.serviceURL;
    }
}

