/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service;

import com.kingdee.bos.rpc.ThreadListener;
import com.kingdee.bos.rpc.ThreadListenerManager;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.IServiceAdapterFilter;
import com.kingdee.bos.service.IServiceStateListener;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public final class ServiceStateManager {
    private static final ThreadLocal<ServiceStateManager> stateContainer = new ThreadLocal();
    private final ServiceStateStack stack = new ServiceStateStack();
    private ServiceState nextCallServiceState = null;
    private static final List<IServiceStateListener> listeners;

    private ServiceStateManager() {
    }

    public static ServiceStateManager getInstance() {
        ServiceStateManager o = stateContainer.get();
        if (o == null) {
            ServiceStateManager manager = new ServiceStateManager();
            stateContainer.set(manager);
            return manager;
        }
        return o;
    }

    public IServiceAdapterFilter getServiceAdapterFilter() {
        final ServiceState state = this.getServiceState();
        return new IServiceAdapterFilter(){

            @Override
            public boolean accept(IServiceAdapter adapter) {
                assert (adapter != null);
                String tmpName = adapter.getName();
                if (state.disableSet.contains(tmpName) || state.disableSet.contains("ALL_SERVICE")) {
                    return false;
                }
                return state.specialSet.contains(tmpName) || state.specialSet.contains("ALL_SERVICE");
            }
        };
    }

    public void reSetStateSnatpot(LoopSnatpot ls) {
        this.reSetServiceState(ls);
        ls.snatpotStack = null;
        ls.snatpotNextCallServiceState = null;
    }

    public void reSetServiceState(LoopSnatpot ls) {
        if (ls.snatpotStack == null) {
            ls.snatpotStack = new ArrayList();
            while (!this.stack.isEmpty()) {
                ls.snatpotStack.add(this.stack.pop());
            }
            if (this.nextCallServiceState != null) {
                ls.snatpotNextCallServiceState = this.nextCallServiceState;
            }
        } else {
            this.stack.clear();
            for (int index = ls.snatpotStack.size() - 1; index >= 0; --index) {
                this.stack.push((ServiceState)ls.snatpotStack.get(index));
            }
            this.nextCallServiceState = ls.snatpotNextCallServiceState;
        }
    }

    public void setServiceState(ServiceState state) {
        if (this.stack.isEmpty()) {
            this.stack.push(this.getFirstCallServiceState());
            this.nextCallServiceState = null;
        } else {
            if (this.nextCallServiceState != null) {
                state.combine(this.nextCallServiceState);
                this.nextCallServiceState = null;
            }
            state.id = this.stack.peek().id;
            state.level = this.stack.peek().level + 1;
            this.stack.push(state);
        }
        if (ServiceStateManager.isHaveListeners()) {
            IServiceStateListener[] listeners = ServiceStateManager.getStateListeners();
            assert (listeners != null);
            int len = listeners.length;
            for (int i = 0; i < len; ++i) {
                listeners[i].pop(state);
            }
        }
    }

    public void disableNextCallServices() {
        this.nextCallServiceState = new ServiceState();
        this.nextCallServiceState.disableServices();
    }

    public void disableNextCallService(String serviceName) {
        this.nextCallServiceState = new ServiceState();
        this.nextCallServiceState.disableSpecialService(serviceName);
    }

    public void enableNextCallService(String serviceName) {
        this.nextCallServiceState = new ServiceState();
        this.nextCallServiceState.enableSpecialService(serviceName);
    }

    public void enableNextCallServices() {
        this.nextCallServiceState = new ServiceState();
        this.nextCallServiceState.enableServices();
    }

    public void finishCall() {
        IServiceStateListener[] listeners;
        ServiceState state = null;
        if (this.stack.isEmpty()) {
            return;
        }
        state = this.stack.pop();
        if (ServiceStateManager.isHaveListeners() && (listeners = ServiceStateManager.getStateListeners()) != null) {
            int len = listeners.length;
            for (int i = 0; i < len; ++i) {
                listeners[i].pop(state);
            }
        }
    }

    static boolean isHaveListeners() {
        return listeners.size() > 0;
    }

    public static void addStateListener(IServiceStateListener listener) {
        listeners.add(listener);
    }

    public static void removeStateListener(IServiceStateListener listener) {
        listeners.remove(listener);
    }

    public static IServiceStateListener[] getStateListeners() {
        return listeners.toArray(new IServiceStateListener[0]);
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public ServiceState getServiceState() {
        assert (!this.stack.isEmpty());
        return this.stack.peek();
    }

    private ServiceState getFirstCallServiceState() {
        ServiceState state = new ServiceState();
        state.id = Uuid.create();
        state.level = 1;
        state.enableServices();
        return state;
    }

    static {
        ThreadListenerManager.addListener((ThreadListener)new ThreadListener(){

            public void threadStarted(Thread thread) {
            }

            public void threadFinished(Thread thread) {
                stateContainer.set(null);
            }

            public void threadRecycled(Thread thread) {
            }

            public void threadRemoved(Thread thread) {
            }
        });
        listeners = new ArrayList<IServiceStateListener>(3);
    }

    public class LoopSnatpot {
        private List<ServiceState> snatpotStack = null;
        private ServiceState snatpotNextCallServiceState = null;

        public List<ServiceState> getSnatpotStack() {
            return this.snatpotStack;
        }

        public void setSnatpotStack(List<ServiceState> snatpotStack) {
            this.snatpotStack = snatpotStack;
        }

        public ServiceState getSnatpotNextCallServiceState() {
            return this.snatpotNextCallServiceState;
        }

        public void setSnatpotNextCallServiceState(ServiceState snatpotNextCallServiceState) {
            this.snatpotNextCallServiceState = snatpotNextCallServiceState;
        }
    }

    private static class ServiceStateStack {
        private final Stack<ServiceState> stack = new Stack();

        private ServiceStateStack() {
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }

        public void clear() {
            this.stack.clear();
        }

        public void push(ServiceState state) {
            this.stack.push(state);
        }

        public ServiceState pop() {
            return this.stack.pop();
        }

        public ServiceState peek() {
            return this.stack.peek();
        }
    }

    public static class ServiceState {
        public static final String ALL_SERVICE = "ALL_SERVICE";
        protected Uuid id;
        protected int level = 0;
        protected final Set<String> disableSet = new HashSet<String>(4);
        protected final Set<String> specialSet = new HashSet<String>(4);

        public void disableServices() {
            this.disableSet.add(ALL_SERVICE);
        }

        public void disableSpecialService(String serviceName) {
            this.disableSet.add(serviceName);
        }

        public void enableServices() {
            this.specialSet.add(ALL_SERVICE);
        }

        public void enableSpecialService(String serviceName) {
            this.specialSet.add(serviceName);
        }

        void combine(ServiceState state) {
            this.disableSet.addAll(state.disableSet);
            this.specialSet.addAll(state.specialSet);
        }

        public Uuid getID() {
            return this.id;
        }

        public int getLevel() {
            return this.level;
        }

        public String toString() {
            return super.toString() + "ID" + this.id + " Level" + this.level + " Disable: " + this.disableSet + " Special: " + this.specialSet;
        }
    }
}

