/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.binding;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDReferenceFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.PKMappingUtil;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.LogServiceItem;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.service.log.define.LogBizRefInfo;
import com.kingdee.bos.service.log.define.LogInfo;
import com.kingdee.bos.service.log.define.LogItemInfo;
import com.kingdee.bos.service.log.define.MethodRefInfo;
import com.kingdee.bos.service.permission.metadata.BizPropertyCollection;
import com.kingdee.bos.service.permission.metadata.BizPropertyInfo;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConcreteServiceBinder
implements IServiceBinder {
    private static Logger logger = Logger.getLogger(ConcreteServiceBinder.class);
    private static final Map<String, ConcreteServiceBinder> binderCache = new HashMap<String, ConcreteServiceBinder>(4);
    private final Map<BOSObjectType, Map<Object, Map<Object, BindItemList>>> bindCache = new HashMap<BOSObjectType, Map<Object, Map<Object, BindItemList>>>(4);
    private final BindItemManager manager = new BindItemManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IServiceBinder getServiceBinder(Context ctx) {
        String ais = ConfigMDUtil.getAIS(ctx);
        ConcreteServiceBinder binder = binderCache.get(ais);
        if (binder == null) {
            Map<String, ConcreteServiceBinder> map = binderCache;
            synchronized (map) {
                if (!binderCache.containsKey(ais)) {
                    long t = System.currentTimeMillis();
                    binder = new ConcreteServiceBinder();
                    binderCache.put(ais, binder);
                    logger.info((Object)("+++ create ConcreteServiceBinder(" + ais + ") spent:" + (System.currentTimeMillis() - t)));
                } else {
                    binder = binderCache.get(ais);
                }
            }
        }
        binder.reload();
        return binder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearServiceBinder(Context ctx) {
        Map<String, ConcreteServiceBinder> map = binderCache;
        synchronized (map) {
            ConcreteServiceBinder binder = binderCache.get(ConfigMDUtil.getAIS(ctx));
            if (binder != null) {
                binder.clear();
            }
        }
    }

    private ConcreteServiceBinder() {
        Map<String, String> entityPKMapping = PKMappingUtil.createEntityPKMapping();
        Map<String, String> facadePKMapping = PKMappingUtil.createFacadePKMapping();
        this.loadLogBindingInfo(entityPKMapping, facadePKMapping, MDReferenceFactory.getLog());
        MDReferenceFactory.releaseLog();
        this.loadPermissionBindingInfo(entityPKMapping, facadePKMapping, MDReferenceFactory.getPermission());
        MDReferenceFactory.releasePermission();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reload() {
        if (this.manager.needReload) {
            Map<BOSObjectType, Map<Object, Map<Object, BindItemList>>> map = this.bindCache;
            synchronized (map) {
                if (!this.manager.needReload) {
                    return;
                }
                this.manager.needReload = false;
                Map<String, String> entityPKMapping = PKMappingUtil.createEntityPKMapping();
                Map<String, String> facadePKMapping = PKMappingUtil.createFacadePKMapping();
                this.loadLogBindingInfo(entityPKMapping, facadePKMapping, MDReferenceFactory.getConfigureLog());
                MDReferenceFactory.releaseLog();
                this.loadPermissionBindingInfo(entityPKMapping, facadePKMapping, MDReferenceFactory.getConfigurePermission());
                MDReferenceFactory.releasePermission();
            }
        }
    }

    void clear() {
        this.manager.clear();
    }

    private void loadLogBindingInfo(Map<String, String> entityPKMapping, Map<String, String> facadePKMapping, LogInfo logInfo) {
        if (logInfo == null) {
            return;
        }
        Iterator it = logInfo.getLogItems().iterator();
        while (it.hasNext()) {
            LogItemInfo logItem = (LogItemInfo)it.next();
            Iterator bizRefIt = logItem.getLogBizRefCollection().iterator();
            while (bizRefIt.hasNext()) {
                LogBizRefInfo log = (LogBizRefInfo)bizRefIt.next();
                MetaDataInfo metaData = log.getMetadataRef();
                String metaDataType = metaData.getMetaDataType();
                if (metaData.getName() == null) {
                    logger.error((Object)("Log metadata define error:" + logItem.getName() + logItem.getGroup()));
                }
                Map<Object, BindItemList> boCache = null;
                if (!StringUtils.isEmpty((String)metaDataType)) {
                    String bosType = null;
                    if (metaDataType.equals(MetaDataTypeList.ENTITY.toString())) {
                        bosType = entityPKMapping.get(metaData.getFullName());
                        if (bosType != null) {
                            boCache = this.getEntityOrFacdeCache(MetaDataTypeList.ENTITY, BOSObjectType.create((String)bosType));
                        }
                    } else if (metaDataType.equals(MetaDataTypeList.FACADE.toString()) && (bosType = facadePKMapping.get(metaData.getFullName())) != null) {
                        boCache = this.getEntityOrFacdeCache(MetaDataTypeList.FACADE, BOSObjectType.create((String)bosType));
                    }
                }
                if (boCache == null) continue;
                Iterator methodIt = log.getMethodRefCollection().iterator();
                while (methodIt.hasNext()) {
                    MethodRefInfo method = (MethodRefInfo)methodIt.next();
                    this.getServiceBindings(boCache, (IMetaDataPK)MetaDataPK.create(method.getInnerID())).add(new ServiceBindItem(1, logItem.getName(), LogServiceItem.createInstance(method)), logItem.isUserDefined());
                }
            }
        }
    }

    private void loadPermissionBindingInfo(Map<String, String> entityPKMapping, Map<String, String> facadePKMapping, PermissionInfo permissionInfo) {
        if (permissionInfo == null) {
            return;
        }
        Iterator it = permissionInfo.getPermissionItems().iterator();
        while (it.hasNext()) {
            PermissionItemInfo pmItem = (PermissionItemInfo)it.next();
            Iterator bizIt = pmItem.getBizRefs().iterator();
            while (bizIt.hasNext()) {
                String bosType;
                String metaDataType;
                BizRefInfo bizRef = (BizRefInfo)bizIt.next();
                MetaDataInfo metaData = bizRef.getBizMetadataInfo();
                if (metaData == null || StringUtils.isEmpty((String)(metaDataType = metaData.getMetaDataType()))) continue;
                Map<Object, BindItemList> boCache = null;
                boolean isIteProps = true;
                if (metaDataType.equals(MetaDataTypeList.ENTITY.toString())) {
                    bosType = entityPKMapping.get(metaData.getFullName());
                    if (bosType != null) {
                        boCache = this.getEntityOrFacdeCache(MetaDataTypeList.ENTITY, BOSObjectType.create((String)bosType));
                    }
                } else if (metaDataType.equals(MetaDataTypeList.FACADE.toString())) {
                    bosType = facadePKMapping.get(metaData.getFullName());
                    if (bosType != null) {
                        boCache = this.getEntityOrFacdeCache(MetaDataTypeList.FACADE, BOSObjectType.create((String)bosType));
                    }
                } else if (metaDataType.equals(MetaDataTypeList.UIOBJECT.toString())) {
                    boCache = this.getUIOrFunctionoCache(MetaDataTypeList.UIOBJECT, MetaDataPK.create(metaData.getPackage(), metaData.getName()));
                } else if (metaDataType.equals(MetaDataTypeList.WEBUIOBJECT.toString())) {
                    boCache = this.getUIOrFunctionoCache(MetaDataTypeList.WEBUIOBJECT, MetaDataPK.create(metaData.getPackage(), metaData.getName()));
                } else if (metaDataType.equals(MetaDataTypeList.BASEQUERY.toString())) {
                    boCache = this.getQueryCache(MetaDataTypeList.BASEQUERY);
                    isIteProps = false;
                } else if (metaDataType.equals(MetaDataTypeList.WEBPAGEOBJECT.toString())) {
                    boCache = this.getUIOrFunctionoCache(MetaDataTypeList.WEBPAGEOBJECT, MetaDataPK.create(metaData.getPackage(), metaData.getName()));
                }
                if (boCache == null) continue;
                if (isIteProps) {
                    BizPropertyCollection bizProps = bizRef.getBizPropertys();
                    Iterator propIt = bizProps.iterator();
                    while (propIt.hasNext()) {
                        BizPropertyInfo bizPropInfo = (BizPropertyInfo)propIt.next();
                        String prop = bizPropInfo.getProperty();
                        if (prop == null) continue;
                        this.getServiceBindings(boCache, (IMetaDataPK)MetaDataPK.create(prop.intern())).add(new ServiceBindItem(0, pmItem.getName(), null), pmItem.isUserDefined());
                    }
                    continue;
                }
                this.getServiceBindings(boCache, (IMetaDataPK)MetaDataPK.create(metaData.getPackage(), metaData.getName())).add(new ServiceBindItem(0, pmItem.getName(), null), pmItem.isUserDefined());
            }
        }
    }

    private Map<Object, BindItemList> getEntityOrFacdeCache(BOSObjectType metaType, BOSObjectType boType) {
        return this.getConcreteCache(metaType, boType);
    }

    private Map<Object, BindItemList> getUIOrFunctionoCache(BOSObjectType metaType, IMetaDataPK pk) {
        return this.getConcreteCache(metaType, pk);
    }

    private Map<Object, BindItemList> getQueryCache(BOSObjectType metaType) {
        return this.getConcreteCache(metaType, metaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, BindItemList> getConcreteCache(BOSObjectType metaType, Object key) {
        Map<Object, Map<Object, BindItemList>> cache = this.getMetaDataCache(metaType);
        Map<Object, BindItemList> objCache = cache.get(key);
        if (objCache == null) {
            Map<Object, Map<Object, BindItemList>> map = cache;
            synchronized (map) {
                if (cache.containsKey(key)) {
                    objCache = cache.get(key);
                } else {
                    objCache = new HashMap<Object, BindItemList>();
                    if (key instanceof IMetaDataPK) {
                        key = MetaDataPK.create((IMetaDataPK)key);
                    }
                    cache.put(key, objCache);
                }
            }
        }
        return objCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, Map<Object, BindItemList>> getMetaDataCache(BOSObjectType metaType) {
        Map<Object, Map<Object, BindItemList>> objCache = this.bindCache.get(metaType);
        if (objCache == null) {
            Map<BOSObjectType, Map<Object, Map<Object, BindItemList>>> map = this.bindCache;
            synchronized (map) {
                if (this.bindCache.containsKey(metaType)) {
                    objCache = this.bindCache.get(metaType);
                } else {
                    objCache = new HashMap<Object, Map<Object, BindItemList>>();
                    this.bindCache.put(metaType, objCache);
                }
            }
        }
        return objCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BindItemList getServiceBindings(Map<Object, BindItemList> cache, IMetaDataPK pk) {
        BindItemList list = cache.get(pk);
        if (list == null) {
            Map<Object, BindItemList> map = cache;
            synchronized (map) {
                if (cache.containsKey(pk)) {
                    list = cache.get(pk);
                } else {
                    pk = MetaDataPK.create(pk);
                    list = new BindItemList();
                    this.manager.register(list);
                    cache.put(pk, list);
                }
            }
        }
        return list;
    }

    @Override
    public ServiceBindItem[] getServiceBindings(BOSObjectType metaType, BOSObjectType boType, IMetaDataPK methodPK) {
        return this.getServiceBindings(this.getEntityOrFacdeCache(metaType, boType), methodPK).toArray();
    }

    @Override
    public ServiceBindItem[] getServiceBindings(BOSObjectType metaType, IMetaDataPK boPK, IMetaDataPK methodPK) {
        return this.getServiceBindings(this.getUIOrFunctionoCache(metaType, boPK), methodPK).toArray();
    }

    @Override
    public ServiceBindItem[] getServiceBindings(BOSObjectType metaType, IMetaDataPK boPK) {
        return this.getServiceBindings(this.getQueryCache(metaType), boPK).toArray();
    }

    static class BindItemManager {
        private final List<BindItemList> lists = new ArrayList<BindItemList>(20);
        volatile boolean needReload = false;

        BindItemManager() {
        }

        synchronized void register(BindItemList l) {
            this.lists.add(l);
        }

        synchronized void clear() {
            for (BindItemList l : this.lists) {
                l.clear();
            }
            this.needReload = true;
        }
    }

    static class BindItemList {
        final List<ServiceBindItem> origin = new ArrayList<ServiceBindItem>(2);
        final List<ServiceBindItem> configure = new ArrayList<ServiceBindItem>(2);
        private volatile ServiceBindItem[] array;

        BindItemList() {
        }

        void add(ServiceBindItem item, boolean userDefined) {
            if (userDefined) {
                this.configure.add(item);
            } else {
                this.origin.add(item);
            }
        }

        ServiceBindItem[] toArray() {
            if (this.array == null) {
                if (this.origin.size() == 0 && this.configure.size() == 0) {
                    this.array = new ServiceBindItem[0];
                } else {
                    ServiceBindItem[] orr = this.origin.toArray(new ServiceBindItem[0]);
                    ServiceBindItem[] crr = this.configure.toArray(new ServiceBindItem[0]);
                    ServiceBindItem[] arr = new ServiceBindItem[orr.length + crr.length];
                    System.arraycopy(orr, 0, arr, 0, orr.length);
                    System.arraycopy(crr, 0, arr, orr.length, crr.length);
                    this.array = arr;
                }
            }
            return this.array;
        }

        void clear() {
            this.configure.clear();
            this.array = null;
        }
    }
}

