/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.log.define;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.management.DataSource;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionCtrl;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.log.define.LogInfo;
import com.kingdee.bos.service.log.define.LogItemInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DeployManagement {
    static Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.log.define.DeployManagement");
    private static final String ITEM_ALIAS = "FAlias";
    private static final String ITEM_DESCRIPTION = "FDescription";
    private static final String ITEM_GROUP = "FGroup";
    private static final int BASE_ITEM_NUM = 4;
    private static final int VAR_ITEM_NUM = 3;

    public static void deploy(LogInfo log, DeployOptionInfo option, Context ctx) throws BOSException {
        if (log == null) {
            throw new BOSException("\u53c2\u6570\u9519\u8befLogInfo\u4e3anull");
        }
        Connection cn = null;
        try {
            DataSource ds = new DataSource(option.getTargetDBMS());
            cn = ds.getConnection();
            boolean isOverride = option.isOverrideDeployFile();
            DeployManagement.deployDB(cn, log, isOverride, ctx);
        }
        catch (Exception e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
    }

    public static void deployDB(Connection cn, LogInfo log, boolean isOver, Context ctx) throws BOSException {
        try {
            if (isOver) {
                String sql = "DELETE FROM T_LOG_LogItem";
                PreparedStatement stmt = cn.prepareStatement(sql);
                stmt.execute();
            }
            logger.debug((Object)("size=" + log.getLogItems().size()));
            LogItemInfo item = null;
            for (int i = 0; i < log.getLogItems().size(); ++i) {
                item = log.getLogItems().get(i);
                DeployManagement.validateLogItem(item);
                logger.debug((Object)item);
                String sql = "SELECT FLogItemID FROM T_LOG_LogItem WHERE FLogItemID=?";
                logger.debug((Object)("select sql=" + sql));
                PreparedStatement stmt = cn.prepareStatement(sql);
                String oldID = item.getInnerID();
                stmt.setString(1, oldID);
                ResultSet rs = stmt.executeQuery();
                Object opreateSql = null;
                if (rs.next()) {
                    DeployManagement.createUpdateSQL(cn, item, oldID, ctx);
                } else {
                    DeployManagement.createInsertSQL(cn, item, ctx);
                }
                SQLUtils.cleanup((Statement)stmt);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static LanguageCollection getLanguages(Context ctx) throws BOSException {
        SolutionCtrl ctrl = new SolutionCtrl(ctx);
        SolutionInfo soluInfo = ctrl.getValue();
        LanguageCollection langs = soluInfo.getLanguages();
        return langs;
    }

    private static void createUpdateSQL(Connection cn, LogItemInfo logItem, String oldID, Context ctx) throws BOSException {
        LanguageCollection langCol = DeployManagement.getLanguages(ctx);
        LanguageInfo defaultLang = DeployManagement.getDefaultLanguage(ctx);
        logItem.setDefaultLocale(defaultLang.getOriginalLocale());
        String sql = "UPDATE T_LOG_LogItem SET FLogItemID=?, FName=?, FType=?, FLevel=?, ";
        for (int i = langCol.size() - 1; i >= 0; --i) {
            LanguageInfo lan = langCol.get(i);
            String postFix = lan.getPostfix();
            String aliasItem = "FAlias_" + postFix;
            sql = sql + aliasItem;
            sql = sql + "=?, ";
            String descItem = "FDescription_" + postFix;
            sql = sql + descItem;
            sql = sql + "=?, ";
            String groupItem = "FGroup_" + postFix;
            sql = sql + groupItem;
            sql = sql + "=?";
            if (i == 0) continue;
            sql = sql + ", ";
        }
        sql = sql + " WHERE FLogItemID=?";
        logger.info((Object)sql);
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            stmt.setString(1, logItem.getInnerID());
            stmt.setString(2, logItem.getName());
            stmt.setInt(3, logItem.getType());
            stmt.setInt(4, logItem.getLevel());
            int index = 1;
            for (int i = langCol.size() - 1; i >= 0; --i) {
                LanguageInfo lan = langCol.get(i);
                String postFix = lan.getPostfix();
                stmt.setString(4 + index, logItem.getAlias(BOSLocaleUtil.getLocale(postFix)));
                stmt.setString(4 + ++index, logItem.getDescription(BOSLocaleUtil.getLocale(postFix)));
                stmt.setString(4 + ++index, logItem.getGroup(BOSLocaleUtil.getLocale(postFix)));
                ++index;
            }
            stmt.setString(4 + 3 * langCol.size() + 1, oldID);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    private static void createInsertSQL(Connection cn, LogItemInfo logItem, Context ctx) throws BOSException {
        LanguageCollection langCol = DeployManagement.getLanguages(ctx);
        LanguageInfo defaultLang = DeployManagement.getDefaultLanguage(ctx);
        logItem.setDefaultLocale(defaultLang.getOriginalLocale());
        String sql = "INSERT INTO T_LOG_LogItem(FLogItemID, FName, FType, FLevel,";
        for (int i = langCol.size() - 1; i >= 0; --i) {
            LanguageInfo lan = langCol.get(i);
            String postFix = lan.getPostfix();
            String aliasItem = "FAlias_" + postFix;
            sql = sql + aliasItem;
            sql = sql + ", ";
            String descItem = "FDescription_" + postFix;
            sql = sql + descItem;
            sql = sql + ", ";
            String groupItem = "FGroup_" + postFix;
            sql = sql + groupItem;
            if (i == 0) continue;
            sql = sql + ", ";
        }
        sql = sql + " ) VALUES(";
        int itemNum = 4 + 3 * langCol.size();
        for (int i = 0; i < itemNum; ++i) {
            sql = sql + "?";
            if (i == itemNum - 1) continue;
            sql = sql + ", ";
        }
        sql = sql + ")";
        logger.info((Object)sql);
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            stmt.setString(1, logItem.getInnerID());
            stmt.setString(2, logItem.getName());
            stmt.setInt(3, logItem.getType());
            stmt.setInt(4, logItem.getLevel());
            int index = 1;
            for (int i = langCol.size() - 1; i >= 0; --i) {
                LanguageInfo lan = langCol.get(i);
                String postFix = lan.getPostfix();
                stmt.setString(4 + index, logItem.getAlias(BOSLocaleUtil.getLocale(postFix)));
                stmt.setString(4 + ++index, logItem.getDescription(BOSLocaleUtil.getLocale(postFix)));
                stmt.setString(4 + ++index, logItem.getGroup(BOSLocaleUtil.getLocale(postFix)));
                ++index;
            }
            stmt.execute();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    private static void validateLogItem(LogItemInfo logItem) throws BOSException {
        if (logItem == null) {
            throw new BOSException("LogItemInfo is null");
        }
        if (logItem.getName() == null) {
            throw new BOSException("The Name of a LogItemInfo is null");
        }
        DeployManagement.validateType(logItem.getName(), logItem.getType());
        DeployManagement.validateLevel(logItem.getName(), logItem.getLevel());
    }

    private static void validateType(String logItemName, int type) throws BOSException {
        if (type != 1 && type != 2 && type != 4 && type != 512) {
            throw new BOSException("\u65e5\u5fd7\u9879" + logItemName + "\u7684type\u4e0d\u7b26\u89c4\u683c");
        }
    }

    private static void validateLevel(String logItemName, int level) throws BOSException {
        if (level != 64 && level != 256 && level != 128) {
            throw new BOSException("\u65e5\u5fd7\u9879" + logItemName + "\u7684level\u4e0d\u7b26\u89c4\u683c");
        }
    }

    private static LanguageInfo getDefaultLanguage(Context ctx) throws BOSException {
        SolutionCtrl ctrl = new SolutionCtrl(ctx);
        SolutionInfo soluInfo = ctrl.getValue();
        return soluInfo.getDefaultLanguage();
    }
}

