/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.log.define;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.service.log.define.LogItemCollection;
import com.kingdee.bos.service.log.define.LogItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.io.Serializable;
import java.util.HashSet;

public class LogInfo
extends AbstractMetaDataValue
implements Serializable {
    public LogInfo() {
        this.put("items", new LogItemCollection());
    }

    protected LogInfo(boolean init) {
        super(init);
        this.put("items", new LogItemCollection());
    }

    public LogItemCollection getLogItems() {
        return (LogItemCollection)this.get("items");
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.LOG;
    }

    @Override
    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        LogItemCollection logItemCol = this.getLogItems();
        int length = logItemCol.size();
        HashSet<String> nameSet = new HashSet<String>();
        HashSet<String> innerIDSet = new HashSet<String>();
        for (int i = 0; i < length; ++i) {
            LogItemInfo item = logItemCol.get(i);
            String name = item.getName();
            String innerID = item.getInnerID();
            if (innerIDSet.contains(innerID)) {
                vld.addError("Duplicated logItem innerID: " + innerID);
            } else {
                innerIDSet.add(innerID);
            }
            if (nameSet.contains(name)) {
                vld.addError("Duplicated logItem name: " + name);
            } else {
                nameSet.add(name);
            }
            vld.addValidateList(logItemCol.get(i).validate());
        }
        return vld.getValidateList();
    }
}

