/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.permission;

import com.kingdee.bos.service.permission.PermissionType;
import com.kingdee.bos.service.permission.metadata.DependenceInfo;
import com.kingdee.bos.service.permission.metadata.EntityObjectRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.service.permission.metadata.RefPermissionItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PermissionUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.permission.PermissionUtils");

    public static void processPermission(PermissionInfo perm) {
        if (perm == null) {
            return;
        }
        int n = perm.getPermissionItems().size();
        for (int i = 0; i < n; ++i) {
            PermissionItemInfo permItem = perm.getPermissionItems().get(i);
            if (permItem == null) continue;
            if (StringUtils.isEmpty((String)permItem.getInnerID())) {
                permItem.setInnerID(BOSUuid.create((String)"PERMITEM").toString());
            }
            if (!StringUtils.isEmpty((String)permItem.getGroupName())) continue;
            permItem.setGroupName(permItem.getGroup());
        }
    }

    private static void createMap(PermissionInfo pmInfo, HashMap m_map) {
        if (m_map == null || pmInfo == null) {
            logger.error((Object)"createMap parameter null error.");
            return;
        }
        PermissionItemInfo item = null;
        for (int i = 0; i < pmInfo.getPermissionItems().size(); ++i) {
            PermissionItemCollection items;
            item = pmInfo.getPermissionItems().get(i);
            if (item == null || item.getEntityObjectMetadataRef() == null || item.getEntityObjectMetadataRef().getEntityMetaInfo() == null) continue;
            EntityObjectRefInfo entityRef = item.getEntityObjectMetadataRef();
            String key = entityRef.getEntityMetaInfo().getPackage() + "." + entityRef.getEntityMetaInfo().getName();
            if (m_map.containsKey(key = key + item.getGroupName())) {
                items = (PermissionItemCollection)m_map.get(key);
                if (items == null) {
                    items = new PermissionItemCollection();
                }
                items.add(item);
                continue;
            }
            items = new PermissionItemCollection();
            items.add(item);
            m_map.put(key, items);
        }
    }

    public static void createDependence(PermissionInfo pmInfo) {
        HashMap m_map = new HashMap();
        if (m_map == null || pmInfo == null) {
            logger.error((Object)"createDependence parameter null error.");
            return;
        }
        PermissionUtils.createMap(pmInfo, m_map);
        PermissionItemCollection items = null;
        for (Map.Entry entry : m_map.entrySet()) {
            items = (PermissionItemCollection)entry.getValue();
            if (items == null) continue;
            PermissionUtils.createDependenceItem(pmInfo, items, m_map);
        }
    }

    private static void createDependenceItem(PermissionInfo pmInfo, PermissionItemCollection items, HashMap m_map) {
        if (m_map == null || pmInfo == null || items == null) {
            logger.error((Object)"createDependenceItem parameter null error.");
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            RefPermissionItemInfo refPerm;
            DependenceInfo dp;
            PermissionItemInfo itemRead;
            int j;
            ArrayList ar;
            PermissionItemInfo item = items.get(i);
            if (item == null || item.getType() == null) continue;
            if (item.getType().equals(PermissionType.UPDATE.getName()) || item.getType().equals(PermissionType.DELETE.getName()) || item.getType().equals(PermissionType.ADDNEW.getName())) {
                ar = PermissionUtils.getItemREAD(items);
                for (j = 0; j < ar.size(); ++j) {
                    itemRead = (PermissionItemInfo)ar.get(j);
                    dp = new DependenceInfo();
                    dp.setReferedItem(item);
                    refPerm = new RefPermissionItemInfo();
                    refPerm.setPermission(pmInfo);
                    refPerm.setPermissionItem(itemRead);
                    dp.getNewReferingItems().add(refPerm);
                    pmInfo.getDependences().add(dp);
                }
                continue;
            }
            if (!item.getType().equals(PermissionType.EXECUTE.getName())) continue;
            ar = PermissionUtils.getItemREAD(items);
            for (j = 0; j < ar.size(); ++j) {
                itemRead = (PermissionItemInfo)ar.get(j);
                dp = new DependenceInfo();
                dp.setReferedItem(item);
                refPerm = new RefPermissionItemInfo();
                refPerm.setPermission(pmInfo);
                refPerm.setPermissionItem(itemRead);
                dp.getNewReferingItems().add(refPerm);
                pmInfo.getDependences().add(dp);
            }
        }
    }

    private static ArrayList getItemREAD(PermissionItemCollection items) {
        ArrayList<PermissionItemInfo> ar = new ArrayList<PermissionItemInfo>();
        for (int i = 0; i < items.size(); ++i) {
            PermissionItemInfo item = items.get(i);
            if (item == null || item.getType() == null || !item.getType().equals(PermissionType.READ.getName())) continue;
            ar.add(item);
        }
        return ar;
    }
}

