/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.permission.metadata;

import com.kingdee.bos.service.permission.PermissionType;
import com.kingdee.bos.service.permission.metadata.DependenceInfo;
import com.kingdee.bos.service.permission.metadata.EntityObjectRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

class DP_BO_MAP {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.permission.metadata.PermissionDeployHelper$DP_BO_MAP");
    private HashMap m_map = new HashMap();

    public void deployDependenceByType(PermissionInfo pmInfo) {
        this.createMap(pmInfo);
        logger.info((Object)("\u6743\u9650\u7c7b\u578bDP_BO_MAP size:" + this.m_map.size()));
        this.createDependence(pmInfo);
    }

    public int size() {
        return this.m_map.size();
    }

    public HashMap getMap() {
        return this.m_map;
    }

    private void createMap(PermissionInfo pmInfo) {
        if (this.m_map == null || pmInfo == null) {
            logger.error((Object)"createMap parameter null error.");
            return;
        }
        PermissionItemInfo item = null;
        for (int i = 0; i < pmInfo.getPermissionItems().size(); ++i) {
            PermissionItemCollection items;
            item = pmInfo.getPermissionItems().get(i);
            if (item == null || item.getEntityObjectMetadataRef() == null || item.getEntityObjectMetadataRef().getEntityMetaInfo() == null || item.getEntityObjectMetadataRef().getEntityType() == null || item.getEntityObjectMetadataRef().getEntityType().length() == 0) continue;
            EntityObjectRefInfo entityRef = item.getEntityObjectMetadataRef();
            String key = entityRef.getEntityMetaInfo().getPackage() + "." + entityRef.getEntityMetaInfo().getName();
            if (this.m_map.containsKey(key)) {
                items = (PermissionItemCollection)this.m_map.get(key);
                if (items == null) {
                    items = new PermissionItemCollection();
                }
                items.add(item);
                continue;
            }
            items = new PermissionItemCollection();
            items.add(item);
            this.m_map.put(key, items);
        }
    }

    private void createDependence(PermissionInfo pmInfo) {
        if (this.m_map == null || pmInfo == null) {
            logger.error((Object)"createDependence parameter null error.");
            return;
        }
        PermissionItemCollection items = null;
        for (Map.Entry entry : this.m_map.entrySet()) {
            items = (PermissionItemCollection)entry.getValue();
            if (items == null) continue;
            this.createDependenceItem(pmInfo, items);
        }
    }

    private void createDependenceItem(PermissionInfo pmInfo, PermissionItemCollection items) {
        if (this.m_map == null || pmInfo == null || items == null) {
            logger.error((Object)"createDependenceItem parameter null error.");
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            PermissionItemInfo item = items.get(i);
            if (item == null) continue;
            if (item.getType().equals(PermissionType.UPDATE.getName()) || item.getType().equals(PermissionType.DELETE.getName()) || item.getType().equals(PermissionType.ADDNEW.getName())) {
                ArrayList ar = this.getItemREAD(items);
                for (int j = 0; j < ar.size(); ++j) {
                    PermissionItemInfo itemRead = (PermissionItemInfo)ar.get(j);
                    DependenceInfo dp = new DependenceInfo();
                    dp.setReferedItem(item);
                    pmInfo.getDependences().add(dp);
                }
                continue;
            }
            if (!item.getType().equals(PermissionType.EXECUTE.getName())) continue;
            for (int j = 0; j < items.size(); ++j) {
                PermissionItemInfo itemALL = items.get(j);
                if (item.getName().equals(itemALL.getName())) continue;
                DependenceInfo dp = new DependenceInfo();
                dp.setReferedItem(item);
                pmInfo.getDependences().add(dp);
            }
        }
    }

    private ArrayList getItemREAD(PermissionItemCollection items) {
        ArrayList<PermissionItemInfo> ar = new ArrayList<PermissionItemInfo>();
        for (int i = 0; i < items.size(); ++i) {
            PermissionItemInfo item = items.get(i);
            if (item == null || !item.getType().equals(PermissionType.READ.getName())) continue;
            ar.add(item);
        }
        return ar;
    }
}

