/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.permission.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.CheckReportFilter;
import com.kingdee.bos.dao.xml.CheckReportItem;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeCtrl;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.service.permission.metadata.BizPropertyCollection;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.service.permission.metadata.IPermissionCtrl;
import com.kingdee.bos.service.permission.metadata.PermissionCollection;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.StringUtils;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class PermissionCtrl
extends AbstractMetaDataCtrl
implements IPermissionCtrl {
    Context ctx = null;
    PermissionItemInfo tempPermItem;

    public PermissionCtrl() {
        super.registerInterface(IPermissionCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.service.permission", "permission"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.data", "dataTable"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.data", "crossTable"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "ownProperty"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "linkProperty"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "entityObject"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "relationship"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "constraint"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "numericConstraint"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "regexConstraint"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "scriptConstraint"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.query", "baseQuery"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.query", "joinQuery"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.query", "unionQuery"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.ui", "uiObject"));
    }

    public PermissionCtrl(Context ctx) {
        super(ctx);
        super.registerInterface(IPermissionCtrl.class, (Object)this);
        this.ctx = ctx;
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.service.permission", "permission"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.data", "dataTable"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.data", "crossTable"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "ownProperty"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "linkProperty"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "entityObject"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "relationship"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "constraint"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "numericConstraint"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "regexConstraint"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.entity", "scriptConstraint"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.query", "baseQuery"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.query", "joinQuery"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.query", "unionQuery"));
        super.loadSelfMetametaData(MetaDataPK.create("metametadata.ui", "uiObject"));
    }

    @Override
    public void addnew(IMetaDataPK pk, PermissionInfo permissionInfo) throws BOSException {
        this.getDAO().addnew(pk, permissionInfo);
    }

    @Override
    public IMetaDataPK addnew(PermissionInfo permissionInfo) throws BOSException {
        return (IMetaDataPK)this.getDAO().addnew(permissionInfo);
    }

    @Override
    public void update(IMetaDataPK metaType, PermissionInfo permissionInfo) throws BOSException {
        this.getDAO().update(metaType, permissionInfo);
    }

    @Override
    public PermissionInfo getValue(IMetaDataPK metaType) throws BOSException {
        if (metaType != null && metaType.equals(MetaDataPK.create(null, "service"))) {
            return this.getUnionValue();
        }
        if (metaType != null) {
            return (PermissionInfo)this.getDAO().getValue(metaType);
        }
        return this.getValue();
    }

    public PermissionInfo getValue() throws BOSException {
        return this.getValue(MetaDataPK.create(null, "service"));
    }

    @Override
    public PermissionInfo getUnionValue() throws BOSException {
        PermissionCollection perms = this.getCollection();
        PermissionInfo permission = new PermissionInfo();
        permission.setName("service");
        int n = perms.size();
        for (int i = 0; i < n; ++i) {
            PermissionInfo info = perms.get(i);
            if (info == null || info.getName().equalsIgnoreCase("service")) continue;
            permission.getPermissionItems().addObjectCollection(info.getPermissionItems());
            permission.getDependences().addObjectCollection(info.getDependences());
        }
        return permission;
    }

    public PermissionCollection getCollection() throws BOSException {
        return (PermissionCollection)this.getDAO().getCollection();
    }

    @Override
    public BOSObjectType getType() {
        return MetaDataTypeList.PERMISSION;
    }

    @Override
    public void deploy(IMetaDataPK pk, DeployOptionInfo options) throws BOSException {
        super.deploy(pk, options);
    }

    @Override
    public void check(IMetaDataPK pk, CheckReportFilter filter, ICheckReport report, OutputStream os) throws BOSException {
        super.check(pk, filter, report, os);
        if (os == null) {
            os = System.out;
        }
        PermissionInfo info = this.getValue(pk);
        this.checkPermItemID(info);
        PermissionItemCollection items = info.getPermissionItems();
        assert (items != null);
        int len = items.size();
        for (int i = 0; i < len; ++i) {
            PermissionItemInfo item = items.get(i);
            this.tempPermItem = null;
            this.tempPermItem = (PermissionItemInfo)item.clone();
            CheckReportItem checkItem = null;
            if (item.getName() == null) {
                checkItem = new CheckReportItem(0, pk, MetaDataTypeList.PERMISSION, pk.toString(), 11, new String[]{"[PermissionItem:" + this.tempPermItem.getName() + "]Name of this Permission Item is null"});
            }
            if (item.getType() == null || item.getType().length() == 0) {
                if (checkItem == null) {
                    checkItem = new CheckReportItem(0, pk, MetaDataTypeList.PERMISSION, pk.toString(), 11, new String[]{"[PermissionItem:" + this.tempPermItem.getName() + "]Type of this Permission Item is null"});
                } else {
                    StringUtils.stringArrayAppend((String[])checkItem.getMessages(), (String)("[PermissionItem:" + this.tempPermItem.getName() + "]Type of this Permission Item is null"));
                }
            }
            if (item.getInnerID() == null) {
                if (checkItem == null) {
                    checkItem = new CheckReportItem(0, pk, MetaDataTypeList.PERMISSION, pk.toString(), 11, new String[]{"[PermissionItem:" + this.tempPermItem.getName() + "]InnerID of this Permission Item is null"});
                } else {
                    StringUtils.stringArrayAppend((String[])checkItem.getMessages(), (String)("[PermissionItem:" + this.tempPermItem.getName() + "]InnerID of this Permission Item is null"));
                }
            }
            if (report == null || checkItem == null) continue;
            report.addItem(checkItem);
            if (os == null) continue;
            PrintStream ps = null;
            ps = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
            ps.println("CheckObject: " + checkItem.getKey() + "\tState: " + checkItem.getState());
            if (checkItem.getMessages() == null) continue;
            String[] msgs = checkItem.getMessages();
            for (int j = 0; j < msgs.length; ++j) {
                ps.println("    " + msgs[j]);
            }
        }
    }

    private void verifyBizRefByType(IMetaDataPK pk, ICheckReport report, OutputStream os, BizRefInfo bizRef, CheckReportItem checkItem) throws BOSException {
        MetaDataInfo metaInfo = bizRef.getBizMetadataInfo();
        BizPropertyCollection bizPropertys = bizRef.getBizPropertys();
        String type = metaInfo.getMetaDataType().toString();
        if (type.equalsIgnoreCase(MetaDataTypeList.ENTITY.toString())) {
            this.verifyEntityMethodIsExists(pk, report, os, metaInfo, bizPropertys, checkItem);
        }
        if (type.equalsIgnoreCase(MetaDataTypeList.FACADE.toString())) {
            this.verifyFacadeMethodIsExists(pk, report, os, metaInfo, bizPropertys, checkItem);
        }
        if (type.equalsIgnoreCase(MetaDataTypeList.UIOBJECT.toString())) {
            this.verifyUIActionIsExists(pk, report, os, metaInfo, bizPropertys, checkItem);
        }
        if (type.equalsIgnoreCase(MetaDataTypeList.BASEQUERY.toString())) {
            // empty if block
        }
    }

    private void verifyEntityMethodIsExists(IMetaDataPK pk, ICheckReport report, OutputStream os, MetaDataInfo metaInfo, BizPropertyCollection bizPropertys, CheckReportItem item) throws BOSException {
        assert (metaInfo != null && bizPropertys != null);
        Set innerIDSet = this.getEntityMethodSet(metaInfo);
        int bindSize = bizPropertys.size();
        for (int k = 0; k < bindSize; ++k) {
            String innerID = bizPropertys.get(k).getProperty();
            if (innerIDSet.contains(innerID)) continue;
            if (item == null) {
                item = new CheckReportItem(0, pk, MetaDataTypeList.PERMISSION, pk.toString(), 1, new String[]{"[PermissionItem:" + this.tempPermItem.getName() + "]Cannot found method[" + bizPropertys.get(k).toString() + "] in bo[" + metaInfo.getFullName() + "] and it's parent!"});
                continue;
            }
            StringUtils.stringArrayAppend((String[])item.getMessages(), (String)("[PermissionItem:" + this.tempPermItem.getName() + "]Cannot found method[" + bizPropertys.get(k).toString() + "] in bo[" + metaInfo.getFullName() + "] and it's parent!"));
        }
        if (bizPropertys.size() == 0) {
            if (item == null) {
                item = new CheckReportItem(0, pk, MetaDataTypeList.PERMISSION, pk.toString(), 11, new String[]{"[PermissionItem:" + this.tempPermItem.getName() + "]PermissionItem binded a Entity Object,but did not bind any Method"});
            } else {
                StringUtils.stringArrayAppend((String[])item.getMessages(), (String)("[PermissionItem:" + this.tempPermItem.getName() + "]PermissionItem binded a Entity Object,but did not bind any Method"));
            }
        }
        if (report != null && item != null) {
            report.addItem(item);
            if (os != null) {
                PrintStream ps = null;
                ps = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
                ps.println("CheckObject: " + item.getKey() + "\tState: " + item.getState());
                if (item.getMessages() != null) {
                    String[] msgs = item.getMessages();
                    for (int j = 0; j < msgs.length; ++j) {
                        ps.println("    " + msgs[j]);
                    }
                }
            }
        }
    }

    private void verifyFacadeMethodIsExists(IMetaDataPK pk, ICheckReport report, OutputStream os, MetaDataInfo metaInfo, BizPropertyCollection bizPropertys, CheckReportItem item) throws BOSException {
        assert (metaInfo != null && bizPropertys != null);
        Set innerIDSet = this.getFacadeMethodSet(metaInfo);
        int bindSize = bizPropertys.size();
        for (int k = 0; k < bindSize; ++k) {
            String innerID = bizPropertys.get(k).getProperty();
            if (innerIDSet.contains(innerID)) continue;
            if (item == null) {
                item = new CheckReportItem(0, pk, MetaDataTypeList.PERMISSION, pk.toString(), 1, new String[]{"[PermissionItem:" + this.tempPermItem.getName() + "]Cannot found method[" + bizPropertys.get(k).toString() + "] in bo[" + metaInfo.getFullName() + "] and it's parent!"});
                continue;
            }
            StringUtils.stringArrayAppend((String[])item.getMessages(), (String)("[PermissionItem:" + this.tempPermItem.getName() + "]Cannot found method[" + bizPropertys.get(k).toString() + "] in bo[" + metaInfo.getFullName() + "] and it's parent!"));
        }
        if (bizPropertys.size() == 0) {
            if (item == null) {
                item = new CheckReportItem(0, pk, MetaDataTypeList.PERMISSION, pk.toString(), 11, new String[]{"[PermissionItem:" + this.tempPermItem.getName() + "]PermissionItem binded a Facade Object,but did not bind any Method"});
            } else {
                StringUtils.stringArrayAppend((String[])item.getMessages(), (String)("[PermissionItem:" + this.tempPermItem.getName() + "]PermissionItem binded a Facade Object,but did not bind any Method"));
            }
        }
        if (report != null && item != null) {
            report.addItem(item);
            if (os != null) {
                PrintStream ps = null;
                ps = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
                ps.println("CheckObject: " + item.getKey() + "\tState: " + item.getState());
                if (item.getMessages() != null) {
                    String[] msgs = item.getMessages();
                    for (int j = 0; j < msgs.length; ++j) {
                        ps.println("    " + msgs[j]);
                    }
                }
            }
        }
    }

    private void verifyUIActionIsExists(IMetaDataPK pk, ICheckReport report, OutputStream os, MetaDataInfo metaInfo, BizPropertyCollection bizPropertys, CheckReportItem item) throws BOSException {
        assert (metaInfo != null && bizPropertys != null);
        Set innerIDSet = this.getUIActionSet(metaInfo);
        int bindSize = bizPropertys.size();
        for (int k = 0; k < bindSize; ++k) {
            String innerID = bizPropertys.get(k).getProperty();
            if (innerIDSet.contains(innerID)) continue;
            if (item == null) {
                item = new CheckReportItem(0, pk, MetaDataTypeList.PERMISSION, pk.toString(), 1, new String[]{"[PermissionItem:" + this.tempPermItem.getName() + "]Cannot found Action[" + bizPropertys.get(k).toString() + "] in UIObject[" + metaInfo.getFullName() + "] and it's parent!"});
                continue;
            }
            StringUtils.stringArrayAppend((String[])item.getMessages(), (String)("[PermissionItem:" + this.tempPermItem.getName() + "]Cannot found Action[" + bizPropertys.get(k).toString() + "] in UIObject[" + metaInfo.getFullName() + "] and it's parent!"));
        }
        if (bizPropertys.size() == 0) {
            if (item == null) {
                item = new CheckReportItem(0, pk, MetaDataTypeList.PERMISSION, pk.toString(), 11, new String[]{"[PermissionItem:" + this.tempPermItem.getName() + "]PermissionItem binded a UI Object,but did not bind any Action"});
            } else {
                StringUtils.stringArrayAppend((String[])item.getMessages(), (String)("[PermissionItem:" + this.tempPermItem.getName() + "]PermissionItem binded a UI Object,but did not bind any Action"));
            }
        }
        if (report != null && item != null) {
            report.addItem(item);
            if (os != null) {
                PrintStream ps = null;
                ps = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
                ps.println("CheckObject: " + item.getKey() + "\tState: " + item.getState());
                if (item.getMessages() != null) {
                    String[] msgs = item.getMessages();
                    for (int j = 0; j < msgs.length; ++j) {
                        ps.println("    " + msgs[j]);
                    }
                }
            }
        }
    }

    private Set getUIActionSet(MetaDataInfo metaInfo) throws BOSException {
        UIObjectInfo uiObj;
        assert (metaInfo != null);
        MetaDataPK pk = MetaDataPK.create(metaInfo.getPackage(), metaInfo.getName());
        UIObjectCtrl uiCtrl = new UIObjectCtrl(this.ctx);
        HashSet<String> set = new HashSet<String>();
        for (UIObjectInfo parent = uiObj = uiCtrl.getValueNotCache(pk); parent != null; parent = parent.getParent()) {
            ActionCollection actions = parent.getActions();
            int size = actions.size();
            for (int i = 0; i < size; ++i) {
                set.add(actions.get(i).getClassName());
            }
        }
        return set;
    }

    private Set getFacadeMethodSet(MetaDataInfo metaInfo) throws BOSException {
        FacadeInfo facade;
        assert (metaInfo != null);
        MetaDataPK pk = MetaDataPK.create(metaInfo.getPackage(), metaInfo.getName());
        FacadeCtrl facadeCtrl = new FacadeCtrl(this.ctx);
        HashSet<String> set = new HashSet<String>();
        for (FacadeInfo parent = facade = facadeCtrl.getValue(pk); parent != null; parent = parent.getBaseFacade()) {
            MethodCollection methods = parent.getMethods();
            int size = methods.size();
            for (int i = 0; i < size; ++i) {
                set.add(methods.get(i).getString("innerID"));
            }
        }
        return set;
    }

    private Set getEntityMethodSet(MetaDataInfo metaInfo) throws BOSException {
        EntityObjectInfo entity;
        assert (metaInfo != null);
        MetaDataPK pk = MetaDataPK.create(metaInfo.getPackage(), metaInfo.getName());
        EntityObjectCtrl entityCtrl = new EntityObjectCtrl(this.ctx);
        HashSet<String> set = new HashSet<String>();
        for (EntityObjectInfo parent = entity = entityCtrl.getValue(pk); parent != null; parent = parent.getBaseEntity()) {
            MethodCollection methods = parent.getMethods();
            int size = methods.size();
            for (int i = 0; i < size; ++i) {
                set.add(methods.get(i).getString("innerID"));
            }
        }
        return set;
    }

    private void checkPermItemID(PermissionInfo permInfo) {
        HashMap<String, PermissionItemInfo> map = new HashMap<String, PermissionItemInfo>();
        PermissionItemCollection itemCol = permInfo.getPermissionItems();
        PermissionItemInfo item = null;
        for (int i = itemCol.size() - 1; i >= 0; --i) {
            item = itemCol.get(i);
            if (!map.containsKey(item.getInnerID())) {
                map.put(item.getInnerID(), item);
                continue;
            }
            BOSUuid id = BOSUuid.create((String)"PERMITEM");
            item.setInnerID(id.toString());
            map.put(item.getInnerID(), item);
        }
    }
}

