/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.permission.metadata;

import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.util.HierarchyTreeNode;
import com.kingdee.util.StringUtils;
import java.util.Enumeration;

public class PermissionDefineHelper {
    public static void generateItemTree(HierarchyTreeNode root, PermissionItemCollection collection) {
        if (root == null || collection == null) {
            throw new IllegalArgumentException("root and collection can not be null");
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            PermissionItemInfo item = collection.get(i);
            String group = item.getGroupName();
            HierarchyTreeNode node = PermissionDefineHelper.getTreeNodeByGroup(root, group);
            HierarchyTreeNode itemNode = new HierarchyTreeNode();
            itemNode.setUserObject((Object)item);
            node.add(itemNode);
        }
    }

    private static HierarchyTreeNode getTreeNodeByGroup(HierarchyTreeNode root, String group) {
        if (StringUtils.isEmpty((String)group)) {
            return root;
        }
        String[] items = StringUtils.split((String)group, (String)".");
        return PermissionDefineHelper.getTreeNodeBySplitArray(root, items);
    }

    private static HierarchyTreeNode getTreeNodeBySplitArray(HierarchyTreeNode root, String[] items) {
        HierarchyTreeNode selectedNode = null;
        if (items.length >= 1) {
            String item = items[0];
            Enumeration children = root.children();
            while (children.hasMoreElements()) {
                String label;
                HierarchyTreeNode child = (HierarchyTreeNode)children.nextElement();
                Object obj = child.getUserObject();
                if (!(obj instanceof String) || !(label = (String)obj).equals(item)) continue;
                selectedNode = child;
                break;
            }
            if (selectedNode == null) {
                selectedNode = new HierarchyTreeNode();
                selectedNode.setUserObject((Object)item);
                root.add(selectedNode);
            }
        }
        if (items.length == 1) {
            return selectedNode;
        }
        String[] otherItems = new String[items.length - 1];
        System.arraycopy(items, 1, otherItems, 0, items.length - 1);
        return PermissionDefineHelper.getTreeNodeBySplitArray(selectedNode, otherItems);
    }
}

