/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.permission.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.management.DataSource;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionCtrl;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.permission.PermissionType;
import com.kingdee.bos.service.permission.metadata.DP_BO_MAP;
import com.kingdee.bos.service.permission.metadata.DP_LR_ITEM;
import com.kingdee.bos.service.permission.metadata.DP_LR_LIST;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class PermissionDeployHelper {
    public static final String ALIAS_DB_ITME = "FAlias";
    public static final String DESCRIPTION_DB_ITME = "FDescription";
    private static final String EAS_UN_DELETE_TYPE = "01EFEC8C";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.permission.metadata.PermissionDeployHelper");
    private static final String ITEM_ALIAS = "FAlias";
    private static final String ITEM_DESCRIPTION = "FDescription";
    private static final String ITEM_GROUP = "FGroup";
    private static final int BASE_ITEM_NUM = 4;
    private static final int VAR_ITEM_NUM = 3;

    public static void deploy(PermissionInfo pmInfo, DeployOptionInfo options, Context ctx) throws BOSException {
        if (pmInfo == null) {
            throw new BOSException("\u53c2\u6570\u9519\u8befpmInfo\u4e3anull");
        }
        Connection cn = null;
        try {
            DataSource ds = new DataSource(options.getTargetDBMS());
            cn = ds.getConnection();
            boolean isOverride = options.isOverrideDeployFile();
            PermissionDeployHelper.deployDB(cn, pmInfo, isOverride, ctx);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
    }

    private static void deployDB(Connection cn, PermissionInfo pmInfo, boolean bOver, Context ctx) throws BOSException {
        PermissionDeployHelper.deployPermItems(cn, pmInfo, bOver, ctx);
        PermissionDeployHelper.deployPermType(pmInfo);
        PermissionDeployHelper.deployDependences(cn, pmInfo, bOver);
    }

    private static String createBOID() {
        return BOSUuid.create((String)"PERMITEM").toString();
    }

    private static int getEnumInt(String enumStr) {
        return PermissionType.getEnum(enumStr).getValue();
    }

    private static void deployPermItems(Connection cn, PermissionInfo pmInfo, boolean bOver, Context ctx) throws BOSException {
        try {
            String strSQL = "";
            PermissionItemInfo pitem = null;
            if (bOver) {
                strSQL = "DELETE FROM T_PM_PermItem WHERE FOBJECTTYPE<>'" + EAS_UN_DELETE_TYPE.trim() + "'";
                SQLUtils.execute((Connection)cn, (String)strSQL);
            }
            for (int i = 0; i < pmInfo.getPermissionItems().size(); ++i) {
                pitem = pmInfo.getPermissionItems().get(i);
                PermissionDeployHelper.verifyPermItem(pitem);
                if (pitem == null) continue;
                if (bOver) {
                    PermissionDeployHelper.createInsertSQL(cn, pitem, ctx);
                    continue;
                }
                strSQL = "SELECT FPERMITEMID FROM T_PM_PermItem WHERE  FPERMITEMID='" + pitem.getInnerID().trim() + "'";
                RowSet rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)strSQL);
                if (rs.next()) {
                    String exid = rs.getString("FPERMITEMID");
                    PermissionDeployHelper.createUpdateSQL(cn, pitem, exid, ctx);
                } else {
                    PermissionDeployHelper.createInsertSQL(cn, pitem, ctx);
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("deployPermItems() error:" + e.getMessage()));
            throw new SQLDataException(e);
        }
    }

    private static void verifyPermItem(PermissionItemInfo permItem) throws BOSException {
        if (permItem.getName() == null) {
            throw new BOSException("name of a permission item can not be null,Perm Item ID:" + permItem.getInnerID());
        }
        if (permItem.getType() == null || permItem.getType().length() == 0) {
            throw new BOSException(permItem.getName() + ":perm type of a permission item can not be null");
        }
        if (permItem.getInnerID() == null) {
            throw new BOSException(permItem.getName() + ":perm item inner id is null");
        }
    }

    private static void deployPermType(PermissionInfo pmInfo) {
        DP_BO_MAP boMap = new DP_BO_MAP();
        boMap.deployDependenceByType(pmInfo);
        boMap = null;
    }

    private static void deployDependences(Connection cn, PermissionInfo pmInfo, boolean bOver) throws BOSException {
        DP_LR_LIST dpls = new DP_LR_LIST();
        ArrayList arLR = null;
        if (dpls.loadData(pmInfo)) {
            logger.debug((Object)"DP_LR_LIST STEP 1 \u88c5\u8f7d\u6570\u636e OK!");
            arLR = dpls.getList();
        }
        dpls = null;
        HashMap map = PermissionDeployHelper.getPermItemNameIDMap(cn);
        logger.debug((Object)"DP_LR_LIST STEP 3 \u88c5\u8f7d\u6743\u9650\u9879Map OK!");
        if (arLR == null || map == null) {
            logger.error((Object)"arLR is null");
            return;
        }
        PermissionDeployHelper.fillIDInLRList(arLR, map);
        logger.debug((Object)"DP_LR_LIST STEP 3.x \u4f9d\u8d56\u5173\u7cfb\u586b\u5165ID\u6570\u636e OK!");
        logger.debug((Object)"DP_LR_LIST STEP 4 \u4f9d\u8d56\u5173\u7cfb\u5199\u5165\u6570\u636e\u5e93 OK!");
        PermissionDeployHelper.expandDependencesDB(cn, arLR, bOver);
        arLR = null;
        logger.debug((Object)"-------------- \u53d1\u5e03\u5b8c\u6210! ----------------------");
    }

    private static HashMap getPermItemNameIDMap(Connection cn) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            RowSet rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)"SELECT FPermItemID,FName FROM T_PM_PermItem");
            while (rs.next()) {
                if (map.containsKey(rs.getString("FName"))) continue;
                map.put(rs.getString("FName"), rs.getString("FPermItemID"));
            }
            SQLUtils.cleanup((ResultSet)rs);
            return map;
        }
        catch (SQLException e) {
            logger.error((Object)("getPermItemNameIDMap error:" + e.getMessage()));
            throw new SQLDataException(e);
        }
    }

    private static void fillIDInLRList(ArrayList ar, HashMap map) {
        if (ar == null || map == null) {
            return;
        }
        DP_LR_ITEM item = null;
        String key = "";
        String id = "";
        int length = ar.size();
        for (int i = 0; i < length; ++i) {
            item = (DP_LR_ITEM)ar.get(i);
            if (item == null) continue;
            key = item.getLeftName();
            if (!map.containsKey(item.getLeftName()) || !map.containsKey(item.getRightName())) continue;
            if (map.containsKey(key)) {
                id = map.get(key).toString();
                item.setLeftID(id);
            }
            if (!map.containsKey(key = item.getRightName())) continue;
            id = map.get(key).toString();
            item.setRightID(id);
        }
    }

    private static void expandDependencesDB(Connection cn, ArrayList arLR, boolean bOver) throws BOSException {
        PermissionDeployHelper.expandDependencesDB_1(cn, arLR);
        PermissionDeployHelper.expandDependencesDB_2(cn, arLR.size());
        PermissionDeployHelper.expandDependencesDB_3(cn, bOver);
    }

    private static void expandDependencesDB_1(Connection cn, ArrayList arLR) throws BOSException {
        DP_LR_ITEM item = null;
        try {
            SQLUtils.execute((Connection)cn, (String)"DELETE FROM T_PM_DeployDepend");
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < arLR.size(); ++i) {
                item = (DP_LR_ITEM)arLR.get(i);
                if (item == null || item.getLeftID() == null || item.getLeftID().trim().length() <= 0 || item.getRightID() == null || item.getRightID().trim().length() <= 0) continue;
                buffer.append("INSERT INTO T_PM_DeployDepend (FLeftID,FRightID,FIndex) VALUES('" + item.getLeftID() + "','" + item.getRightID() + "'," + i + ")");
                buffer.append("\n;\n");
            }
            String sql = buffer.toString();
            if (!StringUtils.isEmpty((String)sql)) {
                SQLUtils.execute((Connection)cn, (String)sql);
            }
        }
        catch (SQLException e) {
            logger.debug((Object)("deployDependencesDB_1 error:" + e.getMessage()));
            throw new SQLDataException(e);
        }
    }

    private static void expandDependencesDB_2(Connection cn, int arSize) throws BOSException {
        int size = 0;
        String sql = "";
        String f_leftid = "";
        String f_rightid = "";
        int f_index = 0;
        try {
            size = arSize;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                sql = "SELECT * FROM T_PM_DeployDepend WHERE FIndex=" + i;
                RowSet rsRight = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
                if (rsRight.next()) {
                    sql = "SELECT * FROM T_PM_DeployDepend WHERE FLeftID='" + rsRight.getString("FRightID") + "'";
                    RowSet rsLeftSet = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
                    while (rsLeftSet.next()) {
                        f_leftid = rsRight.getString("FLeftID").trim();
                        f_rightid = rsLeftSet.getString("FRightID").trim();
                        f_index = size++;
                        sql = "SELECT FLeftID FROM T_PM_DeployDepend WHERE FLeftID='" + f_leftid + "' AND FRightID='" + f_rightid + "'";
                        RowSet rsExist = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
                        if (!rsExist.next()) {
                            sql = "INSERT INTO T_PM_DeployDepend (FLeftID,FRightID,FIndex) VALUES('" + f_leftid + "','" + f_rightid + "'," + f_index + ")";
                            buffer.append(sql);
                            buffer.append("\n;\n");
                        }
                        SQLUtils.cleanup((ResultSet)rsExist);
                    }
                    SQLUtils.cleanup((ResultSet)rsLeftSet);
                }
                SQLUtils.cleanup((ResultSet)rsRight);
            }
            sql = buffer.toString();
            if (sql.trim() != null && sql.trim().length() != 0) {
                SQLUtils.execute((Connection)cn, (String)sql);
            }
        }
        catch (SQLException e) {
            logger.debug((Object)("deployDependencesDB_2" + e.getMessage()));
            throw new SQLDataException(e);
        }
    }

    private static void expandDependencesDB_3(Connection cn, boolean bOver) throws BOSException {
        String sql = "";
        StringBuffer buffer = new StringBuffer();
        try {
            if (bOver) {
                SQLUtils.execute((Connection)cn, (String)"DELETE FROM T_PM_PermDependency");
                RowSet rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)"SELECT * FROM T_PM_DeployDepend");
                while (rs.next()) {
                    sql = "INSERT T_PM_PermDependency (FPERMITEMID,FDEPENDENCYID) VALUES('" + rs.getString("FRightID") + "','" + rs.getString("FLeftID") + "')";
                    buffer.append(sql);
                    buffer.append("\n;\n");
                }
                SQLUtils.cleanup((ResultSet)rs);
            } else {
                sql = "SELECT * FROM T_PM_DeployDepend";
                RowSet rsDeploy = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
                while (rsDeploy.next()) {
                    sql = "SELECT * FROM T_PM_PermDependency WHERE FPERMITEMID='" + rsDeploy.getString("FRightID") + "' AND FDEPENDENCYID='" + rsDeploy.getString("FLeftID") + "'";
                    RowSet rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
                    if (!rs.next()) {
                        sql = "INSERT T_PM_PermDependency (FPERMITEMID,FDEPENDENCYID) VALUES('" + rsDeploy.getString("FRightID") + "','" + rsDeploy.getString("FLeftID") + "')";
                        buffer.append(sql);
                        buffer.append("\n;\n");
                    }
                    SQLUtils.cleanup((ResultSet)rs);
                }
                SQLUtils.cleanup((ResultSet)rsDeploy);
            }
            sql = buffer.toString();
            if (sql.length() > 0) {
                SQLUtils.execute((Connection)cn, (String)sql);
            }
        }
        catch (SQLException e) {
            logger.debug((Object)("deployDependencesDB_3" + e.getMessage()));
            throw new SQLDataException(e);
        }
    }

    private static LanguageCollection getLanguages(Context ctx) throws BOSException {
        SolutionCtrl ctrl = new SolutionCtrl(ctx);
        SolutionInfo soluInfo = ctrl.getValue();
        LanguageCollection langs = soluInfo.getLanguages();
        return langs;
    }

    private static LanguageInfo getDefaultLanguage(Context ctx) throws BOSException {
        SolutionCtrl ctrl = new SolutionCtrl(ctx);
        SolutionInfo soluInfo = ctrl.getValue();
        return soluInfo.getDefaultLanguage();
    }

    private static void createUpdateSQL(Connection cn, PermissionItemInfo permItem, String oldID, Context ctx) throws BOSException {
        LanguageCollection langCol = PermissionDeployHelper.getLanguages(ctx);
        LanguageInfo defaultLang = PermissionDeployHelper.getDefaultLanguage(ctx);
        permItem.setDefaultLocale(defaultLang.getOriginalLocale());
        String sql = "UPDATE T_PM_PermItem SET FPERMITEMID=?, FObjectType=?, FName=?, FPermType=?, ";
        for (int i = langCol.size() - 1; i >= 0; --i) {
            LanguageInfo lan = langCol.get(i);
            String postFix = lan.getPostfix();
            String aliasItem = "FAlias_" + postFix;
            sql = sql + aliasItem;
            sql = sql + "=?, ";
            String descItem = "FDescription_" + postFix;
            sql = sql + descItem;
            sql = sql + "=?, ";
            String groupItem = "FGroup_" + postFix;
            sql = sql + groupItem;
            sql = sql + "=?";
            if (i == 0) continue;
            sql = sql + ", ";
        }
        sql = sql + " WHERE FPermItemID=?";
        logger.info((Object)sql);
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            stmt = cn.prepareStatement(sql);
            stmt.setString(1, permItem.getInnerID());
            if (permItem.getEntityObjectMetadataRef() == null || permItem.getEntityObjectMetadataRef().getEntityType() == null) {
                stmt.setString(2, "");
            } else {
                stmt.setString(2, permItem.getEntityObjectMetadataRef().getEntityType().toString());
            }
            stmt.setString(3, permItem.getName());
            stmt.setInt(4, PermissionType.getEnum(permItem.getType()).getValue());
            int index = 1;
            for (int i = langCol.size() - 1; i >= 0; --i) {
                LanguageInfo lan = langCol.get(i);
                String postFix = lan.getPostfix();
                stmt.setString(4 + index, permItem.getAlias(BOSLocaleUtil.getLocale(postFix)));
                stmt.setString(4 + ++index, permItem.getDescription(BOSLocaleUtil.getLocale(postFix)));
                stmt.setString(4 + ++index, permItem.getGroup(BOSLocaleUtil.getLocale(postFix)));
                ++index;
            }
            stmt.setString(4 + 3 * langCol.size() + 1, oldID);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    private static void createInsertSQL(Connection cn, PermissionItemInfo permItem, Context ctx) throws BOSException {
        LanguageCollection langCol = PermissionDeployHelper.getLanguages(ctx);
        LanguageInfo defaultLang = PermissionDeployHelper.getDefaultLanguage(ctx);
        permItem.setDefaultLocale(defaultLang.getOriginalLocale());
        String sql = "INSERT INTO T_PM_PermItem(FPERMITEMID, FObjectType, FName, FPermType, ";
        for (int i = langCol.size() - 1; i >= 0; --i) {
            LanguageInfo lan = langCol.get(i);
            String postFix = lan.getPostfix();
            String aliasItem = "FAlias_" + postFix;
            sql = sql + aliasItem;
            sql = sql + ", ";
            String descItem = "FDescription_" + postFix;
            sql = sql + descItem;
            sql = sql + ", ";
            String groupItem = "FGroup_" + postFix;
            sql = sql + groupItem;
            if (i == 0) continue;
            sql = sql + ", ";
        }
        sql = sql + " ) VALUES(";
        int itemNum = 4 + 3 * langCol.size();
        for (int i = 0; i < itemNum; ++i) {
            sql = sql + "?";
            if (i == itemNum - 1) continue;
            sql = sql + ", ";
        }
        sql = sql + ")";
        logger.info((Object)sql);
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            stmt.setString(1, permItem.getInnerID());
            if (permItem.getEntityObjectMetadataRef() == null || permItem.getEntityObjectMetadataRef().getEntityType() == null) {
                stmt.setString(2, "");
            } else {
                stmt.setString(2, permItem.getEntityObjectMetadataRef().getEntityType().toString());
            }
            stmt.setString(3, permItem.getName());
            stmt.setInt(4, PermissionType.getEnum(permItem.getType()).getValue());
            int index = 1;
            for (int i = langCol.size() - 1; i >= 0; --i) {
                LanguageInfo lan = langCol.get(i);
                String postFix = lan.getPostfix();
                stmt.setString(4 + index, permItem.getAlias(BOSLocaleUtil.getLocale(postFix)));
                stmt.setString(4 + ++index, permItem.getDescription(BOSLocaleUtil.getLocale(postFix)));
                stmt.setString(4 + ++index, permItem.getGroup(BOSLocaleUtil.getLocale(postFix)));
                ++index;
            }
            stmt.execute();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }
}

