/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.bizunitproxy;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizFieldViewInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.ViewType;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.StatusCollection;
import com.kingdee.bos.metadata.ui.StatusInfo;
import com.kingdee.bos.metadata.ui.StatusItemCollection;
import com.kingdee.bos.metadata.ui.StatusItemInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.Component2XmlHelper;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.WebUIProxyHelper;
import com.kingdee.bos.ui.dtp.WebControlConstant;
import com.kingdee.bos.ui.dtp.model.layout.LabelContainerLayout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.dtp.smartlayout.SmartLayoutData;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class WebEditUIProxyHelper {
    private static final Logger logger = Logger.getLogger(WebEditUIProxyHelper.class);
    private WebUIProxyHelper uiProxyHelper;
    private Hashtable controlMap = new Hashtable();
    private static double MaxFloat = 3.4028234663852886E38;
    private static double MinFloat = -3.4028234663852886E38;

    WebEditUIProxyHelper(WebUIProxyHelper uiProxyHelper) {
        this.initControlMap();
        this.uiProxyHelper = uiProxyHelper;
    }

    public void createEditUI(WebUIObjectInfo model, BizUnitInfo bizUnit, String dataObjName) {
        if (model == null || bizUnit == null) {
            return;
        }
        BizFieldCollection fields = bizUnit.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        ComponentInfo main = model.getMainPanelComponent();
        ComponentInfo container = UIProxyHelper.findControlByName(main, "rootForm");
        if (container == null) {
            container = UIProxyHelper.findControlByName(main, "rootFreePanel");
        }
        if (container == null) {
            return;
        }
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> newGroupBizFields = new Vector<BizFieldInfo>();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (!ObjectStateType.NEW.equals((Object)bizField.getObjectState())) continue;
            if (bizField instanceof BizGroupFieldInfo) {
                newGroupBizFields.add(bizField);
                continue;
            }
            newBizFields.add(bizField);
        }
        BizFieldInfo[] tempFields = new BizFieldInfo[newBizFields.size()];
        System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
        this.createHeaderControls(bizUnit, container, tempFields, dataObjName);
        BizGroupFieldInfo[] tempGroupFields = new BizGroupFieldInfo[newGroupBizFields.size()];
        System.arraycopy(newGroupBizFields.toArray(), 0, tempFields, 0, newGroupBizFields.size());
        this.createDetailsControl(bizUnit, model, container, tempGroupFields, dataObjName);
    }

    public void updateEditUI(WebUIObjectInfo model, BizUnitInfo bizUnit, String dataObjName) {
        BizFieldInfo[] tempFields;
        int size;
        if (model == null || bizUnit == null) {
            return;
        }
        BizFieldCollection fields = bizUnit.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> updBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> delBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> groupBizFields = new Vector<BizFieldInfo>();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (bizField instanceof BizGroupFieldInfo) {
                groupBizFields.add(bizField);
                continue;
            }
            if ((ObjectStateType.NEW.equals((Object)bizField.getObjectState()) || ObjectStateType.NEWCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 4) != 0) {
                newBizFields.add(bizField);
                continue;
            }
            if (ObjectStateType.CHANGED.equals((Object)bizField.getObjectState())) {
                updBizFields.add(bizField);
                continue;
            }
            if (!ObjectStateType.DELETING.equals((Object)bizField.getObjectState()) && !ObjectStateType.DELETEDCONTROL.equals((Object)bizField.getObjectState()) || (bizField.getEffectUI() & 4) == 0) continue;
            delBizFields.add(bizField);
        }
        if (newBizFields.size() == 0 && updBizFields.size() == 0 && delBizFields.size() == 0 && groupBizFields.size() == 0) {
            return;
        }
        ComponentCollection collection = model.getComponents();
        if (collection == null || collection.size() == 0) {
            return;
        }
        ComponentInfo main = model.getMainPanelComponent();
        ComponentInfo container = UIProxyHelper.findControlByName(main, "rootForm");
        if (container == null) {
            container = UIProxyHelper.findControlByName(main, "rootFreePanel");
        }
        if ((size = delBizFields.size()) > 0) {
            tempFields = new BizFieldInfo[size];
            System.arraycopy(delBizFields.toArray(), 0, tempFields, 0, size);
            this.deleteHeaderControl(model, tempFields);
        }
        if ((size = updBizFields.size()) > 0) {
            tempFields = new BizFieldInfo[updBizFields.size()];
            System.arraycopy(updBizFields.toArray(), 0, tempFields, 0, updBizFields.size());
            this.updateHeaderControls(bizUnit, container, tempFields, dataObjName);
        }
        if ((size = newBizFields.size()) > 0) {
            tempFields = new BizFieldInfo[newBizFields.size()];
            System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
            this.createHeaderControls(bizUnit, container, tempFields, dataObjName);
        }
        if ((size = groupBizFields.size()) > 0) {
            BizGroupFieldInfo[] tempGroupFields = new BizGroupFieldInfo[groupBizFields.size()];
            System.arraycopy(groupBizFields.toArray(), 0, tempGroupFields, 0, groupBizFields.size());
            this.updateDetailsControl(bizUnit, model, tempGroupFields, dataObjName);
        }
    }

    private void updKDTableColumn(EntityObjectInfo entity, ComponentInfo kdTable, BizFieldInfo[] updBizFields, String dataObjName, String linkPropName) {
        if (kdTable == null || updBizFields == null || StringUtils.isEmpty((String)dataObjName)) {
            return;
        }
        for (int i = 0; i < updBizFields.length; ++i) {
            com.kingdee.bos.metadata.entity.PropertyInfo prop;
            BizFieldInfo field = updBizFields[i];
            String name = field.getWebControlName();
            String oldColName = name;
            ComponentInfo column = WebUIProxyHelper.findColumn(kdTable, oldColName);
            if (column == null || (prop = entity.getPropertyByName(name)) == null || !(prop instanceof OwnPropertyInfo)) continue;
            PropertyBindingInfo propertyBindingInfo = column.getPropertyBindings().get("value");
            if (propertyBindingInfo != null) {
                propertyBindingInfo.setBindingObject(dataObjName);
                propertyBindingInfo.setBingdingField(linkPropName + "." + prop.getName());
                propertyBindingInfo.setFieldType(((OwnPropertyInfo)prop).getJavaType());
                propertyBindingInfo.setOverride(true);
                continue;
            }
            propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName("value");
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(dataObjName);
            propertyBindingInfo.setBingdingField(linkPropName + "." + prop.getName());
            propertyBindingInfo.setFieldType(((OwnPropertyInfo)prop).getJavaType());
            propertyBindingInfo.setOverride(true);
            column.getPropertyBindings().add(propertyBindingInfo);
        }
    }

    private void updateHeaderControls(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo[] bizFields, String dataObjName) {
        if (container == null || bizFields == null || bizFields.length == 0) {
            return;
        }
        for (int i = 0; i < bizFields.length; ++i) {
            BizFieldInfo bizFieldInfo = bizFields[i];
            String controlName = bizFieldInfo.getWebControlName();
            ComponentInfo control = UIProxyHelper.findControlByName(container, controlName);
            if (control == null) continue;
            control.setAlias(bizFieldInfo.getAlias());
        }
    }

    private void addDelBizFields(Vector delBizFields, BizGroupFieldInfo groupField) {
        delBizFields.add(groupField.getWebControlName());
        BizFieldCollection fields = groupField.getFields();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            if (!(fields.get(i) instanceof BizGroupFieldInfo)) continue;
            this.addDelBizFields(delBizFields, (BizGroupFieldInfo)fields.get(i));
        }
    }

    private void updateDetailsControl(BizUnitInfo bizUnit, WebUIObjectInfo model, BizGroupFieldInfo[] groupFields, String dataObjName) {
        int i;
        EntityObjectInfo entity = bizUnit.getEntity();
        if (entity == null) {
            return;
        }
        Vector<BizGroupFieldInfo> newBizFields = new Vector<BizGroupFieldInfo>();
        Vector<BizGroupFieldInfo> updBizFields = new Vector<BizGroupFieldInfo>();
        Vector delBizFields = new Vector();
        for (BizGroupFieldInfo bizField : groupFields) {
            if (bizField == null) continue;
            if ((ObjectStateType.NEW.equals((Object)bizField.getObjectState()) || ObjectStateType.NEWCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 4) != 0) {
                newBizFields.add(bizField);
                continue;
            }
            if ((ObjectStateType.DELETING.equals((Object)bizField.getObjectState()) || ObjectStateType.DELETEDCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 4) != 0) {
                this.addDelBizFields(delBizFields, bizField);
                continue;
            }
            updBizFields.add(bizField);
        }
        ComponentInfo mainPanel = model.getMainPanelComponent();
        if (delBizFields.size() > 0) {
            this.deleteControl(model, mainPanel, new HashSet(delBizFields), false);
        }
        int j = newBizFields.size();
        for (i = 0; i < j; ++i) {
            BizFieldViewInfo viewInfo;
            BizGroupFieldInfo groupBizField = (BizGroupFieldInfo)newBizFields.get(i);
            com.kingdee.bos.metadata.entity.PropertyInfo prop = entity.getPropertyByName(groupBizField.getPropertyName());
            if (prop == null || (viewInfo = groupBizField.getFieldView()) == null) continue;
            ComponentInfo container = this.uiProxyHelper.findParentControl(mainPanel, groupBizField);
            if (container == null) {
                container = mainPanel;
            }
            this.createKDTableForEntity(model, container, groupBizField, dataObjName, prop.getName());
        }
        j = updBizFields.size();
        for (i = 0; i < j; ++i) {
            WebUIObjectInfo realModel = model;
            BizGroupFieldInfo groupBizField = (BizGroupFieldInfo)updBizFields.get(i);
            com.kingdee.bos.metadata.entity.PropertyInfo prop = entity.getPropertyByName(groupBizField.getPropertyName());
            if (prop == null) continue;
            Object[] tempFields = groupBizField.getFields().toArray();
            BizFieldInfo[] tempBizFields = new BizFieldInfo[tempFields.length];
            System.arraycopy(tempFields, 0, tempBizFields, 0, tempFields.length);
            BizFieldViewInfo viewInfo = groupBizField.getFieldView();
            if (viewInfo == null) continue;
            ComponentInfo container = null;
            ComponentInfo table = WebUIProxyHelper.findControlByName(mainPanel, groupBizField.getWebControlName());
            container = table != null && table.getParent() != null ? table.getParent() : mainPanel;
            if (table == null || !"com.kingdee.bos.ctrl.web.EditDataGrid".equals(table.getClassType())) {
                logger.error((Object)("Cann't find the DataGrid named " + groupBizField.getOldValue("controlName")));
                continue;
            }
            this.updateKDTableForEntity(realModel, container, table, groupBizField, dataObjName, prop.getName());
        }
    }

    private void updateKDTableForEntity(WebUIObjectInfo model, ComponentInfo parent, ComponentInfo kdTable, BizGroupFieldInfo groupField, String dataObjName, String linkPropName) {
        ComponentInfo container = parent;
        ComponentInfo mainPanel = model.getComponents().get(0);
        container = kdTable.getParent() != null && kdTable.getParent().equals(container) ? parent : (kdTable.getParent() != null ? kdTable.getParent() : mainPanel);
        if (container == null || groupField == null || kdTable == null) {
            return;
        }
        EntityObjectInfo entity = groupField.getEntityObject();
        if (entity == null) {
            return;
        }
        this.setControlTabIndex(kdTable, groupField.getFieldView());
        ComponentCollection collection = container.getComponents();
        if (collection == null || collection.size() == 0) {
            return;
        }
        BizFieldCollection fields = groupField.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> delBizFields = new Vector<BizFieldInfo>();
        Vector<BizFieldInfo> updBizFields = new Vector<BizFieldInfo>();
        Vector delGroupFields = new Vector();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (!bizField.isGenControl()) continue;
            if ((ObjectStateType.NEW.equals((Object)bizField.getObjectState()) || ObjectStateType.NEWCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 4) != 0) {
                if (bizField instanceof BizGroupFieldInfo) {
                    this.createKDTableForEntity(model, container, (BizGroupFieldInfo)bizField, dataObjName, linkPropName + "." + bizField.getPropertyName());
                    continue;
                }
                newBizFields.add(bizField);
                continue;
            }
            if ((ObjectStateType.DELETING.equals((Object)bizField.getObjectState()) || ObjectStateType.DELETEDCONTROL.equals((Object)bizField.getObjectState())) && (bizField.getEffectUI() & 4) != 0) {
                if (bizField instanceof BizGroupFieldInfo) {
                    this.addDelBizFields(delGroupFields, (BizGroupFieldInfo)bizField);
                    continue;
                }
                delBizFields.add(bizField);
                continue;
            }
            if (ObjectStateType.CHANGED.equals((Object)bizField.getObjectState())) {
                if (bizField instanceof BizGroupFieldInfo) {
                    this.updateKDTableForEntity(model, container, WebUIProxyHelper.findControlByName(mainPanel, bizField.getWebControlName()), (BizGroupFieldInfo)bizField, dataObjName, linkPropName + "." + bizField.getPropertyName());
                    continue;
                }
                updBizFields.add(bizField);
                continue;
            }
            if (!ObjectStateType.UNCHANGE.equals((Object)bizField.getObjectState()) || !(bizField instanceof BizGroupFieldInfo)) continue;
            this.updateKDTableForEntity(model, container, WebUIProxyHelper.findControlByName(mainPanel, bizField.getWebControlName()), (BizGroupFieldInfo)bizField, dataObjName, linkPropName + "." + bizField.getPropertyName());
        }
        if (delGroupFields.size() > 0) {
            this.deleteControl(model, mainPanel, new HashSet(delGroupFields), false);
        }
        BizFieldInfo[] tempFields = new BizFieldInfo[delBizFields.size()];
        System.arraycopy(delBizFields.toArray(), 0, tempFields, 0, delBizFields.size());
        this.uiProxyHelper.delKDTableColumn(model, kdTable, tempFields, true);
        tempFields = new BizFieldInfo[updBizFields.size()];
        System.arraycopy(updBizFields.toArray(), 0, tempFields, 0, updBizFields.size());
        this.updKDTableColumn(entity, kdTable, tempFields, dataObjName, linkPropName);
        tempFields = new BizFieldInfo[newBizFields.size()];
        System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
        this.createKDTableProperty(model, groupField, tempFields, dataObjName, kdTable, linkPropName);
        this.uiProxyHelper.updateComponentRules(model, kdTable, groupField);
    }

    private void deleteHeaderControl(WebUIObjectInfo model, BizFieldInfo[] bizFields) {
        if (model == null || bizFields == null || bizFields.length == 0) {
            return;
        }
        HashSet<String> controlName = new HashSet<String>();
        for (int i = 0; i < bizFields.length; ++i) {
            controlName.add(bizFields[i].getWebControlName());
        }
        ComponentInfo container = model.getComponents().get(0);
        this.deleteControl(model, container, controlName, true);
    }

    private void deleteControl(WebUIObjectInfo model, ComponentInfo container, Set needDelCtrlName, boolean delLabContainer) {
        if (container == null || needDelCtrlName.isEmpty()) {
            return;
        }
        Iterator iter = needDelCtrlName.iterator();
        while (iter.hasNext()) {
            String controlName;
            ComponentInfo control = UIProxyHelper.findControlByName(container, (String)iter.next());
            if (control == null) continue;
            ComponentInfo regionControl = control;
            ComponentInfo parent = control.getParent();
            if (parent == null) continue;
            if (delLabContainer && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(parent.getClassType())) {
                control = control.getParent();
                parent = control.getParent();
            }
            if (parent != null && control != null) {
                parent.removeChild(model, control);
                control.setParent(null);
            }
            if (StringUtils.isEmpty((String)(controlName = regionControl.getName()))) continue;
            StatusCollection statuses = model.getStatuses();
            int n = statuses.size();
            for (int i = 0; i < n; ++i) {
                StatusInfo status = statuses.get(i);
                StatusItemCollection items = status.getStatusItems();
                for (int j = items.size() - 1; j >= 0; --j) {
                    StatusItemInfo statusItem = items.get(j);
                    if (!controlName.equals(statusItem.getName())) continue;
                    items.removeObject(j);
                }
            }
        }
    }

    private void createHeaderControls(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo[] bizFields, String dataObjName) {
        if (container == null || bizFields == null || bizFields.length == 0) {
            return;
        }
        for (int i = 0; i < bizFields.length; ++i) {
            BizFieldInfo bizFieldInfo = bizFields[i];
            if (!bizFieldInfo.isGenControl()) continue;
            BizFieldViewInfo viewInfo = bizFieldInfo.getFieldView();
            ViewType viewType = viewInfo.getViewType();
            ComponentInfo parent = this.uiProxyHelper.findParentControl(container, bizFieldInfo);
            if (parent != null) {
                container = parent;
            }
            if (ViewType.CHECKBOX.equals((Object)viewType)) {
                this.createCheckBox(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.DATEPICKER.equals((Object)viewType)) {
                this.createDatePicker(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.TIMEPICKER.equals((Object)viewType)) {
                this.createTimePicker(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.F7SELECTOR.equals((Object)viewType)) {
                this.createBizPromptBox(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.RADIOBUTTON.equals((Object)viewType)) {
                this.createRadioButton(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.TEXTAREA.equals((Object)viewType)) {
                this.createTextArea(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.TEXTFIELD.equals((Object)viewType)) {
                this.createTextField(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (ViewType.FORMATTEXTFIELD.equals((Object)viewType)) {
                this.createFormattedTextField(bizUnit, container, bizFieldInfo, dataObjName);
                continue;
            }
            if (!ViewType.COMBOBOX.equals((Object)viewType)) continue;
            this.createComboBox(bizUnit, container, bizFieldInfo, dataObjName);
        }
    }

    private void createDetailsControl(BizUnitInfo bizUnit, WebUIObjectInfo model, ComponentInfo container, BizGroupFieldInfo[] bizFields, String dataObjName) {
        if (bizUnit == null || model == null || bizFields == null || container == null || bizFields.length == 0) {
            return;
        }
        EntityObjectInfo entity = bizUnit.getEntity();
        if (entity == null) {
            return;
        }
        for (int i = 0; i < bizFields.length; ++i) {
            com.kingdee.bos.metadata.entity.PropertyInfo prop = entity.getPropertyByName(bizFields[i].getPropertyName());
            if (prop == null) continue;
            this.createKDTableForEntity(model, container, bizFields[i], dataObjName, prop.getName());
        }
    }

    private void createKDTableForEntity(WebUIObjectInfo model, ComponentInfo container, BizGroupFieldInfo groupField, String dataObjName, String linkPropName) {
        if (container == null || groupField == null) {
            return;
        }
        EntityObjectInfo entity = groupField.getEntityObject();
        if (entity == null) {
            return;
        }
        String fieldName = groupField.getName();
        String baseName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        String tabName = "kdt" + baseName;
        ComponentInfo kdtControl = WebEditUIProxyHelper.createEditDataGrid(model, container, new Rectangle(0, 0, 600, 170));
        kdtControl.setName(tabName);
        kdtControl.setExtendedProperty("createbutton4editdatagrid", "true");
        groupField.setWebControlName(kdtControl.getName());
        PropertyCollection props = entity.getProperties();
        String entryBeanName = Component2XmlHelper.getEntryBeanName(model, entity);
        PropertyInfo pvar = new PropertyInfo();
        pvar.setName("var");
        pvar.setType("java.lang.String");
        pvar.setValue("data");
        PropertyInfo pvalue = new PropertyInfo();
        pvalue.setName("value");
        pvalue.setType("java.lang.String");
        pvalue.setValue("#{" + entryBeanName + ".listModel}");
        PropertyInfo pbinding = new PropertyInfo();
        pbinding.setName("binding");
        pbinding.setType("java.lang.String");
        pbinding.setValue("#{" + entryBeanName + ".editGrid}");
        PropertyInfo pnum = new PropertyInfo();
        pnum.setName("showRowNumber");
        pnum.setType(Boolean.class.getName());
        pnum.setValue("true");
        PropertyInfo psync = new PropertyInfo();
        psync.setName("sync");
        psync.setType(Boolean.class.getName());
        psync.setValue("true");
        com.kingdee.bos.metadata.ui.PropertyCollection pcs = kdtControl.getProperties();
        pcs.add(pvar);
        pcs.add(pvalue);
        pcs.add(pbinding);
        pcs.add(pnum);
        pcs.add(psync);
        WebUIProxyHelper.addIdColumn(entity, kdtControl, model, dataObjName, linkPropName);
        BizFieldCollection fields = groupField.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (!ObjectStateType.NEW.equals((Object)bizField.getObjectState()) && !ObjectStateType.NEWCONTROL.equals((Object)bizField.getObjectState()) || (bizField.getEffectUI() & 4) == 0 || bizField instanceof BizGroupFieldInfo) continue;
            newBizFields.add(bizField);
        }
        BizFieldInfo[] tempFields = new BizFieldInfo[newBizFields.size()];
        System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
        this.createKDTableProperty(model, groupField, tempFields, dataObjName, kdtControl, linkPropName);
        this.uiProxyHelper.updateComponentRules(model, kdtControl, groupField);
    }

    private static ComponentInfo createEditDataGrid(WebUIObjectInfo model, ComponentInfo parent, Rectangle dataGridRect) {
        if (model == null || parent == null) {
            return null;
        }
        if (dataGridRect == null) {
            dataGridRect = new Rectangle(10, 10, 780, 580);
        }
        ComponentInfo dataGrid = new ComponentInfo("com.kingdee.bos.ctrl.web.EditDataGrid");
        dataGrid.setName(model.getNameManager().getNameByName("dataGrid"));
        dataGrid.setContainer(true);
        dataGrid.setConstraint(new SmartLayoutData(dataGridRect.x, dataGridRect.y, dataGridRect.width, dataGridRect.height, 0));
        LayoutInfo layout = new LayoutInfo();
        layout.setName(model.getNameManager().getNameByName("webLayout"));
        layout.setType("WebLayout");
        layout.setValue("0,1,false");
        dataGrid.setLayoutInfo(layout);
        dataGrid.setParent(parent);
        parent.getComponents().add(dataGrid);
        return dataGrid;
    }

    private void createKDTableProperty(WebUIObjectInfo model, BizGroupFieldInfo groupField, BizFieldInfo[] infos, String dataObjName, ComponentInfo kdtControl, String linkPropName) {
        EntityObjectInfo entity = groupField.getEntityObject();
        if (entity == null) {
            return;
        }
        String entryBeanName = Component2XmlHelper.getEntryBeanName(model, entity);
        for (int i = 0; i < infos.length; ++i) {
            String f7Query;
            CardinalityType cardinal;
            BizFieldInfo field = infos[i];
            String propName = field.getPropertyName();
            com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
            if (StringUtils.isEmpty((String)propName)) {
                if (!DataSourceType.BASEDATAEXT.equals((Object)field.getDataSourceType()) || StringUtils.isEmpty((String)field.getDataField())) continue;
                propName = field.getDataField();
                prop = WebEditUIProxyHelper.getPropertyByName(entity, StringUtils.replace((String)field.getDataField(), (String)(linkPropName + "."), (String)""));
            } else {
                prop = WebEditUIProxyHelper.getPropertyByName(entity, propName);
                propName = linkPropName + "." + propName;
            }
            if (prop == null || (!(prop instanceof LinkPropertyInfo) ? !(prop instanceof OwnPropertyInfo) : !CardinalityType.ONE.equals((Object)(cardinal = ((LinkPropertyInfo)prop).getRelationship().getSupplierCardinality())) && !CardinalityType.ZERO_TO_ONE.equals((Object)cardinal))) continue;
            if ("id".equals(prop.getName())) continue;
            ComponentInfo column = new ComponentInfo("com.kingdee.bos.ctrl.web.EditableColumn");
            column.setContainer(true);
            column.setName(model.getNameManager().getNameByName(field.getName() + "Column"));
            field.setWebControlName(column.getName());
            column.setConstraint("width=170;height=19;newLine=false");
            LayoutInfo layout = new LayoutInfo();
            layout.setType("WebLayout");
            layout.setName(model.getNameManager().getNameByName(field.getName() + "WebLayout"));
            layout.setValue("0,1,false");
            column.setLayoutInfo(layout);
            PropertyInfo pheader = new PropertyInfo();
            pheader.setName("header");
            pheader.setType("java.lang.String");
            pheader.setValue(StringUtils.isEmpty((String)prop.getAlias()) ? prop.getName() : prop.getAlias());
            pheader.setMultiLanguage(true);
            PropertyInfo pwidth = new PropertyInfo();
            pwidth.setName("width");
            pwidth.setType("int");
            pwidth.setValue("100");
            com.kingdee.bos.metadata.ui.PropertyCollection pcs = column.getProperties();
            pcs.add(pheader);
            pcs.add(pwidth);
            String classType = WebUIProxyHelper.getClassType(prop);
            classType = classType == null ? "com.kingdee.bos.ctrl.web.TextField" : classType;
            PropertyBindingInfo propertyBindingInfo = WebUIProxyHelper.createPropBindInfo(classType, linkPropName + "." + prop.getName(), prop, dataObjName);
            column.getPropertyBindings().add(propertyBindingInfo);
            ComponentInfo editor = new ComponentInfo(classType);
            editor.setName(model.getNameManager().getNameByName(field.getName() + "Editor"));
            editor.setConstraint("width=170;height=19;newLine=false");
            if ("com.kingdee.bos.ctrl.web.EnumCombo".equals(classType)) {
                PropertyInfo propInfo = new PropertyInfo();
                propInfo.setName("type");
                propInfo.setType(String.class.getName());
                BizEnumInfo bizenum = ((OwnPropertyInfo)prop).getEnumType();
                String value = bizenum.getPackage() + "." + bizenum.getName();
                propInfo.setValue(value);
                editor.getProperties().add(propInfo);
                propInfo = new PropertyInfo();
                propInfo.setName("converter");
                propInfo.setType(String.class.getName());
                propInfo.setValue("enumsConverter");
                column.getProperties().add(propInfo);
            } else if ("com.kingdee.bos.ctrl.web.DateField".equals(classType) || "com.kingdee.bos.ctrl.web.TimeField".equals(classType) || "com.kingdee.bos.ctrl.web.DateTimeField".equals(classType)) {
                PropertyInfo pCastType = new PropertyInfo();
                pCastType.setName("castType");
                pCastType.setType(String.class.getName());
                DataType dataType = ((OwnPropertyInfo)prop).getDataType();
                if (dataType.equals(DataType.DATE)) {
                    pCastType.setValue(Date.class.getName());
                } else if (dataType.equals(DataType.TIME)) {
                    pCastType.setValue(Time.class.getName());
                } else if (dataType.equals(DataType.TIMESTAMP)) {
                    pCastType.setValue(Timestamp.class.getName());
                } else {
                    throw new IllegalArgumentException("\u4e0d\u662f\u6709\u6548\u7684\u65e5\u671f\u7c7b\u578b");
                }
                editor.getProperties().add(pCastType);
            } else if ("com.kingdee.bos.ctrl.web.PromptBox".equals(classType) && !StringUtils.isEmpty((String)(f7Query = ((LinkPropertyInfo)prop).getRelationship().getSupplierObject().getExtendedProperty("defaultF7Query")))) {
                PropertyInfo pQuery = new PropertyInfo();
                pQuery.setName("queryInfo");
                pQuery.setType("java.lang.String");
                pQuery.setValue(f7Query);
                PropertyInfo pConverter = new PropertyInfo();
                pConverter.setName("converter");
                pConverter.setType("java.lang.String");
                pConverter.setValue("objectValueConverter");
                column.getProperties().add(pConverter);
                PropertyInfo pStroe = new PropertyInfo();
                pStroe.setName("store");
                pStroe.setType("java.lang.String");
                pStroe.setValue("#{" + entryBeanName + ".storeValue('" + prop.getName() + "')}");
                PropertyInfo pFormat = this.createDisplayFormatProperty(field);
                PropertyInfo pEditorFormat = this.createEditFormatProperty(field.getFieldView());
                PropertyInfo pCommitFormat = this.createCommitFormatProperty(field.getFieldView());
                com.kingdee.bos.metadata.ui.PropertyCollection pc = editor.getProperties();
                pc.add(pQuery);
                pc.add(pStroe);
                pc.add(pFormat);
                pc.add(pEditorFormat);
                pc.add(pCommitFormat);
            }
            editor.setParent(column);
            column.getComponents().add(editor);
            column.setParent(kdtControl);
            kdtControl.getComponents().add(column);
        }
    }

    public static String getNumberFormat(int precision) {
        String format = "0.";
        for (int i = 0; i < precision; ++i) {
            format = format + "0";
        }
        return format;
    }

    private void createCheckBox(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo checkBox = new ComponentInfo("com.kingdee.bos.ctrl.web.CheckBox");
        checkBox.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        checkBox.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        checkBox.setConstraint(this.createContraint(container, null));
        this.setControlTabIndex(checkBox, viewInfo);
        container.addChild(bizUnit.getWebEditUI(), checkBox);
        com.kingdee.bos.metadata.ui.PropertyCollection props = checkBox.getProperties();
        props.add(this.createLabelTextProperty(viewInfo, "boxLabel"));
        PropertyBindingCollection pbs = checkBox.getPropertyBindings();
        pbs.add(this.createSelectedPropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setWebControlName(checkBox.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getWebEditUI(), checkBox, bizField);
    }

    private void createRadioButton(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo radioBtn = new ComponentInfo("btn");
        radioBtn.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        radioBtn.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        radioBtn.setConstraint(this.createContraint(container, null));
        this.setControlTabIndex(radioBtn, viewInfo);
        container.addChild(bizUnit.getWebEditUI(), radioBtn);
        com.kingdee.bos.metadata.ui.PropertyCollection props = radioBtn.getProperties();
        props.add(this.createLabelTextProperty(viewInfo, "value"));
        bizField.setWebControlName(radioBtn.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getWebEditUI(), radioBtn, bizField);
    }

    private void createTextField(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createTextFieldForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private void createTextArea(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createTextAreaForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private void createFormattedTextField(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createFormattedTextFieldForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private void createDatePicker(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createDatePickerForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private void createTimePicker(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createTimePickerForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private void createComboBox(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createComboBoxForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private void createBizPromptBox(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo labelContainer = this.createLabelContainer(bizUnit, container, bizField);
        if (labelContainer == null) {
            return;
        }
        this.createBizPromptBoxForLabelContainer(bizUnit, labelContainer, bizField, dataObjName);
    }

    private ComponentInfo createLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return null;
        }
        ComponentInfo labelContainer = new ComponentInfo("com.kingdee.bos.ctrl.web.LabelContainer");
        labelContainer.setName("cont" + bizField.getName());
        labelContainer.setConstraint(this.createContraint(container, null));
        labelContainer.setContainer(true);
        labelContainer.setLayoutInfo(LayoutConverter.convertToInfo(new LabelContainerLayout()));
        container.addChild(bizUnit.getWebEditUI(), labelContainer);
        com.kingdee.bos.metadata.ui.PropertyCollection props = labelContainer.getProperties();
        props.add(this.createBoundLabelTextProperty(bizField));
        props.add(this.createBoundLabelLengthProperty());
        labelContainer.setParent(container);
        return labelContainer;
    }

    private void createTextFieldForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo text = new ComponentInfo("com.kingdee.bos.ctrl.web.TextField");
        text.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        text.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        text.setConstraint(String.valueOf(3));
        this.setControlTabIndex(text, viewInfo);
        container.addChild(bizUnit.getWebEditUI(), text);
        com.kingdee.bos.metadata.ui.PropertyCollection props = text.getProperties();
        props.add(this.createTextProperty(bizField, "value"));
        props.add(this.createMaxLengthProperty(bizField.getLength()));
        PropertyBindingCollection pbs = text.getPropertyBindings();
        pbs.add(this.createTextPropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setWebControlName(text.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getWebEditUI(), text, bizField);
    }

    private void createTextAreaForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo text = new ComponentInfo("com.kingdee.bos.ctrl.web.TextArea");
        text.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        text.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        text.setConstraint("0,0,1,1");
        this.setControlTabIndex(text, viewInfo);
        container.addChild(bizUnit.getWebEditUI(), text);
        com.kingdee.bos.metadata.ui.PropertyCollection props = text.getProperties();
        props.add(this.createTextProperty(bizField, "value"));
        props.add(this.createMaxLengthProperty(bizField.getLength()));
        PropertyBindingCollection pbs = text.getPropertyBindings();
        pbs.add(this.createTextPropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setWebControlName(text.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getWebEditUI(), text, bizField);
    }

    private void createFormattedTextFieldForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo text = new ComponentInfo("com.kingdee.bos.ctrl.web.NumberField");
        text.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        text.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        text.setConstraint(String.valueOf(7));
        this.setControlTabIndex(text, viewInfo);
        container.addChild(bizUnit.getWebEditUI(), text);
        com.kingdee.bos.metadata.ui.PropertyCollection props = text.getProperties();
        props.add(this.createDataTypeProperty(bizField));
        props.add(this.createSupportedEmptyProperty(true));
        if (bizField.getBizDataType() == BizDataType.DECIMAL || bizField.getBizDataType() == BizDataType.QUANTITY || bizField.getBizDataType() == BizDataType.PRICE || bizField.getBizDataType() == BizDataType.AMOUNT) {
            props.add(this.createMinimumValueProperty(bizField.getLength(), bizField.getScale()));
            props.add(this.createMaximumValueProperty(bizField.getLength(), bizField.getScale()));
            if (bizField.getFieldView().getDecimalLength() > 0) {
                props.add(this.createPrecisionProperty(bizField.getFieldView().getDecimalLength()));
            } else {
                props.add(this.createPrecisionProperty(bizField.getScale()));
            }
        }
        PropertyBindingCollection pbs = text.getPropertyBindings();
        pbs.add(this.createValuePropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setWebControlName(text.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getWebEditUI(), text, bizField);
    }

    private void createDatePickerForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo picker = new ComponentInfo("com.kingdee.bos.ctrl.web.DateField");
        picker.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        picker.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        picker.setConstraint(String.valueOf(7));
        this.setControlTabIndex(picker, viewInfo);
        picker.setExtendedProperty("addedByBIM", "true");
        container.addChild(bizUnit.getWebEditUI(), picker);
        com.kingdee.bos.metadata.ui.PropertyCollection pcs = picker.getProperties();
        pcs.add(this.createDateOrTimeProperty(picker, bizUnit.getEntity(), bizField));
        PropertyBindingCollection pbs = picker.getPropertyBindings();
        pbs.add(this.createValuePropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setWebControlName(picker.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getWebEditUI(), picker, bizField);
    }

    private void createTimePickerForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo picker = new ComponentInfo("com.kingdee.bos.ctrl.web.TimeField");
        picker.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        picker.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        picker.setConstraint(String.valueOf(7));
        this.setControlTabIndex(picker, viewInfo);
        container.addChild(bizUnit.getWebEditUI(), picker);
        com.kingdee.bos.metadata.ui.PropertyCollection pcs = picker.getProperties();
        pcs.add(this.createDateOrTimeProperty(picker, bizUnit.getEntity(), bizField));
        PropertyBindingCollection pbs = picker.getPropertyBindings();
        pbs.add(this.createValuePropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setWebControlName(picker.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getWebEditUI(), picker, bizField);
    }

    private void createComboBoxForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo combo = new ComponentInfo("com.kingdee.bos.ctrl.web.EnumCombo");
        combo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        combo.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        combo.setConstraint(String.valueOf(7));
        this.setControlTabIndex(combo, viewInfo);
        container.addChild(bizUnit.getWebEditUI(), combo);
        com.kingdee.bos.metadata.ui.PropertyCollection props = combo.getProperties();
        props.add(this.createTypeProperty(bizUnit.getEntity(), bizField));
        PropertyBindingCollection pbs = combo.getPropertyBindings();
        pbs.add(this.createValuePropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setWebControlName(combo.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getWebEditUI(), combo, bizField);
    }

    private void createBizPromptBoxForLabelContainer(BizUnitInfo bizUnit, ComponentInfo container, BizFieldInfo bizField, String dataObjName) {
        assert (container != null && bizField != null);
        BizFieldViewInfo viewInfo = bizField.getFieldView();
        if (viewInfo == null) {
            logger.warn((Object)("The BizFieldViewInfo of BizFieldInfo " + bizField.getName() + " is null!"));
            return;
        }
        ComponentInfo f7 = new ComponentInfo("com.kingdee.bos.ctrl.web.PromptBox");
        f7.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        f7.setName(this.getPrefix(viewInfo.getViewType()) + bizField.getName());
        f7.setConstraint(String.valueOf(7));
        this.setControlTabIndex(f7, viewInfo);
        container.addChild(bizUnit.getWebEditUI(), f7);
        com.kingdee.bos.metadata.ui.PropertyCollection props = f7.getProperties();
        PropertyInfo prop = this.createQueryInfoProperty(viewInfo);
        if (prop != null) {
            props.add(prop);
        }
        props.add(this.createDisplayFormatProperty(bizField));
        props.add(this.createEditFormatProperty(viewInfo));
        props.add(this.createCommitFormatProperty(viewInfo));
        PropertyBindingCollection pbs = f7.getPropertyBindings();
        pbs.add(this.createF7DataPropBinding(bizUnit.getEntity(), dataObjName, bizField));
        bizField.setWebControlName(f7.getName());
        this.uiProxyHelper.updateComponentRules(bizUnit.getWebEditUI(), f7, bizField);
    }

    private Object createContraint(ComponentInfo parent, Rectangle rect) {
        assert (parent != null);
        if (rect == null) {
            rect = new Rectangle(0, 0, 270, 19);
        }
        return UIProxyHelper.getConstraintByLayout(LayoutConverter.convertToLayoutObj(parent.getLayoutInfo()), rect);
    }

    private PropertyInfo createLabelTextProperty(BizFieldViewInfo viewInfo, String propertyName) {
        assert (viewInfo != null && !StringUtils.isEmpty((String)propertyName));
        String text = viewInfo.getDisplayText();
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName(propertyName);
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(text);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createTextProperty(BizFieldInfo bizFieldInfo, String propertyName) {
        assert (bizFieldInfo != null && !StringUtils.isEmpty((String)propertyName));
        String text = bizFieldInfo.getDefaultValue();
        if (text == null) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName(propertyName);
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(text);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createBoundLabelTextProperty(BizFieldInfo field) {
        assert (field != null);
        BizFieldViewInfo viewInfo = field.getFieldView();
        String text = "";
        if (viewInfo != null) {
            text = viewInfo.getDisplayText();
        }
        if (StringUtils.isEmpty((String)text)) {
            text = field.getAlias();
        }
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("caption");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(text);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createBoundLabelLengthProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("lineWidth");
        prop.setType("int");
        prop.setValue(String.valueOf(100));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createQueryInfoProperty(BizFieldViewInfo viewInfo) {
        assert (viewInfo != null);
        if (StringUtils.isEmpty((String)viewInfo.getF7QueryPK())) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("queryInfo");
        prop.setType(String.class.getName());
        prop.setValue(viewInfo.getF7QueryPK());
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createDisplayFormatProperty(BizFieldInfo fieldInfo) {
        assert (fieldInfo != null);
        String sDataField = fieldInfo.getDataField();
        PropertyInfo prop = new PropertyInfo();
        prop.setName("diaplayFormat");
        prop.setType(String.class.getName());
        if (StringUtils.isEmpty((String)sDataField)) {
            prop.setValue("$name$");
        } else {
            prop.setValue(this.parseStrToDisplayField(sDataField));
        }
        prop.setOverride(true);
        return prop;
    }

    private String parseStrToDisplayField(String sDisField) {
        String strFirst = "";
        String strLeft = "";
        String strSecond = "";
        String strRight = "";
        String strTemp = "";
        String sDisplayFormat = "";
        int iPos = sDisField.indexOf("+");
        if (iPos > 0) {
            strFirst = sDisField.substring(0, iPos).trim();
            strTemp = sDisField.substring(iPos + 2);
            sDisplayFormat = "$" + strFirst + "$";
            if (sDisField.trim().length() > iPos && strTemp.trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                strLeft = strTemp.substring(0, iPos);
                strLeft = strLeft.replaceAll("\"", "");
                sDisplayFormat = sDisplayFormat + strLeft;
                if (strTemp.trim().length() > iPos + 1 && (strTemp = strTemp.substring(iPos + 2)).trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                    strSecond = strTemp.substring(0, iPos);
                    sDisplayFormat = sDisplayFormat + "$" + strSecond.trim() + "$";
                    if (strTemp.length() > iPos + 1) {
                        strRight = strTemp.substring(iPos + 2);
                        strRight = strRight.replaceAll("\"", "");
                        sDisplayFormat = sDisplayFormat + strRight;
                    }
                }
            }
        } else {
            strFirst = sDisField.trim();
            sDisplayFormat = "$" + strFirst + "$";
        }
        return sDisplayFormat;
    }

    private PropertyInfo createEditFormatProperty(BizFieldViewInfo viewInfo) {
        assert (viewInfo != null);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("editFormat");
        prop.setType(String.class.getName());
        prop.setValue("$number$");
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createCommitFormatProperty(BizFieldViewInfo viewInfo) {
        assert (viewInfo != null);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("commitFormat");
        prop.setType(String.class.getName());
        prop.setValue("$number$");
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createSupportedEmptyProperty(boolean isSupportedEmpty) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("supportedEmpty");
        prop.setType("boolean");
        prop.setValue(String.valueOf(isSupportedEmpty));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createMaxLengthProperty(int length) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("maxLength");
        prop.setType("int");
        prop.setValue(String.valueOf(length));
        prop.setOverride(true);
        return prop;
    }

    public static String getMininumValue(int length, int scale) {
        int i;
        if (length <= scale) {
            return null;
        }
        int realLength = length - scale;
        String format = "-";
        double minValue = MinFloat;
        for (i = 0; i < realLength; ++i) {
            format = format + "9";
        }
        if (scale > 0) {
            format = format + ".";
            for (i = 0; i < scale; ++i) {
                format = format + "9";
            }
        }
        try {
            if (Double.parseDouble(format) > minValue) {
                minValue = Double.parseDouble(format);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return String.valueOf(minValue);
    }

    public static String getMaximumValue(int length, int scale) {
        int i;
        if (length <= scale) {
            return null;
        }
        int realLength = length - scale;
        String format = "";
        double maxValue = MaxFloat;
        for (i = 0; i < realLength; ++i) {
            format = format + "9";
        }
        if (scale > 0) {
            format = format + ".";
            for (i = 0; i < scale; ++i) {
                format = format + "9";
            }
        }
        try {
            if (Double.parseDouble(format) < maxValue) {
                maxValue = Double.parseDouble(format);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return String.valueOf(maxValue);
    }

    private PropertyInfo createMinimumValueProperty(int length, int scale) {
        if (length <= scale) {
            return null;
        }
        String format = WebEditUIProxyHelper.getMininumValue(length, scale);
        format = "\"" + format + "\"";
        PropertyInfo prop = new PropertyInfo();
        prop.setName("minimumValue");
        prop.setType(BigDecimal.class.getName());
        prop.setValue(format);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createMaximumValueProperty(int length, int scale) {
        if (length <= scale) {
            return null;
        }
        String format = WebEditUIProxyHelper.getMaximumValue(length, scale);
        format = "\"" + format + "\"";
        PropertyInfo prop = new PropertyInfo();
        prop.setName("maximumValue");
        prop.setType(BigDecimal.class.getName());
        prop.setValue(format);
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createPrecisionProperty(int precision) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("precision");
        prop.setType("int");
        prop.setValue(String.valueOf(precision));
        prop.setOverride(true);
        return prop;
    }

    private PropertyInfo createDataTypeProperty(BizFieldInfo info) {
        assert (info != null);
        PropertyInfo prop = new PropertyInfo();
        prop.setName("dataType");
        prop.setType("int");
        prop.setOverride(true);
        BizDataType type = info.getBizDataType();
        if (BizDataType.AMOUNT.equals((Object)type) || BizDataType.DECIMAL.equals((Object)type) || BizDataType.PRICE.equals((Object)type) || BizDataType.QUANTITY.equals((Object)type)) {
            prop.setValue(String.valueOf(1));
        } else if (BizDataType.INTEGER.equals((Object)type)) {
            prop.setValue(String.valueOf(0));
        } else {
            return null;
        }
        return prop;
    }

    private void setControlTabIndex(ComponentInfo control, BizFieldViewInfo viewInfo) {
        assert (control != null && viewInfo != null);
        int oldIndex = control.getTabIndex();
        control.setTabIndex(viewInfo.getTabIndex());
        if (oldIndex == control.getTabIndex()) {
            control.setOverrideTabIndex(true);
        }
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getPropertyByName(EntityObjectInfo entity, String propertyName) {
        if (entity == null || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        String[] propertys = StringUtils.split((String)propertyName, (String)".");
        com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
        EntityObjectInfo subEntity = entity;
        int n = propertys.length;
        for (int i = 0; i < n && (prop = subEntity.getPropertyByName(propertys[i], true)) != null; ++i) {
            if (prop instanceof OwnPropertyInfo) {
                if (i == n - 1) break;
                prop = null;
                break;
            }
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            subEntity = relation.getSupplierObject();
            if (subEntity != null) continue;
            prop = null;
            break;
        }
        return prop;
    }

    private PropertyInfo createDateOrTimeProperty(ComponentInfo control, EntityObjectInfo entity, BizFieldInfo bizField) {
        if (control == null || bizField == null || entity == null) {
            return null;
        }
        String propName = bizField.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo propInfo = entity.getPropertyByName(propName);
        if (propInfo == null || !(propInfo instanceof OwnPropertyInfo)) {
            return null;
        }
        PropertyInfo pCastType = new PropertyInfo();
        pCastType.setName("castType");
        pCastType.setType(String.class.getName());
        DataType dataType = ((OwnPropertyInfo)propInfo).getDataType();
        if (dataType.equals(DataType.DATE)) {
            pCastType.setValue(Date.class.getName());
        } else if (dataType.equals(DataType.TIME)) {
            pCastType.setValue(Time.class.getName());
        } else if (dataType.equals(DataType.TIMESTAMP)) {
            pCastType.setValue(Timestamp.class.getName());
        } else {
            return null;
        }
        return pCastType;
    }

    private PropertyBindingInfo createTextPropBinding(EntityObjectInfo entity, String dataObjName, BizFieldInfo bizField) {
        com.kingdee.bos.metadata.entity.PropertyInfo propInfo;
        if (StringUtils.isEmpty((String)dataObjName) || bizField == null || entity == null) {
            return null;
        }
        String propName = bizField.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            if (DataSourceType.BASEDATAEXT.equals((Object)bizField.getDataSourceType()) && !StringUtils.isEmpty((String)bizField.getDataField())) {
                propName = bizField.getDataField();
            } else {
                return null;
            }
        }
        if ((propInfo = WebEditUIProxyHelper.getPropertyByName(entity, propName)) == null || !(propInfo instanceof OwnPropertyInfo)) {
            return null;
        }
        PropertyBindingInfo pb = new PropertyBindingInfo();
        pb.setPropertyName("text");
        pb.setPropertyType(String.class.getName());
        pb.setBindingObject(dataObjName);
        pb.setBingdingField(propName);
        pb.setFieldType(((OwnPropertyInfo)propInfo).getJavaType());
        pb.setAccessType(2);
        pb.setAutoMode(false);
        pb.setOverride(true);
        return pb;
    }

    private PropertyBindingInfo createValuePropBinding(EntityObjectInfo entity, String dataObjName, BizFieldInfo bizField) {
        if (StringUtils.isEmpty((String)dataObjName) || bizField == null || entity == null) {
            return null;
        }
        String propName = bizField.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo propInfo = entity.getPropertyByName(propName);
        if (propInfo == null || !(propInfo instanceof OwnPropertyInfo)) {
            return null;
        }
        propName = propInfo.getName();
        PropertyBindingInfo pb = new PropertyBindingInfo();
        pb.setPropertyName("value");
        pb.setPropertyType(Object.class.getName());
        pb.setBindingObject(dataObjName);
        pb.setBingdingField(propName);
        pb.setFieldType(((OwnPropertyInfo)propInfo).getJavaType());
        pb.setAccessType(2);
        pb.setAutoMode(false);
        pb.setOverride(true);
        return pb;
    }

    private PropertyInfo createTypeProperty(EntityObjectInfo entity, BizFieldInfo bizField) {
        if (bizField == null || entity == null) {
            return null;
        }
        BizEnumInfo bizEnum = null;
        if (BizDataType.ENUM.equals((Object)bizField.getBizDataType()) && bizField.getEnumType() != null) {
            bizEnum = bizField.getEnumType();
        } else {
            String propName = bizField.getPropertyName();
            if (StringUtils.isEmpty((String)propName)) {
                return null;
            }
            com.kingdee.bos.metadata.entity.PropertyInfo propInfo = entity.getPropertyByName(propName);
            if (propInfo == null || !(propInfo instanceof OwnPropertyInfo)) {
                return null;
            }
            if (((OwnPropertyInfo)propInfo).getEnumType() == null) {
                return null;
            }
            bizEnum = ((OwnPropertyInfo)propInfo).getEnumType();
        }
        PropertyInfo conPropInfo = new PropertyInfo();
        conPropInfo.setName("type");
        conPropInfo.setType(String.class.getName());
        conPropInfo.setMultiLanguage(false);
        String value = bizEnum.getPackage() + "." + bizEnum.getName();
        conPropInfo.setValue(value);
        return conPropInfo;
    }

    private PropertyBindingInfo createF7DataPropBinding(EntityObjectInfo entity, String dataObjName, BizFieldInfo bizField) {
        if (StringUtils.isEmpty((String)dataObjName) || bizField == null || entity == null) {
            return null;
        }
        String propName = bizField.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo propInfo = entity.getPropertyByName(propName);
        if (propInfo == null || !(propInfo instanceof LinkPropertyInfo)) {
            return null;
        }
        propName = propInfo.getName();
        PropertyBindingInfo pb = new PropertyBindingInfo();
        pb.setPropertyName("value");
        pb.setPropertyType(Object.class.getName());
        pb.setBindingObject(dataObjName);
        pb.setBingdingField(propName);
        pb.setFieldType(((LinkPropertyInfo)propInfo).getRelationship().getSupplierObject().getObjectValueClass());
        pb.setAccessType(2);
        pb.setAutoMode(false);
        pb.setOverride(true);
        return pb;
    }

    private PropertyBindingInfo createSelectedPropBinding(EntityObjectInfo entity, String dataObjName, BizFieldInfo bizField) {
        if (StringUtils.isEmpty((String)dataObjName) || bizField == null || entity == null) {
            return null;
        }
        String propName = bizField.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo propInfo = entity.getPropertyByName(propName);
        if (propInfo == null || !(propInfo instanceof OwnPropertyInfo)) {
            return null;
        }
        propName = propInfo.getName();
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("value");
        propertyBindingInfo.setPropertyType("boolean");
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(dataObjName);
        propertyBindingInfo.setBingdingField(propName);
        propertyBindingInfo.setFieldType(((OwnPropertyInfo)propInfo).getJavaType());
        propertyBindingInfo.setOverride(true);
        return propertyBindingInfo;
    }

    private String getPrefix(ViewType type) {
        if (type == null) {
            return "";
        }
        String classType = (String)this.controlMap.get((Object)type);
        if (StringUtils.isEmpty((String)classType)) {
            return "";
        }
        String value = WebControlConstant.getControlNamePrefix(classType);
        if (value == null) {
            return "";
        }
        return value;
    }

    private String getPrefix(String classType) {
        if (StringUtils.isEmpty((String)classType)) {
            return "";
        }
        String value = WebControlConstant.getControlNamePrefix(classType);
        if (value == null) {
            return "";
        }
        return value;
    }

    private void initControlMap() {
        this.controlMap.put(ViewType.CHECKBOX, "com.kingdee.bos.ctrl.web.CheckBox");
        this.controlMap.put(ViewType.DATEPICKER, "com.kingdee.bos.ctrl.web.DateField");
        this.controlMap.put(ViewType.LABEL, "com.kingdee.bos.ctrl.web.Label");
        this.controlMap.put(ViewType.RADIOBUTTON, "com.kingdee.bos.ctrl.web.RadioButton");
        this.controlMap.put(ViewType.TABLEVIEW, "com.kingdee.bos.ctrl.web.EditDataGrid");
        this.controlMap.put(ViewType.TEXTFIELD, "com.kingdee.bos.ctrl.web.TextField");
        this.controlMap.put(ViewType.TEXTAREA, "com.kingdee.bos.ctrl.web.TextArea");
        this.controlMap.put(ViewType.FORMATTEXTFIELD, "com.kingdee.bos.ctrl.web.NumberField");
        this.controlMap.put(ViewType.F7SELECTOR, "com.kingdee.bos.ctrl.web.PromptBox");
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getColumnBindProperty(WebUIObjectInfo model, ComponentInfo cInfo, String columnName) {
        if (model == null || cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        String bindObjectName = "";
        String tableColumnName = "";
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            bindObjectName = pbInfo.getBindingObject();
            String sbindField = pbInfo.getBingdingField();
            int m = model.getDataObjects().size();
            for (int i = 0; i < m; ++i) {
                IObjectValue objectValue;
                if (!model.getDataObjects().get(i).getName().equals(bindObjectName) || (objectValue = model.getDataObjects().get(i).getInstance()) == null || !(objectValue instanceof EntityObjectInfo)) continue;
                EntityObjectInfo entity = (EntityObjectInfo)objectValue;
                return WebEditUIProxyHelper.getPropertyByName(entity, sbindField);
            }
        }
        return null;
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getColumnBindProperty(EntityObjectInfo entity, ComponentInfo cInfo, String columnName) {
        if (entity == null || cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        String tableColumnName = "";
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            String sbindField = pbInfo.getBingdingField();
            return WebEditUIProxyHelper.getPropertyByName(entity, sbindField);
        }
        return null;
    }

    public static String getColumnBindQueryPK(WebUIObjectInfo model, ComponentInfo cInfo, String columnName) {
        String sQueryPK;
        RelationshipInfo relationShip;
        EntityObjectInfo supplyEntityInfo;
        if (model == null || cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo prop = WebEditUIProxyHelper.getColumnBindProperty(model, cInfo, columnName);
        if (prop != null && prop instanceof LinkPropertyInfo && (supplyEntityInfo = (relationShip = ((LinkPropertyInfo)prop).getRelationship()).getSupplierObject()) != null && !StringUtils.isEmpty((String)(sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query")))) {
            return sQueryPK;
        }
        return null;
    }

    public static String getColumnBindQueryPK(EntityObjectInfo entity, ComponentInfo cInfo, String columnName) {
        String sQueryPK;
        RelationshipInfo relationShip;
        EntityObjectInfo supplyEntityInfo;
        if (entity == null || cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo prop = WebEditUIProxyHelper.getColumnBindProperty(entity, cInfo, columnName);
        if (prop != null && prop instanceof LinkPropertyInfo && (supplyEntityInfo = (relationShip = ((LinkPropertyInfo)prop).getRelationship()).getSupplierObject()) != null && !StringUtils.isEmpty((String)(sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query")))) {
            return sQueryPK;
        }
        return null;
    }

    private static String getBindFieldName(PropertyBindingCollection propBindings, String propertyName) {
        int n = propBindings.size();
        for (int i = 0; i < n; ++i) {
            if (!propertyName.equalsIgnoreCase(propBindings.get(i).getPropertyName())) continue;
            return propBindings.get(i).getBingdingField();
        }
        return null;
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getBindingProperty(AbstractUIObjectInfo model, ComponentInfo control, String propertyName) {
        EntityObjectInfo entity;
        String bindFieldName;
        if (model == null || control == null || control.getClassType() == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)propertyName) && !StringUtils.isEmpty((String)(bindFieldName = WebEditUIProxyHelper.getBindFieldName(control.getPropertyBindings(), propertyName))) && model.getDataObjects() != null && model.getDataObjects().size() > 0 && model.getDataObjects().get(0).getObjectType().equals(MetaDataTypeList.ENTITY.toString()) && (entity = (EntityObjectInfo)model.getDataObjects().get(0).getInstance()) != null) {
            return WebEditUIProxyHelper.getPropertyByName(entity, bindFieldName);
        }
        return null;
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getBindingProperty(AbstractUIObjectInfo model, ComponentInfo control) {
        if (model == null || control == null || control.getClassType() == null) {
            return null;
        }
        if ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(control.getClassType())) {
            ComponentCollection components = control.getComponents();
            int n = components.size();
            for (int i = 0; i < n; ++i) {
                EntityObjectInfo entity;
                String bindFieldName;
                if (components.get(i).getPropertyBindings().size() <= 0 || StringUtils.isEmpty((String)(bindFieldName = WebEditUIProxyHelper.getBindFieldName(components.get(i).getPropertyBindings(), "value"))) || bindFieldName.indexOf(".") < 0) continue;
                bindFieldName = bindFieldName.substring(0, bindFieldName.indexOf("."));
                if (model.getDataObjects() == null || model.getDataObjects().size() <= 0 || !model.getDataObjects().get(0).getObjectType().equals(MetaDataTypeList.ENTITY.toString()) || (entity = (EntityObjectInfo)model.getDataObjects().get(0).getInstance()) == null) continue;
                return WebEditUIProxyHelper.getPropertyByName(entity, bindFieldName);
            }
            return null;
        }
        return WebEditUIProxyHelper.getBindingProperty(model, control, "value");
    }
}

