/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp;

import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.dtp.StringConverter;
import com.kingdee.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class EventInfoHelper {
    private static EventInfoHelper instance;
    private static final String LISTENER = "Listener";
    private static final String ADAPTER = "Adapter";
    private Hashtable eventDescriptorsHash = new Hashtable();
    private Hashtable propDescriptorsHash = new Hashtable();
    private Hashtable instanceHash = new Hashtable();
    private Hashtable changeEventHash = new Hashtable();

    private EventInfoHelper() {
        this.initChangeEventHash();
    }

    public static EventInfoHelper getInstance() {
        if (instance == null) {
            instance = new EventInfoHelper();
        }
        return instance;
    }

    public PropertyInfo getProperty(String className, String propertyName) {
        if (StringUtils.isEmpty((String)className) || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        PropertyDescriptor[] propDescs = (PropertyDescriptor[])this.propDescriptorsHash.get(className);
        Object control = this.instanceHash.get(className);
        if (propDescs == null || control == null) {
            BeanInfo beanInfo;
            try {
                Class<?> cl = Class.forName(className);
                control = cl.newInstance();
                beanInfo = Introspector.getBeanInfo(cl);
            }
            catch (Exception ex) {
                return null;
            }
            propDescs = beanInfo.getPropertyDescriptors();
            this.propDescriptorsHash.put(className, propDescs);
            this.instanceHash.put(className, control);
        }
        return this.getPropertyInfo(control, propDescs, propertyName);
    }

    public EventBindingInfo getEventInfo(String className, String eventName) {
        if (StringUtils.isEmpty((String)className) || StringUtils.isEmpty((String)eventName)) {
            return null;
        }
        EventSetDescriptor[] eventDescs = (EventSetDescriptor[])this.eventDescriptorsHash.get(className);
        if (eventDescs == null) {
            BeanInfo beanInfo;
            try {
                Class<?> cl = Class.forName(className);
                Object control = cl.newInstance();
                beanInfo = Introspector.getBeanInfo(cl);
            }
            catch (Exception ex) {
                return null;
            }
            eventDescs = beanInfo.getEventSetDescriptors();
            this.eventDescriptorsHash.put(className, eventDescs);
        }
        return this.getEventBindingInfo(eventDescs, eventName);
    }

    public EventBindingInfo getChangeEventInfo(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return null;
        }
        String eventName = this.getEventName(className);
        if (StringUtils.isEmpty((String)eventName)) {
            return null;
        }
        return this.getEventInfo(className, eventName);
    }

    private EventBindingInfo getEventBindingInfo(EventSetDescriptor[] eventDescs, String eventName) {
        assert (eventDescs != null && !StringUtils.isEmpty((String)eventName));
        for (int i = 0; i < eventDescs.length; ++i) {
            Method[] methods = eventDescs[i].getListenerMethods();
            for (int j = 0; j < methods.length; ++j) {
                if (!eventName.equals(methods[j].getName())) continue;
                EventBindingInfo event = new EventBindingInfo();
                event.setEventName(eventName);
                event.setEventType(methods[j].getParameterTypes()[0].getName());
                String listenerType = eventDescs[i].getListenerType().getName();
                event.setListenerType(listenerType);
                if (methods.length > 1) {
                    event.setListenerAdapter(StringUtils.replace((String)listenerType, (String)LISTENER, (String)ADAPTER));
                } else {
                    event.setListenerAdapter(listenerType);
                }
                return event;
            }
        }
        return null;
    }

    private PropertyInfo getPropertyInfo(Object control, PropertyDescriptor[] propDescs, String propName) {
        assert (propDescs != null && !StringUtils.isEmpty((String)propName));
        for (int i = 0; i < propDescs.length; ++i) {
            String name = propDescs[i].getName();
            if (!propName.equals(name)) continue;
            PropertyInfo prop = new PropertyInfo();
            prop.setName(name);
            prop.setType(propDescs[i].getPropertyType().getName());
            String defValue = null;
            try {
                Object value = propDescs[i].getReadMethod().invoke(control, null);
                defValue = StringConverter.convertToString(propDescs[i].getPropertyType(), value);
            }
            catch (Exception e) {
                defValue = null;
            }
            prop.setValue(defValue);
            if ("text".equals(propName) || "toolTipText".equals(propName)) {
                prop.setMultiLanguage(true);
            } else {
                prop.setMultiLanguage(false);
            }
            return prop;
        }
        return null;
    }

    private String getEventName(String classType) {
        return (String)this.changeEventHash.get(classType);
    }

    private void initChangeEventHash() {
        this.changeEventHash.put("com.kingdee.bos.ctrl.swing.KDDatePicker", "dataChanged");
        this.changeEventHash.put("com.kingdee.bos.ctrl.swing.KDTextField", "keyPressed");
        this.changeEventHash.put("com.kingdee.bos.ctrl.swing.KDTextArea", "keyPressed");
        this.changeEventHash.put("com.kingdee.bos.ctrl.swing.KDSpinner", "stateChanged");
        this.changeEventHash.put("com.kingdee.bos.ctrl.swing.KDSlider", "stateChanged");
        this.changeEventHash.put("com.kingdee.bos.ctrl.swing.KDPasswordField", "keyPressed");
        this.changeEventHash.put("com.kingdee.bos.ctrl.swing.KDFormattedTextField", "dataChanged");
        this.changeEventHash.put("com.kingdee.bos.ctrl.swing.KDNumberTextField", "dataChanged");
        this.changeEventHash.put("com.kingdee.bos.ctrl.swing.KDTimePicker", "dataChanged");
        this.changeEventHash.put("com.kingdee.bos.ctrl.swing.KDCurrencyTextField", "dataChanged");
        this.changeEventHash.put("com.kingdee.bos.ctrl.swing.KDComboBox", "itemStateChanged");
        this.changeEventHash.put("com.kingdee.bos.ctrl.swing.KDCheckBox", "actionPerformed");
        this.changeEventHash.put("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea", "itemStateChanged");
        this.changeEventHash.put("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox", "itemStateChanged");
        this.changeEventHash.put("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox", "stateChanged");
    }
}

