/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp;

import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class StringConverter {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.ui.dtp.StringConverter");
    public static final String BooleanType = "java.lang.Boolean";
    public static final String ByteType = "java.lang.Byte";
    public static final String DoubleType = "java.lang.Double";
    public static final String FloatType = "java.lang.Float";
    public static final String IntegerType = "java.lang.Integer";
    public static final String LongType = "java.lang.Long";
    public static final String StringType = "java.lang.String";
    public static final String CharacterType = "java.lang.Character";
    public static final String DimensionType = "java.awt.Dimension";
    public static final String InsetsType = "java.awt.Insets";
    public static final String RectangleType = "java.awt.Rectangle";
    public static final String PointType = "java.awt.Point";
    public static final String FontType = "java.awt.Font";
    public static final String ColorType = "java.awt.Color";
    public static final String KDLayoutConstraintType = "com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint";
    public static final String SwingConstantsType = "javax.swing.SwingConstants";
    public static final String GridLayoutType = "GridLayout";
    public static final String XYLayoutType = "XYLayout";
    public static final String ConstraintsType = "Constraints";
    protected static ArrayList supportTypes = new ArrayList();

    public boolean isSupportType(Class type) {
        return this.isSupportType(type.getName());
    }

    public boolean isSupportType(String typeName) {
        return supportTypes.contains(typeName);
    }

    public static String convertToString(Class type, Object value) {
        return StringConverter.convertToString(type.getName(), value);
    }

    public static String convertToString(KDLayoutConstraint constraint) {
        if (constraint == null) {
            return "";
        }
        return constraint.x + "," + constraint.y + "," + constraint.width + "," + constraint.height + "," + constraint.anchor;
    }

    public static String convertToString(String typeName, Object value) {
        if (value == null) {
            return "";
        }
        try {
            if (StringType.equals(typeName)) {
                return value.toString();
            }
            if (BooleanType.equals(typeName)) {
                return value.toString();
            }
            if (ByteType.equals(typeName)) {
                return value.toString();
            }
            if (DoubleType.equals(typeName)) {
                return value.toString();
            }
            if (FloatType.equals(typeName)) {
                return value.toString();
            }
            if (IntegerType.equals(typeName)) {
                return value.toString();
            }
            if (LongType.equals(typeName)) {
                return value.toString();
            }
            if (CharacterType.equals(typeName)) {
                return value.toString();
            }
            if (DimensionType.equals(typeName)) {
                Dimension size = (Dimension)value;
                return size.width + "," + size.height;
            }
            if (PointType.equals(typeName)) {
                Point pt = (Point)value;
                return pt.x + "," + pt.y;
            }
            if (InsetsType.equals(typeName)) {
                Insets insets = (Insets)value;
                return insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right;
            }
            if (RectangleType.equals(typeName)) {
                Rectangle rect = (Rectangle)value;
                return rect.x + "," + rect.y + "," + rect.width + "," + rect.height;
            }
            if (FontType.equals(typeName)) {
                Font font = (Font)value;
                String retValue = "family=" + font.getFamily() + ",name=" + font.getName() + ",style=" + font.getStyle() + ",size=" + font.getSize();
                return retValue;
            }
            if (ColorType.equals(typeName)) {
                if (value instanceof Color) {
                    Color color = (Color)value;
                    return "r=" + color.getRed() + ",g=" + color.getGreen() + ",b=" + color.getBlue();
                }
                return value.toString();
            }
            if (KDLayoutConstraintType.equals(typeName)) {
                return StringConverter.convertToString((KDLayoutConstraint)value);
            }
            if (SwingConstantsType.equals(typeName)) {
                return value.toString();
            }
            if (typeName.indexOf("[L") >= 0) {
                String itemType = typeName.substring(2, typeName.length() - 1);
                String retValue = "";
                Object[] a = (Object[])value;
                int n = a.length;
                for (int i = 0; i < n; ++i) {
                    retValue = i == 0 ? StringConverter.convertToString(itemType, a[i]) : retValue + ";" + StringConverter.convertToString(itemType, a[i]);
                }
                return retValue;
            }
            return value.toString();
        }
        catch (Exception e) {
            logger.error((Object)("Convert " + typeName + " type to String type failed!"));
            return "";
        }
    }

    public static Object convertToObject(Class type, String value) {
        return StringConverter.convertToObject(type.getName(), value);
    }

    public static Object convertToObject(String typeName, String value) {
        if (value == null) {
            return null;
        }
        try {
            if (StringType.equals(typeName)) {
                return value;
            }
            if (BooleanType.equals(typeName)) {
                return Boolean.valueOf(value);
            }
            if (ByteType.equals(typeName)) {
                return Byte.valueOf(value);
            }
            if (DoubleType.equals(typeName)) {
                return Double.valueOf(value);
            }
            if (FloatType.equals(typeName)) {
                if (StringUtils.isEmpty((String)value)) {
                    return new Float(0.0f);
                }
                return Float.valueOf(value);
            }
            if (IntegerType.equals(typeName)) {
                if (StringUtils.isEmpty((String)value)) {
                    return new Integer(0);
                }
                return Integer.valueOf(value);
            }
            if (LongType.equals(typeName)) {
                return Long.valueOf(value);
            }
            if (CharacterType.equals(typeName)) {
                return new Character(value.charAt(0));
            }
            if (DimensionType.equals(typeName)) {
                String[] sa = StringUtils.split((String)value, (String)",");
                int width = Integer.parseInt(sa[0]);
                int height = Integer.parseInt(sa[1]);
                return new Dimension(width, height);
            }
            if (PointType.equals(typeName)) {
                String[] sa = StringUtils.split((String)value, (String)",");
                int x = Integer.parseInt(sa[0]);
                int y = Integer.parseInt(sa[1]);
                return new Point(x, y);
            }
            if (RectangleType.equals(typeName)) {
                if (StringUtils.isEmpty((String)value)) {
                    return null;
                }
                String[] sa = StringUtils.split((String)value, (String)",");
                if (sa.length != 4 && sa.length != 5) {
                    return null;
                }
                int x = Integer.parseInt(sa[0]);
                int y = Integer.parseInt(sa[1]);
                int width = Integer.parseInt(sa[2]);
                int height = Integer.parseInt(sa[3]);
                return new Rectangle(x, y, width, height);
            }
            if (InsetsType.equals(typeName)) {
                if (StringUtils.isEmpty((String)value)) {
                    return null;
                }
                String[] sa = StringUtils.split((String)value, (String)",");
                int top = Integer.parseInt(sa[0]);
                int left = Integer.parseInt(sa[1]);
                int bottom = Integer.parseInt(sa[2]);
                int right = Integer.parseInt(sa[3]);
                return new Insets(top, left, bottom, right);
            }
            if (FontType.equals(typeName)) {
                String[] sa = StringUtils.split((String)value, (String)",");
                String family = "dialog";
                String name = "";
                int style = 0;
                int size = 12;
                int n = sa.length;
                for (int i = 0; i < n; ++i) {
                    if (sa[i].indexOf("family") >= 0) {
                        family = sa[i].substring("family".length() + 1);
                        continue;
                    }
                    if (sa[i].indexOf("name") >= 0) {
                        name = sa[i].substring("name".length() + 1);
                        continue;
                    }
                    if (sa[i].indexOf("style") >= 0) {
                        style = Integer.valueOf(sa[i].substring("style".length() + 1));
                        continue;
                    }
                    if (sa[i].indexOf("size") < 0) continue;
                    size = Integer.valueOf(sa[i].substring("size".length() + 1));
                }
                Font font = new Font(name, style, size);
                return font;
            }
            if (ColorType.equals(typeName)) {
                Color color = Color.getColor(value);
                if (color == null) {
                    String[] sa = StringUtils.split((String)value, (String)",");
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    int n = sa.length;
                    for (int i = 0; i < n; ++i) {
                        if (sa[i].indexOf("r") >= 0) {
                            r = Integer.valueOf(sa[i].substring("r".length() + 1));
                            continue;
                        }
                        if (sa[i].indexOf("g") >= 0) {
                            g = Integer.valueOf(sa[i].substring("g".length() + 1));
                            continue;
                        }
                        if (sa[i].indexOf("b") < 0) continue;
                        b = Integer.valueOf(sa[i].substring("b".length() + 1));
                    }
                    color = new Color(r, g, b);
                }
                return color;
            }
            if (KDLayoutConstraintType.equals(typeName)) {
                return StringConverter.convertToKDLayoutConstraint(value);
            }
            if (SwingConstantsType.equals(typeName)) {
                Field field = Class.forName(SwingConstantsType).getField(StringUtils.replace((String)value, (String)"javax.swing.SwingConstants.", (String)""));
                if (field != null) {
                    return field.get(null);
                }
                return value;
            }
            if (typeName.indexOf("[L") >= 0) {
                String itemType = typeName.substring(2, typeName.length() - 1);
                String[] sa = StringUtils.split((String)value, (String)";");
                Object[] oa = (Object[])Array.newInstance(Class.forName(itemType), sa.length);
                int n = sa.length;
                for (int i = 0; i < n; ++i) {
                    oa[i] = StringConverter.convertToObject(itemType, sa[i]);
                }
                return oa;
            }
            return value;
        }
        catch (Exception e) {
            logger.error((Object)("Convert String type to " + typeName + " type failed!"), (Throwable)e);
            return null;
        }
    }

    public static Boolean convertToBoolean(String value) {
        return (Boolean)StringConverter.convertToObject(BooleanType, value);
    }

    public static Integer convertToInteger(String value) {
        return (Integer)StringConverter.convertToObject(IntegerType, value);
    }

    public static Float convertToFloat(String value) {
        return (Float)StringConverter.convertToObject(FloatType, value);
    }

    public static Color convertToColor(String value) {
        return (Color)StringConverter.convertToObject(ColorType, value);
    }

    public static Dimension convertToDimension(String value) {
        return (Dimension)StringConverter.convertToObject(DimensionType, value);
    }

    public static Insets convertToInsets(String value) {
        return (Insets)StringConverter.convertToObject(InsetsType, value);
    }

    public static Font convertToFont(String value) {
        return (Font)StringConverter.convertToObject(FontType, value);
    }

    public static Rectangle convertToRectangle(String value) {
        return (Rectangle)StringConverter.convertToObject(RectangleType, value);
    }

    public static KDLayoutConstraint convertToKDLayoutConstraint(String value) {
        try {
            int anchor;
            String[] sa = StringUtils.split((String)value, (String)",");
            int x = Integer.parseInt(sa[0]);
            int y = Integer.parseInt(sa[1]);
            int width = Integer.parseInt(sa[2]);
            int height = Integer.parseInt(sa[3]);
            try {
                anchor = Integer.parseInt(sa[4]);
            }
            catch (Exception ex) {
                anchor = 0;
            }
            return new KDLayoutConstraint(x, y, width, height, anchor);
        }
        catch (Exception e) {
            logger.error((Object)"Convert String type to KDLayoutConstraint type failed!");
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.replace((String)"aa", (String)"ba", (String)"null"));
    }

    public static void main2(String[] args) {
        Object value = null;
        System.out.println(StringConverter.convertToString("", null));
        System.out.println(StringConverter.convertToObject("", null));
        value = Boolean.TRUE;
        System.out.println(StringConverter.convertToString(BooleanType, value));
        System.out.println(StringConverter.convertToObject(BooleanType, "true"));
        value = Byte.valueOf("123");
        System.out.println(StringConverter.convertToString(ByteType, value));
        System.out.println(StringConverter.convertToObject(ByteType, "123"));
        value = new Character('H');
        System.out.println(StringConverter.convertToString(CharacterType, value));
        System.out.println(StringConverter.convertToObject(CharacterType, "H"));
        value = "123";
        System.out.println(StringConverter.convertToString(StringType, value));
        System.out.println(StringConverter.convertToObject(StringType, "123"));
        value = new Long(123L);
        System.out.println(StringConverter.convertToString(LongType, value));
        System.out.println(StringConverter.convertToObject(LongType, "123"));
        value = new Integer(123);
        System.out.println(StringConverter.convertToString(IntegerType, value));
        System.out.println(StringConverter.convertToObject(IntegerType, "123"));
        value = new Double(123.0);
        System.out.println(StringConverter.convertToString(DoubleType, value));
        System.out.println(StringConverter.convertToObject(DoubleType, "123.00"));
        value = new Float(123.0);
        System.out.println(StringConverter.convertToString(FloatType, value));
        System.out.println(StringConverter.convertToObject(FloatType, "123.00"));
        value = new String[]{"a", "b"};
        System.out.println(StringConverter.convertToString(value.getClass().getName(), value));
        System.out.println(StringConverter.convertToObject("[Ljava.lang.String", "a;b"));
        value = new Dimension(1, 2);
        System.out.println(StringConverter.convertToString(DimensionType, value));
        System.out.println(StringConverter.convertToObject(DimensionType, "1,2"));
        value = new Integer(1);
        System.out.println(StringConverter.convertToString(SwingConstantsType, value));
        System.out.println(StringConverter.convertToObject(SwingConstantsType, "LEFT"));
        value = new Font("alog", 4, 11);
        System.out.println(StringConverter.convertToString(FontType, value));
        System.out.println(StringConverter.convertToObject(FontType, "family=dialog,name=alog,style=0,size=11"));
        System.out.println(StringConverter.convertToString(ColorType, value));
        System.out.println(StringConverter.convertToObject(ColorType, "RED"));
        System.out.println(StringConverter.convertToString(ColorType, (Object)"r=111,g=11,b=0"));
    }

    static {
        supportTypes.add(BooleanType);
        supportTypes.add(ByteType);
        supportTypes.add(DoubleType);
        supportTypes.add(FloatType);
        supportTypes.add(IntegerType);
        supportTypes.add(LongType);
        supportTypes.add(StringType);
        supportTypes.add(CharacterType);
        supportTypes.add(DimensionType);
        supportTypes.add(FontType);
        supportTypes.add(ColorType);
        supportTypes.add(SwingConstantsType);
        supportTypes.add(InsetsType);
        supportTypes.add(PointType);
        supportTypes.add(RectangleType);
    }
}

