/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp;

import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.UIGeneratorHelper;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Vector;

public class UIGenerator {
    public static void generateUIFromQuery(QueryInfo query, UIObjectInfo model, LanguageCollection locales) {
        boolean herited = model.getParent() != null;
        SelectorInfo selector = query.getSelector();
        if (selector == null || selector.size() == 0) {
            return;
        }
        int size = selector.size();
        QueryFieldInfo[] infos = new QueryFieldInfo[size];
        for (int i = 0; i < size; ++i) {
            infos[i] = selector.get(i);
        }
        UIGenerator.generateUIFromQuery(query, model, infos, herited, locales);
    }

    public static void generateUIFromQuery(QueryInfo query, UIObjectInfo model, QueryFieldInfo[] fields, boolean herited, LanguageCollection locales) {
        if (!herited) {
            DataObjectInfo doInfo = new DataObjectInfo();
            String doName = "query" + query.getName();
            doInfo.setName(doName);
            String type = "";
            if (!StringUtils.isEmpty((String)query.getPackage())) {
                type = query.getPackage() + ".";
            }
            type = type + query.getName();
            doInfo.setType(type);
            doInfo.setObjectType(query.getBOSType().toString());
            model.getDataObjects().add(doInfo);
            UIGeneratorHelper.createKDTableForQuery(model, fields, doName, 1, 0, locales);
        } else {
            UIGeneratorHelper.replaceKDTableForQuery(model, fields, query, 1, 0, locales);
        }
    }

    public static void generateUIFromEntity(EntityObjectInfo entity, UIObjectInfo model, LanguageCollection locales) {
        if (entity == null) {
            return;
        }
        PropertyControlPair[] pairs = UIGenerator.genPropertyControlPairs(entity);
        boolean herited = model.getParent() != null;
        UIGenerator.generateUIFromEntity(entity, model, pairs, herited, locales);
    }

    public static void generateUIFromEntity(EntityObjectInfo entity, UIObjectInfo model, PropertyControlPair[] pairs, boolean herited, LanguageCollection locales) {
        if (entity == null || pairs == null || pairs.length == 0) {
            return;
        }
        boolean needToAppendDO = true;
        String doName = "entity" + entity.getName();
        String classType = "";
        if (!StringUtils.isEmpty((String)entity.getPackage())) {
            classType = entity.getPackage() + ".";
        }
        classType = classType + entity.getName();
        if (herited) {
            DataObjectCollection collection = model.getDataObjects();
            String oldDataObjName = null;
            int j = collection.size();
            for (int i = 0; i < j; ++i) {
                DataObjectInfo dataObj = collection.get(i);
                String tempType = dataObj.getObjectType();
                if (!MetaDataTypeList.ENTITY.toString().equals(tempType)) continue;
                oldDataObjName = dataObj.getName();
                dataObj.setType(classType);
                dataObj.setOverride(true);
                dataObj.setWriteCode(true);
                needToAppendDO = false;
                doName = dataObj.getName();
                break;
            }
        }
        if (needToAppendDO) {
            DataObjectInfo doInfo = new DataObjectInfo();
            doInfo.setName(doName);
            doInfo.setType(classType);
            doInfo.setObjectType(entity.getBOSType().toString());
            model.getDataObjects().add(doInfo);
        }
        int row = 1;
        int col = 0;
        int j = pairs.length;
        for (int i = 0; i < j; ++i) {
            PropertyInfo prop = pairs[i].property;
            String controlType = pairs[i].controlType;
            if (prop instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                if ("com.kingdee.bos.ctrl.swing.KDCheckBox".equals(controlType)) {
                    UIGeneratorHelper.createCheckBox(model, ownProp, doName, row, col);
                    col = (col + 1) % 2;
                    if (col != 0) continue;
                    row += 3;
                    continue;
                }
                if ("com.kingdee.bos.ctrl.swing.KDTextField".equals(controlType)) {
                    UIGeneratorHelper.createTextField(model, ownProp, doName, row, col);
                    col = (col + 1) % 2;
                    if (col != 0) continue;
                    row += 3;
                    continue;
                }
                if ("com.kingdee.bos.ctrl.swing.KDComboBox".equals(controlType)) {
                    UIGeneratorHelper.createComboBox(model, ownProp, doName, row, col);
                    col = (col + 1) % 2;
                    if (col != 0) continue;
                    row += 3;
                    continue;
                }
                if ("com.kingdee.bos.ctrl.swing.KDList".equals(controlType)) {
                    UIGeneratorHelper.createList(model, ownProp, doName, row, col);
                    col = (col + 1) % 2;
                    if (col != 0) continue;
                    row += 3;
                    continue;
                }
                if ("com.kingdee.bos.ctrl.swing.KDDatePicker".equals(controlType)) {
                    UIGeneratorHelper.createDatePicker(model, ownProp, doName, row, col);
                    col = (col + 1) % 2;
                    if (col != 0) continue;
                    row += 3;
                    continue;
                }
                if ("com.kingdee.bos.ctrl.swing.KDTimePicker".equals(controlType)) {
                    UIGeneratorHelper.createTimePicker(model, ownProp, doName, row, col);
                    col = (col + 1) % 2;
                    if (col != 0) continue;
                    row += 3;
                    continue;
                }
                if ("com.kingdee.bos.ctrl.swing.KDTextArea".equals(controlType)) {
                    UIGeneratorHelper.createTextArea(model, ownProp, doName, row, col);
                    col = (col + 1) % 2;
                    if (col != 0) continue;
                    row += 3;
                    continue;
                }
                if ("com.kingdee.bos.ctrl.swing.KDPasswordField".equals(controlType)) {
                    UIGeneratorHelper.createPasswordField(model, ownProp, doName, row, col);
                    col = (col + 1) % 2;
                    if (col != 0) continue;
                    row += 3;
                    continue;
                }
                if (!"com.kingdee.bos.ctrl.swing.KDFormattedTextField".equals(controlType)) continue;
                UIGeneratorHelper.createKDFormattedTextField(model, ownProp, doName, row, col);
                col = (col + 1) % 2;
                if (col != 0) continue;
                row += 3;
                continue;
            }
            if (!(prop instanceof LinkPropertyInfo)) continue;
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(controlType)) {
                EntityObjectInfo entityObj;
                CardinalityType cardinalType = ((LinkPropertyInfo)prop).getRelationship().getSupplierCardinality();
                if (!CardinalityType.ONE_TO_UNBOUNDED.equals((Object)cardinalType) && !CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)cardinalType) || (entityObj = ((LinkPropertyInfo)prop).getRelationship().getSupplierObject()) == null) continue;
                UIGeneratorHelper.createKDTableForEntity(model, entityObj, doName, prop.getName(), row, col, locales);
                col = 0;
                row += 6;
                continue;
            }
            if (!"com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(controlType)) continue;
            LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
            UIGeneratorHelper.createKDBizPromptBox(model, (LinkPropertyInfo)prop, doName, row, col);
            col = (col + 1) % 2;
            if (col != 0) continue;
            row += 3;
        }
    }

    private static PropertyControlPair[] genPropertyControlPairs(EntityObjectInfo entity) {
        PropertyCollection collection = entity.getInheritedNoDuplicatedProperties();
        if (collection == null || collection.size() == 0) {
            return new PropertyControlPair[0];
        }
        Vector<PropertyControlPair> pairs = new Vector<PropertyControlPair>();
        PropertyInfo prop = null;
        OwnPropertyInfo ownProp = null;
        DataType dataType = null;
        String defaultControType = null;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            prop = (PropertyInfo)iter.next();
            if (prop instanceof OwnPropertyInfo) {
                ownProp = (OwnPropertyInfo)prop;
                dataType = ownProp.getDataType();
                if (DataType.BOOLEAN.equals(dataType)) {
                    defaultControType = "com.kingdee.bos.ctrl.swing.KDCheckBox";
                } else if (DataType.STRING.equals(dataType) || DataType.BOSUUID.equals(dataType) || DataType.UUID.equals(dataType)) {
                    defaultControType = "com.kingdee.bos.ctrl.swing.KDTextField";
                } else if (DataType.FLOAT.equals(dataType) || DataType.DOUBLE.equals(dataType) || DataType.DECIMAL.equals(dataType) || DataType.INTEGER.equals(dataType) || DataType.SHORT.equals(dataType) || DataType.LONG.equals(dataType)) {
                    defaultControType = "com.kingdee.bos.ctrl.swing.KDFormattedTextField";
                } else if (DataType.ENUM.equals(dataType)) {
                    defaultControType = "com.kingdee.bos.ctrl.swing.KDComboBox";
                } else if (DataType.DATE.equals(dataType)) {
                    defaultControType = "com.kingdee.bos.ctrl.swing.KDDatePicker";
                } else if (DataType.TIME.equals(dataType) || DataType.TIMESTAMP.equals(dataType)) {
                    defaultControType = "com.kingdee.bos.ctrl.swing.KDTimePicker";
                }
            } else if (prop instanceof LinkPropertyInfo) {
                CardinalityType cardinalType = ((LinkPropertyInfo)prop).getRelationship().getSupplierCardinality();
                defaultControType = CardinalityType.ONE_TO_UNBOUNDED.equals((Object)cardinalType) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)cardinalType) ? "com.kingdee.bos.ctrl.kdf.table.KDTable" : "com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox";
            }
            PropertyControlPair pair = new PropertyControlPair();
            pair.property = prop;
            pair.controlType = defaultControType;
            pairs.add(pair);
        }
        pairs.trimToSize();
        PropertyControlPair[] retPairs = new PropertyControlPair[pairs.size()];
        System.arraycopy(pairs.toArray(), 0, retPairs, 0, pairs.size());
        return retPairs;
    }

    public static class PropertyControlPair {
        protected PropertyInfo property;
        protected String controlType = null;

        public String getControlType() {
            return this.controlType;
        }

        public void setControlType(String controlType) {
            this.controlType = controlType;
        }

        public PropertyInfo getProperty() {
            return this.property;
        }

        public void setProperty(PropertyInfo property) {
            this.property = property;
        }
    }
}

