/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp.kdtable;

import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.MergeBlockInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class KDTableDesignerHelper {
    private static Namespace NS_TABLE = Namespace.getNamespace((String)"t", (String)"http://www.kingdee.com/Table");
    private static Namespace NS_COMMON = Namespace.getNamespace((String)"c", (String)"http://www.kingdee.com/Common");

    public static TableInfo getTableInfoFrom(String formatXml) {
        Element headBlocksNode;
        int i;
        Element headNode;
        Element cgNode;
        TableInfo table = new TableInfo();
        SAXBuilder sb = new SAXBuilder();
        Element tableNode = null;
        Element styles = null;
        Element sheet = null;
        Object mergeBlocks = null;
        try {
            Document doc = sb.build((Reader)new StringReader(formatXml));
            sheet = doc.getRootElement().getChild("Table").getChild("Sheet", NS_TABLE);
            tableNode = sheet.getChild("Table", NS_TABLE);
            styles = doc.getRootElement().getChild("Styles");
        }
        catch (Exception e) {
            return table;
        }
        String attVal = tableNode.getAttributeValue("selectMode", NS_TABLE);
        if (attVal != null && !attVal.equals("")) {
            table.setSelectMode(Integer.parseInt(attVal));
        }
        if ((attVal = tableNode.getAttributeValue("mergeMode", NS_TABLE)) != null && !attVal.equals("")) {
            table.setMergeMode(Integer.parseInt(attVal));
        }
        if ((attVal = tableNode.getAttributeValue("dataRequestMode", NS_TABLE)) != null && !attVal.equals("")) {
            table.setDataRequestMode(Integer.parseInt(attVal));
        }
        if ((attVal = tableNode.getAttributeValue("pageRowCount", NS_TABLE)) != null && !attVal.equals("")) {
            table.setPageRowCount(Integer.parseInt(attVal));
        }
        if ((attVal = tableNode.getAttributeValue("styleID", NS_TABLE)) != null) {
            table.setLock(KDTableDesignerHelper.isLock(KDTableDesignerHelper.getStyle(styles, attVal)));
        }
        if ("true".equalsIgnoreCase(attVal = tableNode.getAttributeValue("configured", NS_TABLE))) {
            table.setConfigured(true);
        }
        if ((cgNode = tableNode.getChild("ColumnGroup", NS_TABLE)) != null) {
            List colList = cgNode.getChildren("Column", NS_TABLE);
            for (int i2 = 0; i2 < colList.size(); ++i2) {
                Element colNode = (Element)colList.get(i2);
                ColumnInfo column = new ColumnInfo(table);
                attVal = colNode.getAttributeValue("width", NS_TABLE);
                if (attVal != null && !attVal.equals("")) {
                    column.setWidth(Integer.parseInt(attVal));
                }
                if ((attVal = colNode.getAttributeValue("key", NS_TABLE)) != null && !attVal.equals("")) {
                    column.setName(attVal);
                }
                if ((attVal = colNode.getAttributeValue("mergeable", NS_TABLE)) != null && !attVal.equals("")) {
                    column.setMergeable(KDTableDesignerHelper.getBoolean(attVal));
                }
                if ((attVal = colNode.getAttributeValue("resizeable", NS_TABLE)) != null && !attVal.equals("")) {
                    column.setResizeable(KDTableDesignerHelper.getBoolean(attVal));
                }
                if ((attVal = colNode.getAttributeValue("moveable", NS_TABLE)) != null && !attVal.equals("")) {
                    column.setMoveable(KDTableDesignerHelper.getBoolean(attVal));
                }
                if ((attVal = colNode.getAttributeValue("group", NS_TABLE)) != null && !attVal.equals("")) {
                    column.setGroup(KDTableDesignerHelper.getBoolean(attVal));
                }
                if ((attVal = colNode.getAttributeValue("required", NS_TABLE)) != null && !attVal.equals("")) {
                    column.setRequired(KDTableDesignerHelper.getBoolean(attVal));
                }
                if ((attVal = colNode.getAttributeValue("index", NS_TABLE)) != null && !attVal.equals("")) {
                    column.setIndex(Integer.parseInt(attVal));
                }
                if ((attVal = colNode.getAttributeValue("configured", NS_TABLE)) != null && !attVal.equals("")) {
                    column.setConfigured(KDTableDesignerHelper.getBoolean(attVal));
                }
                if ((attVal = colNode.getAttributeValue("styleID", NS_TABLE)) != null) {
                    Element style = KDTableDesignerHelper.getStyle(styles, attVal);
                    column.setLock(KDTableDesignerHelper.isLock(style));
                    column.setHide(KDTableDesignerHelper.isHide(style));
                    String sTemp = KDTableDesignerHelper.getFormatString(style);
                    if (sTemp != null && !sTemp.equals("")) {
                        column.setFormatString(sTemp);
                    }
                    if ((sTemp = KDTableDesignerHelper.getHorizonAlign(style)) != null && !sTemp.equals("")) {
                        column.setHorizonAlign(sTemp);
                    }
                }
                if ((attVal = colNode.getAttributeValue("fieldName", NS_TABLE)) != null && !attVal.equals("")) {
                    column.setFieldName(attVal);
                }
                table.addColumn(column);
            }
        }
        if ((headNode = tableNode.getChild("Head", NS_TABLE)) != null) {
            List rowList = headNode.getChildren("Row", NS_TABLE);
            for (i = 0; i < rowList.size(); ++i) {
                Element rowNode = (Element)rowList.get(i);
                HeaderInfo row = new HeaderInfo(table);
                attVal = rowNode.getAttributeValue("name", NS_TABLE);
                if (attVal != null && !attVal.equals("")) {
                    row.setName(attVal);
                } else {
                    row.setName("row" + i);
                }
                attVal = rowNode.getAttributeValue("height", NS_TABLE);
                if (attVal != null && !attVal.equals("")) {
                    row.setHeight(Integer.parseInt(attVal));
                }
                if ((attVal = rowNode.getAttributeValue("mergeable", NS_TABLE)) != null && !attVal.equals("")) {
                    row.setMergeable(!attVal.equals("0"));
                }
                if ((attVal = rowNode.getAttributeValue("resizeable", NS_TABLE)) != null && !attVal.equals("")) {
                    row.setResizeable(!attVal.equals("0"));
                }
                if ((attVal = rowNode.getAttributeValue("configured", NS_TABLE)) != null && !attVal.equals("")) {
                    row.setConfigured(KDTableDesignerHelper.getBoolean(attVal));
                }
                List cellList = rowNode.getChildren("Cell", NS_TABLE);
                for (int j = 0; j < cellList.size(); ++j) {
                    Element cellNode = (Element)cellList.get(j);
                    CellInfo cell = new CellInfo(row);
                    attVal = cellNode.getText();
                    if (attVal != null && !attVal.equals("")) {
                        cell.setName(attVal);
                    }
                    if ((attVal = cellNode.getAttributeValue("rowSpan", NS_TABLE)) != null && !attVal.equals("")) {
                        cell.setRowSpan(Integer.parseInt(attVal));
                    }
                    if ((attVal = cellNode.getAttributeValue("colSpan", NS_TABLE)) != null && !attVal.equals("")) {
                        cell.setColSpan(Integer.parseInt(attVal));
                    }
                    if ((attVal = cellNode.getAttributeValue("configured", NS_TABLE)) != null && !attVal.equals("")) {
                        cell.setConfigured(KDTableDesignerHelper.getBoolean(attVal));
                    }
                    row.addCell(cell);
                }
                table.addHeader(row);
            }
        }
        try {
            headBlocksNode = sheet.getChild("SheetOptions", NS_TABLE).getChild("MergeBlocks", NS_TABLE).getChild("Head", NS_TABLE);
        }
        catch (Exception e) {
            return table;
        }
        if (headBlocksNode != null) {
            List blockList = headBlocksNode.getChildren("Block", NS_TABLE);
            for (i = 0; i < blockList.size(); ++i) {
                Element blockNode = (Element)blockList.get(i);
                MergeBlockInfo info = new MergeBlockInfo(table);
                attVal = blockNode.getAttributeValue("top", NS_TABLE);
                if (attVal != null && !attVal.equals("")) {
                    info.setTop(Integer.parseInt(attVal));
                }
                if ((attVal = blockNode.getAttributeValue("left", NS_TABLE)) != null && !attVal.equals("")) {
                    info.setLeft(Integer.parseInt(attVal));
                }
                if ((attVal = blockNode.getAttributeValue("bottom", NS_TABLE)) != null && !attVal.equals("")) {
                    info.setBottom(Integer.parseInt(attVal));
                }
                if ((attVal = blockNode.getAttributeValue("right", NS_TABLE)) != null && !attVal.equals("")) {
                    info.setRight(Integer.parseInt(attVal));
                }
                if ((attVal = blockNode.getAttributeValue("configured", NS_TABLE)) != null && !attVal.equals("")) {
                    info.setConfigured(KDTableDesignerHelper.getBoolean(attVal));
                }
                table.addMergeBlock(info);
            }
        }
        return table;
    }

    public static String getXmlFrom(TableInfo table) {
        int i;
        String sVal;
        boolean bVal;
        Element mergeBlocks;
        Element tableNode;
        Element styles;
        Document doc;
        if (table == null) {
            return "";
        }
        String initSource = "<?xml version=\"1.0\" encoding=\"UNICODE\"?><DocRoot xmlns:c=\"http://www.kingdee.com/Common\" xmlns:f=\"http://www.kingdee.com/Form\" xmlns:t=\"http://www.kingdee.com/Table\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.kingdee.com/KDF KDFSchema.xsd\" version=\"0.0\"><Styles></Styles><Table id=\"KDTable\"><t:Sheet name=\"sheet1\"><t:Table></t:Table><t:SheetOptions><t:MergeBlocks><t:Head></t:Head></t:MergeBlocks></t:SheetOptions></t:Sheet></Table></DocRoot>";
        SAXBuilder sb = new SAXBuilder();
        try {
            doc = sb.build((Reader)new StringReader(initSource));
            Element sheet = doc.getRootElement().getChild("Table").getChild("Sheet", NS_TABLE);
            styles = doc.getRootElement().getChild("Styles");
            tableNode = sheet.getChild("Table", NS_TABLE);
            mergeBlocks = sheet.getChild("SheetOptions", NS_TABLE).getChild("MergeBlocks", NS_TABLE).getChild("Head", NS_TABLE);
        }
        catch (Exception e) {
            return "";
        }
        table.putCellIndex();
        int iVal = table.getSelectMode();
        tableNode.setAttribute("selectMode", String.valueOf(iVal), NS_TABLE);
        iVal = table.getMergeMode();
        tableNode.setAttribute("mergeMode", String.valueOf(iVal), NS_TABLE);
        iVal = table.getDataRequestMode();
        tableNode.setAttribute("dataRequestMode", String.valueOf(iVal), NS_TABLE);
        iVal = table.getPageRowCount();
        tableNode.setAttribute("pageRowCount", String.valueOf(iVal), NS_TABLE);
        if (table.isConfigured()) {
            tableNode.setAttribute("configured", "true", NS_TABLE);
        }
        if (bVal = table.isLock()) {
            Element style = KDTableDesignerHelper.createDefaultStyle();
            style.setAttribute("id", "sTable");
            tableNode.setAttribute("styleID", "sTable", NS_TABLE);
            Element protection = new Element("Protection", NS_COMMON);
            protection.setAttribute("locked", "true");
            style.addContent(protection);
            styles.addContent(style);
        }
        Element cgNode = new Element("ColumnGroup", NS_TABLE);
        tableNode.addContent(cgNode);
        Element headNode = new Element("Head", NS_TABLE);
        tableNode.addContent(headNode);
        List colList = table.getColumns();
        for (int i2 = 0; i2 < table.getColumnCount(); ++i2) {
            Element colNode = new Element("Column", NS_TABLE);
            cgNode.addContent(colNode);
            ColumnInfo column = (ColumnInfo)colList.get(i2);
            sVal = column.getName();
            if (sVal != null) {
                colNode.setAttribute("key", sVal, NS_TABLE);
            }
            iVal = column.getWidth();
            colNode.setAttribute("width", String.valueOf(iVal), NS_TABLE);
            bVal = column.isMergeable();
            colNode.setAttribute("mergeable", String.valueOf(bVal), NS_TABLE);
            bVal = column.isResizeable();
            colNode.setAttribute("resizeable", String.valueOf(bVal), NS_TABLE);
            bVal = column.isMoveable();
            colNode.setAttribute("moveable", String.valueOf(bVal), NS_TABLE);
            bVal = column.isGroup();
            colNode.setAttribute("group", String.valueOf(bVal), NS_TABLE);
            bVal = column.isRequired();
            colNode.setAttribute("required", String.valueOf(bVal), NS_TABLE);
            int index = column.getIndex();
            colNode.setAttribute("index", String.valueOf(index), NS_TABLE);
            bVal = column.isConfigured();
            if (bVal) {
                colNode.setAttribute("configured", String.valueOf(bVal), NS_TABLE);
            }
            Element style = null;
            if (column.isLock() || column.isHide()) {
                if (style == null) {
                    style = KDTableDesignerHelper.createBlankStyle();
                    style.setAttribute("id", "sCol" + i2);
                    colNode.setAttribute("styleID", "sCol" + i2, NS_TABLE);
                }
                Element protection = new Element("Protection", NS_COMMON);
                if (column.isLock()) {
                    protection.setAttribute("locked", "true");
                }
                if (column.isHide()) {
                    protection.setAttribute("hidden", "true");
                }
                style.addContent(protection);
            }
            if (column.getFormatString() != null && !column.getFormatString().equals("")) {
                if (style == null) {
                    style = KDTableDesignerHelper.createBlankStyle();
                    style.setAttribute("id", "sCol" + i2);
                    colNode.setAttribute("styleID", "sCol" + i2, NS_TABLE);
                }
                Element format = new Element("NumberFormat", NS_COMMON);
                format.setText(column.getFormatString());
                style.addContent(format);
            }
            if (!column.getHorizonAlign().equals("left")) {
                if (style == null) {
                    style = KDTableDesignerHelper.createBlankStyle();
                    style.setAttribute("id", "sCol" + i2);
                    colNode.setAttribute("styleID", "sCol" + i2, NS_TABLE);
                }
                Element align = new Element("Alignment", NS_COMMON);
                align.setAttribute("horizontal", column.getHorizonAlign());
                style.addContent(align);
            }
            if (style == null) continue;
            styles.addContent(style);
        }
        List rowList = table.getHeaders();
        for (i = 0; i < table.getHeaderCount(); ++i) {
            Element rowNode = new Element("Row", NS_TABLE);
            headNode.addContent(rowNode);
            HeaderInfo row = (HeaderInfo)rowList.get(i);
            sVal = row.getName();
            if (sVal != null) {
                rowNode.setAttribute("name", sVal, NS_TABLE);
            }
            iVal = row.getHeight();
            rowNode.setAttribute("height", String.valueOf(iVal), NS_TABLE);
            bVal = row.isMergeable();
            rowNode.setAttribute("mergeable", String.valueOf(bVal), NS_TABLE);
            bVal = row.isResizeable();
            rowNode.setAttribute("resizeable", String.valueOf(bVal), NS_TABLE);
            bVal = row.isConfigured();
            if (bVal) {
                rowNode.setAttribute("configured", String.valueOf(bVal), NS_TABLE);
            }
            ArrayList cellList = row.getCells();
            for (int j = 0; j < row.getCellCount(); ++j) {
                boolean configured;
                Element cellNode = new Element("Cell", NS_TABLE);
                rowNode.addContent(cellNode);
                CellInfo cell = (CellInfo)cellList.get(j);
                sVal = cell.getName();
                if (sVal != null) {
                    cellNode.setText(sVal);
                }
                if (!(configured = cell.isConfigured())) continue;
                cellNode.setAttribute("configured", String.valueOf(configured), NS_TABLE);
            }
        }
        for (i = 0; i < table.getMergeBlockCount(); ++i) {
            MergeBlockInfo mergeBlock = (MergeBlockInfo)table.getMergeBlocks().get(i);
            Element e = KDTableDesignerHelper.createMergeBlock(mergeBlock);
            mergeBlocks.addContent(e);
        }
        XMLOutputter out = new XMLOutputter();
        String retStr = out.outputString(doc);
        if (retStr != null) {
            retStr = retStr.replaceAll("\r\n", "");
        }
        return retStr;
    }

    private static Element createMergeBlock(MergeBlockInfo info) {
        Element block = new Element("Block", NS_TABLE);
        block.setAttribute("top", String.valueOf(info.getTop()), NS_TABLE);
        block.setAttribute("left", String.valueOf(info.getLeft()), NS_TABLE);
        block.setAttribute("bottom", String.valueOf(info.getBottom()), NS_TABLE);
        block.setAttribute("right", String.valueOf(info.getRight()), NS_TABLE);
        if (info.isConfigured()) {
            block.setAttribute("configured", String.valueOf(info.isConfigured()), NS_TABLE);
        }
        return block;
    }

    private static Element createBlankStyle() {
        return new Element("Style", NS_COMMON);
    }

    private static Element createDefaultStyle() {
        Element style = new Element("Style", NS_COMMON);
        Element alignment = new Element("Alignment", NS_COMMON);
        alignment.setAttribute("horizontal", "left");
        style.addContent(alignment);
        return style;
    }

    private static Element getStyle(Element styles, String id) {
        if (styles == null || id == null || id.equals("")) {
            return null;
        }
        List styleList = styles.getChildren("Style", NS_COMMON);
        for (int i = styleList.size() - 1; i >= 0; --i) {
            Element style = (Element)styleList.get(i);
            if (!style.getAttributeValue("id").equals(id)) continue;
            return style;
        }
        return null;
    }

    private static boolean getBoolean(String attVal) {
        return attVal != null && (attVal.equals("true") || attVal.equals("1"));
    }

    private static boolean isLock(Element style) {
        String attVal;
        Element protection = style.getChild("Protection", NS_COMMON);
        return protection != null && (attVal = protection.getAttributeValue("locked")) != null && (attVal.equals("true") || attVal.equals("1"));
    }

    private static boolean isHide(Element style) {
        String attVal;
        Element protection = style.getChild("Protection", NS_COMMON);
        return protection != null && (attVal = protection.getAttributeValue("hidden")) != null && (attVal.equals("true") || attVal.equals("1"));
    }

    private static String getFormatString(Element style) {
        Element format = style.getChild("NumberFormat", NS_COMMON);
        if (format != null) {
            String attVal = format.getText();
            return attVal;
        }
        return null;
    }

    private static String getHorizonAlign(Element style) {
        Element align = style.getChild("Alignment", NS_COMMON);
        if (align != null) {
            String attVal = align.getAttributeValue("horizontal");
            return attVal;
        }
        return null;
    }
}

