/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ui.dtp.kdtable;

import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.MergeBlockInfo;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TableInfo
implements Serializable {
    private int selectMode = 15;
    private int mergeMode = 0;
    private int dataRequestMode = 0;
    private int pageRowCount = 100;
    private boolean configured = false;
    private boolean lock = false;
    private ArrayList columns = new ArrayList();
    private ArrayList headers = new ArrayList();
    private ArrayList mergeBlocks = new ArrayList();

    public int getSelectMode() {
        return this.selectMode;
    }

    public int getMergeMode() {
        return this.mergeMode;
    }

    public int getDataRequestMode() {
        return this.dataRequestMode;
    }

    public int getPageRowCount() {
        return this.pageRowCount;
    }

    public void setSelectMode(int i) {
        this.selectMode = i;
    }

    public void setMergeMode(int i) {
        this.mergeMode = i;
    }

    public void setDataRequestMode(int i) {
        this.dataRequestMode = i;
    }

    public void setPageRowCount(int i) {
        this.pageRowCount = i;
    }

    public List getColumns() {
        return this.columns;
    }

    public String[] getColumnNameList() {
        int count = this.getColumnCount();
        String[] nameList = new String[count];
        for (int i = 0; i < count; ++i) {
            nameList[i] = ((ColumnInfo)this.columns.get(i)).getName();
        }
        return nameList;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public void addColumn(ColumnInfo column) {
        this.columns.add(column);
    }

    public void removeColumn(ColumnInfo column) {
        this.columns.remove(column);
    }

    public List getHeaders() {
        return this.headers;
    }

    public int getHeaderCount() {
        return this.headers.size();
    }

    public void addHeader(HeaderInfo header) {
        this.headers.add(header);
    }

    public void removeHeader(HeaderInfo header) {
        this.headers.remove(header);
    }

    public int getMergeBlockCount() {
        return this.mergeBlocks.size();
    }

    public List getMergeBlocks() {
        return this.mergeBlocks;
    }

    public void addMergeBlock(MergeBlockInfo mergeBlock) {
        this.mergeBlocks.add(mergeBlock);
    }

    public void removeMergeBlock(MergeBlockInfo mergeBlock) {
        this.mergeBlocks.remove(mergeBlock);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }

    public void dump(PrintStream ps) {
        int i;
        for (i = 0; i < this.headers.size(); ++i) {
            HeaderInfo header = (HeaderInfo)this.headers.get(i);
            ps.println("header[" + i + "].name=" + header.getName());
            for (int j = 0; j < header.getCells().size(); ++j) {
                ps.println("    cell[" + i + "].name=" + ((CellInfo)header.getCells().get(i)).getName());
            }
        }
        for (i = 0; i < this.columns.size(); ++i) {
            ps.println("column[" + i + "].name=" + ((ColumnInfo)this.columns.get(i)).getName());
        }
        for (i = 0; i < this.headers.size(); ++i) {
        }
    }

    HeaderInfo getHeaderInfo(int index) {
        if (index >= 0 && index < this.headers.size()) {
            return (HeaderInfo)this.headers.get(index);
        }
        return null;
    }

    void putCellIndex() {
        for (int i = 0; i < this.headers.size(); ++i) {
            HeaderInfo header = this.getHeaderInfo(i);
            for (int j = 0; j < header.getCellCount(); ++j) {
                CellInfo cell = header.getCell(j);
                int rowSpan = cell.getRowSpan();
                int colSpan = cell.getColSpan();
                if (rowSpan <= 0) continue;
                for (int k = 0; k < rowSpan; ++k) {
                    cell = this.getHeaderInfo(i + k + 1).getCellFrom(j);
                    if (cell == null) continue;
                    cell.setIndex(j + colSpan + 1);
                }
            }
        }
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean b) {
        this.lock = b;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }
}

